/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.IBluetoothPbap;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;

public class BluetoothPbap {
    private static final boolean DBG = false;
    public static final String PBAP_PREVIOUS_STATE = "android.bluetooth.pbap.intent.PBAP_PREVIOUS_STATE";
    public static final String PBAP_STATE = "android.bluetooth.pbap.intent.PBAP_STATE";
    public static final String PBAP_STATE_CHANGED_ACTION = "android.bluetooth.pbap.intent.action.PBAP_STATE_CHANGED";
    public static final int RESULT_CANCELED = 2;
    public static final int RESULT_FAILURE = 0;
    public static final int RESULT_SUCCESS = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_ERROR = -1;
    private static final String TAG = "BluetoothPbap";
    private ServiceConnection mConnection = new ServiceConnection(){

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            BluetoothPbap.access$002(BluetoothPbap.this, IBluetoothPbap.Stub.asInterface(iBinder));
            if (BluetoothPbap.this.mServiceListener != null) {
                BluetoothPbap.this.mServiceListener.onServiceConnected();
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            BluetoothPbap.access$002(BluetoothPbap.this, null);
            if (BluetoothPbap.this.mServiceListener != null) {
                BluetoothPbap.this.mServiceListener.onServiceDisconnected();
            }
        }
    };
    private final Context mContext;
    private IBluetoothPbap mService;
    private final ServiceListener mServiceListener;

    public BluetoothPbap(Context context, ServiceListener serviceListener) {
        this.mContext = context;
        this.mServiceListener = serviceListener;
        if (!context.bindService(new Intent(IBluetoothPbap.class.getName()), this.mConnection, 0)) {
            Log.e(TAG, "Could not bind to Bluetooth Pbap Service");
        }
    }

    static /* synthetic */ IBluetoothPbap access$002(BluetoothPbap bluetoothPbap, IBluetoothPbap iBluetoothPbap) {
        bluetoothPbap.mService = iBluetoothPbap;
        return iBluetoothPbap;
    }

    public static boolean doesClassMatchSink(BluetoothClass bluetoothClass) {
        switch (bluetoothClass.getDeviceClass()) {
            default: {
                return false;
            }
            case 256: 
            case 260: 
            case 264: 
            case 268: 
        }
        return true;
    }

    private static void log(String string2) {
        Log.d(TAG, string2);
    }

    public void close() {
        synchronized (this) {
            if (this.mConnection != null) {
                this.mContext.unbindService(this.mConnection);
                this.mConnection = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disconnect() {
        if (this.mService != null) {
            try {
                this.mService.disconnect();
                return true;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return false;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BluetoothDevice getClient() {
        if (this.mService != null) {
            try {
                return this.mService.getClient();
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return null;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getState() {
        if (this.mService != null) {
            try {
                return this.mService.getState();
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return -1;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConnected(BluetoothDevice bluetoothDevice) {
        if (this.mService != null) {
            try {
                return this.mService.isConnected(bluetoothDevice);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return false;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    public static interface ServiceListener {
        public void onServiceConnected();

        public void onServiceDisconnected();
    }
}

