/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothDeviceProfileState;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Message;
import android.util.Log;
import com.android.internal.util.HierarchicalState;
import com.android.internal.util.HierarchicalStateMachine;

public class BluetoothProfileState
extends HierarchicalStateMachine {
    public static final int A2DP = 1;
    private static final boolean DBG = true;
    public static final int HFP = 0;
    private static final String TAG = "BluetoothProfileState";
    static final int TRANSITION_TO_STABLE = 100;
    private BroadcastReceiver mBroadcastReceiver;
    private PendingCommandState mPendingCommandState = new PendingCommandState();
    private BluetoothDevice mPendingDevice;
    private int mProfile;
    private StableState mStableState = new StableState();

    public BluetoothProfileState(Context context, int n) {
        super("BluetoothProfileState:" + n);
        this.mBroadcastReceiver = new BroadcastReceiver(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                String string2 = intent.getAction();
                BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (string2.equals("android.bluetooth.headset.action.STATE_CHANGED")) {
                    int n = intent.getIntExtra("android.bluetooth.headset.extra.STATE", 0);
                    if (BluetoothProfileState.this.mProfile != 0 || n != 2 && n != 0) return;
                    BluetoothProfileState.this.sendMessage(100);
                    return;
                }
                if (string2.equals("android.bluetooth.a2dp.action.SINK_STATE_CHANGED")) {
                    int n = intent.getIntExtra("android.bluetooth.a2dp.extra.SINK_STATE", 0);
                    if (BluetoothProfileState.this.mProfile != 1 || n != 2 && n != 0) return;
                    BluetoothProfileState.this.sendMessage(100);
                    return;
                } else {
                    if (!string2.equals("android.bluetooth.device.action.ACL_DISCONNECTED") || !bluetoothDevice.equals(BluetoothProfileState.this.mPendingDevice)) return;
                    BluetoothProfileState.this.sendMessage(100);
                    return;
                }
            }
        };
        this.mProfile = n;
        this.addState(this.mStableState);
        this.addState(this.mPendingCommandState);
        this.setInitialState(this.mStableState);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.bluetooth.a2dp.action.SINK_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.headset.action.STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
        context.registerReceiver(this.mBroadcastReceiver, intentFilter);
    }

    static /* synthetic */ BluetoothDevice access$302(BluetoothProfileState bluetoothProfileState, BluetoothDevice bluetoothDevice) {
        bluetoothProfileState.mPendingDevice = bluetoothDevice;
        return bluetoothDevice;
    }

    private void log(String string2) {
        Log.i(TAG, "Message:" + string2);
    }

    private class PendingCommandState
    extends HierarchicalState {
        private PendingCommandState() {
        }

        private void dispatchMessage(Message message) {
            BluetoothDeviceProfileState bluetoothDeviceProfileState = (BluetoothDeviceProfileState)message.obj;
            int n = message.arg1;
            if (BluetoothProfileState.this.mPendingDevice == null || BluetoothProfileState.this.mPendingDevice.equals(bluetoothDeviceProfileState.getDevice())) {
                BluetoothProfileState.access$302(BluetoothProfileState.this, bluetoothDeviceProfileState.getDevice());
                bluetoothDeviceProfileState.sendMessage(n);
                return;
            }
            Message message2 = new Message();
            message2.arg1 = n;
            message2.obj = bluetoothDeviceProfileState;
            BluetoothProfileState.this.deferMessage(message2);
        }

        @Override
        protected void enter() {
            BluetoothProfileState.this.log("Entering PendingCommandState State");
            this.dispatchMessage(BluetoothProfileState.this.getCurrentMessage());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected boolean processMessage(Message message) {
            if (message.what == 100) {
                BluetoothProfileState.this.transitionTo(BluetoothProfileState.this.mStableState);
                return true;
            }
            this.dispatchMessage(message);
            return true;
        }
    }

    private class StableState
    extends HierarchicalState {
        private StableState() {
        }

        @Override
        protected void enter() {
            BluetoothProfileState.this.log("Entering Stable State");
            BluetoothProfileState.access$302(BluetoothProfileState.this, null);
        }

        @Override
        protected boolean processMessage(Message message) {
            if (message.what != 100) {
                BluetoothProfileState.this.transitionTo(BluetoothProfileState.this.mPendingCommandState);
            }
            return true;
        }
    }
}

