/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.os.ParcelUuid;
import java.util.Arrays;
import java.util.HashSet;

public final class BluetoothUuid {
    public static final ParcelUuid AdvAudioDist;
    public static final ParcelUuid AudioSink;
    public static final ParcelUuid AudioSource;
    public static final ParcelUuid AvrcpController;
    public static final ParcelUuid AvrcpTarget;
    public static final ParcelUuid HSP;
    public static final ParcelUuid Handsfree;
    public static final ParcelUuid ObexObjectPush;
    public static final ParcelUuid[] RESERVED_UUIDS;

    static {
        AudioSink = ParcelUuid.fromString("0000110B-0000-1000-8000-00805F9B34FB");
        AudioSource = ParcelUuid.fromString("0000110A-0000-1000-8000-00805F9B34FB");
        AdvAudioDist = ParcelUuid.fromString("0000110D-0000-1000-8000-00805F9B34FB");
        HSP = ParcelUuid.fromString("00001108-0000-1000-8000-00805F9B34FB");
        Handsfree = ParcelUuid.fromString("0000111E-0000-1000-8000-00805F9B34FB");
        AvrcpController = ParcelUuid.fromString("0000110E-0000-1000-8000-00805F9B34FB");
        AvrcpTarget = ParcelUuid.fromString("0000110C-0000-1000-8000-00805F9B34FB");
        ObexObjectPush = ParcelUuid.fromString("00001105-0000-1000-8000-00805f9b34fb");
        ParcelUuid[] parcelUuidArray = new ParcelUuid[]{AudioSink, AudioSource, AdvAudioDist, HSP, Handsfree, AvrcpController, AvrcpTarget, ObexObjectPush};
        RESERVED_UUIDS = parcelUuidArray;
    }

    public static boolean containsAllUuids(ParcelUuid[] parcelUuidArray, ParcelUuid[] parcelUuidArray2) {
        if (parcelUuidArray == null && parcelUuidArray2 == null) {
            return true;
        }
        if (parcelUuidArray == null) {
            return parcelUuidArray2.length == 0;
        }
        if (parcelUuidArray2 == null) {
            return true;
        }
        HashSet<ParcelUuid> hashSet = new HashSet<ParcelUuid>(Arrays.asList(parcelUuidArray));
        int n = parcelUuidArray2.length;
        for (int i = 0; i < n; ++i) {
            if (hashSet.contains(parcelUuidArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAnyUuid(ParcelUuid[] parcelUuidArray, ParcelUuid[] parcelUuidArray2) {
        if (parcelUuidArray == null && parcelUuidArray2 == null) {
            return true;
        }
        if (parcelUuidArray == null) {
            return parcelUuidArray2.length == 0;
        }
        if (parcelUuidArray2 == null) {
            return parcelUuidArray.length == 0;
        }
        HashSet<ParcelUuid> hashSet = new HashSet<ParcelUuid>(Arrays.asList(parcelUuidArray));
        int n = parcelUuidArray2.length;
        for (int i = 0; i < n; ++i) {
            if (!hashSet.contains(parcelUuidArray2[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isAdvAudioDist(ParcelUuid parcelUuid) {
        return parcelUuid.equals(AdvAudioDist);
    }

    public static boolean isAudioSink(ParcelUuid parcelUuid) {
        return parcelUuid.equals(AudioSink);
    }

    public static boolean isAudioSource(ParcelUuid parcelUuid) {
        return parcelUuid.equals(AudioSource);
    }

    public static boolean isAvrcpController(ParcelUuid parcelUuid) {
        return parcelUuid.equals(AvrcpController);
    }

    public static boolean isAvrcpTarget(ParcelUuid parcelUuid) {
        return parcelUuid.equals(AvrcpTarget);
    }

    public static boolean isHandsfree(ParcelUuid parcelUuid) {
        return parcelUuid.equals(Handsfree);
    }

    public static boolean isHeadset(ParcelUuid parcelUuid) {
        return parcelUuid.equals(HSP);
    }

    public static boolean isUuidPresent(ParcelUuid[] parcelUuidArray, ParcelUuid parcelUuid) {
        if ((parcelUuidArray == null || parcelUuidArray.length == 0) && parcelUuid == null) {
            return true;
        }
        if (parcelUuidArray == null) {
            return false;
        }
        int n = parcelUuidArray.length;
        for (int i = 0; i < n; ++i) {
            if (!parcelUuidArray[i].equals(parcelUuid)) continue;
            return true;
        }
        return false;
    }
}

