/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IContentService;
import android.content.ISyncStatusObserver;
import android.content.PeriodicSync;
import android.content.SyncAdapterType;
import android.content.SyncInfo;
import android.content.SyncManager;
import android.content.SyncStatusInfo;
import android.database.IContentObserver;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public final class ContentService
extends IContentService.Stub {
    private static final String TAG = "ContentService";
    private Context mContext;
    private boolean mFactoryTest;
    private final ObserverNode mRootNode = new ObserverNode("");
    private SyncManager mSyncManager = null;
    private final Object mSyncManagerLock = new Object();

    ContentService(Context context, boolean bl) {
        this.mContext = context;
        this.mFactoryTest = bl;
        this.getSyncManager();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SyncManager getSyncManager() {
        Object object = this.mSyncManagerLock;
        synchronized (object) {
            try {
                if (this.mSyncManager != null) return this.mSyncManager;
                this.mSyncManager = new SyncManager(this.mContext, this.mFactoryTest);
                return this.mSyncManager;
            }
            catch (SQLiteException sQLiteException) {
                Log.e(TAG, "Can't create SyncManager", sQLiteException);
            }
            return this.mSyncManager;
        }
    }

    public static IContentService main(Context context, boolean bl) {
        ContentService contentService = new ContentService(context, bl);
        ServiceManager.addService("content", contentService);
        return contentService;
    }

    @Override
    public void addPeriodicSync(Account account, String string2, Bundle bundle, long l) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
        long l2 = ContentService.clearCallingIdentity();
        try {
            this.getSyncManager().getSyncStorageEngine().addPeriodicSync(account, string2, bundle, l);
            return;
        }
        finally {
            ContentService.restoreCallingIdentity(l2);
        }
    }

    @Override
    public void addStatusChangeListener(int n, ISyncStatusObserver iSyncStatusObserver) {
        long l;
        block4: {
            l = ContentService.clearCallingIdentity();
            SyncManager syncManager = this.getSyncManager();
            if (syncManager == null || iSyncStatusObserver == null) break block4;
            syncManager.getSyncStorageEngine().addStatusChangeListener(n, iSyncStatusObserver);
        }
        return;
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void cancelSync(Account account, String string2) {
        long l;
        block4: {
            l = ContentService.clearCallingIdentity();
            SyncManager syncManager = this.getSyncManager();
            if (syncManager == null) break block4;
            syncManager.clearScheduledSyncOperations(account, string2);
            syncManager.cancelActiveSync(account, string2);
        }
        return;
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", "caller doesn't have the DUMP permission");
            long l = ContentService.clearCallingIdentity();
            try {
                if (this.mSyncManager == null) {
                    printWriter.println("No SyncManager created!  (Disk full?)");
                } else {
                    this.mSyncManager.dump(fileDescriptor, printWriter);
                }
                return;
            }
            finally {
                ContentService.restoreCallingIdentity(l);
            }
        }
    }

    @Override
    public SyncInfo getCurrentSync() {
        long l;
        block4: {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_STATS", "no permission to read the sync stats");
            l = ContentService.clearCallingIdentity();
            SyncManager syncManager = this.getSyncManager();
            if (syncManager == null) break block4;
            SyncInfo syncInfo = syncManager.getSyncStorageEngine().getCurrentSync();
            return syncInfo;
        }
        ContentService.restoreCallingIdentity(l);
        return null;
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    @Override
    public int getIsSyncable(Account account, String string2) {
        long l;
        block4: {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_SETTINGS", "no permission to read the sync settings");
            l = ContentService.clearCallingIdentity();
            SyncManager syncManager = this.getSyncManager();
            if (syncManager == null) break block4;
            int n = syncManager.getSyncStorageEngine().getIsSyncable(account, string2);
            return n;
        }
        ContentService.restoreCallingIdentity(l);
        return -1;
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    @Override
    public boolean getMasterSyncAutomatically() {
        long l;
        block4: {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_SETTINGS", "no permission to read the sync settings");
            l = ContentService.clearCallingIdentity();
            SyncManager syncManager = this.getSyncManager();
            if (syncManager == null) break block4;
            boolean bl = syncManager.getSyncStorageEngine().getMasterSyncAutomatically();
            return bl;
        }
        ContentService.restoreCallingIdentity(l);
        return false;
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    @Override
    public List<PeriodicSync> getPeriodicSyncs(Account account, String string2) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_SETTINGS", "no permission to read the sync settings");
        long l = ContentService.clearCallingIdentity();
        try {
            List<PeriodicSync> list = this.getSyncManager().getSyncStorageEngine().getPeriodicSyncs(account, string2);
            return list;
        }
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    @Override
    public SyncAdapterType[] getSyncAdapterTypes() {
        long l = ContentService.clearCallingIdentity();
        try {
            SyncAdapterType[] syncAdapterTypeArray = this.getSyncManager().getSyncAdapterTypes();
            return syncAdapterTypeArray;
        }
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    @Override
    public boolean getSyncAutomatically(Account account, String string2) {
        long l;
        block4: {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_SETTINGS", "no permission to read the sync settings");
            l = ContentService.clearCallingIdentity();
            SyncManager syncManager = this.getSyncManager();
            if (syncManager == null) break block4;
            boolean bl = syncManager.getSyncStorageEngine().getSyncAutomatically(account, string2);
            return bl;
        }
        ContentService.restoreCallingIdentity(l);
        return false;
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    @Override
    public SyncStatusInfo getSyncStatus(Account account, String string2) {
        long l;
        block4: {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_STATS", "no permission to read the sync stats");
            l = ContentService.clearCallingIdentity();
            SyncManager syncManager = this.getSyncManager();
            if (syncManager == null) break block4;
            SyncStatusInfo syncStatusInfo = syncManager.getSyncStorageEngine().getStatusByAccountAndAuthority(account, string2);
            return syncStatusInfo;
        }
        ContentService.restoreCallingIdentity(l);
        return null;
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    @Override
    public boolean isSyncActive(Account account, String string2) {
        long l;
        block4: {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_STATS", "no permission to read the sync stats");
            l = ContentService.clearCallingIdentity();
            SyncManager syncManager = this.getSyncManager();
            if (syncManager == null) break block4;
            boolean bl = syncManager.getSyncStorageEngine().isSyncActive(account, string2);
            return bl;
        }
        ContentService.restoreCallingIdentity(l);
        return false;
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    @Override
    public boolean isSyncPending(Account account, String string2) {
        long l;
        block4: {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_STATS", "no permission to read the sync stats");
            l = ContentService.clearCallingIdentity();
            SyncManager syncManager = this.getSyncManager();
            if (syncManager == null) break block4;
            boolean bl = syncManager.getSyncStorageEngine().isSyncPending(account, string2);
            return bl;
        }
        ContentService.restoreCallingIdentity(l);
        return false;
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void notifyChange(Uri var1_1, IContentObserver var2_2, boolean var3_3, boolean var4_4) {
        if (Log.isLoggable("ContentService", 2)) {
            Log.v("ContentService", "Notifying update of " + var1_1 + " from observer " + var2_2 + ", syncToNetwork " + var4_4);
        }
        var5_5 = ContentService.clearCallingIdentity();
        var7_6 = new ArrayList<ObserverCall>();
        var9_7 = this.mRootNode;
        synchronized (var9_7) {
            this.mRootNode.collectObserversLocked(var1_1, 0, var2_2, var3_3, var7_6);
        }
        {
            catch (Throwable var8_17) {
                ContentService.restoreCallingIdentity(var5_5);
                throw var8_17;
            }
            {
                // MONITOREXIT @DISABLED, blocks:[10, 13] lbl14 : MonitorExitStatement: MONITOREXIT : var9_7
                var11_8 = var7_6.size();
                block14: for (var12_9 = 0; var12_9 < var11_8; ++var12_9) {
                    var13_10 = var7_6.get(var12_9);
                    try {
                        var13_10.mObserver.onChange(var13_10.mSelfNotify);
                        if (Log.isLoggable("ContentService", 2)) {
                            Log.v("ContentService", "Notified " + var13_10.mObserver + " of " + "update at " + var1_1);
                        }
lbl23:
                        // 4 sources

                        continue block14;
                    }
                    catch (RemoteException var14_11) {}
                    {
                        var15_12 = this.mRootNode;
                        ** synchronized (var15_12)
                    }
lbl-1000:
                    // 1 sources

                    {
                        Log.w("ContentService", "Found dead observer, removing");
                        var18_13 = var13_10.mObserver.asBinder();
                        var19_14 = ObserverNode.access$000(var13_10.mNode);
                        var20_15 = var19_14.size();
                        var21_16 = 0;
lbl34:
                        // 2 sources

                        while (true) {
                            if (var21_16 < var20_15) {
                                if (((ObserverNode.ObserverEntry)var19_14.get((int)var21_16)).observer.asBinder() == var18_13) {
                                    var19_14.remove(var21_16);
                                    --var21_16;
                                    --var20_15;
                                }
                                ** break block22
                            }
                            // MONITOREXIT @DISABLED, blocks:[16, 10, 11, 13, 14] lbl43 : MonitorExitStatement: MONITOREXIT : var15_12
                            ** continue;
                            break;
                        }
                    }
                }
            }
        }
        if (var4_4 && (var24_18 = this.getSyncManager()) != null) {
            var24_18.scheduleLocalSync(null, var1_1.getAuthority());
        }
        ContentService.restoreCallingIdentity(var5_5);
        return;
lbl-1000:
        // 1 sources

        {
            ++var21_16;
            ** continue;
        }
    }

    @Override
    public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
        try {
            boolean bl = super.onTransact(n, parcel, parcel2, n2);
            return bl;
        }
        catch (RuntimeException runtimeException) {
            if (!(runtimeException instanceof SecurityException)) {
                Log.e(TAG, "Content Service Crash", runtimeException);
            }
            throw runtimeException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void registerContentObserver(Uri uri, boolean bl, IContentObserver iContentObserver) {
        if (iContentObserver != null && uri != null) {
            ObserverNode observerNode = this.mRootNode;
            synchronized (observerNode) {
                this.mRootNode.addObserverLocked(uri, iContentObserver, bl, this.mRootNode);
                return;
            }
        }
        throw new IllegalArgumentException("You must pass a valid uri and observer");
    }

    @Override
    public void removePeriodicSync(Account account, String string2, Bundle bundle) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
        long l = ContentService.clearCallingIdentity();
        try {
            this.getSyncManager().getSyncStorageEngine().removePeriodicSync(account, string2, bundle);
            return;
        }
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void removeStatusChangeListener(ISyncStatusObserver iSyncStatusObserver) {
        long l;
        block4: {
            l = ContentService.clearCallingIdentity();
            SyncManager syncManager = this.getSyncManager();
            if (syncManager == null || iSyncStatusObserver == null) break block4;
            syncManager.getSyncStorageEngine().removeStatusChangeListener(iSyncStatusObserver);
        }
        return;
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void requestSync(Account account, String string2, Bundle bundle) {
        long l;
        block4: {
            ContentResolver.validateSyncExtrasBundle(bundle);
            l = ContentService.clearCallingIdentity();
            SyncManager syncManager = this.getSyncManager();
            if (syncManager == null) break block4;
            syncManager.scheduleSync(account, string2, bundle, 0L, false);
        }
        return;
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void setIsSyncable(Account account, String string2, int n) {
        long l;
        block4: {
            this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
            l = ContentService.clearCallingIdentity();
            SyncManager syncManager = this.getSyncManager();
            if (syncManager == null) break block4;
            syncManager.getSyncStorageEngine().setIsSyncable(account, string2, n);
        }
        return;
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void setMasterSyncAutomatically(boolean bl) {
        long l;
        block4: {
            this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
            l = ContentService.clearCallingIdentity();
            SyncManager syncManager = this.getSyncManager();
            if (syncManager == null) break block4;
            syncManager.getSyncStorageEngine().setMasterSyncAutomatically(bl);
        }
        return;
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    @Override
    public void setSyncAutomatically(Account account, String string2, boolean bl) {
        long l;
        block4: {
            this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
            l = ContentService.clearCallingIdentity();
            SyncManager syncManager = this.getSyncManager();
            if (syncManager == null) break block4;
            syncManager.getSyncStorageEngine().setSyncAutomatically(account, string2, bl);
        }
        return;
        finally {
            ContentService.restoreCallingIdentity(l);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void unregisterContentObserver(IContentObserver iContentObserver) {
        if (iContentObserver == null) {
            throw new IllegalArgumentException("You must pass a valid observer");
        }
        ObserverNode observerNode = this.mRootNode;
        synchronized (observerNode) {
            this.mRootNode.removeObserverLocked(iContentObserver);
            return;
        }
    }

    public static final class ObserverCall {
        final ObserverNode mNode;
        final IContentObserver mObserver;
        final boolean mSelfNotify;

        ObserverCall(ObserverNode observerNode, IContentObserver iContentObserver, boolean bl) {
            this.mNode = observerNode;
            this.mObserver = iContentObserver;
            this.mSelfNotify = bl;
        }
    }

    public static final class ObserverNode {
        public static final int DELETE_TYPE = 2;
        public static final int INSERT_TYPE = 0;
        public static final int UPDATE_TYPE = 1;
        private ArrayList<ObserverNode> mChildren = new ArrayList();
        private String mName;
        private ArrayList<ObserverEntry> mObservers = new ArrayList();

        public ObserverNode(String string2) {
            this.mName = string2;
        }

        static /* synthetic */ ArrayList access$000(ObserverNode observerNode) {
            return observerNode.mObservers;
        }

        private void addObserverLocked(Uri uri, int n, IContentObserver iContentObserver, boolean bl, Object object) {
            if (n == this.countUriSegments(uri)) {
                this.mObservers.add(new ObserverEntry(iContentObserver, bl, object));
                return;
            }
            String string2 = this.getUriSegment(uri, n);
            if (string2 == null) {
                throw new IllegalArgumentException("Invalid Uri (" + uri + ") used for observer");
            }
            int n2 = this.mChildren.size();
            for (int i = 0; i < n2; ++i) {
                ObserverNode observerNode = this.mChildren.get(i);
                if (!observerNode.mName.equals(string2)) continue;
                observerNode.addObserverLocked(uri, n + 1, iContentObserver, bl, object);
                return;
            }
            ObserverNode observerNode = new ObserverNode(string2);
            this.mChildren.add(observerNode);
            observerNode.addObserverLocked(uri, n + 1, iContentObserver, bl, object);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void collectMyObserversLocked(boolean bl, IContentObserver iContentObserver, boolean bl2, ArrayList<ObserverCall> arrayList) {
            int n = this.mObservers.size();
            IBinder iBinder = iContentObserver == null ? null : iContentObserver.asBinder();
            int n2 = 0;
            while (n2 < n) {
                ObserverEntry observerEntry = this.mObservers.get(n2);
                if ((observerEntry.observer.asBinder() != iBinder || bl2) && (bl || !bl && observerEntry.notifyForDescendents)) {
                    arrayList.add(new ObserverCall(this, observerEntry.observer, bl2));
                }
                ++n2;
            }
            return;
        }

        private int countUriSegments(Uri uri) {
            if (uri == null) {
                return 0;
            }
            return 1 + uri.getPathSegments().size();
        }

        private String getUriSegment(Uri uri, int n) {
            if (uri != null) {
                if (n == 0) {
                    return uri.getAuthority();
                }
                return uri.getPathSegments().get(n - 1);
            }
            return null;
        }

        public void addObserverLocked(Uri uri, IContentObserver iContentObserver, boolean bl, Object object) {
            this.addObserverLocked(uri, 0, iContentObserver, bl, object);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void collectObserversLocked(Uri uri, int n, IContentObserver iContentObserver, boolean bl, ArrayList<ObserverCall> arrayList) {
            String string2 = null;
            int n2 = this.countUriSegments(uri);
            if (n >= n2) {
                this.collectMyObserversLocked(true, iContentObserver, bl, arrayList);
            } else {
                string2 = null;
                if (n < n2) {
                    string2 = this.getUriSegment(uri, n);
                    this.collectMyObserversLocked(false, iContentObserver, bl, arrayList);
                }
            }
            int n3 = this.mChildren.size();
            int n4 = 0;
            while (true) {
                block8: {
                    block7: {
                        if (n4 >= n3) break block7;
                        ObserverNode observerNode = this.mChildren.get(n4);
                        if (string2 != null && !observerNode.mName.equals(string2)) break block8;
                        observerNode.collectObserversLocked(uri, n + 1, iContentObserver, bl, arrayList);
                        if (string2 == null) break block8;
                    }
                    return;
                }
                ++n4;
            }
        }

        public boolean removeObserverLocked(IContentObserver iContentObserver) {
            int n = this.mChildren.size();
            for (int i = 0; i < n; ++i) {
                if (!this.mChildren.get(i).removeObserverLocked(iContentObserver)) continue;
                this.mChildren.remove(i);
                --i;
                --n;
            }
            IBinder iBinder = iContentObserver.asBinder();
            int n2 = this.mObservers.size();
            int n3 = 0;
            while (true) {
                block5: {
                    block4: {
                        if (n3 >= n2) break block4;
                        ObserverEntry observerEntry = this.mObservers.get(n3);
                        if (observerEntry.observer.asBinder() != iBinder) break block5;
                        this.mObservers.remove(n3);
                        iBinder.unlinkToDeath(observerEntry, 0);
                    }
                    return this.mChildren.size() == 0 && this.mObservers.size() == 0;
                }
                ++n3;
            }
        }

        private class ObserverEntry
        implements IBinder.DeathRecipient {
            public final boolean notifyForDescendents;
            public final IContentObserver observer;
            private final Object observersLock;

            public ObserverEntry(IContentObserver iContentObserver, boolean bl, Object object) {
                this.observersLock = object;
                this.observer = iContentObserver;
                this.notifyForDescendents = bl;
                try {
                    this.observer.asBinder().linkToDeath(this, 0);
                    return;
                }
                catch (RemoteException remoteException) {
                    this.binderDied();
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void binderDied() {
                Object object = this.observersLock;
                synchronized (object) {
                    ObserverNode.this.removeObserverLocked(this.observer);
                    return;
                }
            }
        }
    }
}

