/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentInsertHandler;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.net.Uri;
import android.util.Xml;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DefaultDataHandler
implements ContentInsertHandler {
    private static final String ARG = "arg";
    private static final String COL = "col";
    private static final String DEL = "del";
    private static final String POSTFIX = "postfix";
    private static final String ROW = "row";
    private static final String SELECT = "select";
    private static final String URI_STR = "uri";
    private ContentResolver mContentResolver;
    private Stack<Uri> mUris = new Stack();
    private ContentValues mValues;

    private Uri insertRow() {
        Uri uri = this.mContentResolver.insert((Uri)this.mUris.lastElement(), this.mValues);
        this.mValues = null;
        return uri;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseRow(Attributes attributes) throws SAXException {
        Uri uri;
        String string2 = attributes.getValue(URI_STR);
        if (string2 != null) {
            uri = Uri.parse(string2);
            if (uri == null) {
                throw new SAXException("attribute " + attributes.getValue(URI_STR) + " parsing failure");
            }
        } else {
            if (this.mUris.size() <= 0) {
                throw new SAXException("attribute parsing failure");
            }
            String string3 = attributes.getValue(POSTFIX);
            uri = string3 != null ? Uri.withAppendedPath((Uri)this.mUris.lastElement(), string3) : (Uri)this.mUris.lastElement();
        }
        this.mUris.push(uri);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String string2, String string3, String string4) throws SAXException {
        if (ROW.equals(string3)) {
            if (this.mUris.empty()) {
                throw new SAXException("uri mismatch");
            }
            if (this.mValues != null) {
                this.insertRow();
            }
            this.mUris.pop();
        }
    }

    @Override
    public void endPrefixMapping(String string2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void insert(ContentResolver contentResolver, InputStream inputStream) throws IOException, SAXException {
        this.mContentResolver = contentResolver;
        Xml.parse(inputStream, Xml.Encoding.UTF_8, this);
    }

    @Override
    public void insert(ContentResolver contentResolver, String string2) throws SAXException {
        this.mContentResolver = contentResolver;
        Xml.parse(string2, (ContentHandler)this);
    }

    @Override
    public void processingInstruction(String string2, String string3) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String string2) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        if (ROW.equals(string3)) {
            if (this.mValues != null) {
                if (this.mUris.empty()) {
                    throw new SAXException("uri is empty");
                }
                Uri uri = this.insertRow();
                if (uri == null) {
                    throw new SAXException("insert to uri " + ((Uri)this.mUris.lastElement()).toString() + " failure");
                }
                this.mUris.pop();
                this.mUris.push(uri);
                this.parseRow(attributes);
                return;
            }
            if (attributes.getLength() == 0) {
                this.mUris.push((Uri)this.mUris.lastElement());
                return;
            }
            this.parseRow(attributes);
            return;
        }
        if (COL.equals(string3)) {
            int n = attributes.getLength();
            if (n != 2) {
                throw new SAXException("illegal attributes number " + n);
            }
            String string5 = attributes.getValue(0);
            String string6 = attributes.getValue(1);
            if (string5 != null && string5.length() > 0 && string6 != null && string6.length() > 0) {
                if (this.mValues == null) {
                    this.mValues = new ContentValues();
                }
                this.mValues.put(string5, string6);
                return;
            }
            throw new SAXException("illegal attributes value");
        }
        if (DEL.equals(string3)) {
            Uri uri = Uri.parse(attributes.getValue(URI_STR));
            if (uri == null) {
                throw new SAXException("attribute " + attributes.getValue(URI_STR) + " parsing failure");
            }
            int n = attributes.getLength() - 2;
            if (n > 0) {
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = attributes.getValue(i + 2);
                }
                this.mContentResolver.delete(uri, attributes.getValue(1), stringArray);
                return;
            }
            if (n == 0) {
                this.mContentResolver.delete(uri, attributes.getValue(1), null);
                return;
            }
            this.mContentResolver.delete(uri, null, null);
            return;
        }
        throw new SAXException("unknown element: " + string3);
    }

    @Override
    public void startPrefixMapping(String string2, String string3) throws SAXException {
    }
}

