/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.OnAccountsUpdateListener;
import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.ISyncAdapter;
import android.content.ISyncContext;
import android.content.ISyncStatusObserver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.SyncAdapterType;
import android.content.SyncAdaptersCache;
import android.content.SyncInfo;
import android.content.SyncOperation;
import android.content.SyncQueue;
import android.content.SyncResult;
import android.content.SyncStatusInfo;
import android.content.SyncStorageEngine;
import android.content.pm.ProviderInfo;
import android.content.pm.RegisteredServicesCache;
import android.content.pm.RegisteredServicesCacheListener;
import android.content.pm.ResolveInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.WorkSource;
import android.provider.Settings;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.util.EventLog;
import android.util.Log;
import android.util.Pair;
import com.android.internal.util.ArrayUtils;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;

public class SyncManager
implements OnAccountsUpdateListener {
    private static final String ACTION_SYNC_ALARM = "android.content.syncmanager.SYNC_ALARM";
    private static final long DEFAULT_MAX_SYNC_RETRY_TIME_IN_SECONDS = 3600L;
    private static final int DELAY_RETRY_SYNC_IN_PROGRESS_IN_SECONDS = 10;
    private static final long ERROR_NOTIFICATION_DELAY_MS = 600000L;
    private static final String HANDLE_SYNC_ALARM_WAKE_LOCK = "SyncManagerHandleSyncAlarm";
    private static final int INITIALIZATION_UNBIND_DELAY_MS = 5000;
    private static final Account[] INITIAL_ACCOUNTS_ARRAY;
    private static final long INITIAL_SYNC_RETRY_TIME_IN_MS = 30000L;
    private static final long LOCAL_SYNC_DELAY = 0L;
    private static final long MAX_TIME_PER_SYNC = 0L;
    private static final long SYNC_NOTIFICATION_DELAY = 30000L;
    private static final String SYNC_WAKE_LOCK = "*sync*";
    private static final String TAG = "SyncManager";
    private volatile Account[] mAccounts = INITIAL_ACCOUNTS_ARRAY;
    private ActiveSyncContext mActiveSyncContext = null;
    private AlarmManager mAlarmService = null;
    private BroadcastReceiver mBackgroundDataSettingChanged;
    private volatile boolean mBootCompleted = false;
    private BroadcastReceiver mBootCompletedReceiver;
    private ConnectivityManager mConnManagerDoNotUseDirectly;
    private BroadcastReceiver mConnectivityIntentReceiver;
    private Context mContext;
    private volatile boolean mDataConnectionIsConnected = false;
    private volatile PowerManager.WakeLock mHandleAlarmWakeLock;
    private final Handler mMainHandler;
    private boolean mNeedSyncActiveNotification = false;
    private boolean mNeedSyncErrorNotification = false;
    private final NotificationManager mNotificationMgr;
    private BroadcastReceiver mShutdownIntentReceiver;
    private BroadcastReceiver mStorageIntentReceiver = new BroadcastReceiver(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String string2 = intent.getAction();
            if ("android.intent.action.DEVICE_STORAGE_LOW".equals(string2)) {
                if (Log.isLoggable(SyncManager.TAG, 2)) {
                    Log.v(SyncManager.TAG, "Internal storage is low.");
                }
                SyncManager.access$002(SyncManager.this, true);
                SyncManager.this.cancelActiveSync(null, null);
                return;
            } else {
                if (!"android.intent.action.DEVICE_STORAGE_OK".equals(string2)) return;
                if (Log.isLoggable(SyncManager.TAG, 2)) {
                    Log.v(SyncManager.TAG, "Internal storage is ok.");
                }
                SyncManager.access$002(SyncManager.this, false);
                SyncManager.this.sendCheckAlarmsMessage();
                return;
            }
        }
    };
    private volatile boolean mStorageIsLow = false;
    private final SyncAdaptersCache mSyncAdapters;
    private final PendingIntent mSyncAlarmIntent;
    private final SyncHandler mSyncHandler;
    public final SyncQueue mSyncQueue;
    private final SyncStorageEngine mSyncStorageEngine;
    private volatile PowerManager.WakeLock mSyncWakeLock;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        String string2 = SystemProperties.get("sync.local_sync_delay");
        long l = 30000L;
        if (string2 != null) {
            try {
                long l2;
                l = l2 = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        LOCAL_SYNC_DELAY = l;
        String string3 = SystemProperties.get("sync.max_time_per_sync");
        long l3 = 300000L;
        if (string3 != null) {
            try {
                long l4;
                l3 = l4 = Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        MAX_TIME_PER_SYNC = l3;
        INITIAL_ACCOUNTS_ARRAY = new Account[0];
    }

    /*
     * Enabled aggressive block sorting
     */
    public SyncManager(Context context, boolean bl) {
        this.mBootCompletedReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                SyncManager.this.mSyncHandler.onBootCompleted();
            }
        };
        this.mBackgroundDataSettingChanged = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                if (SyncManager.this.getConnectivityManager().getBackgroundDataSetting()) {
                    SyncManager.this.scheduleSync(null, null, new Bundle(), 0L, false);
                }
            }
        };
        this.mConnectivityIntentReceiver = new BroadcastReceiver(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                NetworkInfo.State state = networkInfo == null ? NetworkInfo.State.UNKNOWN : networkInfo.getState();
                if (Log.isLoggable(SyncManager.TAG, 2)) {
                    Log.v(SyncManager.TAG, "received connectivity action.  network info: " + networkInfo);
                }
                switch (8.$SwitchMap$android$net$NetworkInfo$State[state.ordinal()]) {
                    case 1: {
                        SyncManager.access$402(SyncManager.this, true);
                    }
                    default: {
                        break;
                    }
                    case 2: {
                        if (intent.getBooleanExtra("noConnectivity", false)) {
                            SyncManager.access$402(SyncManager.this, false);
                            break;
                        }
                        SyncManager.access$402(SyncManager.this, true);
                    }
                }
                if (SyncManager.this.mDataConnectionIsConnected) {
                    SyncManager.this.sendCheckAlarmsMessage();
                }
            }
        };
        this.mShutdownIntentReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                Log.w(SyncManager.TAG, "Writing sync state before shutdown...");
                SyncManager.this.getSyncStorageEngine().writeAllState();
            }
        };
        SyncStorageEngine.init(context);
        this.mSyncStorageEngine = SyncStorageEngine.getSingleton();
        this.mSyncQueue = new SyncQueue(this.mSyncStorageEngine);
        this.mContext = context;
        HandlerThread handlerThread = new HandlerThread("SyncHandlerThread", 10);
        handlerThread.start();
        this.mSyncHandler = new SyncHandler(handlerThread.getLooper());
        this.mMainHandler = new Handler(this.mContext.getMainLooper());
        this.mSyncAdapters = new SyncAdaptersCache(this.mContext);
        this.mSyncAdapters.setListener(new RegisteredServicesCacheListener<SyncAdapterType>(){

            @Override
            public void onServiceChanged(SyncAdapterType syncAdapterType, boolean bl) {
                if (!bl) {
                    SyncManager.this.scheduleSync(null, syncAdapterType.authority, null, 0L, false);
                }
            }
        }, this.mSyncHandler);
        this.mSyncAlarmIntent = PendingIntent.getBroadcast(this.mContext, 0, new Intent(ACTION_SYNC_ALARM), 0);
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver(this.mConnectivityIntentReceiver, intentFilter);
        if (!bl) {
            IntentFilter intentFilter2 = new IntentFilter("android.intent.action.BOOT_COMPLETED");
            context.registerReceiver(this.mBootCompletedReceiver, intentFilter2);
        }
        IntentFilter intentFilter3 = new IntentFilter("android.net.conn.BACKGROUND_DATA_SETTING_CHANGED");
        context.registerReceiver(this.mBackgroundDataSettingChanged, intentFilter3);
        IntentFilter intentFilter4 = new IntentFilter("android.intent.action.DEVICE_STORAGE_LOW");
        intentFilter4.addAction("android.intent.action.DEVICE_STORAGE_OK");
        context.registerReceiver(this.mStorageIntentReceiver, intentFilter4);
        IntentFilter intentFilter5 = new IntentFilter("android.intent.action.ACTION_SHUTDOWN");
        intentFilter5.setPriority(100);
        context.registerReceiver(this.mShutdownIntentReceiver, intentFilter5);
        if (!bl) {
            this.mNotificationMgr = (NotificationManager)context.getSystemService("notification");
            context.registerReceiver(new SyncAlarmIntentReceiver(), new IntentFilter(ACTION_SYNC_ALARM));
        } else {
            this.mNotificationMgr = null;
        }
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mSyncWakeLock = powerManager.newWakeLock(1, SYNC_WAKE_LOCK);
        this.mSyncWakeLock.setReferenceCounted(false);
        this.mHandleAlarmWakeLock = powerManager.newWakeLock(1, HANDLE_SYNC_ALARM_WAKE_LOCK);
        this.mHandleAlarmWakeLock.setReferenceCounted(false);
        this.mSyncStorageEngine.addStatusChangeListener(1, new ISyncStatusObserver.Stub(){

            @Override
            public void onStatusChanged(int n) {
                SyncManager.this.sendCheckAlarmsMessage();
            }
        });
        if (!bl) {
            AccountManager.get(this.mContext).addOnAccountsUpdatedListener(this, this.mSyncHandler, false);
            this.onAccountsUpdated(AccountManager.get(this.mContext).getAccounts());
        }
    }

    static /* synthetic */ boolean access$002(SyncManager syncManager, boolean bl) {
        syncManager.mStorageIsLow = bl;
        return bl;
    }

    static /* synthetic */ ActiveSyncContext access$1102(SyncManager syncManager, ActiveSyncContext activeSyncContext) {
        syncManager.mActiveSyncContext = activeSyncContext;
        return activeSyncContext;
    }

    static /* synthetic */ boolean access$1302(SyncManager syncManager, boolean bl) {
        syncManager.mBootCompleted = bl;
        return bl;
    }

    static /* synthetic */ boolean access$2402(SyncManager syncManager, boolean bl) {
        syncManager.mNeedSyncActiveNotification = bl;
        return bl;
    }

    static /* synthetic */ boolean access$2502(SyncManager syncManager, boolean bl) {
        syncManager.mNeedSyncErrorNotification = bl;
        return bl;
    }

    static /* synthetic */ boolean access$402(SyncManager syncManager, boolean bl) {
        syncManager.mDataConnectionIsConnected = bl;
        return bl;
    }

    private void clearBackoffSetting(SyncOperation syncOperation) {
        this.mSyncStorageEngine.setBackoff(syncOperation.account, syncOperation.authority, -1L, -1L);
    }

    private void dumpDayStatistic(PrintWriter printWriter, SyncStorageEngine.DayStats dayStats) {
        printWriter.print("Success (");
        printWriter.print(dayStats.successCount);
        if (dayStats.successCount > 0) {
            printWriter.print(" for ");
            this.dumpTimeSec(printWriter, dayStats.successTime);
            printWriter.print(" avg=");
            this.dumpTimeSec(printWriter, dayStats.successTime / (long)dayStats.successCount);
        }
        printWriter.print(") Failure (");
        printWriter.print(dayStats.failureCount);
        if (dayStats.failureCount > 0) {
            printWriter.print(" for ");
            this.dumpTimeSec(printWriter, dayStats.failureTime);
            printWriter.print(" avg=");
            this.dumpTimeSec(printWriter, dayStats.failureTime / (long)dayStats.failureCount);
        }
        printWriter.println(")");
    }

    private void dumpTimeSec(PrintWriter printWriter, long l) {
        printWriter.print(l / 1000L);
        printWriter.print('.');
        printWriter.print(l / 100L % 10L);
        printWriter.print('s');
    }

    private void ensureAlarmService() {
        if (this.mAlarmService == null) {
            this.mAlarmService = (AlarmManager)this.mContext.getSystemService("alarm");
        }
    }

    static String formatTime(long l) {
        Time time = new Time();
        time.set(l);
        return time.format("%Y-%m-%d %H:%M:%S");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConnectivityManager getConnectivityManager() {
        synchronized (this) {
            if (this.mConnManagerDoNotUseDirectly != null) return this.mConnManagerDoNotUseDirectly;
            this.mConnManagerDoNotUseDirectly = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            return this.mConnManagerDoNotUseDirectly;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void increaseBackoffSetting(SyncOperation syncOperation) {
        long l;
        long l2 = SystemClock.elapsedRealtime();
        Pair<Long, Long> pair = this.mSyncStorageEngine.getBackoff(syncOperation.account, syncOperation.authority);
        long l3 = pair == null || (Long)pair.second <= 0L ? this.jitterize(30000L, 33000L) : 2L * (Long)pair.second;
        if (l3 > (l = Settings.Secure.getLong(this.mContext.getContentResolver(), "sync_max_retry_delay_in_seconds", 3600L)) * 1000L) {
            l3 = l * 1000L;
        }
        this.mSyncStorageEngine.setBackoff(syncOperation.account, syncOperation.authority, l2 + l3, l3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initializeSyncAdapter(Account account, String string2) {
        SyncAdapterType syncAdapterType;
        RegisteredServicesCache.ServiceInfo<SyncAdapterType> serviceInfo;
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "initializeSyncAdapter: " + account + ", authority " + string2);
        }
        if ((serviceInfo = this.mSyncAdapters.getServiceInfo(syncAdapterType = SyncAdapterType.newKey(string2, account.type))) == null) {
            Log.w(TAG, "can't find a sync adapter for " + syncAdapterType + ", removing");
            this.mSyncStorageEngine.removeAuthority(account, string2);
            return;
        } else {
            Intent intent = new Intent();
            intent.setAction("android.content.SyncAdapter");
            intent.setComponent(serviceInfo.componentName);
            if (this.mContext.bindService(intent, new InitializerServiceConnection(account, string2, this.mContext, this.mMainHandler), 5)) return;
            Log.w(TAG, "initializeSyncAdapter: failed to bind to " + intent);
            return;
        }
    }

    private long jitterize(long l, long l2) {
        Random random = new Random(SystemClock.elapsedRealtime());
        long l3 = l2 - l;
        if (l3 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("the difference between the maxValue and the minValue must be less than 2147483647");
        }
        return l + (long)random.nextInt((int)l3);
    }

    private void sendCheckAlarmsMessage() {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "sending MESSAGE_CHECK_ALARMS");
        }
        this.mSyncHandler.sendEmptyMessage(3);
    }

    private void sendSyncAlarmMessage() {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "sending MESSAGE_SYNC_ALARM");
        }
        this.mSyncHandler.sendEmptyMessage(2);
    }

    private void sendSyncFinishedOrCanceledMessage(ActiveSyncContext activeSyncContext, SyncResult syncResult) {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "sending MESSAGE_SYNC_FINISHED");
        }
        Message message = this.mSyncHandler.obtainMessage();
        message.what = 1;
        message.obj = new SyncHandlerMessagePayload(activeSyncContext, syncResult);
        this.mSyncHandler.sendMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setDelayUntilTime(SyncOperation syncOperation, long l) {
        long l2 = l * 1000L;
        long l3 = System.currentTimeMillis();
        long l4 = l2 > l3 ? SystemClock.elapsedRealtime() + (l2 - l3) : 0L;
        this.mSyncStorageEngine.setDelayUntilTime(syncOperation.account, syncOperation.authority, l4);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void cancelActiveSync(Account account, String string2) {
        ActiveSyncContext activeSyncContext = this.mActiveSyncContext;
        if (activeSyncContext == null || account != null && !account.equals(activeSyncContext.mSyncOperation.account) || string2 != null && !string2.equals(activeSyncContext.mSyncOperation.authority)) {
            return;
        }
        this.sendSyncFinishedOrCanceledMessage(activeSyncContext, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearScheduledSyncOperations(Account account, String string2) {
        this.mSyncStorageEngine.setBackoff(account, string2, -1L, -1L);
        SyncQueue syncQueue = this.mSyncQueue;
        synchronized (syncQueue) {
            this.mSyncQueue.remove(account, string2);
            return;
        }
    }

    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter) {
        StringBuilder stringBuilder = new StringBuilder();
        this.dumpSyncState(printWriter, stringBuilder);
        this.dumpSyncHistory(printWriter, stringBuilder);
        printWriter.println();
        printWriter.println("SyncAdapters:");
        for (RegisteredServicesCache.ServiceInfo serviceInfo : this.mSyncAdapters.getAllServices()) {
            printWriter.println("  " + serviceInfo);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void dumpSyncHistory(PrintWriter printWriter, StringBuilder stringBuilder) {
        ArrayList<SyncStorageEngine.SyncHistoryItem> arrayList;
        SyncStorageEngine.DayStats[] dayStatsArray = this.mSyncStorageEngine.getDayStatistics();
        if (dayStatsArray != null && dayStatsArray[0] != null) {
            int n;
            int n2;
            SyncStorageEngine.DayStats dayStats;
            int n3;
            int n4;
            printWriter.println();
            printWriter.println("Sync Statistics");
            printWriter.print("  Today:  ");
            this.dumpDayStatistic(printWriter, dayStatsArray[0]);
            int n5 = dayStatsArray[0].day;
            for (n4 = 1; n4 <= 6 && n4 < (n3 = dayStatsArray.length) && (dayStats = dayStatsArray[n4]) != null && (n2 = n5 - dayStats.day) <= 6; ++n4) {
                printWriter.print("  Day-");
                printWriter.print(n2);
                printWriter.print(":  ");
                this.dumpDayStatistic(printWriter, dayStats);
            }
            int n6 = n5;
            while (n4 < (n = dayStatsArray.length)) {
                int n7;
                SyncStorageEngine.DayStats dayStats2 = null;
                n6 -= 7;
                while (n4 < (n7 = dayStatsArray.length)) {
                    long l;
                    int n8;
                    long l2;
                    int n9;
                    SyncStorageEngine.DayStats dayStats3 = dayStatsArray[n4];
                    if (dayStats3 == null) {
                        n4 = dayStatsArray.length;
                        break;
                    }
                    if (n6 - dayStats3.day > 6) break;
                    ++n4;
                    if (dayStats2 == null) {
                        dayStats2 = new SyncStorageEngine.DayStats(n6);
                    }
                    dayStats2.successCount = n9 = dayStats2.successCount + dayStats3.successCount;
                    dayStats2.successTime = l2 = dayStats2.successTime + dayStats3.successTime;
                    dayStats2.failureCount = n8 = dayStats2.failureCount + dayStats3.failureCount;
                    dayStats2.failureTime = l = dayStats2.failureTime + dayStats3.failureTime;
                }
                if (dayStats2 == null) continue;
                printWriter.print("  Week-");
                printWriter.print((n5 - n6) / 7);
                printWriter.print(": ");
                this.dumpDayStatistic(printWriter, dayStats2);
            }
        }
        if ((arrayList = this.mSyncStorageEngine.getSyncHistory()) != null && arrayList.size() > 0) {
            printWriter.println();
            printWriter.println("Recent Sync History");
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                SyncStorageEngine.SyncHistoryItem syncHistoryItem = arrayList.get(i);
                SyncStorageEngine.AuthorityInfo authorityInfo = this.mSyncStorageEngine.getAuthority(syncHistoryItem.authorityId);
                printWriter.print("  #");
                printWriter.print(i + 1);
                printWriter.print(": ");
                if (authorityInfo != null) {
                    printWriter.print(authorityInfo.account.name);
                    printWriter.print(":");
                    printWriter.print(authorityInfo.account.type);
                    printWriter.print(" ");
                    printWriter.print(authorityInfo.authority);
                } else {
                    printWriter.print("<no account>");
                }
                new Time().set(syncHistoryItem.eventTime);
                printWriter.print(" ");
                printWriter.print(SyncStorageEngine.SOURCES[syncHistoryItem.source]);
                printWriter.print(" @ ");
                printWriter.print(SyncManager.formatTime(syncHistoryItem.eventTime));
                printWriter.print(" for ");
                this.dumpTimeSec(printWriter, syncHistoryItem.elapsedTime);
                printWriter.println();
                if (syncHistoryItem.event != 1 || syncHistoryItem.upstreamActivity != 0L || syncHistoryItem.downstreamActivity != 0L) {
                    printWriter.print("    event=");
                    printWriter.print(syncHistoryItem.event);
                    printWriter.print(" upstreamActivity=");
                    printWriter.print(syncHistoryItem.upstreamActivity);
                    printWriter.print(" downstreamActivity=");
                    printWriter.println(syncHistoryItem.downstreamActivity);
                }
                if (syncHistoryItem.mesg == null || "success".equals(syncHistoryItem.mesg)) continue;
                printWriter.print("    mesg=");
                printWriter.println(syncHistoryItem.mesg);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dumpSyncState(PrintWriter printWriter, StringBuilder stringBuilder) {
        ArrayList<SyncStorageEngine.PendingOperation> arrayList;
        printWriter.print("data connected: ");
        printWriter.println(this.mDataConnectionIsConnected);
        printWriter.print("memory low: ");
        printWriter.println(this.mStorageIsLow);
        Account[] accountArray = this.mAccounts;
        printWriter.print("accounts: ");
        if (accountArray != INITIAL_ACCOUNTS_ARRAY) {
            printWriter.println(accountArray.length);
        } else {
            printWriter.println("not known yet");
        }
        long l = SystemClock.elapsedRealtime();
        printWriter.print("now: ");
        printWriter.print(l);
        printWriter.println(" (" + SyncManager.formatTime(System.currentTimeMillis()) + ")");
        printWriter.print("uptime: ");
        printWriter.print(DateUtils.formatElapsedTime(l / 1000L));
        printWriter.println(" (HH:MM:SS)");
        printWriter.print("time spent syncing: ");
        printWriter.print(DateUtils.formatElapsedTime(this.mSyncHandler.mSyncTimeTracker.timeSpentSyncing() / 1000L));
        printWriter.print(" (HH:MM:SS), sync ");
        String string2 = this.mSyncHandler.mSyncTimeTracker.mLastWasSyncing ? "" : "not ";
        printWriter.print(string2);
        printWriter.println("in progress");
        if (this.mSyncHandler.mAlarmScheduleTime != null) {
            printWriter.print("next alarm time: ");
            printWriter.print(this.mSyncHandler.mAlarmScheduleTime);
            printWriter.print(" (");
            printWriter.print(DateUtils.formatElapsedTime((this.mSyncHandler.mAlarmScheduleTime - l) / 1000L));
            printWriter.println(" (HH:MM:SS) from now)");
        } else {
            printWriter.println("no alarm is scheduled (there had better not be any pending syncs)");
        }
        ActiveSyncContext activeSyncContext = this.mActiveSyncContext;
        printWriter.print("active sync: ");
        printWriter.println(activeSyncContext);
        printWriter.print("notification info: ");
        stringBuilder.setLength(0);
        this.mSyncHandler.mSyncNotificationInfo.toString(stringBuilder);
        printWriter.println(stringBuilder.toString());
        SyncQueue syncQueue = this.mSyncQueue;
        synchronized (syncQueue) {
            printWriter.print("sync queue: ");
            stringBuilder.setLength(0);
            this.mSyncQueue.dump(stringBuilder);
            printWriter.println(stringBuilder.toString());
        }
        SyncInfo syncInfo = this.mSyncStorageEngine.getCurrentSync();
        if (syncInfo != null) {
            SyncStorageEngine.AuthorityInfo authorityInfo = this.mSyncStorageEngine.getAuthority(syncInfo.authorityId);
            long l2 = (l - syncInfo.startTime) / 1000L;
            printWriter.print("Active sync: ");
            Object object = authorityInfo != null ? authorityInfo.account : "<no account>";
            printWriter.print(object);
            printWriter.print(" ");
            String string3 = authorityInfo != null ? authorityInfo.authority : "<no account>";
            printWriter.print(string3);
            if (activeSyncContext != null) {
                printWriter.print(" ");
                printWriter.print(SyncStorageEngine.SOURCES[activeSyncContext.mSyncOperation.syncSource]);
            }
            printWriter.print(", duration is ");
            printWriter.println(DateUtils.formatElapsedTime(l2));
        } else {
            printWriter.println("No sync is in progress.");
        }
        if ((arrayList = this.mSyncStorageEngine.getPendingOperations()) != null && arrayList.size() > 0) {
            printWriter.println();
            printWriter.println("Pending Syncs");
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                SyncStorageEngine.PendingOperation pendingOperation = arrayList.get(i);
                printWriter.print("  #");
                printWriter.print(i);
                printWriter.print(": account=");
                printWriter.print(pendingOperation.account.name);
                printWriter.print(":");
                printWriter.print(pendingOperation.account.type);
                printWriter.print(" authority=");
                printWriter.print(pendingOperation.authority);
                printWriter.print(" expedited=");
                printWriter.println(pendingOperation.expedited);
                if (pendingOperation.extras == null || pendingOperation.extras.size() <= 0) continue;
                stringBuilder.setLength(0);
                SyncOperation.extrasToStringBuilder(pendingOperation.extras, stringBuilder, false);
                printWriter.print("    extras: ");
                printWriter.println(stringBuilder.toString());
            }
        }
        printWriter.println();
        printWriter.println("Sync Status");
        int n = accountArray.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            printWriter.print("  Account ");
            printWriter.print(account.name);
            printWriter.print(" ");
            printWriter.print(account.type);
            printWriter.println(":");
            for (RegisteredServicesCache.ServiceInfo serviceInfo : this.mSyncAdapters.getAllServices()) {
                int n3;
                if (!((SyncAdapterType)serviceInfo.type).accountType.equals(account.type)) continue;
                SyncStorageEngine.AuthorityInfo authorityInfo = this.mSyncStorageEngine.getOrCreateAuthority(account, ((SyncAdapterType)serviceInfo.type).authority);
                SyncStatusInfo syncStatusInfo = this.mSyncStorageEngine.getOrCreateSyncStatus(authorityInfo);
                printWriter.print("    ");
                printWriter.print(authorityInfo.authority);
                printWriter.println(":");
                printWriter.print("      settings:");
                StringBuilder stringBuilder2 = new StringBuilder().append(" ");
                String string4 = authorityInfo.syncable > 0 ? "syncable" : (authorityInfo.syncable == 0 ? "not syncable" : "not initialized");
                printWriter.print(stringBuilder2.append(string4).toString());
                StringBuilder stringBuilder3 = new StringBuilder().append(", ");
                String string5 = authorityInfo.enabled ? "enabled" : "disabled";
                printWriter.print(stringBuilder3.append(string5).toString());
                if (authorityInfo.delayUntil > l) {
                    printWriter.print(", delay for " + (authorityInfo.delayUntil - l) / 1000L + " sec");
                }
                if (authorityInfo.backoffTime > l) {
                    printWriter.print(", backoff for " + (authorityInfo.backoffTime - l) / 1000L + " sec");
                }
                if (authorityInfo.backoffDelay > 0L) {
                    printWriter.print(", the backoff increment is " + authorityInfo.backoffDelay / 1000L + " sec");
                }
                printWriter.println();
                for (int i = 0; i < (n3 = authorityInfo.periodicSyncs.size()); ++i) {
                    Pair<Bundle, Long> pair = authorityInfo.periodicSyncs.get(i);
                    long l3 = syncStatusInfo.getPeriodicSyncTime(i) + 1000L * (Long)pair.second;
                    printWriter.println("      periodic period=" + pair.second + ", extras=" + pair.first + ", next=" + SyncManager.formatTime(l3));
                }
                printWriter.print("      count: local=");
                printWriter.print(syncStatusInfo.numSourceLocal);
                printWriter.print(" poll=");
                printWriter.print(syncStatusInfo.numSourcePoll);
                printWriter.print(" periodic=");
                printWriter.print(syncStatusInfo.numSourcePeriodic);
                printWriter.print(" server=");
                printWriter.print(syncStatusInfo.numSourceServer);
                printWriter.print(" user=");
                printWriter.print(syncStatusInfo.numSourceUser);
                printWriter.print(" total=");
                printWriter.print(syncStatusInfo.numSyncs);
                printWriter.println();
                printWriter.print("      total duration: ");
                printWriter.println(DateUtils.formatElapsedTime(syncStatusInfo.totalElapsedTime / 1000L));
                if (syncStatusInfo.lastSuccessTime != 0L) {
                    printWriter.print("      SUCCESS: source=");
                    printWriter.print(SyncStorageEngine.SOURCES[syncStatusInfo.lastSuccessSource]);
                    printWriter.print(" time=");
                    printWriter.println(SyncManager.formatTime(syncStatusInfo.lastSuccessTime));
                }
                if (syncStatusInfo.lastFailureTime == 0L) continue;
                printWriter.print("      FAILURE: source=");
                printWriter.print(SyncStorageEngine.SOURCES[syncStatusInfo.lastFailureSource]);
                printWriter.print(" initialTime=");
                printWriter.print(SyncManager.formatTime(syncStatusInfo.initialFailureTime));
                printWriter.print(" lastTime=");
                printWriter.println(SyncManager.formatTime(syncStatusInfo.lastFailureTime));
                printWriter.print("      message: ");
                printWriter.println(syncStatusInfo.lastFailureMesg);
            }
            ++n2;
        }
        return;
    }

    public SyncAdapterType[] getSyncAdapterTypes() {
        Collection collection = this.mSyncAdapters.getAllServices();
        SyncAdapterType[] syncAdapterTypeArray = new SyncAdapterType[collection.size()];
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            syncAdapterTypeArray[n] = (SyncAdapterType)iterator.next().type;
            ++n;
        }
        return syncAdapterTypeArray;
    }

    public SyncStorageEngine getSyncStorageEngine() {
        return this.mSyncStorageEngine;
    }

    void maybeRescheduleSync(SyncResult syncResult, SyncOperation syncOperation) {
        boolean bl = Log.isLoggable(TAG, 3);
        if (bl) {
            Log.d(TAG, "encountered error(s) during the sync: " + syncResult + ", " + syncOperation);
        }
        SyncOperation syncOperation2 = new SyncOperation(syncOperation);
        if (syncOperation2.extras.getBoolean("ignore_backoff", false)) {
            syncOperation2.extras.remove("ignore_backoff");
        }
        if (syncOperation2.extras.getBoolean("do_not_retry", false)) {
            Log.d(TAG, "not retrying sync operation because SYNC_EXTRAS_DO_NOT_RETRY was specified " + syncOperation2);
            return;
        }
        if (syncOperation2.extras.getBoolean("upload", false)) {
            syncOperation2.extras.remove("upload");
            Log.d(TAG, "retrying sync operation as a two-way sync because an upload-only sync encountered an error: " + syncOperation2);
            this.scheduleSyncOperation(syncOperation2);
            return;
        }
        if (syncResult.tooManyRetries) {
            Log.d(TAG, "not retrying sync operation because it retried too many times: " + syncOperation2);
            return;
        }
        if (syncResult.madeSomeProgress()) {
            if (bl) {
                Log.d(TAG, "retrying sync operation because even though it had an error it achieved some success");
            }
            this.scheduleSyncOperation(syncOperation2);
            return;
        }
        if (syncResult.syncAlreadyInProgress) {
            if (bl) {
                Log.d(TAG, "retrying sync operation that failed because there was already a sync in progress: " + syncOperation2);
            }
            this.scheduleSyncOperation(new SyncOperation(syncOperation2.account, syncOperation2.syncSource, syncOperation2.authority, syncOperation2.extras, 10000L));
            return;
        }
        if (syncResult.hasSoftError()) {
            if (bl) {
                Log.d(TAG, "retrying sync operation because it encountered a soft error: " + syncOperation2);
            }
            this.scheduleSyncOperation(syncOperation2);
            return;
        }
        Log.d(TAG, "not retrying sync operation because the error is a hard error: " + syncOperation2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onAccountsUpdated(Account[] accountArray) {
        boolean bl = this.mAccounts == INITIAL_ACCOUNTS_ARRAY;
        this.mAccounts = accountArray;
        ActiveSyncContext activeSyncContext = this.mActiveSyncContext;
        if (activeSyncContext != null && !ArrayUtils.contains(accountArray, activeSyncContext.mSyncOperation.account)) {
            Log.d(TAG, "canceling sync since the account has been removed");
            this.sendSyncFinishedOrCanceledMessage(activeSyncContext, null);
        }
        this.sendCheckAlarmsMessage();
        if (this.mBootCompleted) {
            this.mSyncStorageEngine.doDatabaseCleanup(accountArray);
        }
        if (accountArray.length > 0) {
            this.scheduleSync(null, null, null, 0L, bl);
        }
    }

    public void scheduleLocalSync(Account account, String string2) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("upload", true);
        this.scheduleSync(account, string2, bundle, LOCAL_SYNC_DELAY, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void scheduleSync(Account account, String string2, Bundle bundle, long l, boolean bl) {
        Account[] accountArray;
        boolean bl2 = Log.isLoggable(TAG, 2);
        boolean bl3 = !this.mBootCompleted || this.getConnectivityManager().getBackgroundDataSetting();
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (Boolean.valueOf(bundle.getBoolean("expedited", false)).booleanValue()) {
            l = -1L;
        }
        if (account != null) {
            accountArray = new Account[]{account};
        } else {
            accountArray = this.mAccounts;
            if (accountArray.length == 0) {
                if (!bl2) return;
                Log.v(TAG, "scheduleSync: no accounts configured, dropping");
                return;
            }
        }
        boolean bl4 = bundle.getBoolean("upload", false);
        boolean bl5 = bundle.getBoolean("force", false);
        if (bl5) {
            bundle.putBoolean("ignore_backoff", true);
            bundle.putBoolean("ignore_settings", true);
        }
        boolean bl6 = bundle.getBoolean("ignore_settings", false);
        int n = bl4 ? 1 : (bl5 ? 3 : (string2 == null ? 2 : 0));
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.mSyncAdapters.getAllServices().iterator();
        while (iterator.hasNext()) {
            hashSet.add(((SyncAdapterType)iterator.next().type).authority);
        }
        if (string2 != null) {
            boolean bl7 = hashSet.contains(string2);
            hashSet.clear();
            if (bl7) {
                hashSet.add(string2);
            }
        }
        boolean bl8 = this.mSyncStorageEngine.getMasterSyncAutomatically();
        Iterator iterator2 = hashSet.iterator();
        block1: while (iterator2.hasNext()) {
            String string3 = (String)iterator2.next();
            Account[] accountArray2 = accountArray;
            int n2 = accountArray2.length;
            int n3 = 0;
            while (true) {
                RegisteredServicesCache.ServiceInfo<SyncAdapterType> serviceInfo;
                if (n3 >= n2) continue block1;
                Account account2 = accountArray2[n3];
                int n4 = this.mSyncStorageEngine.getIsSyncable(account2, string3);
                if (!(n4 == 0 || bl && n4 >= 0 || (serviceInfo = this.mSyncAdapters.getServiceInfo(SyncAdapterType.newKey(string3, account2.type))) == null || !((SyncAdapterType)serviceInfo.type).supportsUploading() && bl4)) {
                    boolean bl9 = n4 < 0 || bl6 || bl3 && bl8 && this.mSyncStorageEngine.getSyncAutomatically(account2, string3);
                    if (!bl9) {
                        if (bl2) {
                            Log.d(TAG, "scheduleSync: sync of " + account2 + ", " + string3 + " is not allowed, dropping request");
                        }
                    } else {
                        if (bl2) {
                            Log.v(TAG, "scheduleSync: delay " + l + ", source " + n + ", account " + account2 + ", authority " + string3 + ", extras " + bundle);
                        }
                        this.scheduleSyncOperation(new SyncOperation(account2, n, string3, bundle, l));
                    }
                }
                ++n3;
            }
            break;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void scheduleSyncOperation(SyncOperation syncOperation) {
        ActiveSyncContext activeSyncContext = this.mActiveSyncContext;
        if (syncOperation.expedited && activeSyncContext != null) {
            boolean bl = activeSyncContext.mSyncOperation.key.equals(syncOperation.key);
            if (!activeSyncContext.mSyncOperation.expedited && !bl) {
                this.scheduleSyncOperation(new SyncOperation(activeSyncContext.mSyncOperation));
                this.sendSyncFinishedOrCanceledMessage(activeSyncContext, null);
            }
        }
        SyncQueue syncQueue = this.mSyncQueue;
        // MONITORENTER : syncQueue
        boolean bl = this.mSyncQueue.add(syncOperation);
        // MONITOREXIT : syncQueue
        if (!bl) {
            if (!Log.isLoggable(TAG, 2)) return;
            Log.v(TAG, "scheduleSyncOperation: dropping duplicate sync operation " + syncOperation);
            return;
        }
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "scheduleSyncOperation: enqueued " + syncOperation);
        }
        this.sendCheckAlarmsMessage();
    }

    class ActiveSyncContext
    extends ISyncContext.Stub
    implements ServiceConnection {
        boolean mBound;
        final long mHistoryRowId;
        final long mStartTime;
        ISyncAdapter mSyncAdapter;
        final SyncOperation mSyncOperation;
        long mTimeoutStartTime;

        public ActiveSyncContext(SyncOperation syncOperation, long l) {
            this.mSyncOperation = syncOperation;
            this.mHistoryRowId = l;
            this.mSyncAdapter = null;
            this.mTimeoutStartTime = this.mStartTime = SystemClock.elapsedRealtime();
        }

        boolean bindToSyncAdapter(RegisteredServicesCache.ServiceInfo serviceInfo) {
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Log.d(SyncManager.TAG, "bindToSyncAdapter: " + serviceInfo.componentName + ", connection " + this);
            }
            Intent intent = new Intent();
            intent.setAction("android.content.SyncAdapter");
            intent.setComponent(serviceInfo.componentName);
            intent.putExtra("android.intent.extra.client_label", 17040226);
            intent.putExtra("android.intent.extra.client_intent", PendingIntent.getActivity(SyncManager.this.mContext, 0, new Intent("android.settings.SYNC_SETTINGS"), 0));
            this.mBound = true;
            boolean bl = SyncManager.this.mContext.bindService(intent, this, 5);
            if (!bl) {
                this.mBound = false;
            }
            return bl;
        }

        protected void close() {
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Log.d(SyncManager.TAG, "unBindFromSyncAdapter: connection " + this);
            }
            if (this.mBound) {
                this.mBound = false;
                SyncManager.this.mContext.unbindService(this);
            }
        }

        @Override
        public void onFinished(SyncResult syncResult) {
            SyncManager.this.sendSyncFinishedOrCanceledMessage(this, syncResult);
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            Message message = SyncManager.this.mSyncHandler.obtainMessage();
            message.what = 4;
            message.obj = new ServiceConnectionData(this, ISyncAdapter.Stub.asInterface(iBinder));
            SyncManager.this.mSyncHandler.sendMessage(message);
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            Message message = SyncManager.this.mSyncHandler.obtainMessage();
            message.what = 5;
            message.obj = new ServiceConnectionData(this, null);
            SyncManager.this.mSyncHandler.sendMessage(message);
        }

        @Override
        public void sendHeartbeat() {
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.toString(stringBuilder);
            return stringBuilder.toString();
        }

        public void toString(StringBuilder stringBuilder) {
            stringBuilder.append("startTime ").append(this.mStartTime).append(", mTimeoutStartTime ").append(this.mTimeoutStartTime).append(", mHistoryRowId ").append(this.mHistoryRowId).append(", syncOperation ").append(this.mSyncOperation);
        }
    }

    private static class InitializerServiceConnection
    implements ServiceConnection {
        private final Account mAccount;
        private final String mAuthority;
        private volatile Context mContext;
        private final Handler mHandler;
        private volatile boolean mInitialized;

        public InitializerServiceConnection(Account account, String string2, Context context, Handler handler) {
            this.mAccount = account;
            this.mAuthority = string2;
            this.mContext = context;
            this.mHandler = handler;
            this.mInitialized = false;
        }

        static /* synthetic */ Context access$502(InitializerServiceConnection initializerServiceConnection, Context context) {
            initializerServiceConnection.mContext = context;
            return context;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void onServiceConnected(ComponentName var1_1, IBinder var2_2) {
            try {
                if (!this.mInitialized) {
                    this.mInitialized = true;
                    if (Log.isLoggable("SyncManager", 2)) {
                        Log.v("SyncManager", "calling initialize: " + this.mAccount + ", authority " + this.mAuthority);
                    }
                    ISyncAdapter.Stub.asInterface(var2_2).initialize(this.mAccount, this.mAuthority);
                }
                var7_3 = this.mHandler;
            }
            catch (RemoteException var5_5) {
                try {
                    Log.d("SyncManager", "error while initializing: " + this.mAccount + ", authority " + this.mAuthority, var5_5);
                    var7_3 = this.mHandler;
                }
                catch (Throwable var3_6) {
                    this.mHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (InitializerServiceConnection.this.mContext != null) {
                                InitializerServiceConnection.this.mContext.unbindService(InitializerServiceConnection.this);
                                InitializerServiceConnection.access$502(InitializerServiceConnection.this, null);
                            }
                        }
                    }, 5000L);
                    throw var3_6;
                }
                var8_4 = new /* invalid duplicate definition of identical inner class */;
                ** continue;
            }
            var8_4 = new /* invalid duplicate definition of identical inner class */;
lbl10:
            // 2 sources

            while (true) {
                var7_3.postDelayed(var8_4, 5000L);
                return;
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            if (this.mContext != null) {
                this.mContext.unbindService(this);
                this.mContext = null;
            }
        }
    }

    class ServiceConnectionData {
        public final ActiveSyncContext activeSyncContext;
        public final ISyncAdapter syncAdapter;

        ServiceConnectionData(ActiveSyncContext activeSyncContext, ISyncAdapter iSyncAdapter) {
            this.activeSyncContext = activeSyncContext;
            this.syncAdapter = iSyncAdapter;
        }
    }

    class SyncAlarmIntentReceiver
    extends BroadcastReceiver {
        SyncAlarmIntentReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            SyncManager.this.mHandleAlarmWakeLock.acquire();
            SyncManager.this.sendSyncAlarmMessage();
        }
    }

    class SyncHandler
    extends Handler {
        private static final int MESSAGE_CHECK_ALARMS = 3;
        private static final int MESSAGE_SERVICE_CONNECTED = 4;
        private static final int MESSAGE_SERVICE_DISCONNECTED = 5;
        private static final int MESSAGE_SYNC_ALARM = 2;
        private static final int MESSAGE_SYNC_FINISHED = 1;
        private Long mAlarmScheduleTime;
        private boolean mErrorNotificationInstalled;
        private volatile CountDownLatch mReadyToRunLatch;
        public final SyncNotificationInfo mSyncNotificationInfo;
        public final SyncTimeTracker mSyncTimeTracker;

        public SyncHandler(Looper looper) {
            super(looper);
            this.mSyncNotificationInfo = new SyncNotificationInfo();
            this.mAlarmScheduleTime = null;
            this.mSyncTimeTracker = new SyncTimeTracker();
            this.mErrorNotificationInstalled = false;
            this.mReadyToRunLatch = new CountDownLatch(1);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void installHandleTooManyDeletesNotification(Account account, String string2, long l) {
            ProviderInfo providerInfo;
            if (SyncManager.this.mNotificationMgr == null || (providerInfo = SyncManager.this.mContext.getPackageManager().resolveContentProvider(string2, 0)) == null) {
                return;
            }
            CharSequence charSequence = providerInfo.loadLabel(SyncManager.this.mContext.getPackageManager());
            Intent intent = new Intent();
            intent.setClassName("com.android.providers.subscribedfeeds", "com.android.settings.SyncActivityTooManyDeletes");
            intent.putExtra("account", account);
            intent.putExtra("authority", string2);
            intent.putExtra("provider", ((Object)charSequence).toString());
            intent.putExtra("numDeletes", l);
            if (!this.isActivityAvailable(intent)) {
                Log.w(SyncManager.TAG, "No activity found to handle too many deletes.");
                return;
            }
            PendingIntent pendingIntent = PendingIntent.getActivity(SyncManager.this.mContext, 0, intent, 0x10000000);
            CharSequence charSequence2 = SyncManager.this.mContext.getResources().getText(17039627);
            Notification notification = new Notification(17302163, SyncManager.this.mContext.getString(17039625), System.currentTimeMillis());
            notification.setLatestEventInfo(SyncManager.this.mContext, SyncManager.this.mContext.getString(17039626), String.format(((Object)charSequence2).toString(), charSequence), pendingIntent);
            notification.flags = 2 | notification.flags;
            SyncManager.this.mNotificationMgr.notify(account.hashCode() ^ string2.hashCode(), notification);
        }

        private boolean isActivityAvailable(Intent intent) {
            List<ResolveInfo> list = SyncManager.this.mContext.getPackageManager().queryIntentActivities(intent, 0);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if ((1 & list.get((int)i).activityInfo.applicationInfo.flags) == 0) continue;
                return true;
            }
            return false;
        }

        private void manageErrorNotification() {
            long l = SyncManager.this.mSyncStorageEngine.getInitialSyncFailureTime();
            if (l > 0L && 600000L + l < System.currentTimeMillis()) {
                if (!this.mErrorNotificationInstalled) {
                    SyncManager.access$2502(SyncManager.this, true);
                    this.sendSyncStateIntent();
                }
                this.mErrorNotificationInstalled = true;
                return;
            }
            if (this.mErrorNotificationInstalled) {
                SyncManager.access$2502(SyncManager.this, false);
                this.sendSyncStateIntent();
            }
            this.mErrorNotificationInstalled = false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void manageSyncAlarm(Long l) {
            block16: {
                block12: {
                    boolean bl;
                    boolean bl2;
                    Long l2;
                    block15: {
                        boolean bl3;
                        block13: {
                            block14: {
                                long l3;
                                if (!SyncManager.this.mDataConnectionIsConnected || SyncManager.this.mStorageIsLow) break block12;
                                long l4 = SystemClock.elapsedRealtime();
                                if (SyncManager.this.mActiveSyncContext == null) {
                                    SyncQueue syncQueue = SyncManager.this.mSyncQueue;
                                    synchronized (syncQueue) {
                                        Pair<SyncOperation, Long> pair = SyncManager.this.mSyncQueue.nextOperation();
                                        l2 = l == null && pair == null ? null : (l == null ? (Long)pair.second : (pair == null ? l : Long.valueOf(Math.min(l, (Long)pair.second))));
                                    }
                                }
                                long l5 = 30000L + ((SyncManager)SyncManager.this).mSyncHandler.mSyncNotificationInfo.startTime;
                                long l6 = ((SyncManager)SyncManager.this).mActiveSyncContext.mTimeoutStartTime + MAX_TIME_PER_SYNC;
                                l2 = ((SyncManager)SyncManager.this).mSyncHandler.mSyncNotificationInfo.isActive ? Long.valueOf(l6) : Long.valueOf(Math.min(l5, l6));
                                if (!this.mErrorNotificationInstalled && (l3 = SyncManager.this.mSyncStorageEngine.getInitialSyncFailureTime()) > 0L) {
                                    long l7 = l4 + (l3 + 600000L - System.currentTimeMillis());
                                    long l8 = l2 != null ? Math.min(l2, l7) : l7;
                                    l2 = l8;
                                }
                                bl2 = false;
                                bl3 = this.mAlarmScheduleTime != null;
                                boolean bl4 = l2 != null;
                                if (!bl4) break block13;
                                if (!bl3) break block14;
                                long l9 = l2 - this.mAlarmScheduleTime;
                                long l10 = l9 == 0L ? 0 : (l9 < 0L ? -1 : 1);
                                bl2 = false;
                                bl = false;
                                if (l10 >= 0) break block15;
                            }
                            bl = true;
                            break block15;
                        }
                        bl2 = bl3;
                        bl = false;
                    }
                    SyncManager.this.ensureAlarmService();
                    if (bl) {
                        this.mAlarmScheduleTime = l2;
                        SyncManager.this.mAlarmService.set(2, l2, SyncManager.this.mSyncAlarmIntent);
                        return;
                    }
                    if (bl2) break block16;
                }
                return;
            }
            this.mAlarmScheduleTime = null;
            SyncManager.this.mAlarmService.cancel(SyncManager.this.mSyncAlarmIntent);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void manageSyncNotification() {
            boolean bl;
            boolean bl2;
            if (SyncManager.this.mActiveSyncContext == null) {
                this.mSyncNotificationInfo.startTime = null;
                bl2 = this.mSyncNotificationInfo.isActive;
                bl = false;
            } else {
                SyncOperation syncOperation = ((SyncManager)SyncManager.this).mActiveSyncContext.mSyncOperation;
                long l = SystemClock.elapsedRealtime();
                if (this.mSyncNotificationInfo.startTime == null) {
                    this.mSyncNotificationInfo.startTime = l;
                }
                bl2 = this.mSyncNotificationInfo.isActive && (!syncOperation.authority.equals(this.mSyncNotificationInfo.authority) || !syncOperation.account.equals(this.mSyncNotificationInfo.account));
                if (this.mSyncNotificationInfo.isActive) {
                    bl = bl2;
                } else {
                    boolean bl3 = l > 30000L + this.mSyncNotificationInfo.startTime;
                    boolean bl4 = syncOperation.extras.getBoolean("force", false);
                    bl = bl3 || bl4;
                }
            }
            if (bl2 && !bl) {
                SyncManager.access$2402(SyncManager.this, false);
                this.sendSyncStateIntent();
                this.mSyncNotificationInfo.isActive = false;
            }
            if (bl) {
                SyncOperation syncOperation = ((SyncManager)SyncManager.this).mActiveSyncContext.mSyncOperation;
                SyncManager.access$2402(SyncManager.this, true);
                this.sendSyncStateIntent();
                this.mSyncNotificationInfo.isActive = true;
                this.mSyncNotificationInfo.account = syncOperation.account;
                this.mSyncNotificationInfo.authority = syncOperation.authority;
            }
        }

        private void runBoundToSyncAdapter(ISyncAdapter iSyncAdapter) {
            ((SyncManager)SyncManager.this).mActiveSyncContext.mSyncAdapter = iSyncAdapter;
            SyncOperation syncOperation = ((SyncManager)SyncManager.this).mActiveSyncContext.mSyncOperation;
            try {
                iSyncAdapter.startSync(SyncManager.this.mActiveSyncContext, syncOperation.authority, syncOperation.account, syncOperation.extras);
                return;
            }
            catch (RemoteException remoteException) {
                Log.d(SyncManager.TAG, "runStateIdle: caught a RemoteException, rescheduling", remoteException);
                SyncManager.this.mActiveSyncContext.close();
                SyncManager.access$1102(SyncManager.this, null);
                SyncManager.this.mSyncStorageEngine.setActiveSync(SyncManager.this.mActiveSyncContext);
                SyncManager.this.increaseBackoffSetting(syncOperation);
                SyncManager.this.scheduleSyncOperation(new SyncOperation(syncOperation));
                return;
            }
            catch (RuntimeException runtimeException) {
                SyncManager.this.mActiveSyncContext.close();
                SyncManager.access$1102(SyncManager.this, null);
                SyncManager.this.mSyncStorageEngine.setActiveSync(SyncManager.this.mActiveSyncContext);
                Log.e(SyncManager.TAG, "Caught RuntimeException while starting the sync " + syncOperation, runtimeException);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void runStateIdle() {
            int n;
            SyncOperation syncOperation;
            boolean bl = Log.isLoggable(SyncManager.TAG, 2);
            if (bl) {
                Log.v(SyncManager.TAG, "runStateIdle");
            }
            if (!SyncManager.this.mDataConnectionIsConnected) {
                if (!bl) return;
                Log.v(SyncManager.TAG, "runStateIdle: no data connection, skipping");
                return;
            }
            if (SyncManager.this.mStorageIsLow) {
                if (!bl) return;
                Log.v(SyncManager.TAG, "runStateIdle: memory low, skipping");
                return;
            }
            if (SyncManager.this.mAccounts == INITIAL_ACCOUNTS_ARRAY) {
                if (!bl) return;
                Log.v(SyncManager.TAG, "runStateIdle: accounts not known, skipping");
                return;
            }
            boolean bl2 = SyncManager.this.getConnectivityManager().getBackgroundDataSetting();
            boolean bl3 = SyncManager.this.mSyncStorageEngine.getMasterSyncAutomatically();
            SyncQueue syncQueue = SyncManager.this.mSyncQueue;
            synchronized (syncQueue) {
                long l = SystemClock.elapsedRealtime();
                do {
                    Pair<SyncOperation, Long> pair;
                    if ((pair = SyncManager.this.mSyncQueue.nextOperation()) == null || (Long)pair.second > l) {
                        if (!bl) return;
                        Log.v(SyncManager.TAG, "runStateIdle: no more ready sync operations, returning");
                        return;
                    }
                    syncOperation = (SyncOperation)pair.first;
                    SyncManager.this.mSyncQueue.remove(syncOperation);
                } while (!ArrayUtils.contains(SyncManager.this.mAccounts, syncOperation.account) || (n = SyncManager.this.mSyncStorageEngine.getIsSyncable(syncOperation.account, syncOperation.authority)) == 0 || !syncOperation.extras.getBoolean("ignore_settings", false) && n > 0 && (!bl3 || !bl2 || !SyncManager.this.mSyncStorageEngine.getSyncAutomatically(syncOperation.account, syncOperation.authority)));
                if (bl) {
                    Log.v(SyncManager.TAG, "runStateIdle: we are going to sync " + syncOperation);
                }
            }
            boolean bl4 = syncOperation.extras.getBoolean("initialize", false);
            if (n < 0 && !bl4) {
                syncOperation.extras.putBoolean("initialize", true);
                syncOperation = new SyncOperation(syncOperation);
            } else if (n > 0 && bl4) {
                syncOperation.extras.putBoolean("initialize", false);
                syncOperation = new SyncOperation(syncOperation);
            }
            SyncAdapterType syncAdapterType = SyncAdapterType.newKey(syncOperation.authority, syncOperation.account.type);
            RegisteredServicesCache.ServiceInfo<SyncAdapterType> serviceInfo = SyncManager.this.mSyncAdapters.getServiceInfo(syncAdapterType);
            if (serviceInfo == null) {
                Log.d(SyncManager.TAG, "can't find a sync adapter for " + syncAdapterType + ", removing settings for it");
                SyncManager.this.mSyncStorageEngine.removeAuthority(syncOperation.account, syncOperation.authority);
                this.runStateIdle();
                return;
            }
            SyncManager syncManager = SyncManager.this;
            long l = this.insertStartSyncEvent(syncOperation);
            ActiveSyncContext activeSyncContext = syncManager.new ActiveSyncContext(syncOperation, l);
            SyncManager.access$1102(SyncManager.this, activeSyncContext);
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Log.v(SyncManager.TAG, "runStateIdle: setting mActiveSyncContext to " + SyncManager.this.mActiveSyncContext);
            }
            SyncManager.this.mSyncStorageEngine.setActiveSync(SyncManager.this.mActiveSyncContext);
            if (!activeSyncContext.bindToSyncAdapter(serviceInfo)) {
                Log.e(SyncManager.TAG, "Bind attempt failed to " + serviceInfo);
                SyncManager.this.mActiveSyncContext.close();
                SyncManager.access$1102(SyncManager.this, null);
                SyncManager.this.mSyncStorageEngine.setActiveSync(SyncManager.this.mActiveSyncContext);
                SyncManager.this.mSyncWakeLock.setWorkSource(null);
                this.runStateIdle();
                return;
            }
            SyncManager.this.mSyncWakeLock.setWorkSource(new WorkSource(serviceInfo.uid));
            SyncManager.this.mSyncWakeLock.acquire();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void runStateSyncing() {
            long l;
            block6: {
                block5: {
                    ActiveSyncContext activeSyncContext = SyncManager.this.mActiveSyncContext;
                    l = SystemClock.elapsedRealtime();
                    if (l <= activeSyncContext.mTimeoutStartTime + MAX_TIME_PER_SYNC) break block5;
                    SyncQueue syncQueue = SyncManager.this.mSyncQueue;
                    synchronized (syncQueue) {
                        Pair<SyncOperation, Long> pair = SyncManager.this.mSyncQueue.nextOperation();
                        if (pair == null || (Long)pair.second > l) break block6;
                    }
                    Log.d(SyncManager.TAG, "canceling and rescheduling sync because it ran too long: " + activeSyncContext.mSyncOperation);
                    SyncManager.this.scheduleSyncOperation(new SyncOperation(activeSyncContext.mSyncOperation));
                    SyncManager.this.sendSyncFinishedOrCanceledMessage(activeSyncContext, null);
                }
                return;
            }
            activeSyncContext.mTimeoutStartTime = l + MAX_TIME_PER_SYNC;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void runSyncFinishedOrCanceled(SyncResult syncResult) {
            String string2;
            boolean bl = Log.isLoggable(SyncManager.TAG, 2);
            ActiveSyncContext activeSyncContext = SyncManager.this.mActiveSyncContext;
            SyncManager.access$1102(SyncManager.this, null);
            SyncManager.this.mSyncStorageEngine.setActiveSync(SyncManager.this.mActiveSyncContext);
            SyncOperation syncOperation = activeSyncContext.mSyncOperation;
            long l = SystemClock.elapsedRealtime() - activeSyncContext.mStartTime;
            if (syncResult != null) {
                if (bl) {
                    Log.v(SyncManager.TAG, "runSyncFinishedOrCanceled [finished]: " + syncOperation + ", result " + syncResult);
                }
                if (!syncResult.hasError()) {
                    string2 = "success";
                    SyncManager.this.clearBackoffSetting(syncOperation);
                    if (syncOperation.extras.getBoolean("initialize", false) && SyncManager.this.mSyncStorageEngine.getIsSyncable(syncOperation.account, syncOperation.authority) > 0) {
                        SyncManager.this.scheduleSyncOperation(new SyncOperation(syncOperation));
                    }
                } else {
                    Log.d(SyncManager.TAG, "failed sync operation " + syncOperation + ", " + syncResult);
                    if (!syncResult.syncAlreadyInProgress) {
                        SyncManager.this.increaseBackoffSetting(syncOperation);
                    }
                    SyncManager.this.maybeRescheduleSync(syncResult, syncOperation);
                    string2 = Integer.toString(this.syncResultToErrorNumber(syncResult));
                }
                SyncManager.this.setDelayUntilTime(syncOperation, syncResult.delayUntil);
            } else {
                if (bl) {
                    Log.v(SyncManager.TAG, "runSyncFinishedOrCanceled [canceled]: " + syncOperation);
                }
                if (activeSyncContext.mSyncAdapter != null) {
                    try {
                        activeSyncContext.mSyncAdapter.cancelSync(activeSyncContext);
                    }
                    catch (RemoteException remoteException) {}
                }
                string2 = "canceled";
            }
            this.stopSyncEvent(activeSyncContext.mHistoryRowId, syncOperation, string2, 0, 0, l);
            activeSyncContext.close();
            if (syncResult != null && syncResult.tooManyDeletions) {
                this.installHandleTooManyDeletesNotification(syncOperation.account, syncOperation.authority, syncResult.stats.numDeletes);
            } else {
                SyncManager.this.mNotificationMgr.cancel(syncOperation.account.hashCode() ^ syncOperation.authority.hashCode());
            }
            if (syncResult != null && syncResult.fullSyncRequested) {
                SyncManager.this.scheduleSyncOperation(new SyncOperation(syncOperation.account, syncOperation.syncSource, syncOperation.authority, new Bundle(), 0L));
            }
        }

        /*
         * Unable to fully structure code
         */
        private Long scheduleReadyPeriodicSyncs() {
            var1_1 = SyncManager.access$300(SyncManager.this).getBackgroundDataSetting();
            var2_2 = null;
            if (!var1_1 || !SyncManager.access$1400(SyncManager.this).getMasterSyncAutomatically()) {
                return null;
            }
            var3_3 = System.currentTimeMillis();
            for (SyncStorageEngine.AuthorityInfo var10_6 : SyncManager.access$1400(SyncManager.this).getAuthorities()) {
                if (!ArrayUtils.contains(SyncManager.access$1600(SyncManager.this), var10_6.account) || !SyncManager.access$1400(SyncManager.this).getSyncAutomatically(var10_6.account, var10_6.authority) || SyncManager.access$1400(SyncManager.this).getIsSyncable(var10_6.account, var10_6.authority) == 0) continue;
                var11_7 = SyncManager.access$1400(SyncManager.this).getOrCreateSyncStatus(var10_6);
                var13_9 = var10_6.periodicSyncs.size();
                block1: for (var12_8 = 0; var12_8 < var13_9; ++var12_8) {
                    var14_10 = (Bundle)var10_6.periodicSyncs.get((int)var12_8).first;
                    var15_11 = (Long)var10_6.periodicSyncs.get((int)var12_8).second;
                    var16_5 = var11_7.getPeriodicSyncTime(var12_8) + 1000L * var15_11;
                    if (var16_5 <= var3_3) {
                        SyncManager.this.scheduleSyncOperation(new SyncOperation(var10_6.account, 4, var10_6.authority, var14_10, 0L));
                        var11_7.setPeriodicSyncTime(var12_8, var3_3);
lbl17:
                        // 3 sources

                        continue block1;
                    }
                    if (var2_2 != null && var16_5 >= var2_2) ** GOTO lbl17
                    var2_2 = var16_5;
                    ** continue;
                }
            }
            if (var2_2 == null) {
                return null;
            }
            var6_12 = SystemClock.elapsedRealtime();
            if (var2_2 < var3_3) {
                var8_13 = 0L;
lbl28:
                // 2 sources

                return var6_12 + var8_13;
            }
            var8_13 = var2_2 - var3_3;
            ** while (true)
        }

        private void sendSyncStateIntent() {
            Intent intent = new Intent("android.intent.action.SYNC_STATE_CHANGED");
            intent.addFlags(0x10000000);
            intent.putExtra("active", SyncManager.this.mNeedSyncActiveNotification);
            intent.putExtra("failing", SyncManager.this.mNeedSyncErrorNotification);
            SyncManager.this.mContext.sendBroadcast(intent);
        }

        private int syncResultToErrorNumber(SyncResult syncResult) {
            if (syncResult.syncAlreadyInProgress) {
                return 1;
            }
            if (syncResult.stats.numAuthExceptions > 0L) {
                return 2;
            }
            if (syncResult.stats.numIoExceptions > 0L) {
                return 3;
            }
            if (syncResult.stats.numParseExceptions > 0L) {
                return 4;
            }
            if (syncResult.stats.numConflictDetectedExceptions > 0L) {
                return 5;
            }
            if (syncResult.tooManyDeletions) {
                return 6;
            }
            if (syncResult.tooManyRetries) {
                return 7;
            }
            if (syncResult.databaseError) {
                return 8;
            }
            throw new IllegalStateException("we are not in an error state, " + syncResult);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void waitUntilReadyToRun() {
            CountDownLatch countDownLatch = this.mReadyToRunLatch;
            if (countDownLatch == null) return;
            while (true) {
                try {
                    countDownLatch.await();
                    this.mReadyToRunLatch = null;
                    return;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void handleMessage(Message var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 310->492)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public long insertStartSyncEvent(SyncOperation syncOperation) {
            int n = syncOperation.syncSource;
            long l = System.currentTimeMillis();
            Object[] objectArray = new Object[]{syncOperation.authority, 0, n, syncOperation.account.name.hashCode()};
            EventLog.writeEvent(2720, objectArray);
            return SyncManager.this.mSyncStorageEngine.insertStartSyncEvent(syncOperation.account, syncOperation.authority, l, n);
        }

        public void onBootCompleted() {
            SyncManager.access$1302(SyncManager.this, true);
            SyncManager.this.mSyncStorageEngine.doDatabaseCleanup(AccountManager.get(SyncManager.this.mContext).getAccounts());
            if (this.mReadyToRunLatch != null) {
                this.mReadyToRunLatch.countDown();
            }
        }

        public void stopSyncEvent(long l, SyncOperation syncOperation, String string2, int n, int n2, long l2) {
            Object[] objectArray = new Object[]{syncOperation.authority, 1, syncOperation.syncSource, syncOperation.account.name.hashCode()};
            EventLog.writeEvent(2720, objectArray);
            SyncManager.this.mSyncStorageEngine.stopSyncEvent(l, l2, string2, n2, n);
        }

        class SyncNotificationInfo {
            public Account account;
            public String authority;
            public boolean isActive = false;
            public Long startTime = null;

            SyncNotificationInfo() {
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                this.toString(stringBuilder);
                return stringBuilder.toString();
            }

            public void toString(StringBuilder stringBuilder) {
                stringBuilder.append("account ").append(this.account).append(", authority ").append(this.authority).append(", isActive ").append(this.isActive).append(", startTime ").append(this.startTime);
            }
        }
    }

    class SyncHandlerMessagePayload {
        public final ActiveSyncContext activeSyncContext;
        public final SyncResult syncResult;

        SyncHandlerMessagePayload(ActiveSyncContext activeSyncContext, SyncResult syncResult) {
            this.activeSyncContext = activeSyncContext;
            this.syncResult = syncResult;
        }
    }

    private class SyncTimeTracker {
        boolean mLastWasSyncing = false;
        private long mTimeSpentSyncing;
        long mWhenSyncStarted = 0L;

        private SyncTimeTracker() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public long timeSpentSyncing() {
            synchronized (this) {
                block4: {
                    if (this.mLastWasSyncing) break block4;
                    return this.mTimeSpentSyncing;
                }
                long l = SystemClock.elapsedRealtime();
                long l2 = this.mTimeSpentSyncing;
                long l3 = this.mWhenSyncStarted;
                return l2 + (l - l3);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void update() {
            synchronized (this) {
                boolean bl = SyncManager.this.mActiveSyncContext != null;
                boolean bl2 = this.mLastWasSyncing;
                if (bl != bl2) {
                    long l = SystemClock.elapsedRealtime();
                    if (bl) {
                        this.mWhenSyncStarted = l;
                    } else {
                        this.mTimeSpentSyncing += l - this.mWhenSyncStarted;
                    }
                    this.mLastWasSyncing = bl;
                }
                return;
            }
        }
    }
}

