/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.content.SyncStorageEngine;
import android.os.Bundle;
import android.os.SystemClock;

public class SyncOperation
implements Comparable {
    public final Account account;
    public String authority;
    public long earliestRunTime;
    public boolean expedited;
    public Bundle extras;
    public final String key;
    public SyncStorageEngine.PendingOperation pendingOperation;
    public int syncSource;

    /*
     * Enabled aggressive block sorting
     */
    public SyncOperation(Account account, int n, String string2, Bundle bundle, long l) {
        this.account = account;
        this.syncSource = n;
        this.authority = string2;
        this.extras = new Bundle(bundle);
        this.removeFalseExtra("upload");
        this.removeFalseExtra("force");
        this.removeFalseExtra("ignore_settings");
        this.removeFalseExtra("ignore_backoff");
        this.removeFalseExtra("do_not_retry");
        this.removeFalseExtra("discard_deletions");
        this.removeFalseExtra("expedited");
        this.removeFalseExtra("deletions_override");
        long l2 = SystemClock.elapsedRealtime();
        if (l < 0L) {
            this.expedited = true;
            this.earliestRunTime = l2;
        } else {
            this.expedited = false;
            this.earliestRunTime = l2 + l;
        }
        this.key = this.toKey();
    }

    SyncOperation(SyncOperation syncOperation) {
        this.account = syncOperation.account;
        this.syncSource = syncOperation.syncSource;
        this.authority = syncOperation.authority;
        this.extras = new Bundle(syncOperation.extras);
        this.expedited = syncOperation.expedited;
        this.earliestRunTime = SystemClock.elapsedRealtime();
        this.key = this.toKey();
    }

    public static void extrasToStringBuilder(Bundle bundle, StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("[");
        for (String string2 : bundle.keySet()) {
            if (bl && "initialize".equals(string2)) continue;
            stringBuilder.append(string2).append("=").append(bundle.get(string2)).append(" ");
        }
        stringBuilder.append("]");
    }

    private void removeFalseExtra(String string2) {
        if (!this.extras.getBoolean(string2, false)) {
            this.extras.remove(string2);
        }
    }

    private String toKey() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("authority: ").append(this.authority);
        stringBuilder.append(" account {name=" + this.account.name + ", type=" + this.account.type + "}");
        stringBuilder.append(" extras: ");
        SyncOperation.extrasToStringBuilder(this.extras, stringBuilder, true);
        return stringBuilder.toString();
    }

    public int compareTo(Object object) {
        SyncOperation syncOperation = (SyncOperation)object;
        if (this.earliestRunTime == syncOperation.earliestRunTime) {
            return 0;
        }
        if (this.earliestRunTime < syncOperation.earliestRunTime) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("authority: ").append(this.authority);
        stringBuilder.append(" account: ").append(this.account);
        stringBuilder.append(" extras: ");
        SyncOperation.extrasToStringBuilder(this.extras, stringBuilder, false);
        stringBuilder.append(" syncSource: ").append(this.syncSource);
        stringBuilder.append(" when: ").append(this.earliestRunTime);
        stringBuilder.append(" expedited: ").append(this.expedited);
        return stringBuilder.toString();
    }
}

