/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.content.SyncOperation;
import android.content.SyncStorageEngine;
import android.os.SystemClock;
import android.util.Log;
import android.util.Pair;
import com.google.android.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SyncQueue {
    private static final String TAG = "SyncManager";
    private final HashMap<String, SyncOperation> mOperationsMap = Maps.newHashMap();
    private SyncStorageEngine mSyncStorageEngine;

    public SyncQueue(SyncStorageEngine syncStorageEngine) {
        this.mSyncStorageEngine = syncStorageEngine;
        ArrayList<SyncStorageEngine.PendingOperation> arrayList = this.mSyncStorageEngine.getPendingOperations();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            SyncStorageEngine.PendingOperation pendingOperation = arrayList.get(i);
            SyncOperation syncOperation = new SyncOperation(pendingOperation.account, pendingOperation.syncSource, pendingOperation.authority, pendingOperation.extras, 0L);
            syncOperation.expedited = pendingOperation.expedited;
            syncOperation.pendingOperation = pendingOperation;
            this.add(syncOperation, pendingOperation);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean add(SyncOperation syncOperation, SyncStorageEngine.PendingOperation pendingOperation) {
        String string2 = syncOperation.key;
        SyncOperation syncOperation2 = this.mOperationsMap.get(string2);
        if (syncOperation2 != null) {
            boolean bl;
            if (syncOperation2.expedited == syncOperation.expedited) {
                long l = Math.min(syncOperation2.earliestRunTime, syncOperation.earliestRunTime);
                long l2 = syncOperation2.earliestRunTime - l;
                long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                bl = false;
                if (l3 == false) return bl;
                syncOperation2.earliestRunTime = l;
                return true;
            }
            boolean bl2 = syncOperation.expedited;
            bl = false;
            if (!bl2) return bl;
            syncOperation2.expedited = true;
            return true;
        }
        syncOperation.pendingOperation = pendingOperation;
        if (syncOperation.pendingOperation == null) {
            SyncStorageEngine.PendingOperation pendingOperation2 = new SyncStorageEngine.PendingOperation(syncOperation.account, syncOperation.syncSource, syncOperation.authority, syncOperation.extras, syncOperation.expedited);
            SyncStorageEngine.PendingOperation pendingOperation3 = this.mSyncStorageEngine.insertIntoPending(pendingOperation2);
            if (pendingOperation3 == null) {
                throw new IllegalStateException("error adding pending sync operation " + syncOperation);
            }
            syncOperation.pendingOperation = pendingOperation3;
        }
        this.mOperationsMap.put(string2, syncOperation);
        return true;
    }

    public boolean add(SyncOperation syncOperation) {
        return this.add(syncOperation, null);
    }

    public void dump(StringBuilder stringBuilder) {
        stringBuilder.append("SyncQueue: ").append(this.mOperationsMap.size()).append(" operation(s)\n");
        Iterator<SyncOperation> iterator = this.mOperationsMap.values().iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next()).append("\n");
        }
    }

    boolean getIsInitial(SyncOperation syncOperation) {
        return !syncOperation.extras.getBoolean("initialize", false) && this.mSyncStorageEngine.getIsSyncable(syncOperation.account, syncOperation.authority) < 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long getOpTime(SyncOperation syncOperation) {
        long l;
        long l2 = syncOperation.earliestRunTime;
        if (syncOperation.extras.getBoolean("ignore_backoff", false)) return l2;
        Pair<Long, Long> pair = this.mSyncStorageEngine.getBackoff(syncOperation.account, syncOperation.authority);
        long l3 = Math.max(l2, this.mSyncStorageEngine.getDelayUntilTime(syncOperation.account, syncOperation.authority));
        if (pair != null) {
            l = (Long)pair.first;
            return Math.max(l3, l);
        }
        l = 0L;
        return Math.max(l3, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isOpBetter(SyncOperation syncOperation, long l, boolean bl, SyncOperation syncOperation2, long l2, boolean bl2) {
        boolean bl3;
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "nextOperation: Processing op: " + syncOperation2);
        }
        if (syncOperation == null) {
            if (!Log.isLoggable(TAG, 2)) return true;
            Log.v(TAG, "   First op selected");
            return true;
        }
        if (bl == bl2) {
            if (syncOperation.expedited == syncOperation2.expedited) {
                long l3 = l2 == l ? 0 : (l2 < l ? -1 : 1);
                bl3 = false;
                if (l3 >= 0) return bl3;
                if (!Log.isLoggable(TAG, 2)) return true;
                Log.v(TAG, "   Same expedite level - new op selected");
                return true;
            }
            long l4 = SystemClock.elapsedRealtime();
            if (syncOperation2.expedited) {
                if (l2 <= l4 || l > l4) {
                    if (!Log.isLoggable(TAG, 2)) return true;
                    Log.v(TAG, "   New op is expedited and can run - new op selected");
                    return true;
                }
                boolean bl4 = Log.isLoggable(TAG, 2);
                bl3 = false;
                if (!bl4) return bl3;
                Log.v(TAG, "   New op is expedited but can't run and best can");
                return false;
            }
            long l5 = l == l4 ? 0 : (l < l4 ? -1 : 1);
            bl3 = false;
            if (l5 <= 0) return bl3;
            long l6 = l2 == l4 ? 0 : (l2 < l4 ? -1 : 1);
            bl3 = false;
            if (l6 > 0) return bl3;
            if (!Log.isLoggable(TAG, 2)) return true;
            Log.v(TAG, "   New op is not expedited but can run - new op selected");
            return true;
        }
        bl3 = false;
        if (!bl2) return bl3;
        if (!Log.isLoggable(TAG, 2)) return true;
        Log.v(TAG, "   New op is init - new op selected");
        return true;
    }

    public Pair<SyncOperation, Long> nextOperation() {
        SyncOperation syncOperation = null;
        long l = 0L;
        boolean bl = false;
        for (SyncOperation syncOperation2 : this.mOperationsMap.values()) {
            boolean bl2;
            long l2;
            if (!this.isOpBetter(syncOperation, l, bl, syncOperation2, l2 = this.getOpTime(syncOperation2), bl2 = this.getIsInitial(syncOperation2))) continue;
            syncOperation = syncOperation2;
            bl = bl2;
            l = l2;
        }
        if (syncOperation == null) {
            return null;
        }
        return Pair.create(syncOperation, l);
    }

    public Pair<SyncOperation, Long> nextReadyToRun(long l) {
        Pair<SyncOperation, Long> pair = this.nextOperation();
        if (pair == null || (Long)pair.second > l) {
            return null;
        }
        return pair;
    }

    public void remove(Account account, String string2) {
        Iterator<Map.Entry<String, SyncOperation>> iterator = this.mOperationsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            SyncOperation syncOperation = iterator.next().getValue();
            if (account != null && !syncOperation.account.equals(account) || string2 != null && !syncOperation.authority.equals(string2)) continue;
            iterator.remove();
            if (this.mSyncStorageEngine.deleteFromPending(syncOperation.pendingOperation)) continue;
            String string3 = "unable to find pending row for " + syncOperation;
            Log.e(TAG, string3, new IllegalStateException(string3));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void remove(SyncOperation syncOperation) {
        SyncOperation syncOperation2 = this.mOperationsMap.remove(syncOperation.key);
        if (syncOperation2 == null || this.mSyncStorageEngine.deleteFromPending(syncOperation2.pendingOperation)) {
            return;
        }
        String string2 = "unable to find pending row for " + syncOperation2;
        Log.e(TAG, string2, new IllegalStateException(string2));
    }
}

