/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.ArrayList;
import java.util.Iterator;

public class SyncStatusInfo
implements Parcelable {
    public static final Parcelable.Creator<SyncStatusInfo> CREATOR = new Parcelable.Creator<SyncStatusInfo>(){

        @Override
        public SyncStatusInfo createFromParcel(Parcel parcel) {
            return new SyncStatusInfo(parcel);
        }

        public SyncStatusInfo[] newArray(int n) {
            return new SyncStatusInfo[n];
        }
    };
    private static final String TAG = "Sync";
    static final int VERSION = 2;
    public final int authorityId;
    public long initialFailureTime;
    public boolean initialize;
    public String lastFailureMesg;
    public int lastFailureSource;
    public long lastFailureTime;
    public int lastSuccessSource;
    public long lastSuccessTime;
    public int numSourceLocal;
    public int numSourcePeriodic;
    public int numSourcePoll;
    public int numSourceServer;
    public int numSourceUser;
    public int numSyncs;
    public boolean pending;
    public ArrayList<Long> periodicSyncTimes;
    public long totalElapsedTime;

    SyncStatusInfo(int n) {
        this.authorityId = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    SyncStatusInfo(Parcel parcel) {
        int n = parcel.readInt();
        if (n != 2 && n != 1) {
            Log.w("SyncStatusInfo", "Unknown version: " + n);
        }
        this.authorityId = parcel.readInt();
        this.totalElapsedTime = parcel.readLong();
        this.numSyncs = parcel.readInt();
        this.numSourcePoll = parcel.readInt();
        this.numSourceServer = parcel.readInt();
        this.numSourceLocal = parcel.readInt();
        this.numSourceUser = parcel.readInt();
        this.lastSuccessTime = parcel.readLong();
        this.lastSuccessSource = parcel.readInt();
        this.lastFailureTime = parcel.readLong();
        this.lastFailureSource = parcel.readInt();
        this.lastFailureMesg = parcel.readString();
        this.initialFailureTime = parcel.readLong();
        boolean bl = parcel.readInt() != 0;
        this.pending = bl;
        boolean bl2 = parcel.readInt() != 0;
        this.initialize = bl2;
        if (n == 1) {
            this.periodicSyncTimes = null;
            return;
        } else {
            int n2 = parcel.readInt();
            if (n2 < 0) {
                this.periodicSyncTimes = null;
                return;
            }
            this.periodicSyncTimes = new ArrayList();
            for (int i = 0; i < n2; ++i) {
                this.periodicSyncTimes.add(parcel.readLong());
            }
        }
    }

    private void ensurePeriodicSyncTimeSize(int n) {
        if (this.periodicSyncTimes == null) {
            this.periodicSyncTimes = new ArrayList(0);
        }
        int n2 = n + 1;
        if (this.periodicSyncTimes.size() < n2) {
            for (int i = this.periodicSyncTimes.size(); i < n2; ++i) {
                this.periodicSyncTimes.add(0L);
            }
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getLastFailureMesgAsInt(int n) {
        try {
            if (this.lastFailureMesg != null) {
                int n2 = Integer.parseInt(this.lastFailureMesg);
                return n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            Log.d(TAG, "error parsing lastFailureMesg of " + this.lastFailureMesg, numberFormatException);
        }
        return n;
    }

    public long getPeriodicSyncTime(int n) {
        if (this.periodicSyncTimes == null || this.periodicSyncTimes.size() < n + 1) {
            return 0L;
        }
        return this.periodicSyncTimes.get(n);
    }

    public void removePeriodicSyncTime(int n) {
        this.ensurePeriodicSyncTimeSize(n);
        this.periodicSyncTimes.remove(n);
    }

    public void setPeriodicSyncTime(int n, long l) {
        this.ensurePeriodicSyncTimeSize(n);
        this.periodicSyncTimes.set(n, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(2);
        parcel.writeInt(this.authorityId);
        parcel.writeLong(this.totalElapsedTime);
        parcel.writeInt(this.numSyncs);
        parcel.writeInt(this.numSourcePoll);
        parcel.writeInt(this.numSourceServer);
        parcel.writeInt(this.numSourceLocal);
        parcel.writeInt(this.numSourceUser);
        parcel.writeLong(this.lastSuccessTime);
        parcel.writeInt(this.lastSuccessSource);
        parcel.writeLong(this.lastFailureTime);
        parcel.writeInt(this.lastFailureSource);
        parcel.writeString(this.lastFailureMesg);
        parcel.writeLong(this.initialFailureTime);
        int n2 = this.pending ? 1 : 0;
        parcel.writeInt(n2);
        int n3 = this.initialize ? 1 : 0;
        parcel.writeInt(n3);
        if (this.periodicSyncTimes != null) {
            parcel.writeInt(this.periodicSyncTimes.size());
            Iterator<Long> iterator = this.periodicSyncTimes.iterator();
            while (iterator.hasNext()) {
                parcel.writeLong(iterator.next());
            }
            return;
        } else {
            parcel.writeInt(-1);
        }
    }
}

