/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ISyncStatusObserver;
import android.content.Intent;
import android.content.PeriodicSync;
import android.content.SyncInfo;
import android.content.SyncManager;
import android.content.SyncStatusInfo;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteQueryBuilder;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import android.util.SparseArray;
import com.android.internal.os.AtomicFile;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FastXmlSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.xmlpull.v1.XmlPullParser;

public class SyncStorageEngine
extends Handler {
    private static final int ACCOUNTS_VERSION = 2;
    private static final boolean DEBUG_FILE = false;
    private static final long DEFAULT_POLL_FREQUENCY_SECONDS = 86400L;
    public static final String[] EVENTS = new String[]{"START", "STOP"};
    public static final int EVENT_START = 0;
    public static final int EVENT_STOP = 1;
    public static final int MAX_HISTORY = 100;
    public static final String MESG_CANCELED = "canceled";
    public static final String MESG_SUCCESS = "success";
    static final long MILLIS_IN_4WEEKS = 2419200000L;
    private static final int MSG_WRITE_STATISTICS = 2;
    private static final int MSG_WRITE_STATUS = 1;
    public static final long NOT_IN_BACKOFF_MODE = -1L;
    private static final int PENDING_FINISH_TO_WRITE = 4;
    public static final int PENDING_OPERATION_VERSION = 2;
    public static final String[] SOURCES;
    public static final int SOURCE_LOCAL = 1;
    public static final int SOURCE_PERIODIC = 4;
    public static final int SOURCE_POLL = 2;
    public static final int SOURCE_SERVER = 0;
    public static final int SOURCE_USER = 3;
    public static final int STATISTICS_FILE_END = 0;
    public static final int STATISTICS_FILE_ITEM = 101;
    public static final int STATISTICS_FILE_ITEM_OLD = 100;
    public static final int STATUS_FILE_END = 0;
    public static final int STATUS_FILE_ITEM = 100;
    public static final Intent SYNC_CONNECTION_SETTING_CHANGED_INTENT;
    private static final boolean SYNC_ENABLED_DEFAULT = false;
    private static final String TAG = "SyncManager";
    private static final long WRITE_STATISTICS_DELAY = 1800000L;
    private static final long WRITE_STATUS_DELAY = 600000L;
    private static HashMap<String, String> sAuthorityRenames;
    private static volatile SyncStorageEngine sSyncStorageEngine;
    private final AtomicFile mAccountInfoFile;
    private final HashMap<Account, AccountInfo> mAccounts;
    private final SparseArray<AuthorityInfo> mAuthorities = new SparseArray();
    private final Calendar mCal;
    private final RemoteCallbackList<ISyncStatusObserver> mChangeListeners;
    private final Context mContext;
    private SyncInfo mCurrentSync;
    private final DayStats[] mDayStats;
    private boolean mMasterSyncAutomatically = true;
    private int mNextAuthorityId = 0;
    private int mNextHistoryId = 0;
    private int mNumPendingFinished = 0;
    private final AtomicFile mPendingFile;
    private final ArrayList<PendingOperation> mPendingOperations;
    private final AtomicFile mStatisticsFile;
    private final AtomicFile mStatusFile;
    private final ArrayList<SyncHistoryItem> mSyncHistory;
    private final SparseArray<SyncStatusInfo> mSyncStatus;
    private int mYear;
    private int mYearInDays;

    static {
        SYNC_CONNECTION_SETTING_CHANGED_INTENT = new Intent("com.android.sync.SYNC_CONN_STATUS_CHANGED");
        SOURCES = new String[]{"SERVER", "LOCAL", "POLL", "USER", "PERIODIC"};
        sAuthorityRenames = new HashMap();
        sAuthorityRenames.put("contacts", "com.android.contacts");
        sAuthorityRenames.put("calendar", "com.android.calendar");
        sSyncStorageEngine = null;
    }

    private SyncStorageEngine(Context context, File file) {
        this.mAccounts = new HashMap();
        this.mPendingOperations = new ArrayList();
        this.mSyncStatus = new SparseArray();
        this.mSyncHistory = new ArrayList();
        this.mChangeListeners = new RemoteCallbackList();
        this.mDayStats = new DayStats[28];
        this.mContext = context;
        sSyncStorageEngine = this;
        this.mCal = Calendar.getInstance(TimeZone.getTimeZone("GMT+0"));
        File file2 = new File(new File(file, "system"), "sync");
        file2.mkdirs();
        this.mAccountInfoFile = new AtomicFile(new File(file2, "accounts.xml"));
        this.mStatusFile = new AtomicFile(new File(file2, "status.bin"));
        this.mPendingFile = new AtomicFile(new File(file2, "pending.bin"));
        this.mStatisticsFile = new AtomicFile(new File(file2, "stats.bin"));
        this.readAccountInfoLocked();
        this.readStatusLocked();
        this.readPendingOperationsLocked();
        this.readStatisticsLocked();
        this.readAndDeleteLegacyAccountInfoLocked();
        this.writeAccountInfoLocked();
        this.writeStatusLocked();
        this.writePendingOperationsLocked();
        this.writeStatisticsLocked();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendPendingOperationLocked(PendingOperation pendingOperation) {
        FileOutputStream fileOutputStream = this.mPendingFile.openAppend();
        Parcel parcel = Parcel.obtain();
        this.writePendingOperationLocked(pendingOperation, parcel);
        fileOutputStream.write(parcel.marshall());
        parcel.recycle();
        fileOutputStream.close();
        return;
        {
            catch (IOException iOException) {
                return;
            }
        }
        catch (IOException iOException) {
            this.writePendingOperationsLocked();
            return;
        }
        catch (IOException iOException) {
            try {
                Log.w(TAG, "Error writing pending operations", iOException);
            }
            catch (Throwable throwable) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException2) {
                    throw throwable;
                }
                throw throwable;
            }
            fileOutputStream.close();
            return;
        }
    }

    public static boolean equals(Bundle bundle, Bundle bundle2) {
        if (bundle.size() != bundle2.size()) {
            return false;
        }
        if (bundle.isEmpty()) {
            return true;
        }
        for (String string2 : bundle.keySet()) {
            if (!bundle2.containsKey(string2)) {
                return false;
            }
            if (bundle.get(string2).equals(bundle2.get(string2))) continue;
            return false;
        }
        return true;
    }

    private static byte[] flattenBundle(Bundle bundle) {
        Parcel parcel = Parcel.obtain();
        try {
            bundle.writeToParcel(parcel, 0);
            byte[] byArray = parcel.marshall();
            return byArray;
        }
        finally {
            parcel.recycle();
        }
    }

    private AuthorityInfo getAuthorityLocked(Account account, String string2, String string3) {
        AccountInfo accountInfo = this.mAccounts.get(account);
        if (accountInfo == null) {
            if (string3 != null && Log.isLoggable(TAG, 2)) {
                Log.v(TAG, string3 + ": unknown account " + account);
            }
            return null;
        }
        AuthorityInfo authorityInfo = accountInfo.authorities.get(string2);
        if (authorityInfo == null) {
            if (string3 != null && Log.isLoggable(TAG, 2)) {
                Log.v(TAG, string3 + ": unknown authority " + string2);
            }
            return null;
        }
        return authorityInfo;
    }

    private int getCurrentDayLocked() {
        this.mCal.setTimeInMillis(System.currentTimeMillis());
        int n = this.mCal.get(6);
        if (this.mYear != this.mCal.get(1)) {
            this.mYear = this.mCal.get(1);
            this.mCal.clear();
            this.mCal.set(1, this.mYear);
            this.mYearInDays = (int)(this.mCal.getTimeInMillis() / 86400000L);
        }
        return n + this.mYearInDays;
    }

    static int getIntColumn(Cursor cursor, String string2) {
        return cursor.getInt(cursor.getColumnIndex(string2));
    }

    static long getLongColumn(Cursor cursor, String string2) {
        return cursor.getLong(cursor.getColumnIndex(string2));
    }

    private AuthorityInfo getOrCreateAuthorityLocked(Account account, String string2, int n, boolean bl) {
        AuthorityInfo authorityInfo;
        AccountInfo accountInfo = this.mAccounts.get(account);
        if (accountInfo == null) {
            accountInfo = new AccountInfo(account);
            this.mAccounts.put(account, accountInfo);
        }
        if ((authorityInfo = accountInfo.authorities.get(string2)) == null) {
            if (n < 0) {
                n = this.mNextAuthorityId;
                this.mNextAuthorityId = 1 + this.mNextAuthorityId;
                bl = true;
            }
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "created a new AuthorityInfo for " + account + ", provider " + string2);
            }
            authorityInfo = new AuthorityInfo(account, string2, n);
            accountInfo.authorities.put(string2, authorityInfo);
            this.mAuthorities.put(n, authorityInfo);
            if (bl) {
                this.writeAccountInfoLocked();
            }
        }
        return authorityInfo;
    }

    private SyncStatusInfo getOrCreateSyncStatusLocked(int n) {
        SyncStatusInfo syncStatusInfo = this.mSyncStatus.get(n);
        if (syncStatusInfo == null) {
            syncStatusInfo = new SyncStatusInfo(n);
            this.mSyncStatus.put(n, syncStatusInfo);
        }
        return syncStatusInfo;
    }

    public static SyncStorageEngine getSingleton() {
        if (sSyncStorageEngine == null) {
            throw new IllegalStateException("not initialized");
        }
        return sSyncStorageEngine;
    }

    public static void init(Context context) {
        if (sSyncStorageEngine != null) {
            return;
        }
        sSyncStorageEngine = new SyncStorageEngine(context, Environment.getSecureDataDirectory());
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean maybeMigrateSettingsForRenamedAuthorities() {
        boolean bl = false;
        ArrayList<AuthorityInfo> arrayList = new ArrayList<AuthorityInfo>();
        int n = this.mAuthorities.size();
        for (int i = 0; i < n; ++i) {
            AuthorityInfo authorityInfo = this.mAuthorities.valueAt(i);
            String string2 = sAuthorityRenames.get(authorityInfo.authority);
            if (string2 == null) continue;
            arrayList.add(authorityInfo);
            if (!authorityInfo.enabled || this.getAuthorityLocked(authorityInfo.account, string2, "cleanup") != null) continue;
            this.getOrCreateAuthorityLocked((Account)authorityInfo.account, (String)string2, (int)-1, (boolean)false).enabled = true;
            bl = true;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            AuthorityInfo authorityInfo = (AuthorityInfo)iterator.next();
            this.removeAuthorityLocked(authorityInfo.account, authorityInfo.authority, false);
            bl = true;
        }
        return bl;
    }

    public static SyncStorageEngine newTestInstance(Context context) {
        return new SyncStorageEngine(context, context.getFilesDir());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AuthorityInfo parseAuthority(XmlPullParser xmlPullParser, int n) {
        String string2;
        AuthorityInfo authorityInfo;
        block11: {
            block10: {
                int n2 = -1;
                try {
                    int n3;
                    n2 = n3 = Integer.parseInt(xmlPullParser.getAttributeValue(null, "id"));
                }
                catch (NumberFormatException numberFormatException) {
                    Log.e(TAG, "error parsing the id of the authority", numberFormatException);
                }
                catch (NullPointerException nullPointerException) {
                    Log.e(TAG, "the id of the authority is null", nullPointerException);
                }
                authorityInfo = null;
                if (n2 < 0) break block10;
                String string3 = xmlPullParser.getAttributeValue(null, "authority");
                String string4 = xmlPullParser.getAttributeValue(null, "enabled");
                string2 = xmlPullParser.getAttributeValue(null, "syncable");
                String string5 = xmlPullParser.getAttributeValue(null, "account");
                String string6 = xmlPullParser.getAttributeValue(null, "type");
                if (string6 == null) {
                    string6 = "com.google";
                    string2 = "unknown";
                }
                if ((authorityInfo = this.mAuthorities.get(n2)) == null) {
                    authorityInfo = this.getOrCreateAuthorityLocked(new Account(string5, string6), string3, n2, false);
                    if (n > 0) {
                        authorityInfo.periodicSyncs.clear();
                    }
                }
                if (authorityInfo == null) {
                    Log.w(TAG, "Failure adding authority: account=" + string5 + " auth=" + string3 + " enabled=" + string4 + " syncable=" + string2);
                    return authorityInfo;
                }
                boolean bl = string4 == null || Boolean.parseBoolean(string4);
                authorityInfo.enabled = bl;
                if (!"unknown".equals(string2)) break block11;
                authorityInfo.syncable = -1;
            }
            return authorityInfo;
        }
        int n4 = string2 == null || Boolean.parseBoolean(string2) ? 1 : 0;
        authorityInfo.syncable = n4;
        return authorityInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseExtra(XmlPullParser xmlPullParser, Pair<Bundle, Long> pair) {
        Bundle bundle = (Bundle)pair.first;
        String string2 = xmlPullParser.getAttributeValue(null, "name");
        String string3 = xmlPullParser.getAttributeValue(null, "type");
        String string4 = xmlPullParser.getAttributeValue(null, "value1");
        String string5 = xmlPullParser.getAttributeValue(null, "value2");
        try {
            if ("long".equals(string3)) {
                bundle.putLong(string2, Long.parseLong(string4));
                return;
            }
            if ("integer".equals(string3)) {
                bundle.putInt(string2, Integer.parseInt(string4));
                return;
            }
            if ("double".equals(string3)) {
                bundle.putDouble(string2, Double.parseDouble(string4));
                return;
            }
            if ("float".equals(string3)) {
                bundle.putFloat(string2, Float.parseFloat(string4));
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            Log.e(TAG, "error parsing bundle value", numberFormatException);
            return;
        }
        catch (NullPointerException nullPointerException) {
            Log.e(TAG, "error parsing bundle value", nullPointerException);
            return;
        }
        if ("boolean".equals(string3)) {
            bundle.putBoolean(string2, Boolean.parseBoolean(string4));
            return;
        }
        if ("string".equals(string3)) {
            bundle.putString(string2, string4);
            return;
        }
        if ("account".equals(string3)) {
            bundle.putParcelable(string2, new Account(string4, string5));
        }
    }

    private Pair<Bundle, Long> parsePeriodicSync(XmlPullParser xmlPullParser, AuthorityInfo authorityInfo) {
        long l;
        Bundle bundle = new Bundle();
        String string2 = xmlPullParser.getAttributeValue(null, "period");
        try {
            l = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Log.e(TAG, "error parsing the period of a periodic sync", numberFormatException);
            return null;
        }
        catch (NullPointerException nullPointerException) {
            Log.e(TAG, "the period of a periodic sync is null", nullPointerException);
            return null;
        }
        Pair<Bundle, Long> pair = Pair.create(bundle, l);
        authorityInfo.periodicSyncs.add(pair);
        return pair;
    }

    /*
     * Exception decompiling
     */
    private void readAccountInfoLocked() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 16[TRYBLOCK] [55 : 486->491)] java.io.IOException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readAndDeleteLegacyAccountInfoLocked() {
        block23: {
            block22: {
                block20: {
                    var1_1 = this.mContext.getDatabasePath("syncmanager.db");
                    if (!var1_1.exists()) {
                        return;
                    }
                    var2_2 = var1_1.getPath();
                    try {
                        var4_4 = var60_3 = SQLiteDatabase.openDatabase(var2_2, null, 1);
                        if (var4_4 == null) return;
                    }
                    catch (SQLiteException var3_5) {
                        return;
                    }
                    if (var4_4.getVersion() >= 11) {
                        var5_6 = true;
lbl10:
                        // 2 sources

                        while (true) {
                            var6_7 = new SQLiteQueryBuilder();
                            var6_7.setTables("stats, status");
                            var7_8 = new HashMap<String, String>();
                            var7_8.put("_id", "status._id as _id");
                            var7_8.put("account", "stats.account as account");
                            if (var5_6) {
                                var7_8.put("account_type", "stats.account_type as account_type");
                            }
                            var7_8.put("authority", "stats.authority as authority");
                            var7_8.put("totalElapsedTime", "totalElapsedTime");
                            var7_8.put("numSyncs", "numSyncs");
                            var7_8.put("numSourceLocal", "numSourceLocal");
                            var7_8.put("numSourcePoll", "numSourcePoll");
                            var7_8.put("numSourceServer", "numSourceServer");
                            var7_8.put("numSourceUser", "numSourceUser");
                            var7_8.put("lastSuccessSource", "lastSuccessSource");
                            var7_8.put("lastSuccessTime", "lastSuccessTime");
                            var7_8.put("lastFailureSource", "lastFailureSource");
                            var7_8.put("lastFailureTime", "lastFailureTime");
                            var7_8.put("lastFailureMesg", "lastFailureMesg");
                            var7_8.put("pending", "pending");
                            var6_7.setProjectionMap(var7_8);
                            var6_7.appendWhere("stats._id = status.stats_id");
                            var23_9 = var6_7.query(var4_4, null, null, null, null, null, null);
                            block3: while (var23_9.moveToNext()) {
                                var35_10 = var23_9.getString(var23_9.getColumnIndex("account"));
                                if (!var5_6) break block20;
                                var36_11 = var23_9.getString(var23_9.getColumnIndex("account_type"));
lbl54:
                                // 2 sources

                                while (true) {
                                    block21: {
                                        if (var36_11 == null) {
                                            var36_11 = "com.google";
                                        }
                                        if ((var38_13 = this.getOrCreateAuthorityLocked(new Account(var35_10, var36_11), var37_12 = var23_9.getString(var23_9.getColumnIndex("authority")), -1, false)) == null) continue block3;
                                        var39_14 = this.mSyncStatus.size();
                                        var40_15 = null;
                                        do {
                                            var41_16 = false;
                                            if (var39_14 <= 0) break block21;
                                            var40_15 = this.mSyncStatus.valueAt(--var39_14);
                                        } while (var40_15.authorityId != var38_13.ident);
                                        var41_16 = true;
                                    }
                                    if (!var41_16) {
                                        var58_30 = var38_13.ident;
                                        var40_15 = new SyncStatusInfo(var58_30);
                                        this.mSyncStatus.put(var38_13.ident, var40_15);
                                    }
                                    var40_15.totalElapsedTime = var42_17 = SyncStorageEngine.getLongColumn(var23_9, "totalElapsedTime");
                                    var40_15.numSyncs = var44_18 = SyncStorageEngine.getIntColumn(var23_9, "numSyncs");
                                    var40_15.numSourceLocal = var45_19 = SyncStorageEngine.getIntColumn(var23_9, "numSourceLocal");
                                    var40_15.numSourcePoll = var46_20 = SyncStorageEngine.getIntColumn(var23_9, "numSourcePoll");
                                    var40_15.numSourceServer = var47_21 = SyncStorageEngine.getIntColumn(var23_9, "numSourceServer");
                                    var40_15.numSourceUser = var48_22 = SyncStorageEngine.getIntColumn(var23_9, "numSourceUser");
                                    var40_15.numSourcePeriodic = 0;
                                    var40_15.lastSuccessSource = var49_23 = SyncStorageEngine.getIntColumn(var23_9, "lastSuccessSource");
                                    var40_15.lastSuccessTime = var50_24 = SyncStorageEngine.getLongColumn(var23_9, "lastSuccessTime");
                                    var40_15.lastFailureSource = var52_25 = SyncStorageEngine.getIntColumn(var23_9, "lastFailureSource");
                                    var40_15.lastFailureTime = var53_26 = SyncStorageEngine.getLongColumn(var23_9, "lastFailureTime");
                                    var40_15.lastFailureMesg = var55_27 = var23_9.getString(var23_9.getColumnIndex("lastFailureMesg"));
                                    if (SyncStorageEngine.getIntColumn(var23_9, "pending") != 0) {
                                        var56_28 = true;
lbl85:
                                        // 2 sources

                                        while (true) {
                                            var40_15.pending = var57_29 = var56_28;
                                            continue block3;
                                            break;
                                        }
                                    }
                                    break block22;
                                    break;
                                }
                            }
                            break block23;
                            break;
                        }
                    }
                    var5_6 = false;
                    ** while (true)
                }
                var36_11 = null;
                ** while (true)
            }
            var56_28 = false;
            ** while (true)
        }
        var23_9.close();
        var24_31 = new SQLiteQueryBuilder();
        var24_31.setTables("settings");
        var25_32 = var24_31.query(var4_4, null, null, null, null, null, null);
        block7: while (var25_32.moveToNext()) {
            var28_33 = var25_32.getString(var25_32.getColumnIndex("name"));
            var29_34 = var25_32.getString(var25_32.getColumnIndex("value"));
            if (var28_33 == null) continue;
            if (var28_33.equals("listen_for_tickles")) {
                if (var29_34 == null || Boolean.parseBoolean(var29_34)) {
                    var34_39 = true;
lbl110:
                    // 2 sources

                    while (true) {
                        this.setMasterSyncAutomatically(var34_39);
                        continue block7;
                        break;
                    }
                }
                var34_39 = false;
                ** continue;
            }
            if (!var28_33.startsWith("sync_provider_")) continue;
            var30_35 = var28_33.substring("sync_provider_".length(), var28_33.length());
            var31_36 = this.mAuthorities.size();
            block9: while (var31_36 > 0) {
                var32_37 = this.mAuthorities.valueAt(--var31_36);
                if (!var32_37.authority.equals(var30_35)) continue;
                if (var29_34 == null || Boolean.parseBoolean(var29_34)) {
                    var33_38 = true;
lbl123:
                    // 2 sources

                    while (true) {
                        var32_37.enabled = var33_38;
                        var32_37.syncable = 1;
                        continue block9;
                        break;
                    }
                }
                var33_38 = false;
                ** continue;
            }
        }
        var25_32.close();
        var4_4.close();
        var26_40 = new File(var2_2);
        var26_40.delete();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readPendingOperationsLocked() {
        try {
            byte[] byArray = this.mPendingFile.readFully();
            Parcel parcel = Parcel.obtain();
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            int n = parcel.dataSize();
            while (parcel.dataPosition() < n) {
                int n2 = parcel.readInt();
                if (n2 != 2 && n2 != 1) {
                    Log.w(TAG, "Unknown pending operation version " + n2 + "; dropping all ops");
                    return;
                }
                int n3 = parcel.readInt();
                int n4 = parcel.readInt();
                byte[] byArray2 = parcel.createByteArray();
                boolean bl = n2 == 2 ? parcel.readInt() != 0 : false;
                AuthorityInfo authorityInfo = this.mAuthorities.get(n3);
                if (authorityInfo == null) continue;
                Bundle bundle = null;
                if (byArray2 != null) {
                    bundle = SyncStorageEngine.unflattenBundle(byArray2);
                }
                PendingOperation pendingOperation = new PendingOperation(authorityInfo.account, n4, authorityInfo.authority, bundle, bl);
                pendingOperation.authorityId = n3;
                pendingOperation.flatExtras = byArray2;
                this.mPendingOperations.add(pendingOperation);
            }
            return;
        }
        catch (IOException iOException) {
            Log.i(TAG, "No initial pending operations");
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readStatisticsLocked() {
        int n;
        byte[] byArray = this.mStatisticsFile.readFully();
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        int n2 = 0;
        while (true) {
            int n3;
            block7: {
                n = parcel.readInt();
                if (n == 0) return;
                if (n != 101 && n != 100) break;
                n3 = parcel.readInt();
                if (n != 100) break block7;
                n3 = 14245 + (n3 - 2009);
            }
            DayStats dayStats = new DayStats(n3);
            dayStats.successCount = parcel.readInt();
            dayStats.successTime = parcel.readLong();
            dayStats.failureCount = parcel.readInt();
            dayStats.failureTime = parcel.readLong();
            if (n2 >= this.mDayStats.length) continue;
            this.mDayStats[n2] = dayStats;
            ++n2;
            continue;
            break;
        }
        try {
            Log.w(TAG, "Unknown stats token: " + n);
            return;
        }
        catch (IOException iOException) {
            Log.i(TAG, "No initial statistics");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readStatusLocked() {
        try {
            int n;
            byte[] byArray = this.mStatusFile.readFully();
            Parcel parcel = Parcel.obtain();
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            while ((n = parcel.readInt()) != 0) {
                if (n == 100) {
                    SyncStatusInfo syncStatusInfo = new SyncStatusInfo(parcel);
                    if (this.mAuthorities.indexOfKey(syncStatusInfo.authorityId) < 0) continue;
                    syncStatusInfo.pending = false;
                    this.mSyncStatus.put(syncStatusInfo.authorityId, syncStatusInfo);
                    continue;
                }
                Log.w(TAG, "Unknown status token: " + n);
                return;
            }
            return;
        }
        catch (IOException iOException) {
            Log.i(TAG, "No initial status");
        }
    }

    private void removeAuthorityLocked(Account account, String string2, boolean bl) {
        AuthorityInfo authorityInfo;
        AccountInfo accountInfo = this.mAccounts.get(account);
        if (accountInfo != null && (authorityInfo = accountInfo.authorities.remove(string2)) != null) {
            this.mAuthorities.remove(authorityInfo.ident);
            if (bl) {
                this.writeAccountInfoLocked();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void reportChange(int n) {
        int n2;
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        // MONITORENTER : sparseArray
        ArrayList<ISyncStatusObserver> arrayList = null;
        for (int i = n2 = this.mChangeListeners.beginBroadcast(); i > 0; --i) {
            if ((n & (Integer)this.mChangeListeners.getBroadcastCookie(i)) == 0) continue;
            ArrayList<ISyncStatusObserver> arrayList2 = arrayList == null ? new ArrayList<ISyncStatusObserver>(i) : arrayList;
            arrayList2.add(this.mChangeListeners.getBroadcastItem(i));
            arrayList = arrayList2;
        }
        this.mChangeListeners.finishBroadcast();
        // MONITOREXIT : sparseArray
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "reportChange " + n + " to: " + arrayList);
        }
        if (arrayList == null) return;
        int n3 = arrayList.size();
        while (n3 > 0) {
            --n3;
            try {
                ((ISyncStatusObserver)arrayList.get(n3)).onStatusChanged(n);
            }
            catch (RemoteException remoteException) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Bundle unflattenBundle(byte[] byArray) {
        Bundle bundle;
        Parcel parcel = Parcel.obtain();
        try {
            Bundle bundle2;
            parcel.unmarshall(byArray, 0, byArray.length);
            parcel.setDataPosition(0);
            bundle = bundle2 = parcel.readBundle();
            return bundle;
        }
        catch (RuntimeException runtimeException) {
            bundle = new Bundle();
            return bundle;
        }
        finally {
            parcel.recycle();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateOrRemovePeriodicSync(Account var1_1, String var2_2, Bundle var3_3, long var4_4, boolean var6_5) {
        block23: {
            if (var4_4 <= 0L) {
                var4_4 = 0L;
            }
            if (var3_3 == null) {
                var3_3 = new Bundle();
            }
            if (Log.isLoggable("SyncManager", 2)) {
                Log.v("SyncManager", "addOrRemovePeriodicSync: " + var1_1 + ", provider " + var2_2 + " -> period " + var4_4 + ", extras " + var3_3);
            }
            var7_6 = this.mAuthorities;
            synchronized (var7_6) {
                block25: {
                    block24: {
                        var10_7 = this.getOrCreateAuthorityLocked(var1_1, var2_2, -1, false);
                        if (!var6_5) ** GOTO lbl-1000
                        var15_8 = 0;
                        var16_9 = var10_7.periodicSyncs.size();
                        while (true) lbl-1000:
                        // 2 sources

                        {
                            var17_10 = false;
                            if (var15_8 >= var16_9) ** GOTO lbl35
                            var18_11 = var10_7.periodicSyncs.get(var15_8);
                            if (!SyncStorageEngine.equals((Bundle)var18_11.first, var3_3)) break block21;
                            var19_12 = (Long)var18_11.second;
                            if (var19_12 != var4_4) break block22;
                            this.writeAccountInfoLocked();
                            this.writeStatusLocked();
                            break;
                        }
                        {
                            block21: {
                                block22: {
                                    return;
                                }
                                var21_13 = var10_7.periodicSyncs;
                                var22_14 = var4_4;
                                var23_15 = Pair.create(var3_3, var22_14);
                                var21_13.set(var15_8, var23_15);
                                var17_10 = true;
lbl35:
                                // 2 sources

                                if (!var17_10) {
                                    var25_16 = var10_7.periodicSyncs;
                                    var26_17 = var4_4;
                                    var25_16.add(Pair.create(var3_3, var26_17));
                                    this.getOrCreateSyncStatusLocked(var10_7.ident).setPeriodicSyncTime(var10_7.periodicSyncs.size() - 1, 0L);
                                }
                                break block23;
                            }
                            ++var15_8;
                            ** while (true)
                        }
lbl-1000:
                        // 1 sources

                        {
                            var11_18 = this.mSyncStatus.get(var10_7.ident);
                            var12_19 = false;
                            var13_20 = var10_7.periodicSyncs.iterator();
                            var14_21 = 0;
lbl49:
                            // 4 sources

                            while (var13_20.hasNext()) {
                                if (SyncStorageEngine.equals((Bundle)var13_20.next().first, var3_3)) {
                                    var13_20.remove();
                                    var12_19 = true;
                                    if (var11_18 == null) continue;
                                    var11_18.removePeriodicSyncTime(var14_21);
                                    continue;
                                }
                                break block24;
                            }
                            break block25;
                        }
                        finally {
                            this.writeAccountInfoLocked();
                            this.writeStatusLocked();
                        }
                    }
                    ++var14_21;
                    ** GOTO lbl49
                }
                if (!var12_19) ** break block26
            }
        }
        this.reportChange(1);
        return;
        {
            this.writeAccountInfoLocked();
            this.writeStatusLocked();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeAccountInfoLocked() {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = this.mAccountInfoFile.startWrite();
            FastXmlSerializer fastXmlSerializer = new FastXmlSerializer();
            fastXmlSerializer.setOutput(fileOutputStream, "utf-8");
            fastXmlSerializer.startDocument(null, true);
            fastXmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            fastXmlSerializer.startTag(null, "accounts");
            fastXmlSerializer.attribute(null, "version", Integer.toString(2));
            fastXmlSerializer.attribute(null, "nextAuthorityId", Integer.toString(this.mNextAuthorityId));
            if (!this.mMasterSyncAutomatically) {
                fastXmlSerializer.attribute(null, "listen-for-tickles", "false");
            }
            int n = this.mAuthorities.size();
            int n2 = 0;
            block4: while (true) {
                AuthorityInfo authorityInfo;
                if (n2 < n) {
                    authorityInfo = this.mAuthorities.valueAt(n2);
                    fastXmlSerializer.startTag(null, "authority");
                    fastXmlSerializer.attribute(null, "id", Integer.toString(authorityInfo.ident));
                    fastXmlSerializer.attribute(null, "account", authorityInfo.account.name);
                    fastXmlSerializer.attribute(null, "type", authorityInfo.account.type);
                    fastXmlSerializer.attribute(null, "authority", authorityInfo.authority);
                    fastXmlSerializer.attribute(null, "enabled", Boolean.toString(authorityInfo.enabled));
                    if (authorityInfo.syncable < 0) {
                        fastXmlSerializer.attribute(null, "syncable", "unknown");
                    } else {
                        boolean bl = authorityInfo.syncable != 0;
                        fastXmlSerializer.attribute(null, "syncable", Boolean.toString(bl));
                    }
                } else {
                    fastXmlSerializer.endTag(null, "accounts");
                    fastXmlSerializer.endDocument();
                    this.mAccountInfoFile.finishWrite(fileOutputStream);
                    return;
                }
                Iterator<Pair<Bundle, Long>> iterator = authorityInfo.periodicSyncs.iterator();
                while (true) {
                    Iterator<String> iterator2;
                    Bundle bundle;
                    if (iterator.hasNext()) {
                        Pair<Bundle, Long> pair = iterator.next();
                        fastXmlSerializer.startTag(null, "periodicSync");
                        fastXmlSerializer.attribute(null, "period", Long.toString((Long)pair.second));
                        bundle = (Bundle)pair.first;
                        iterator2 = bundle.keySet().iterator();
                    } else {
                        fastXmlSerializer.endTag(null, "authority");
                        ++n2;
                        continue block4;
                    }
                    while (iterator2.hasNext()) {
                        String string2 = iterator2.next();
                        fastXmlSerializer.startTag(null, "extra");
                        fastXmlSerializer.attribute(null, "name", string2);
                        Object object = bundle.get(string2);
                        if (object instanceof Long) {
                            fastXmlSerializer.attribute(null, "type", "long");
                            fastXmlSerializer.attribute(null, "value1", object.toString());
                        } else if (object instanceof Integer) {
                            fastXmlSerializer.attribute(null, "type", "integer");
                            fastXmlSerializer.attribute(null, "value1", object.toString());
                        } else if (object instanceof Boolean) {
                            fastXmlSerializer.attribute(null, "type", "boolean");
                            fastXmlSerializer.attribute(null, "value1", object.toString());
                        } else if (object instanceof Float) {
                            fastXmlSerializer.attribute(null, "type", "float");
                            fastXmlSerializer.attribute(null, "value1", object.toString());
                        } else if (object instanceof Double) {
                            fastXmlSerializer.attribute(null, "type", "double");
                            fastXmlSerializer.attribute(null, "value1", object.toString());
                        } else if (object instanceof String) {
                            fastXmlSerializer.attribute(null, "type", "string");
                            fastXmlSerializer.attribute(null, "value1", object.toString());
                        } else if (object instanceof Account) {
                            fastXmlSerializer.attribute(null, "type", "account");
                            fastXmlSerializer.attribute(null, "value1", ((Account)object).name);
                            fastXmlSerializer.attribute(null, "value2", ((Account)object).type);
                        }
                        fastXmlSerializer.endTag(null, "extra");
                    }
                    fastXmlSerializer.endTag(null, "periodicSync");
                }
                break;
            }
        }
        catch (IOException iOException) {
            Log.w(TAG, "Error writing accounts", iOException);
            if (fileOutputStream != null) {
                this.mAccountInfoFile.failWrite(fileOutputStream);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writePendingOperationLocked(PendingOperation pendingOperation, Parcel parcel) {
        parcel.writeInt(2);
        parcel.writeInt(pendingOperation.authorityId);
        parcel.writeInt(pendingOperation.syncSource);
        if (pendingOperation.flatExtras == null && pendingOperation.extras != null) {
            pendingOperation.flatExtras = SyncStorageEngine.flattenBundle(pendingOperation.extras);
        }
        parcel.writeByteArray(pendingOperation.flatExtras);
        int n = pendingOperation.expedited ? 1 : 0;
        parcel.writeInt(n);
    }

    /*
     * Unable to fully structure code
     */
    private void writePendingOperationsLocked() {
        var1_1 = this.mPendingOperations.size();
        var2_2 = null;
        if (var1_1 != 0) ** GOTO lbl7
        this.mPendingFile.truncate();
        return;
lbl7:
        // 1 sources

        var2_2 = this.mPendingFile.startWrite();
        var5_3 = Parcel.obtain();
        for (var6_4 = 0; var6_4 < var1_1; ++var6_4) {
            this.writePendingOperationLocked(this.mPendingOperations.get(var6_4), var5_3);
            continue;
        }
        try {
            var2_2.write(var5_3.marshall());
            var5_3.recycle();
            this.mPendingFile.finishWrite(var2_2);
            return;
        }
        catch (IOException var3_5) {
            Log.w("SyncManager", "Error writing pending operations", var3_5);
            if (var2_2 != null) {
                this.mPendingFile.failWrite(var2_2);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeStatisticsLocked() {
        this.removeMessages(2);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = this.mStatisticsFile.startWrite();
            Parcel parcel = Parcel.obtain();
            int n = this.mDayStats.length;
            int n2 = 0;
            while (true) {
                DayStats dayStats;
                if (n2 >= n || (dayStats = this.mDayStats[n2]) == null) {
                    parcel.writeInt(0);
                    fileOutputStream.write(parcel.marshall());
                    parcel.recycle();
                    this.mStatisticsFile.finishWrite(fileOutputStream);
                    return;
                }
                parcel.writeInt(101);
                parcel.writeInt(dayStats.day);
                parcel.writeInt(dayStats.successCount);
                parcel.writeLong(dayStats.successTime);
                parcel.writeInt(dayStats.failureCount);
                parcel.writeLong(dayStats.failureTime);
                ++n2;
            }
        }
        catch (IOException iOException) {
            Log.w(TAG, "Error writing stats", iOException);
            if (fileOutputStream != null) {
                this.mStatisticsFile.failWrite(fileOutputStream);
            }
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeStatusLocked() {
        Parcel parcel;
        this.removeMessages(1);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = this.mStatusFile.startWrite();
            parcel = Parcel.obtain();
            int n = this.mSyncStatus.size();
            for (int i = 0; i < n; ++i) {
                SyncStatusInfo syncStatusInfo = this.mSyncStatus.valueAt(i);
                parcel.writeInt(100);
                syncStatusInfo.writeToParcel(parcel, 0);
            }
        }
        catch (IOException iOException) {
            Log.w(TAG, "Error writing status", iOException);
            if (fileOutputStream == null) return;
            this.mStatusFile.failWrite(fileOutputStream);
            return;
        }
        {
            parcel.writeInt(0);
            fileOutputStream.write(parcel.marshall());
            parcel.recycle();
            this.mStatusFile.finishWrite(fileOutputStream);
            return;
        }
    }

    public void addPeriodicSync(Account account, String string2, Bundle bundle, long l) {
        this.updateOrRemovePeriodicSync(account, string2, bundle, l, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addStatusChangeListener(int n, ISyncStatusObserver iSyncStatusObserver) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            this.mChangeListeners.register(iSyncStatusObserver, n);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearAndReadState() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            this.mAuthorities.clear();
            this.mAccounts.clear();
            this.mPendingOperations.clear();
            this.mSyncStatus.clear();
            this.mSyncHistory.clear();
            this.readAccountInfoLocked();
            this.readStatusLocked();
            this.readPendingOperationsLocked();
            this.readStatisticsLocked();
            this.readAndDeleteLegacyAccountInfoLocked();
            this.writeAccountInfoLocked();
            this.writeStatusLocked();
            this.writePendingOperationsLocked();
            this.writeStatisticsLocked();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int clearPending() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "clearPending");
            }
            int n = this.mPendingOperations.size();
            this.mPendingOperations.clear();
            int n2 = this.mSyncStatus.size();
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    this.writePendingOperationsLocked();
                    // MONITOREXIT @DISABLED, blocks:[3, 4, 5] lbl13 : MonitorExitStatement: MONITOREXIT : var1_1
                    this.reportChange(2);
                    return n;
                }
                this.mSyncStatus.valueAt((int)n3).pending = false;
                ++n3;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteFromPending(PendingOperation pendingOperation) {
        boolean bl;
        block12: {
            SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
            synchronized (sparseArray) {
                block13: {
                    AuthorityInfo authorityInfo;
                    if (Log.isLoggable(TAG, 2)) {
                        Log.v(TAG, "deleteFromPending: account=" + pendingOperation.account + " auth=" + pendingOperation.authority + " src=" + pendingOperation.syncSource + " extras=" + pendingOperation.extras);
                    }
                    boolean bl2 = this.mPendingOperations.remove(pendingOperation);
                    bl = false;
                    if (!bl2) break block12;
                    if (this.mPendingOperations.size() == 0 || this.mNumPendingFinished >= 4) {
                        this.writePendingOperationsLocked();
                        this.mNumPendingFinished = 0;
                    } else {
                        this.mNumPendingFinished = 1 + this.mNumPendingFinished;
                    }
                    if ((authorityInfo = this.getAuthorityLocked(pendingOperation.account, pendingOperation.authority, "deleteFromPending")) == null) break block13;
                    if (Log.isLoggable(TAG, 2)) {
                        Log.v(TAG, "removing - " + authorityInfo);
                    }
                    int n = this.mPendingOperations.size();
                    int n2 = 0;
                    while (true) {
                        block15: {
                            boolean bl3;
                            block14: {
                                bl3 = false;
                                if (n2 >= n) break block14;
                                PendingOperation pendingOperation2 = this.mPendingOperations.get(n2);
                                if (!pendingOperation2.account.equals(pendingOperation.account) || !pendingOperation2.authority.equals(pendingOperation.authority)) break block15;
                                bl3 = true;
                            }
                            if (bl3) break;
                            if (Log.isLoggable(TAG, 2)) {
                                Log.v(TAG, "no more pending!");
                            }
                            this.getOrCreateSyncStatusLocked((int)authorityInfo.ident).pending = false;
                            break;
                        }
                        ++n2;
                    }
                }
                bl = true;
            }
        }
        this.reportChange(2);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doDatabaseCleanup(Account[] accountArray) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            if (Log.isLoggable(TAG, 2)) {
                Log.w(TAG, "Updating for new accounts...");
            }
            SparseArray<AuthorityInfo> sparseArray2 = new SparseArray<AuthorityInfo>();
            Iterator<AccountInfo> iterator = this.mAccounts.values().iterator();
            while (iterator.hasNext()) {
                AccountInfo accountInfo = iterator.next();
                if (ArrayUtils.contains(accountArray, accountInfo.account)) continue;
                if (Log.isLoggable(TAG, 2)) {
                    Log.w(TAG, "Account removed: " + accountInfo.account);
                }
                for (AuthorityInfo authorityInfo : accountInfo.authorities.values()) {
                    sparseArray2.put(authorityInfo.ident, authorityInfo);
                }
                iterator.remove();
            }
            int n = sparseArray2.size();
            if (n > 0) {
                while (n > 0) {
                    int n2 = sparseArray2.keyAt(--n);
                    this.mAuthorities.remove(n2);
                    int n3 = this.mSyncStatus.size();
                    while (n3 > 0) {
                        if (this.mSyncStatus.keyAt(--n3) != n2) continue;
                        this.mSyncStatus.remove(this.mSyncStatus.keyAt(n3));
                    }
                    int n4 = this.mSyncHistory.size();
                    while (n4 > 0) {
                        if (this.mSyncHistory.get((int)(--n4)).authorityId != n2) continue;
                        this.mSyncHistory.remove(n4);
                    }
                }
                this.writeAccountInfoLocked();
                this.writeStatusLocked();
                this.writePendingOperationsLocked();
                this.writeStatisticsLocked();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<AuthorityInfo> getAuthorities() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            int n = this.mAuthorities.size();
            ArrayList<AuthorityInfo> arrayList = new ArrayList<AuthorityInfo>(n);
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(this.mAuthorities.valueAt(n2));
                ++n2;
            }
            return arrayList;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AuthorityInfo getAuthority(int n) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            return this.mAuthorities.get(n);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Pair<Long, Long> getBackoff(Account account, String string2) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authorityInfo = this.getAuthorityLocked(account, string2, "getBackoff");
            if (authorityInfo == null) return null;
            if (authorityInfo.backoffTime < 0L) return null;
            return Pair.create(authorityInfo.backoffTime, authorityInfo.backoffDelay);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SyncInfo getCurrentSync() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            return this.mCurrentSync;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DayStats[] getDayStatistics() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            DayStats[] dayStatsArray = new DayStats[this.mDayStats.length];
            System.arraycopy(this.mDayStats, 0, dayStatsArray, 0, dayStatsArray.length);
            return dayStatsArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getDelayUntilTime(Account account, String string2) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authorityInfo = this.getAuthorityLocked(account, string2, "getDelayUntil");
            if (authorityInfo != null) return authorityInfo.delayUntil;
            return 0L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getInitialSyncFailureTime() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            if (!this.mMasterSyncAutomatically) {
                return 0L;
            }
            long l = 0L;
            int n = this.mSyncStatus.size();
            while (n > 0) {
                SyncStatusInfo syncStatusInfo = this.mSyncStatus.valueAt(--n);
                AuthorityInfo authorityInfo = this.mAuthorities.get(syncStatusInfo.authorityId);
                if (authorityInfo == null || !authorityInfo.enabled || l != 0L && syncStatusInfo.initialFailureTime >= l) continue;
                l = syncStatusInfo.initialFailureTime;
            }
            return l;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getIsSyncable(Account account, String string2) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authorityInfo;
            if (account != null) {
                AuthorityInfo authorityInfo2 = this.getAuthorityLocked(account, string2, "getIsSyncable");
                if (authorityInfo2 != null) return authorityInfo2.syncable;
                return -1;
            }
            int n = this.mAuthorities.size();
            do {
                if (n <= 0) {
                    return -1;
                }
                authorityInfo = this.mAuthorities.valueAt(--n);
            } while (!authorityInfo.authority.equals(string2));
            return authorityInfo.syncable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getMasterSyncAutomatically() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            return this.mMasterSyncAutomatically;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AuthorityInfo getOrCreateAuthority(Account account, String string2) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            return this.getOrCreateAuthorityLocked(account, string2, -1, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SyncStatusInfo getOrCreateSyncStatus(AuthorityInfo authorityInfo) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            return this.getOrCreateSyncStatusLocked(authorityInfo.ident);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPendingOperationCount() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            return this.mPendingOperations.size();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<PendingOperation> getPendingOperations() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            return new ArrayList<PendingOperation>(this.mPendingOperations);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<PeriodicSync> getPeriodicSyncs(Account account, String string2) {
        ArrayList<PeriodicSync> arrayList = new ArrayList<PeriodicSync>();
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authorityInfo = this.getAuthorityLocked(account, string2, "getPeriodicSyncs");
            if (authorityInfo != null) {
                for (Pair<Bundle, Long> pair : authorityInfo.periodicSyncs) {
                    arrayList.add(new PeriodicSync(account, string2, (Bundle)pair.first, (Long)pair.second));
                }
            }
            return arrayList;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SyncStatusInfo getStatusByAccountAndAuthority(Account account, String string2) {
        if (account == null || string2 == null) {
            throw new IllegalArgumentException();
        }
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            int n = this.mSyncStatus.size();
            int n2 = 0;
            while (n2 < n) {
                SyncStatusInfo syncStatusInfo = this.mSyncStatus.valueAt(n2);
                AuthorityInfo authorityInfo = this.mAuthorities.get(syncStatusInfo.authorityId);
                if (authorityInfo != null && authorityInfo.authority.equals(string2) && account.equals(authorityInfo.account)) {
                    return syncStatusInfo;
                }
                ++n2;
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getSyncAutomatically(Account account, String string2) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authorityInfo;
            if (account != null) {
                AuthorityInfo authorityInfo2 = this.getAuthorityLocked(account, string2, "getSyncAutomatically");
                if (authorityInfo2 == null) return false;
                if (!authorityInfo2.enabled) return false;
                return true;
            }
            int n = this.mAuthorities.size();
            do {
                if (n <= 0) {
                    return false;
                }
                authorityInfo = this.mAuthorities.valueAt(--n);
            } while (!authorityInfo.authority.equals(string2) || !authorityInfo.enabled);
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<SyncHistoryItem> getSyncHistory() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            int n = this.mSyncHistory.size();
            ArrayList<SyncHistoryItem> arrayList = new ArrayList<SyncHistoryItem>(n);
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(this.mSyncHistory.get(n2));
                ++n2;
            }
            return arrayList;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<SyncStatusInfo> getSyncStatus() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            int n = this.mSyncStatus.size();
            ArrayList<SyncStatusInfo> arrayList = new ArrayList<SyncStatusInfo>(n);
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(this.mSyncStatus.valueAt(n2));
                ++n2;
            }
            return arrayList;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMessage(Message message) {
        if (message.what == 1) {
            SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
            synchronized (sparseArray) {
                this.writeStatusLocked();
                return;
            }
        }
        if (message.what == 2) {
            SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
            synchronized (sparseArray) {
                this.writeStatisticsLocked();
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PendingOperation insertIntoPending(PendingOperation pendingOperation) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authorityInfo;
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "insertIntoPending: account=" + pendingOperation.account + " auth=" + pendingOperation.authority + " src=" + pendingOperation.syncSource + " extras=" + pendingOperation.extras);
            }
            if ((authorityInfo = this.getOrCreateAuthorityLocked(pendingOperation.account, pendingOperation.authority, -1, true)) == null) {
                return null;
            }
            PendingOperation pendingOperation2 = new PendingOperation(pendingOperation);
            try {
                pendingOperation2.authorityId = authorityInfo.ident;
                this.mPendingOperations.add(pendingOperation2);
                this.appendPendingOperationLocked(pendingOperation2);
                this.getOrCreateSyncStatusLocked((int)authorityInfo.ident).pending = true;
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl16 : MonitorExitStatement: MONITOREXIT : var2_2
                this.reportChange(2);
                return pendingOperation2;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long insertStartSyncEvent(Account account, String string2, long l, int n) {
        long l2;
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authorityInfo;
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "insertStartSyncEvent: account=" + account + " auth=" + string2 + " source=" + n);
            }
            if ((authorityInfo = this.getAuthorityLocked(account, string2, "insertStartSyncEvent")) == null) {
                return -1L;
            }
            SyncHistoryItem syncHistoryItem = new SyncHistoryItem();
            syncHistoryItem.authorityId = authorityInfo.ident;
            int n2 = this.mNextHistoryId;
            this.mNextHistoryId = n2 + 1;
            syncHistoryItem.historyId = n2;
            if (this.mNextHistoryId < 0) {
                this.mNextHistoryId = 0;
            }
            syncHistoryItem.eventTime = l;
            syncHistoryItem.source = n;
            syncHistoryItem.event = 0;
            this.mSyncHistory.add(0, syncHistoryItem);
            while (this.mSyncHistory.size() > 100) {
                this.mSyncHistory.remove(this.mSyncHistory.size() - 1);
            }
            l2 = syncHistoryItem.historyId;
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "returning historyId " + l2);
            }
        }
        this.reportChange(8);
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSyncActive(Account account, String string2) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authorityInfo;
            int n = this.mPendingOperations.size();
            while (n > 0) {
                PendingOperation pendingOperation = this.mPendingOperations.get(--n);
                if (!pendingOperation.account.equals(account) || !pendingOperation.authority.equals(string2)) continue;
                return true;
            }
            return this.mCurrentSync != null && (authorityInfo = this.getAuthority(this.mCurrentSync.authorityId)) != null && authorityInfo.account.equals(account) && authorityInfo.authority.equals(string2);
            {
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSyncPending(Account account, String string2) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            int n = this.mSyncStatus.size();
            int n2 = 0;
            while (n2 < n) {
                SyncStatusInfo syncStatusInfo = this.mSyncStatus.valueAt(n2);
                AuthorityInfo authorityInfo = this.mAuthorities.get(syncStatusInfo.authorityId);
                if (authorityInfo != null && (account == null || authorityInfo.account.equals(account)) && authorityInfo.authority.equals(string2) && syncStatusInfo.pending) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeAuthority(Account account, String string2) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            this.removeAuthorityLocked(account, string2, true);
            return;
        }
    }

    public void removePeriodicSync(Account account, String string2, Bundle bundle) {
        this.updateOrRemovePeriodicSync(account, string2, bundle, 0L, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeStatusChangeListener(ISyncStatusObserver iSyncStatusObserver) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            this.mChangeListeners.unregister(iSyncStatusObserver);
            return;
        }
    }

    public void reportActiveChange() {
        this.reportChange(4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setActiveSync(SyncManager.ActiveSyncContext activeSyncContext) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            if (activeSyncContext != null) {
                AuthorityInfo authorityInfo;
                if (Log.isLoggable(TAG, 2)) {
                    Log.v(TAG, "setActiveSync: account=" + activeSyncContext.mSyncOperation.account + " auth=" + activeSyncContext.mSyncOperation.authority + " src=" + activeSyncContext.mSyncOperation.syncSource + " extras=" + activeSyncContext.mSyncOperation.extras);
                }
                if (this.mCurrentSync != null) {
                    Log.w(TAG, "setActiveSync called with existing active sync!");
                }
                if ((authorityInfo = this.getAuthorityLocked(activeSyncContext.mSyncOperation.account, activeSyncContext.mSyncOperation.authority, "setActiveSync")) == null) {
                    return;
                }
                this.mCurrentSync = new SyncInfo(authorityInfo.ident, authorityInfo.account, authorityInfo.authority, activeSyncContext.mStartTime);
            } else {
                if (Log.isLoggable(TAG, 2)) {
                    Log.v(TAG, "setActiveSync: null");
                }
                this.mCurrentSync = null;
            }
        }
        this.reportChange(4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setBackoff(Account account, String string2, long l, long l2) {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "setBackoff: " + account + ", provider " + string2 + " -> nextSyncTime " + l + ", nextDelay " + l2);
        }
        boolean bl = false;
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        // MONITORENTER : sparseArray
        if (account == null || string2 == null) {
            for (AccountInfo accountInfo : this.mAccounts.values()) {
                if (account != null && !account.equals(accountInfo.account)) continue;
                for (AuthorityInfo authorityInfo : accountInfo.authorities.values()) {
                    if (string2 != null && !string2.equals(authorityInfo.authority) || authorityInfo.backoffTime == l && authorityInfo.backoffDelay == l2) continue;
                    authorityInfo.backoffTime = l;
                    authorityInfo.backoffDelay = l2;
                    bl = true;
                }
            }
        } else {
            AuthorityInfo authorityInfo = this.getOrCreateAuthorityLocked(account, string2, -1, true);
            if (authorityInfo.backoffTime == l && authorityInfo.backoffDelay == l2) {
                // MONITOREXIT : sparseArray
                return;
            }
            authorityInfo.backoffTime = l;
            authorityInfo.backoffDelay = l2;
            bl = true;
        }
        // MONITOREXIT : sparseArray
        if (!bl) return;
        this.reportChange(1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDelayUntilTime(Account account, String string2, long l) {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "setDelayUntil: " + account + ", provider " + string2 + " -> delayUntil " + l);
        }
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            AuthorityInfo authorityInfo = this.getOrCreateAuthorityLocked(account, string2, -1, true);
            if (authorityInfo.delayUntil == l) {
                return;
            }
            authorityInfo.delayUntil = l;
        }
        this.reportChange(1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setIsSyncable(Account account, String string2, int n) {
        if (n > 1) {
            n = 1;
        } else if (n < -1) {
            n = -1;
        }
        Log.d(TAG, "setIsSyncable: " + account + ", provider " + string2 + " -> " + n);
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        // MONITORENTER : sparseArray
        AuthorityInfo authorityInfo = this.getOrCreateAuthorityLocked(account, string2, -1, false);
        if (authorityInfo.syncable == n) {
            Log.d(TAG, "setIsSyncable: already set to " + n + ", doing nothing");
            // MONITOREXIT : sparseArray
            return;
        }
        authorityInfo.syncable = n;
        this.writeAccountInfoLocked();
        // MONITOREXIT : sparseArray
        if (n > 0) {
            ContentResolver.requestSync(account, string2, new Bundle());
        }
        this.reportChange(1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setMasterSyncAutomatically(boolean bl) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        // MONITORENTER : sparseArray
        if (this.mMasterSyncAutomatically == bl) {
            // MONITOREXIT : sparseArray
            return;
        }
        this.mMasterSyncAutomatically = bl;
        this.writeAccountInfoLocked();
        // MONITOREXIT : sparseArray
        if (bl) {
            ContentResolver.requestSync(null, null, new Bundle());
        }
        this.reportChange(1);
        this.mContext.sendBroadcast(SYNC_CONNECTION_SETTING_CHANGED_INTENT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void setSyncAutomatically(Account account, String string2, boolean bl) {
        Log.d(TAG, "setSyncAutomatically: , provider " + string2 + " -> " + bl);
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        // MONITORENTER : sparseArray
        AuthorityInfo authorityInfo = this.getOrCreateAuthorityLocked(account, string2, -1, false);
        if (authorityInfo.enabled == bl) {
            Log.d(TAG, "setSyncAutomatically: already set to " + bl + ", doing nothing");
            // MONITOREXIT : sparseArray
            return;
        }
        authorityInfo.enabled = bl;
        this.writeAccountInfoLocked();
        // MONITOREXIT : sparseArray
        if (bl) {
            ContentResolver.requestSync(account, string2, new Bundle());
        }
        this.reportChange(1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopSyncEvent(long l, long l2, String string2, long l3, long l4) {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            boolean bl;
            boolean bl2;
            block32: {
                long l5;
                DayStats dayStats;
                SyncHistoryItem syncHistoryItem;
                block31: {
                    block30: {
                        SyncStatusInfo syncStatusInfo;
                        block29: {
                            if (Log.isLoggable(TAG, 2)) {
                                Log.v(TAG, "stopSyncEvent: historyId=" + l);
                            }
                            int n = this.mSyncHistory.size();
                            do {
                                syncHistoryItem = null;
                                if (n <= 0) break;
                                syncHistoryItem = this.mSyncHistory.get(--n);
                            } while ((long)syncHistoryItem.historyId != l);
                            if (syncHistoryItem == null) {
                                Log.w(TAG, "stopSyncEvent: no history for id " + l);
                                return;
                            }
                            syncHistoryItem.elapsedTime = l2;
                            syncHistoryItem.event = 1;
                            syncHistoryItem.mesg = string2;
                            syncHistoryItem.downstreamActivity = l3;
                            syncHistoryItem.upstreamActivity = l4;
                            syncStatusInfo = this.getOrCreateSyncStatusLocked(syncHistoryItem.authorityId);
                            syncStatusInfo.numSyncs = 1 + syncStatusInfo.numSyncs;
                            syncStatusInfo.totalElapsedTime = l2 + syncStatusInfo.totalElapsedTime;
                            switch (syncHistoryItem.source) {
                                case 1: {
                                    syncStatusInfo.numSourceLocal = 1 + syncStatusInfo.numSourceLocal;
                                    break;
                                }
                                case 2: {
                                    syncStatusInfo.numSourcePoll = 1 + syncStatusInfo.numSourcePoll;
                                    break;
                                }
                                case 3: {
                                    syncStatusInfo.numSourceUser = 1 + syncStatusInfo.numSourceUser;
                                    break;
                                }
                                case 0: {
                                    syncStatusInfo.numSourceServer = 1 + syncStatusInfo.numSourceServer;
                                    break;
                                }
                                case 4: {
                                    syncStatusInfo.numSourcePeriodic = 1 + syncStatusInfo.numSourcePeriodic;
                                }
                            }
                            bl2 = false;
                            int n2 = this.getCurrentDayLocked();
                            if (this.mDayStats[0] == null) {
                                DayStats dayStats2;
                                DayStats[] dayStatsArray = this.mDayStats;
                                dayStatsArray[0] = dayStats2 = new DayStats(n2);
                            } else if (n2 != this.mDayStats[0].day) {
                                DayStats dayStats3;
                                System.arraycopy(this.mDayStats, 0, this.mDayStats, 1, this.mDayStats.length - 1);
                                DayStats[] dayStatsArray = this.mDayStats;
                                dayStatsArray[0] = dayStats3 = new DayStats(n2);
                                bl2 = true;
                            } else {
                                DayStats dayStats4 = this.mDayStats[0];
                                bl2 = false;
                                if (dayStats4 == null) {
                                    bl2 = false;
                                }
                            }
                            dayStats = this.mDayStats[0];
                            l5 = l2 + syncHistoryItem.eventTime;
                            if (!MESG_SUCCESS.equals(string2)) break block29;
                            if (syncStatusInfo.lastSuccessTime == 0L) break block30;
                            long l6 = syncStatusInfo.lastFailureTime - 0L;
                            long l7 = l6 == 0L ? 0 : (l6 < 0L ? -1 : 1);
                            bl = false;
                            if (l7 == false) break block31;
                            break block30;
                        }
                        boolean bl3 = MESG_CANCELED.equals(string2);
                        bl = false;
                        if (!bl3) {
                            long l8 = syncStatusInfo.lastFailureTime - 0L;
                            long l9 = l8 == 0L ? 0 : (l8 < 0L ? -1 : 1);
                            bl = false;
                            if (l9 == false) {
                                bl = true;
                            }
                            syncStatusInfo.lastFailureTime = l5;
                            syncStatusInfo.lastFailureSource = syncHistoryItem.source;
                            syncStatusInfo.lastFailureMesg = string2;
                            if (syncStatusInfo.initialFailureTime == 0L) {
                                syncStatusInfo.initialFailureTime = l5;
                            }
                            dayStats.failureCount = 1 + dayStats.failureCount;
                            dayStats.failureTime = l2 + dayStats.failureTime;
                        }
                        break block32;
                    }
                    bl = true;
                }
                syncStatusInfo.lastSuccessTime = l5;
                syncStatusInfo.lastSuccessSource = syncHistoryItem.source;
                syncStatusInfo.lastFailureTime = 0L;
                syncStatusInfo.lastFailureSource = -1;
                syncStatusInfo.lastFailureMesg = null;
                syncStatusInfo.initialFailureTime = 0L;
                dayStats.successCount = 1 + dayStats.successCount;
                dayStats.successTime = l2 + dayStats.successTime;
            }
            if (bl) {
                this.writeStatusLocked();
            } else if (!this.hasMessages(1)) {
                this.sendMessageDelayed(this.obtainMessage(1), 600000L);
            }
            if (bl2) {
                this.writeStatisticsLocked();
            } else if (!this.hasMessages(2)) {
                this.sendMessageDelayed(this.obtainMessage(2), 1800000L);
            }
        }
        this.reportChange(8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeAllState() {
        SparseArray<AuthorityInfo> sparseArray = this.mAuthorities;
        synchronized (sparseArray) {
            if (this.mNumPendingFinished > 0) {
                this.writePendingOperationsLocked();
            }
            this.writeStatusLocked();
            this.writeStatisticsLocked();
            return;
        }
    }

    static class AccountInfo {
        final Account account;
        final HashMap<String, AuthorityInfo> authorities = new HashMap();

        AccountInfo(Account account) {
            this.account = account;
        }
    }

    public static class AuthorityInfo {
        final Account account;
        final String authority;
        long backoffDelay;
        long backoffTime;
        long delayUntil;
        boolean enabled;
        final int ident;
        final ArrayList<Pair<Bundle, Long>> periodicSyncs;
        int syncable;

        AuthorityInfo(Account account, String string2, int n) {
            this.account = account;
            this.authority = string2;
            this.ident = n;
            this.enabled = false;
            this.syncable = -1;
            this.backoffTime = -1L;
            this.backoffDelay = -1L;
            this.periodicSyncs = new ArrayList();
            this.periodicSyncs.add(Pair.create(new Bundle(), 86400L));
        }
    }

    public static class DayStats {
        public final int day;
        public int failureCount;
        public long failureTime;
        public int successCount;
        public long successTime;

        public DayStats(int n) {
            this.day = n;
        }
    }

    public static class PendingOperation {
        final Account account;
        final String authority;
        int authorityId;
        final boolean expedited;
        final Bundle extras;
        byte[] flatExtras;
        final int syncSource;

        /*
         * Enabled aggressive block sorting
         */
        PendingOperation(Account account, int n, String string2, Bundle bundle, boolean bl) {
            this.account = account;
            this.syncSource = n;
            this.authority = string2;
            Bundle bundle2 = bundle != null ? new Bundle(bundle) : bundle;
            this.extras = bundle2;
            this.expedited = bl;
            this.authorityId = -1;
        }

        PendingOperation(PendingOperation pendingOperation) {
            this.account = pendingOperation.account;
            this.syncSource = pendingOperation.syncSource;
            this.authority = pendingOperation.authority;
            this.extras = pendingOperation.extras;
            this.authorityId = pendingOperation.authorityId;
            this.expedited = pendingOperation.expedited;
        }
    }

    public static class SyncHistoryItem {
        int authorityId;
        long downstreamActivity;
        long elapsedTime;
        int event;
        long eventTime;
        int historyId;
        String mesg;
        int source;
        long upstreamActivity;
    }
}

