/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageInstallObserver;
import android.content.pm.IPackageMoveObserver;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IPackageManager
extends IInterface {
    public void addPackageToPreferred(String var1) throws RemoteException;

    public boolean addPermission(PermissionInfo var1) throws RemoteException;

    public boolean addPermissionAsync(PermissionInfo var1) throws RemoteException;

    public void addPreferredActivity(IntentFilter var1, int var2, ComponentName[] var3, ComponentName var4) throws RemoteException;

    public String[] canonicalToCurrentPackageNames(String[] var1) throws RemoteException;

    public int checkPermission(String var1, String var2) throws RemoteException;

    public int checkSignatures(String var1, String var2) throws RemoteException;

    public int checkUidPermission(String var1, int var2) throws RemoteException;

    public int checkUidSignatures(int var1, int var2) throws RemoteException;

    public void clearApplicationUserData(String var1, IPackageDataObserver var2) throws RemoteException;

    public void clearPackagePreferredActivities(String var1) throws RemoteException;

    public String[] currentToCanonicalPackageNames(String[] var1) throws RemoteException;

    public void deleteApplicationCacheFiles(String var1, IPackageDataObserver var2) throws RemoteException;

    public void deletePackage(String var1, IPackageDeleteObserver var2, int var3) throws RemoteException;

    public void enterSafeMode() throws RemoteException;

    public void finishPackageInstall(int var1) throws RemoteException;

    public void freeStorage(long var1, IntentSender var3) throws RemoteException;

    public void freeStorageAndNotify(long var1, IPackageDataObserver var3) throws RemoteException;

    public ActivityInfo getActivityInfo(ComponentName var1, int var2) throws RemoteException;

    public List<PermissionGroupInfo> getAllPermissionGroups(int var1) throws RemoteException;

    public int getApplicationEnabledSetting(String var1) throws RemoteException;

    public ApplicationInfo getApplicationInfo(String var1, int var2) throws RemoteException;

    public int getComponentEnabledSetting(ComponentName var1) throws RemoteException;

    public int getInstallLocation() throws RemoteException;

    public List<ApplicationInfo> getInstalledApplications(int var1) throws RemoteException;

    public List<PackageInfo> getInstalledPackages(int var1) throws RemoteException;

    public String getInstallerPackageName(String var1) throws RemoteException;

    public InstrumentationInfo getInstrumentationInfo(ComponentName var1, int var2) throws RemoteException;

    public String getNameForUid(int var1) throws RemoteException;

    public int[] getPackageGids(String var1) throws RemoteException;

    public PackageInfo getPackageInfo(String var1, int var2) throws RemoteException;

    public void getPackageSizeInfo(String var1, IPackageStatsObserver var2) throws RemoteException;

    public int getPackageUid(String var1) throws RemoteException;

    public String[] getPackagesForUid(int var1) throws RemoteException;

    public PermissionGroupInfo getPermissionGroupInfo(String var1, int var2) throws RemoteException;

    public PermissionInfo getPermissionInfo(String var1, int var2) throws RemoteException;

    public List<ApplicationInfo> getPersistentApplications(int var1) throws RemoteException;

    public int getPreferredActivities(List<IntentFilter> var1, List<ComponentName> var2, String var3) throws RemoteException;

    public List<PackageInfo> getPreferredPackages(int var1) throws RemoteException;

    public ProviderInfo getProviderInfo(ComponentName var1, int var2) throws RemoteException;

    public ActivityInfo getReceiverInfo(ComponentName var1, int var2) throws RemoteException;

    public ServiceInfo getServiceInfo(ComponentName var1, int var2) throws RemoteException;

    public FeatureInfo[] getSystemAvailableFeatures() throws RemoteException;

    public String[] getSystemSharedLibraryNames() throws RemoteException;

    public int getUidForSharedUser(String var1) throws RemoteException;

    public boolean hasSystemFeature(String var1) throws RemoteException;

    public boolean hasSystemUidErrors() throws RemoteException;

    public void installPackage(Uri var1, IPackageInstallObserver var2, int var3, String var4) throws RemoteException;

    public boolean isProtectedBroadcast(String var1) throws RemoteException;

    public boolean isSafeMode() throws RemoteException;

    public void movePackage(String var1, IPackageMoveObserver var2, int var3) throws RemoteException;

    public String nextPackageToClean(String var1) throws RemoteException;

    public boolean performDexOpt(String var1) throws RemoteException;

    public List<ProviderInfo> queryContentProviders(String var1, int var2, int var3) throws RemoteException;

    public List<InstrumentationInfo> queryInstrumentation(String var1, int var2) throws RemoteException;

    public List<ResolveInfo> queryIntentActivities(Intent var1, String var2, int var3) throws RemoteException;

    public List<ResolveInfo> queryIntentActivityOptions(ComponentName var1, Intent[] var2, String[] var3, Intent var4, String var5, int var6) throws RemoteException;

    public List<ResolveInfo> queryIntentReceivers(Intent var1, String var2, int var3) throws RemoteException;

    public List<ResolveInfo> queryIntentServices(Intent var1, String var2, int var3) throws RemoteException;

    public List<PermissionInfo> queryPermissionsByGroup(String var1, int var2) throws RemoteException;

    public void querySyncProviders(List<String> var1, List<ProviderInfo> var2) throws RemoteException;

    public void removePackageFromPreferred(String var1) throws RemoteException;

    public void removePermission(String var1) throws RemoteException;

    public void replacePreferredActivity(IntentFilter var1, int var2, ComponentName[] var3, ComponentName var4) throws RemoteException;

    public ProviderInfo resolveContentProvider(String var1, int var2) throws RemoteException;

    public ResolveInfo resolveIntent(Intent var1, String var2, int var3) throws RemoteException;

    public ResolveInfo resolveService(Intent var1, String var2, int var3) throws RemoteException;

    public void setApplicationEnabledSetting(String var1, int var2, int var3) throws RemoteException;

    public void setComponentEnabledSetting(ComponentName var1, int var2, int var3) throws RemoteException;

    public boolean setInstallLocation(int var1) throws RemoteException;

    public void systemReady() throws RemoteException;

    public void updateExternalMediaStatus(boolean var1, boolean var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPackageManager {
        private static final String DESCRIPTOR = "android.content.pm.IPackageManager";
        static final int TRANSACTION_addPackageToPreferred = 43;
        static final int TRANSACTION_addPermission = 17;
        static final int TRANSACTION_addPermissionAsync = 70;
        static final int TRANSACTION_addPreferredActivity = 46;
        static final int TRANSACTION_canonicalToCurrentPackageNames = 5;
        static final int TRANSACTION_checkPermission = 15;
        static final int TRANSACTION_checkSignatures = 20;
        static final int TRANSACTION_checkUidPermission = 16;
        static final int TRANSACTION_checkUidSignatures = 21;
        static final int TRANSACTION_clearApplicationUserData = 57;
        static final int TRANSACTION_clearPackagePreferredActivities = 48;
        static final int TRANSACTION_currentToCanonicalPackageNames = 4;
        static final int TRANSACTION_deleteApplicationCacheFiles = 56;
        static final int TRANSACTION_deletePackage = 41;
        static final int TRANSACTION_enterSafeMode = 62;
        static final int TRANSACTION_finishPackageInstall = 40;
        static final int TRANSACTION_freeStorage = 55;
        static final int TRANSACTION_freeStorageAndNotify = 54;
        static final int TRANSACTION_getActivityInfo = 11;
        static final int TRANSACTION_getAllPermissionGroups = 9;
        static final int TRANSACTION_getApplicationEnabledSetting = 53;
        static final int TRANSACTION_getApplicationInfo = 10;
        static final int TRANSACTION_getComponentEnabledSetting = 51;
        static final int TRANSACTION_getInstallLocation = 72;
        static final int TRANSACTION_getInstalledApplications = 32;
        static final int TRANSACTION_getInstalledPackages = 31;
        static final int TRANSACTION_getInstallerPackageName = 42;
        static final int TRANSACTION_getInstrumentationInfo = 37;
        static final int TRANSACTION_getNameForUid = 23;
        static final int TRANSACTION_getPackageGids = 3;
        static final int TRANSACTION_getPackageInfo = 1;
        static final int TRANSACTION_getPackageSizeInfo = 58;
        static final int TRANSACTION_getPackageUid = 2;
        static final int TRANSACTION_getPackagesForUid = 22;
        static final int TRANSACTION_getPermissionGroupInfo = 8;
        static final int TRANSACTION_getPermissionInfo = 6;
        static final int TRANSACTION_getPersistentApplications = 33;
        static final int TRANSACTION_getPreferredActivities = 49;
        static final int TRANSACTION_getPreferredPackages = 45;
        static final int TRANSACTION_getProviderInfo = 14;
        static final int TRANSACTION_getReceiverInfo = 12;
        static final int TRANSACTION_getServiceInfo = 13;
        static final int TRANSACTION_getSystemAvailableFeatures = 60;
        static final int TRANSACTION_getSystemSharedLibraryNames = 59;
        static final int TRANSACTION_getUidForSharedUser = 24;
        static final int TRANSACTION_hasSystemFeature = 61;
        static final int TRANSACTION_hasSystemUidErrors = 65;
        static final int TRANSACTION_installPackage = 39;
        static final int TRANSACTION_isProtectedBroadcast = 19;
        static final int TRANSACTION_isSafeMode = 63;
        static final int TRANSACTION_movePackage = 69;
        static final int TRANSACTION_nextPackageToClean = 68;
        static final int TRANSACTION_performDexOpt = 66;
        static final int TRANSACTION_queryContentProviders = 36;
        static final int TRANSACTION_queryInstrumentation = 38;
        static final int TRANSACTION_queryIntentActivities = 26;
        static final int TRANSACTION_queryIntentActivityOptions = 27;
        static final int TRANSACTION_queryIntentReceivers = 28;
        static final int TRANSACTION_queryIntentServices = 30;
        static final int TRANSACTION_queryPermissionsByGroup = 7;
        static final int TRANSACTION_querySyncProviders = 35;
        static final int TRANSACTION_removePackageFromPreferred = 44;
        static final int TRANSACTION_removePermission = 18;
        static final int TRANSACTION_replacePreferredActivity = 47;
        static final int TRANSACTION_resolveContentProvider = 34;
        static final int TRANSACTION_resolveIntent = 25;
        static final int TRANSACTION_resolveService = 29;
        static final int TRANSACTION_setApplicationEnabledSetting = 52;
        static final int TRANSACTION_setComponentEnabledSetting = 50;
        static final int TRANSACTION_setInstallLocation = 71;
        static final int TRANSACTION_systemReady = 64;
        static final int TRANSACTION_updateExternalMediaStatus = 67;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPackageManager asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IPackageManager) {
                return (IPackageManager)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    PackageInfo packageInfo = this.getPackageInfo(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    if (packageInfo != null) {
                        parcel2.writeInt(1);
                        packageInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n3 = this.getPackageUid(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n3);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int[] nArray = this.getPackageGids(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeIntArray(nArray);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.currentToCanonicalPackageNames(parcel.createStringArray());
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.canonicalToCurrentPackageNames(parcel.createStringArray());
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    PermissionInfo permissionInfo = this.getPermissionInfo(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    if (permissionInfo != null) {
                        parcel2.writeInt(1);
                        permissionInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<PermissionInfo> list = this.queryPermissionsByGroup(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    PermissionGroupInfo permissionGroupInfo = this.getPermissionGroupInfo(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    if (permissionGroupInfo != null) {
                        parcel2.writeInt(1);
                        permissionGroupInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<PermissionGroupInfo> list = this.getAllPermissionGroups(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ApplicationInfo applicationInfo = this.getApplicationInfo(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    if (applicationInfo != null) {
                        parcel2.writeInt(1);
                        applicationInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    int n4 = parcel.readInt();
                    ActivityInfo activityInfo = this.getActivityInfo(componentName, n4);
                    parcel2.writeNoException();
                    if (activityInfo != null) {
                        parcel2.writeInt(1);
                        activityInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    int n5 = parcel.readInt();
                    ActivityInfo activityInfo = this.getReceiverInfo(componentName, n5);
                    parcel2.writeNoException();
                    if (activityInfo != null) {
                        parcel2.writeInt(1);
                        activityInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    int n6 = parcel.readInt();
                    ServiceInfo serviceInfo = this.getServiceInfo(componentName, n6);
                    parcel2.writeNoException();
                    if (serviceInfo != null) {
                        parcel2.writeInt(1);
                        serviceInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    int n7 = parcel.readInt();
                    ProviderInfo providerInfo = this.getProviderInfo(componentName, n7);
                    parcel2.writeNoException();
                    if (providerInfo != null) {
                        parcel2.writeInt(1);
                        providerInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n8 = this.checkPermission(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n8);
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n9 = this.checkUidPermission(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n9);
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    PermissionInfo permissionInfo = parcel.readInt() != 0 ? PermissionInfo.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.addPermission(permissionInfo);
                    parcel2.writeNoException();
                    int n10 = bl ? 1 : 0;
                    parcel2.writeInt(n10);
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removePermission(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isProtectedBroadcast(parcel.readString());
                    parcel2.writeNoException();
                    int n11 = bl ? 1 : 0;
                    parcel2.writeInt(n11);
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n12 = this.checkSignatures(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n12);
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n13 = this.checkUidSignatures(parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n13);
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.getPackagesForUid(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 23: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = this.getNameForUid(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeString(string2);
                    return true;
                }
                case 24: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n14 = this.getUidForSharedUser(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n14);
                    return true;
                }
                case 25: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = parcel.readInt() != 0 ? Intent.CREATOR.createFromParcel(parcel) : null;
                    String string3 = parcel.readString();
                    int n15 = parcel.readInt();
                    ResolveInfo resolveInfo = this.resolveIntent(intent, string3, n15);
                    parcel2.writeNoException();
                    if (resolveInfo != null) {
                        parcel2.writeInt(1);
                        resolveInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 26: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = parcel.readInt() != 0 ? Intent.CREATOR.createFromParcel(parcel) : null;
                    String string4 = parcel.readString();
                    int n16 = parcel.readInt();
                    List<ResolveInfo> list = this.queryIntentActivities(intent, string4, n16);
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 27: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    Intent[] intentArray = parcel.createTypedArray(Intent.CREATOR);
                    String[] stringArray = parcel.createStringArray();
                    Intent intent = parcel.readInt() != 0 ? Intent.CREATOR.createFromParcel(parcel) : null;
                    List<ResolveInfo> list = this.queryIntentActivityOptions(componentName, intentArray, stringArray, intent, parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 28: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = parcel.readInt() != 0 ? Intent.CREATOR.createFromParcel(parcel) : null;
                    String string5 = parcel.readString();
                    int n17 = parcel.readInt();
                    List<ResolveInfo> list = this.queryIntentReceivers(intent, string5, n17);
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 29: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = parcel.readInt() != 0 ? Intent.CREATOR.createFromParcel(parcel) : null;
                    String string6 = parcel.readString();
                    int n18 = parcel.readInt();
                    ResolveInfo resolveInfo = this.resolveService(intent, string6, n18);
                    parcel2.writeNoException();
                    if (resolveInfo != null) {
                        parcel2.writeInt(1);
                        resolveInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 30: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = parcel.readInt() != 0 ? Intent.CREATOR.createFromParcel(parcel) : null;
                    String string7 = parcel.readString();
                    int n19 = parcel.readInt();
                    List<ResolveInfo> list = this.queryIntentServices(intent, string7, n19);
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 31: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<PackageInfo> list = this.getInstalledPackages(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 32: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<ApplicationInfo> list = this.getInstalledApplications(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 33: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<ApplicationInfo> list = this.getPersistentApplications(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 34: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ProviderInfo providerInfo = this.resolveContentProvider(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    if (providerInfo != null) {
                        parcel2.writeInt(1);
                        providerInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 35: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ArrayList<String> arrayList = parcel.createStringArrayList();
                    ArrayList<ProviderInfo> arrayList2 = parcel.createTypedArrayList(ProviderInfo.CREATOR);
                    this.querySyncProviders(arrayList, arrayList2);
                    parcel2.writeNoException();
                    parcel2.writeStringList(arrayList);
                    parcel2.writeTypedList(arrayList2);
                    return true;
                }
                case 36: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<ProviderInfo> list = this.queryContentProviders(parcel.readString(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 37: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    int n20 = parcel.readInt();
                    InstrumentationInfo instrumentationInfo = this.getInstrumentationInfo(componentName, n20);
                    parcel2.writeNoException();
                    if (instrumentationInfo != null) {
                        parcel2.writeInt(1);
                        instrumentationInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 38: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<InstrumentationInfo> list = this.queryInstrumentation(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 39: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Uri uri = parcel.readInt() != 0 ? Uri.CREATOR.createFromParcel(parcel) : null;
                    IPackageInstallObserver iPackageInstallObserver = IPackageInstallObserver.Stub.asInterface(parcel.readStrongBinder());
                    int n21 = parcel.readInt();
                    String string8 = parcel.readString();
                    this.installPackage(uri, iPackageInstallObserver, n21, string8);
                    parcel2.writeNoException();
                    return true;
                }
                case 40: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.finishPackageInstall(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 41: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.deletePackage(parcel.readString(), IPackageDeleteObserver.Stub.asInterface(parcel.readStrongBinder()), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 42: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string9 = this.getInstallerPackageName(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeString(string9);
                    return true;
                }
                case 43: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.addPackageToPreferred(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 44: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removePackageFromPreferred(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 45: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<PackageInfo> list = this.getPreferredPackages(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 46: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IntentFilter intentFilter = parcel.readInt() != 0 ? IntentFilter.CREATOR.createFromParcel(parcel) : null;
                    int n22 = parcel.readInt();
                    ComponentName[] componentNameArray = parcel.createTypedArray(ComponentName.CREATOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    this.addPreferredActivity(intentFilter, n22, componentNameArray, componentName);
                    parcel2.writeNoException();
                    return true;
                }
                case 47: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IntentFilter intentFilter = parcel.readInt() != 0 ? IntentFilter.CREATOR.createFromParcel(parcel) : null;
                    int n23 = parcel.readInt();
                    ComponentName[] componentNameArray = parcel.createTypedArray(ComponentName.CREATOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    this.replacePreferredActivity(intentFilter, n23, componentNameArray, componentName);
                    parcel2.writeNoException();
                    return true;
                }
                case 48: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.clearPackagePreferredActivities(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 49: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ArrayList<IntentFilter> arrayList = new ArrayList<IntentFilter>();
                    ArrayList<ComponentName> arrayList3 = new ArrayList<ComponentName>();
                    int n24 = this.getPreferredActivities(arrayList, arrayList3, parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n24);
                    parcel2.writeTypedList(arrayList);
                    parcel2.writeTypedList(arrayList3);
                    return true;
                }
                case 50: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    int n25 = parcel.readInt();
                    int n26 = parcel.readInt();
                    this.setComponentEnabledSetting(componentName, n25, n26);
                    parcel2.writeNoException();
                    return true;
                }
                case 51: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    int n27 = this.getComponentEnabledSetting(componentName);
                    parcel2.writeNoException();
                    parcel2.writeInt(n27);
                    return true;
                }
                case 52: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setApplicationEnabledSetting(parcel.readString(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 53: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n28 = this.getApplicationEnabledSetting(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n28);
                    return true;
                }
                case 54: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.freeStorageAndNotify(parcel.readLong(), IPackageDataObserver.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 55: {
                    parcel.enforceInterface(DESCRIPTOR);
                    long l = parcel.readLong();
                    IntentSender intentSender = parcel.readInt() != 0 ? IntentSender.CREATOR.createFromParcel(parcel) : null;
                    this.freeStorage(l, intentSender);
                    parcel2.writeNoException();
                    return true;
                }
                case 56: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.deleteApplicationCacheFiles(parcel.readString(), IPackageDataObserver.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 57: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.clearApplicationUserData(parcel.readString(), IPackageDataObserver.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 58: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.getPackageSizeInfo(parcel.readString(), IPackageStatsObserver.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 59: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.getSystemSharedLibraryNames();
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 60: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Parcelable[] parcelableArray = this.getSystemAvailableFeatures();
                    parcel2.writeNoException();
                    parcel2.writeTypedArray(parcelableArray, 1);
                    return true;
                }
                case 61: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.hasSystemFeature(parcel.readString());
                    parcel2.writeNoException();
                    int n29 = bl ? 1 : 0;
                    parcel2.writeInt(n29);
                    return true;
                }
                case 62: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.enterSafeMode();
                    parcel2.writeNoException();
                    return true;
                }
                case 63: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isSafeMode();
                    parcel2.writeNoException();
                    int n30 = bl ? 1 : 0;
                    parcel2.writeInt(n30);
                    return true;
                }
                case 64: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.systemReady();
                    parcel2.writeNoException();
                    return true;
                }
                case 65: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.hasSystemUidErrors();
                    parcel2.writeNoException();
                    int n31 = bl ? 1 : 0;
                    parcel2.writeInt(n31);
                    return true;
                }
                case 66: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.performDexOpt(parcel.readString());
                    parcel2.writeNoException();
                    int n32 = bl ? 1 : 0;
                    parcel2.writeInt(n32);
                    return true;
                }
                case 67: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    boolean bl2 = parcel.readInt() != 0;
                    this.updateExternalMediaStatus(bl, bl2);
                    parcel2.writeNoException();
                    return true;
                }
                case 68: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string10 = this.nextPackageToClean(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeString(string10);
                    return true;
                }
                case 69: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.movePackage(parcel.readString(), IPackageMoveObserver.Stub.asInterface(parcel.readStrongBinder()), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 70: {
                    parcel.enforceInterface(DESCRIPTOR);
                    PermissionInfo permissionInfo = parcel.readInt() != 0 ? PermissionInfo.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.addPermissionAsync(permissionInfo);
                    parcel2.writeNoException();
                    int n33 = bl ? 1 : 0;
                    parcel2.writeInt(n33);
                    return true;
                }
                case 71: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.setInstallLocation(parcel.readInt());
                    parcel2.writeNoException();
                    int n34 = bl ? 1 : 0;
                    parcel2.writeInt(n34);
                    return true;
                }
                case 72: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            int n35 = this.getInstallLocation();
            parcel2.writeNoException();
            parcel2.writeInt(n35);
            return true;
        }

        private static class Proxy
        implements IPackageManager {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public void addPackageToPreferred(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(43, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean addPermission(PermissionInfo permissionInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (permissionInfo != null) {
                        parcel.writeInt(1);
                        permissionInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean addPermissionAsync(PermissionInfo permissionInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (permissionInfo != null) {
                        parcel.writeInt(1);
                        permissionInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(70, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addPreferredActivity(IntentFilter intentFilter, int n, ComponentName[] componentNameArray, ComponentName componentName) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intentFilter != null) {
                        parcel.writeInt(1);
                        intentFilter.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    parcel.writeTypedArray(componentNameArray, 0);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(46, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public String[] canonicalToCurrentPackageNames(String[] stringArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStringArray(stringArray);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray2 = parcel2.createStringArray();
                    return stringArray2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int checkPermission(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int checkSignatures(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int checkUidPermission(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int checkUidSignatures(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = parcel2.readInt();
                    return n3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void clearApplicationUserData(String string2, IPackageDataObserver iPackageDataObserver) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    IBinder iBinder = iPackageDataObserver != null ? iPackageDataObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(57, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void clearPackagePreferredActivities(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(48, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String[] currentToCanonicalPackageNames(String[] stringArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStringArray(stringArray);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray2 = parcel2.createStringArray();
                    return stringArray2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void deleteApplicationCacheFiles(String string2, IPackageDataObserver iPackageDataObserver) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    IBinder iBinder = iPackageDataObserver != null ? iPackageDataObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(56, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void deletePackage(String string2, IPackageDeleteObserver iPackageDeleteObserver, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    IBinder iBinder = iPackageDeleteObserver != null ? iPackageDeleteObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(41, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void enterSafeMode() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(62, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void finishPackageInstall(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(40, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void freeStorage(long l, IntentSender intentSender) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    if (intentSender != null) {
                        parcel.writeInt(1);
                        intentSender.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(55, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void freeStorageAndNotify(long l, IPackageDataObserver iPackageDataObserver) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    IBinder iBinder = iPackageDataObserver != null ? iPackageDataObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(54, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ActivityInfo getActivityInfo(ComponentName componentName, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    ActivityInfo activityInfo = parcel2.readInt() != 0 ? ActivityInfo.CREATOR.createFromParcel(parcel2) : null;
                    return activityInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<PermissionGroupInfo> getAllPermissionGroups(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<PermissionGroupInfo> arrayList = parcel2.createTypedArrayList(PermissionGroupInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getApplicationEnabledSetting(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(53, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ApplicationInfo getApplicationInfo(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    ApplicationInfo applicationInfo = parcel2.readInt() != 0 ? ApplicationInfo.CREATOR.createFromParcel(parcel2) : null;
                    return applicationInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int getComponentEnabledSetting(ComponentName componentName) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(51, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getInstallLocation() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(72, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<ApplicationInfo> getInstalledApplications(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(32, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<ApplicationInfo> arrayList = parcel2.createTypedArrayList(ApplicationInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<PackageInfo> getInstalledPackages(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(31, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<PackageInfo> arrayList = parcel2.createTypedArrayList(PackageInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String getInstallerPackageName(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(42, parcel, parcel2, 0);
                    parcel2.readException();
                    String string3 = parcel2.readString();
                    return string3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public InstrumentationInfo getInstrumentationInfo(ComponentName componentName, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(37, parcel, parcel2, 0);
                    parcel2.readException();
                    InstrumentationInfo instrumentationInfo = parcel2.readInt() != 0 ? InstrumentationInfo.CREATOR.createFromParcel(parcel2) : null;
                    return instrumentationInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public String getNameForUid(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    String string2 = parcel2.readString();
                    return string2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int[] getPackageGids(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    int[] nArray = parcel2.createIntArray();
                    return nArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public PackageInfo getPackageInfo(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    PackageInfo packageInfo = parcel2.readInt() != 0 ? PackageInfo.CREATOR.createFromParcel(parcel2) : null;
                    return packageInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void getPackageSizeInfo(String string2, IPackageStatsObserver iPackageStatsObserver) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    IBinder iBinder = iPackageStatsObserver != null ? iPackageStatsObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(58, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int getPackageUid(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String[] getPackagesForUid(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray = parcel2.createStringArray();
                    return stringArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public PermissionGroupInfo getPermissionGroupInfo(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    PermissionGroupInfo permissionGroupInfo = parcel2.readInt() != 0 ? PermissionGroupInfo.CREATOR.createFromParcel(parcel2) : null;
                    return permissionGroupInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public PermissionInfo getPermissionInfo(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    PermissionInfo permissionInfo = parcel2.readInt() != 0 ? PermissionInfo.CREATOR.createFromParcel(parcel2) : null;
                    return permissionInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<ApplicationInfo> getPersistentApplications(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(33, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<ApplicationInfo> arrayList = parcel2.createTypedArrayList(ApplicationInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getPreferredActivities(List<IntentFilter> list, List<ComponentName> list2, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(49, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    parcel2.readTypedList(list, IntentFilter.CREATOR);
                    parcel2.readTypedList(list2, ComponentName.CREATOR);
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<PackageInfo> getPreferredPackages(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(45, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<PackageInfo> arrayList = parcel2.createTypedArrayList(PackageInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ProviderInfo getProviderInfo(ComponentName componentName, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    ProviderInfo providerInfo = parcel2.readInt() != 0 ? ProviderInfo.CREATOR.createFromParcel(parcel2) : null;
                    return providerInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ActivityInfo getReceiverInfo(ComponentName componentName, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    ActivityInfo activityInfo = parcel2.readInt() != 0 ? ActivityInfo.CREATOR.createFromParcel(parcel2) : null;
                    return activityInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ServiceInfo getServiceInfo(ComponentName componentName, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    ServiceInfo serviceInfo = parcel2.readInt() != 0 ? ServiceInfo.CREATOR.createFromParcel(parcel2) : null;
                    return serviceInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public FeatureInfo[] getSystemAvailableFeatures() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(60, parcel, parcel2, 0);
                    parcel2.readException();
                    FeatureInfo[] featureInfoArray = parcel2.createTypedArray(FeatureInfo.CREATOR);
                    return featureInfoArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String[] getSystemSharedLibraryNames() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(59, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray = parcel2.createStringArray();
                    return stringArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getUidForSharedUser(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean hasSystemFeature(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(61, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean hasSystemUidErrors() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(65, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void installPackage(Uri uri, IPackageInstallObserver iPackageInstallObserver, int n, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (uri != null) {
                        parcel.writeInt(1);
                        uri.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    IBinder iBinder = iPackageInstallObserver != null ? iPackageInstallObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    this.mRemote.transact(39, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isProtectedBroadcast(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isSafeMode() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(63, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void movePackage(String string2, IPackageMoveObserver iPackageMoveObserver, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    IBinder iBinder = iPackageMoveObserver != null ? iPackageMoveObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(69, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public String nextPackageToClean(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(68, parcel, parcel2, 0);
                    parcel2.readException();
                    String string3 = parcel2.readString();
                    return string3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean performDexOpt(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(66, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<ProviderInfo> queryContentProviders(String string2, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(36, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<ProviderInfo> arrayList = parcel2.createTypedArrayList(ProviderInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<InstrumentationInfo> queryInstrumentation(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(38, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<InstrumentationInfo> arrayList = parcel2.createTypedArrayList(InstrumentationInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<ResolveInfo> queryIntentActivities(Intent intent, String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<ResolveInfo> arrayList = parcel2.createTypedArrayList(ResolveInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<ResolveInfo> queryIntentActivityOptions(ComponentName componentName, Intent[] intentArray, String[] stringArray, Intent intent, String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeTypedArray(intentArray, 0);
                    parcel.writeStringArray(stringArray);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(27, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<ResolveInfo> arrayList = parcel2.createTypedArrayList(ResolveInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<ResolveInfo> queryIntentReceivers(Intent intent, String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(28, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<ResolveInfo> arrayList = parcel2.createTypedArrayList(ResolveInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<ResolveInfo> queryIntentServices(Intent intent, String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(30, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<ResolveInfo> arrayList = parcel2.createTypedArrayList(ResolveInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<PermissionInfo> queryPermissionsByGroup(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<PermissionInfo> arrayList = parcel2.createTypedArrayList(PermissionInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void querySyncProviders(List<String> list, List<ProviderInfo> list2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStringList(list);
                    parcel.writeTypedList(list2);
                    this.mRemote.transact(35, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.readStringList(list);
                    parcel2.readTypedList(list2, ProviderInfo.CREATOR);
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void removePackageFromPreferred(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(44, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void removePermission(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void replacePreferredActivity(IntentFilter intentFilter, int n, ComponentName[] componentNameArray, ComponentName componentName) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intentFilter != null) {
                        parcel.writeInt(1);
                        intentFilter.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    parcel.writeTypedArray(componentNameArray, 0);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(47, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ProviderInfo resolveContentProvider(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(34, parcel, parcel2, 0);
                    parcel2.readException();
                    ProviderInfo providerInfo = parcel2.readInt() != 0 ? ProviderInfo.CREATOR.createFromParcel(parcel2) : null;
                    return providerInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ResolveInfo resolveIntent(Intent intent, String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    ResolveInfo resolveInfo = parcel2.readInt() != 0 ? ResolveInfo.CREATOR.createFromParcel(parcel2) : null;
                    return resolveInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ResolveInfo resolveService(Intent intent, String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(29, parcel, parcel2, 0);
                    parcel2.readException();
                    ResolveInfo resolveInfo = parcel2.readInt() != 0 ? ResolveInfo.CREATOR.createFromParcel(parcel2) : null;
                    return resolveInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setApplicationEnabledSetting(String string2, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(52, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setComponentEnabledSetting(ComponentName componentName, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(50, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setInstallLocation(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(71, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = n2 != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void systemReady() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(64, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void updateExternalMediaStatus(boolean bl, boolean bl2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    int n2 = bl2 ? 1 : 0;
                    parcel.writeInt(n2);
                    this.mRemote.transact(67, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }
        }
    }
}

