/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.ComponentName;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PathPermission;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.os.Bundle;
import android.os.PatternMatcher;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import com.android.internal.R;
import com.android.internal.util.XmlUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PackageParser {
    private static final String ANDROID_RESOURCES = "http://schemas.android.com/apk/res/android";
    public static final NewPermissionInfo[] NEW_PERMISSIONS;
    public static final int PARSE_CHATTY = 2;
    private static final int PARSE_DEFAULT_INSTALL_LOCATION = -1;
    public static final int PARSE_FORWARD_LOCK = 16;
    public static final int PARSE_IGNORE_PROCESSES = 8;
    public static final int PARSE_IS_SYSTEM = 1;
    public static final int PARSE_IS_SYSTEM_DIR = 64;
    public static final int PARSE_MUST_BE_APK = 4;
    public static final int PARSE_ON_SDCARD = 32;
    private static final boolean RIGID_PARSER = false;
    private static final String SDK_CODENAME;
    private static final int SDK_VERSION = 0;
    private static final String TAG = "PackageParser";
    private static WeakReference<byte[]> mReadBuffer;
    private static final Object mSync;
    private static boolean sCompatibilityModeEnabled;
    private String mArchiveSourcePath;
    private ParseComponentArgs mParseActivityAliasArgs;
    private ParseComponentArgs mParseActivityArgs;
    private int mParseError = 1;
    private ParsePackageItemArgs mParseInstrumentationArgs;
    private ParseComponentArgs mParseProviderArgs;
    private ParseComponentArgs mParseServiceArgs;
    private String[] mSeparateProcesses;

    /*
     * Enabled aggressive block sorting
     */
    static {
        NewPermissionInfo[] newPermissionInfoArray = new NewPermissionInfo[]{new NewPermissionInfo("android.permission.WRITE_EXTERNAL_STORAGE", 4, 0), new NewPermissionInfo("android.permission.READ_PHONE_STATE", 4, 0)};
        NEW_PERMISSIONS = newPermissionInfoArray;
        SDK_VERSION = Build.VERSION.SDK_INT;
        String string2 = "REL".equals(Build.VERSION.CODENAME) ? null : Build.VERSION.CODENAME;
        SDK_CODENAME = string2;
        mSync = new Object();
        sCompatibilityModeEnabled = true;
    }

    public PackageParser(String string2) {
        this.mArchiveSourcePath = string2;
    }

    private static String buildClassName(String string2, CharSequence charSequence, String[] stringArray) {
        if (charSequence == null || charSequence.length() <= 0) {
            stringArray[0] = "Empty class name in package " + string2;
            return null;
        }
        String string3 = ((Object)charSequence).toString();
        char c = string3.charAt(0);
        if (c == '.') {
            return (string2 + string3).intern();
        }
        if (string3.indexOf(46) < 0) {
            StringBuilder stringBuilder = new StringBuilder(string2);
            stringBuilder.append('.');
            stringBuilder.append(string3);
            return stringBuilder.toString().intern();
        }
        if (c >= 'a' && c <= 'z') {
            return string3.intern();
        }
        stringArray[0] = "Bad class name " + string3 + " in package " + string2;
        return null;
    }

    private static String buildCompoundName(String string2, CharSequence charSequence, String string3, String[] stringArray) {
        String string4 = ((Object)charSequence).toString();
        char c = string4.charAt(0);
        if (string2 != null && c == ':') {
            if (string4.length() < 2) {
                stringArray[0] = "Bad " + string3 + " name " + string4 + " in package " + string2 + ": must be at least two characters";
                return null;
            }
            String string5 = PackageParser.validateName(string4.substring(1), false);
            if (string5 != null) {
                stringArray[0] = "Invalid " + string3 + " name " + string4 + " in package " + string2 + ": " + string5;
                return null;
            }
            return (string2 + string4).intern();
        }
        String string6 = PackageParser.validateName(string4, true);
        if (string6 != null && !"system".equals(string4)) {
            stringArray[0] = "Invalid " + string3 + " name " + string4 + " in package " + string2 + ": " + string6;
            return null;
        }
        return string4.intern();
    }

    private static String buildProcessName(String string2, String string3, CharSequence charSequence, int n, String[] stringArray, String[] stringArray2) {
        if ((n & 8) != 0 && !"system".equals(charSequence)) {
            if (string3 != null) {
                return string3;
            }
            return string2;
        }
        if (stringArray != null) {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                String string4 = stringArray[i];
                if (!string4.equals(string2) && !string4.equals(string3) && !string4.equals(charSequence)) continue;
                return string2;
            }
        }
        if (charSequence == null || charSequence.length() <= 0) {
            return string3;
        }
        return PackageParser.buildCompoundName(string2, charSequence, "process", stringArray2);
    }

    private static String buildTaskAffinityName(String string2, String string3, CharSequence charSequence, String[] stringArray) {
        if (charSequence == null) {
            return string3;
        }
        if (charSequence.length() <= 0) {
            return null;
        }
        return PackageParser.buildCompoundName(string2, charSequence, "taskAffinity", stringArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean copyNeeded(int n, Package package_, Bundle bundle) {
        boolean bl;
        if (package_.mSetEnabled != 0 && package_.applicationInfo.enabled != (bl = package_.mSetEnabled == 1)) {
            return true;
        }
        if ((n & 0x80) != 0 && (bundle != null || package_.mAppMetaData != null)) {
            return true;
        }
        return (n & 0x400) != 0 && package_.usesLibraryFiles != null;
    }

    public static final ActivityInfo generateActivityInfo(Activity activity, int n) {
        if (activity == null) {
            return null;
        }
        if (!PackageParser.copyNeeded(n, activity.owner, activity.metaData)) {
            return activity.info;
        }
        ActivityInfo activityInfo = new ActivityInfo(activity.info);
        activityInfo.metaData = activity.metaData;
        activityInfo.applicationInfo = PackageParser.generateApplicationInfo(activity.owner, n);
        return activityInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ApplicationInfo generateApplicationInfo(Package package_, int n) {
        if (package_ == null) {
            return null;
        }
        if (!PackageParser.copyNeeded(n, package_, null)) {
            if (sCompatibilityModeEnabled) return package_.applicationInfo;
            package_.applicationInfo.disableCompatibilityMode();
            return package_.applicationInfo;
        }
        ApplicationInfo applicationInfo = new ApplicationInfo(package_.applicationInfo);
        if ((n & 0x80) != 0) {
            applicationInfo.metaData = package_.mAppMetaData;
        }
        if ((n & 0x400) != 0) {
            applicationInfo.sharedLibraryFiles = package_.usesLibraryFiles;
        }
        if (!sCompatibilityModeEnabled) {
            applicationInfo.disableCompatibilityMode();
        }
        if (package_.mSetEnabled == 1) {
            applicationInfo.enabled = true;
            return applicationInfo;
        }
        if (package_.mSetEnabled != 2) return applicationInfo;
        applicationInfo.enabled = false;
        return applicationInfo;
    }

    public static final InstrumentationInfo generateInstrumentationInfo(Instrumentation instrumentation, int n) {
        if (instrumentation == null) {
            return null;
        }
        if ((n & 0x80) == 0) {
            return instrumentation.info;
        }
        InstrumentationInfo instrumentationInfo = new InstrumentationInfo(instrumentation.info);
        instrumentationInfo.metaData = instrumentation.metaData;
        return instrumentationInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static PackageInfo generatePackageInfo(Package package_, int[] nArray, int n, long l, long l2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        PackageInfo packageInfo = new PackageInfo();
        packageInfo.packageName = package_.packageName;
        packageInfo.versionCode = package_.mVersionCode;
        packageInfo.versionName = package_.mVersionName;
        packageInfo.sharedUserId = package_.mSharedUserId;
        packageInfo.sharedUserLabel = package_.mSharedUserLabel;
        packageInfo.applicationInfo = PackageParser.generateApplicationInfo(package_, n);
        packageInfo.installLocation = package_.installLocation;
        packageInfo.firstInstallTime = l;
        packageInfo.lastUpdateTime = l2;
        if ((n & 0x100) != 0) {
            packageInfo.gids = nArray;
        }
        if ((n & 0x4000) != 0) {
            int n8;
            int n9 = package_.configPreferences.size();
            if (n9 > 0) {
                packageInfo.configPreferences = new ConfigurationInfo[n9];
                package_.configPreferences.toArray(packageInfo.configPreferences);
            }
            if ((n8 = package_.reqFeatures != null ? package_.reqFeatures.size() : 0) > 0) {
                packageInfo.reqFeatures = new FeatureInfo[n8];
                package_.reqFeatures.toArray(packageInfo.reqFeatures);
            }
        }
        if ((n & 1) != 0 && (n7 = package_.activities.size()) > 0) {
            if ((n & 0x200) != 0) {
                packageInfo.activities = new ActivityInfo[n7];
            } else {
                int n10 = 0;
                for (int i = 0; i < n7; ++i) {
                    if (!package_.activities.get((int)i).info.enabled) continue;
                    ++n10;
                }
                packageInfo.activities = new ActivityInfo[n10];
            }
            int n11 = 0;
            for (int i = 0; i < n7; ++i) {
                if (!package_.activities.get((int)i).info.enabled && (n & 0x200) == 0) continue;
                ActivityInfo[] activityInfoArray = packageInfo.activities;
                int n12 = n11 + 1;
                activityInfoArray[n11] = PackageParser.generateActivityInfo(package_.activities.get(i), n);
                n11 = n12;
            }
        }
        if ((n & 2) != 0 && (n6 = package_.receivers.size()) > 0) {
            if ((n & 0x200) != 0) {
                packageInfo.receivers = new ActivityInfo[n6];
            } else {
                int n13 = 0;
                for (int i = 0; i < n6; ++i) {
                    if (!package_.receivers.get((int)i).info.enabled) continue;
                    ++n13;
                }
                packageInfo.receivers = new ActivityInfo[n13];
            }
            int n14 = 0;
            for (int i = 0; i < n6; ++i) {
                if (!package_.receivers.get((int)i).info.enabled && (n & 0x200) == 0) continue;
                ActivityInfo[] activityInfoArray = packageInfo.receivers;
                int n15 = n14 + 1;
                activityInfoArray[n14] = PackageParser.generateActivityInfo(package_.receivers.get(i), n);
                n14 = n15;
            }
        }
        if ((n & 4) != 0 && (n5 = package_.services.size()) > 0) {
            if ((n & 0x200) != 0) {
                packageInfo.services = new ServiceInfo[n5];
            } else {
                int n16 = 0;
                for (int i = 0; i < n5; ++i) {
                    if (!package_.services.get((int)i).info.enabled) continue;
                    ++n16;
                }
                packageInfo.services = new ServiceInfo[n16];
            }
            int n17 = 0;
            for (int i = 0; i < n5; ++i) {
                int n18;
                if (package_.services.get((int)i).info.enabled || (n & 0x200) != 0) {
                    ServiceInfo[] serviceInfoArray = packageInfo.services;
                    n18 = n17 + 1;
                    serviceInfoArray[n17] = PackageParser.generateServiceInfo(package_.services.get(i), n);
                } else {
                    n18 = n17;
                }
                n17 = n18;
            }
        }
        if ((n & 8) != 0 && (n4 = package_.providers.size()) > 0) {
            if ((n & 0x200) != 0) {
                packageInfo.providers = new ProviderInfo[n4];
            } else {
                int n19 = 0;
                for (int i = 0; i < n4; ++i) {
                    if (!package_.providers.get((int)i).info.enabled) continue;
                    ++n19;
                }
                packageInfo.providers = new ProviderInfo[n19];
            }
            int n20 = 0;
            for (int i = 0; i < n4; ++i) {
                int n21;
                if (package_.providers.get((int)i).info.enabled || (n & 0x200) != 0) {
                    ProviderInfo[] providerInfoArray = packageInfo.providers;
                    n21 = n20 + 1;
                    providerInfoArray[n20] = PackageParser.generateProviderInfo(package_.providers.get(i), n);
                } else {
                    n21 = n20;
                }
                n20 = n21;
            }
        }
        if ((n & 0x10) != 0 && (n3 = package_.instrumentation.size()) > 0) {
            packageInfo.instrumentation = new InstrumentationInfo[n3];
            for (int i = 0; i < n3; ++i) {
                packageInfo.instrumentation[i] = PackageParser.generateInstrumentationInfo(package_.instrumentation.get(i), n);
            }
        }
        if ((n & 0x1000) != 0) {
            int n22;
            int n23 = package_.permissions.size();
            if (n23 > 0) {
                packageInfo.permissions = new PermissionInfo[n23];
                for (int i = 0; i < n23; ++i) {
                    packageInfo.permissions[i] = PackageParser.generatePermissionInfo(package_.permissions.get(i), n);
                }
            }
            if ((n22 = package_.requestedPermissions.size()) > 0) {
                packageInfo.requestedPermissions = new String[n22];
                for (int i = 0; i < n22; ++i) {
                    packageInfo.requestedPermissions[i] = package_.requestedPermissions.get(i);
                }
            }
        }
        if ((n & 0x40) != 0 && (n2 = package_.mSignatures != null ? package_.mSignatures.length : 0) > 0) {
            packageInfo.signatures = new Signature[n2];
            System.arraycopy(package_.mSignatures, 0, packageInfo.signatures, 0, n2);
        }
        return packageInfo;
    }

    public static final PermissionGroupInfo generatePermissionGroupInfo(PermissionGroup permissionGroup, int n) {
        if (permissionGroup == null) {
            return null;
        }
        if ((n & 0x80) == 0) {
            return permissionGroup.info;
        }
        PermissionGroupInfo permissionGroupInfo = new PermissionGroupInfo(permissionGroup.info);
        permissionGroupInfo.metaData = permissionGroup.metaData;
        return permissionGroupInfo;
    }

    public static final PermissionInfo generatePermissionInfo(Permission permission2, int n) {
        if (permission2 == null) {
            return null;
        }
        if ((n & 0x80) == 0) {
            return permission2.info;
        }
        PermissionInfo permissionInfo = new PermissionInfo(permission2.info);
        permissionInfo.metaData = permission2.metaData;
        return permissionInfo;
    }

    public static final ProviderInfo generateProviderInfo(Provider provider, int n) {
        if (provider == null) {
            return null;
        }
        if (!(PackageParser.copyNeeded(n, provider.owner, provider.metaData) || (n & 0x800) == 0 && provider.info.uriPermissionPatterns != null)) {
            return provider.info;
        }
        ProviderInfo providerInfo = new ProviderInfo(provider.info);
        providerInfo.metaData = provider.metaData;
        if ((n & 0x800) == 0) {
            providerInfo.uriPermissionPatterns = null;
        }
        providerInfo.applicationInfo = PackageParser.generateApplicationInfo(provider.owner, n);
        return providerInfo;
    }

    public static final ServiceInfo generateServiceInfo(Service service, int n) {
        if (service == null) {
            return null;
        }
        if (!PackageParser.copyNeeded(n, service.owner, service.metaData)) {
            return service.info;
        }
        ServiceInfo serviceInfo = new ServiceInfo(service.info);
        serviceInfo.metaData = service.metaData;
        serviceInfo.applicationInfo = PackageParser.generateApplicationInfo(service.owner, n);
        return serviceInfo;
    }

    private static final boolean isPackageFilename(String string2) {
        return string2.endsWith(".apk");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Certificate[] loadCertificates(JarFile jarFile, JarEntry jarEntry, byte[] byArray) {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(jarFile.getInputStream(jarEntry));
        while (((InputStream)bufferedInputStream).read(byArray, 0, byArray.length) != -1) {
        }
        ((InputStream)bufferedInputStream).close();
        if (jarEntry == null) return null;
        try {
            return jarEntry.getCertificates();
        }
        catch (IOException iOException) {
            Log.w(TAG, "Exception reading " + jarEntry.getName() + " in " + jarFile.getName(), iOException);
            return null;
        }
        catch (RuntimeException runtimeException) {
            Log.w(TAG, "Exception reading " + jarEntry.getName() + " in " + jarFile.getName(), runtimeException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Activity parseActivity(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray, boolean bl) throws XmlPullParserException, IOException {
        int n2;
        boolean bl2;
        TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestActivity);
        if (this.mParseActivityArgs == null) {
            this.mParseActivityArgs = new ParseComponentArgs(package_, stringArray, 3, 1, 2, 0, this.mSeparateProcesses, 7, 17, 5);
        }
        ParseComponentArgs parseComponentArgs = this.mParseActivityArgs;
        String string2 = bl ? "<receiver>" : "<activity>";
        parseComponentArgs.tag = string2;
        this.mParseActivityArgs.sa = typedArray;
        this.mParseActivityArgs.flags = n;
        Activity activity = new Activity(this.mParseActivityArgs, new ActivityInfo());
        if (stringArray[0] != null) {
            typedArray.recycle();
            return null;
        }
        boolean bl3 = typedArray.hasValue(6);
        if (bl3) {
            activity.info.exported = typedArray.getBoolean(6, false);
        }
        activity.info.theme = typedArray.getResourceId(0, 0);
        String string3 = typedArray.getNonConfigurationString(4, 0);
        if (string3 == null) {
            activity.info.permission = package_.applicationInfo.permission;
        } else {
            ActivityInfo activityInfo = activity.info;
            String string4 = string3.length() > 0 ? string3.toString().intern() : null;
            activityInfo.permission = string4;
        }
        String string5 = typedArray.getNonConfigurationString(8, 0);
        activity.info.taskAffinity = PackageParser.buildTaskAffinityName(package_.applicationInfo.packageName, package_.applicationInfo.taskAffinity, string5, stringArray);
        activity.info.flags = 0;
        if (typedArray.getBoolean(9, false)) {
            ActivityInfo activityInfo = activity.info;
            activityInfo.flags = 1 | activityInfo.flags;
        }
        if (typedArray.getBoolean(10, false)) {
            ActivityInfo activityInfo = activity.info;
            activityInfo.flags = 2 | activityInfo.flags;
        }
        if (typedArray.getBoolean(11, false)) {
            ActivityInfo activityInfo = activity.info;
            activityInfo.flags = 4 | activityInfo.flags;
        }
        if (typedArray.getBoolean(21, false)) {
            ActivityInfo activityInfo = activity.info;
            activityInfo.flags = 0x80 | activityInfo.flags;
        }
        if (typedArray.getBoolean(18, false)) {
            ActivityInfo activityInfo = activity.info;
            activityInfo.flags = 8 | activityInfo.flags;
        }
        if (typedArray.getBoolean(12, false)) {
            ActivityInfo activityInfo = activity.info;
            activityInfo.flags = 0x10 | activityInfo.flags;
        }
        if (typedArray.getBoolean(13, false)) {
            ActivityInfo activityInfo = activity.info;
            activityInfo.flags = 0x20 | activityInfo.flags;
        }
        if (typedArray.getBoolean(19, bl2 = (0x20 & package_.applicationInfo.flags) != 0)) {
            ActivityInfo activityInfo = activity.info;
            activityInfo.flags = 0x40 | activityInfo.flags;
        }
        if (typedArray.getBoolean(22, false)) {
            ActivityInfo activityInfo = activity.info;
            activityInfo.flags = 0x100 | activityInfo.flags;
        }
        if (!bl) {
            activity.info.launchMode = typedArray.getInt(14, 0);
            activity.info.screenOrientation = typedArray.getInt(15, -1);
            activity.info.configChanges = typedArray.getInt(16, 0);
            activity.info.softInputMode = typedArray.getInt(20, 0);
        } else {
            activity.info.launchMode = 0;
            activity.info.configChanges = 0;
        }
        typedArray.recycle();
        if (bl && (0x8000000 & package_.applicationInfo.flags) != 0 && activity.info.processName == package_.packageName) {
            stringArray[0] = "Heavy-weight applications can not have receivers in main process";
        }
        if (stringArray[0] != null) {
            return null;
        }
        int n3 = xmlPullParser.getDepth();
        while ((n2 = xmlPullParser.next()) != 1 && (n2 != 3 || xmlPullParser.getDepth() > n3)) {
            if (n2 == 3 || n2 == 4) continue;
            if (xmlPullParser.getName().equals("intent-filter")) {
                ActivityIntentInfo activityIntentInfo = new ActivityIntentInfo(activity);
                boolean bl4 = !bl;
                if (!this.parseIntent(resources, xmlPullParser, attributeSet, n, activityIntentInfo, stringArray, bl4)) {
                    return null;
                }
                if (activityIntentInfo.countActions() == 0) {
                    Log.w(TAG, "No actions in intent filter at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
                    continue;
                }
                activity.intents.add(activityIntentInfo);
                continue;
            }
            if (xmlPullParser.getName().equals("meta-data")) {
                Bundle bundle;
                activity.metaData = bundle = this.parseMetaData(resources, xmlPullParser, attributeSet, activity.metaData, stringArray);
                if (bundle != null) continue;
                return null;
            }
            Log.w(TAG, "Problem in package " + this.mArchiveSourcePath + ":");
            if (bl) {
                Log.w(TAG, "Unknown element under <receiver>: " + xmlPullParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
            } else {
                Log.w(TAG, "Unknown element under <activity>: " + xmlPullParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
            }
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
        if (!bl3) {
            ActivityInfo activityInfo = activity.info;
            boolean bl5 = activity.intents.size() > 0;
            activityInfo.exported = bl5;
        }
        return activity;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Activity parseActivityAlias(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray) throws XmlPullParserException, IOException {
        int n2;
        String string2;
        Activity activity;
        String string3;
        TypedArray typedArray;
        block16: {
            Activity activity2;
            typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestActivityAlias);
            String string4 = typedArray.getNonConfigurationString(7, 0);
            if (string4 == null) {
                stringArray[0] = "<activity-alias> does not specify android:targetActivity";
                typedArray.recycle();
                return null;
            }
            string3 = PackageParser.buildClassName(package_.applicationInfo.packageName, string4, stringArray);
            if (string3 == null) {
                typedArray.recycle();
                return null;
            }
            if (this.mParseActivityAliasArgs == null) {
                this.mParseActivityAliasArgs = new ParseComponentArgs(package_, stringArray, 2, 0, 1, 0, this.mSeparateProcesses, 0, 6, 4);
                this.mParseActivityAliasArgs.tag = "<activity-alias>";
            }
            this.mParseActivityAliasArgs.sa = typedArray;
            this.mParseActivityAliasArgs.flags = n;
            int n3 = package_.activities.size();
            int n4 = 0;
            do {
                int n5 = ++n4;
                activity = null;
                if (n5 >= n3) break block16;
                activity2 = package_.activities.get(n4);
            } while (!string3.equals(activity2.info.name));
            activity = activity2;
        }
        if (activity == null) {
            stringArray[0] = "<activity-alias> target activity " + string3 + " not found in manifest";
            typedArray.recycle();
            return null;
        }
        ActivityInfo activityInfo = new ActivityInfo();
        activityInfo.targetActivity = string3;
        activityInfo.configChanges = activity.info.configChanges;
        activityInfo.flags = activity.info.flags;
        activityInfo.icon = activity.info.icon;
        activityInfo.logo = activity.info.logo;
        activityInfo.labelRes = activity.info.labelRes;
        activityInfo.nonLocalizedLabel = activity.info.nonLocalizedLabel;
        activityInfo.launchMode = activity.info.launchMode;
        activityInfo.processName = activity.info.processName;
        if (activityInfo.descriptionRes == 0) {
            activityInfo.descriptionRes = activity.info.descriptionRes;
        }
        activityInfo.screenOrientation = activity.info.screenOrientation;
        activityInfo.taskAffinity = activity.info.taskAffinity;
        activityInfo.theme = activity.info.theme;
        Activity activity3 = new Activity(this.mParseActivityAliasArgs, activityInfo);
        if (stringArray[0] != null) {
            typedArray.recycle();
            return null;
        }
        boolean bl = typedArray.hasValue(5);
        if (bl) {
            activity3.info.exported = typedArray.getBoolean(5, false);
        }
        if ((string2 = typedArray.getNonConfigurationString(3, 0)) != null) {
            ActivityInfo activityInfo2 = activity3.info;
            String string5 = string2.length() > 0 ? string2.toString().intern() : null;
            activityInfo2.permission = string5;
        }
        typedArray.recycle();
        if (stringArray[0] != null) {
            return null;
        }
        int n6 = xmlPullParser.getDepth();
        while ((n2 = xmlPullParser.next()) != 1 && (n2 != 3 || xmlPullParser.getDepth() > n6)) {
            if (n2 == 3 || n2 == 4) continue;
            if (xmlPullParser.getName().equals("intent-filter")) {
                ActivityIntentInfo activityIntentInfo = new ActivityIntentInfo(activity3);
                if (!this.parseIntent(resources, xmlPullParser, attributeSet, n, activityIntentInfo, stringArray, true)) {
                    return null;
                }
                if (activityIntentInfo.countActions() == 0) {
                    Log.w(TAG, "No actions in intent filter at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
                    continue;
                }
                activity3.intents.add(activityIntentInfo);
                continue;
            }
            if (xmlPullParser.getName().equals("meta-data")) {
                Bundle bundle;
                activity3.metaData = bundle = this.parseMetaData(resources, xmlPullParser, attributeSet, activity3.metaData, stringArray);
                if (bundle != null) continue;
                return null;
            }
            Log.w(TAG, "Unknown element under <activity-alias>: " + xmlPullParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
        if (!bl) {
            ActivityInfo activityInfo3 = activity3.info;
            boolean bl2 = activity3.intents.size() > 0;
            activityInfo3.exported = bl2;
        }
        return activity3;
    }

    private boolean parseAllMetaData(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String string2, Component component, String[] stringArray) throws XmlPullParserException, IOException {
        int n;
        int n2 = xmlPullParser.getDepth();
        while ((n = xmlPullParser.next()) != 1 && (n != 3 || xmlPullParser.getDepth() > n2)) {
            if (n == 3 || n == 4) continue;
            if (xmlPullParser.getName().equals("meta-data")) {
                Bundle bundle;
                component.metaData = bundle = this.parseMetaData(resources, xmlPullParser, attributeSet, component.metaData, stringArray);
                if (bundle != null) continue;
                return false;
            }
            Log.w(TAG, "Unknown element under " + string2 + ": " + xmlPullParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseApplication(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray) throws XmlPullParserException, IOException {
        int n2;
        String string2;
        TypedValue typedValue;
        String string3;
        ApplicationInfo applicationInfo = package_.applicationInfo;
        String string4 = package_.applicationInfo.packageName;
        TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestApplication);
        String string5 = typedArray.getNonConfigurationString(3, 0);
        if (string5 != null) {
            applicationInfo.className = PackageParser.buildClassName(string4, string5, stringArray);
            if (applicationInfo.className == null) {
                typedArray.recycle();
                this.mParseError = -108;
                return false;
            }
        }
        if ((string3 = typedArray.getNonConfigurationString(4, 0)) != null) {
            applicationInfo.manageSpaceActivityName = PackageParser.buildClassName(string4, string3, stringArray);
        }
        if (typedArray.getBoolean(17, true)) {
            applicationInfo.flags = 0x8000 | applicationInfo.flags;
            String string6 = typedArray.getNonConfigurationString(16, 0);
            if (string6 != null) {
                applicationInfo.backupAgentName = PackageParser.buildClassName(string4, string6, stringArray);
                if (typedArray.getBoolean(18, true)) {
                    applicationInfo.flags = 0x10000 | applicationInfo.flags;
                }
                if (typedArray.getBoolean(21, false)) {
                    applicationInfo.flags = 0x20000 | applicationInfo.flags;
                }
            }
        }
        if ((typedValue = typedArray.peekValue(1)) != null) {
            int n3;
            applicationInfo.labelRes = n3 = typedValue.resourceId;
            if (n3 == 0) {
                applicationInfo.nonLocalizedLabel = typedValue.coerceToString();
            }
        }
        applicationInfo.icon = typedArray.getResourceId(2, 0);
        applicationInfo.theme = typedArray.getResourceId(0, 0);
        applicationInfo.descriptionRes = typedArray.getResourceId(13, 0);
        if ((n & 1) != 0 && typedArray.getBoolean(8, false)) {
            applicationInfo.flags = 8 | applicationInfo.flags;
        }
        if ((n & 0x10) != 0) {
            applicationInfo.flags = 0x20000000 | applicationInfo.flags;
        }
        if ((n & 0x20) != 0) {
            applicationInfo.flags = 0x40000 | applicationInfo.flags;
        }
        if (typedArray.getBoolean(10, false)) {
            applicationInfo.flags = 2 | applicationInfo.flags;
        }
        if (typedArray.getBoolean(20, false)) {
            applicationInfo.flags = 0x4000 | applicationInfo.flags;
        }
        if (typedArray.getBoolean(7, true)) {
            applicationInfo.flags = 4 | applicationInfo.flags;
        }
        if (typedArray.getBoolean(14, false)) {
            applicationInfo.flags = 0x20 | applicationInfo.flags;
        }
        if (typedArray.getBoolean(5, true)) {
            applicationInfo.flags = 0x40 | applicationInfo.flags;
        }
        if (typedArray.getBoolean(15, false)) {
            applicationInfo.flags = 0x100 | applicationInfo.flags;
        }
        if (typedArray.getBoolean(22, false)) {
            applicationInfo.flags = 0x40000000 | applicationInfo.flags;
        }
        String string7 = (string2 = typedArray.getNonConfigurationString(6, 0)) != null && string2.length() > 0 ? string2.intern() : null;
        applicationInfo.permission = string7;
        String string8 = package_.applicationInfo.targetSdkVersion >= 8 ? typedArray.getNonConfigurationString(12, 0) : typedArray.getNonResourceString(12);
        applicationInfo.taskAffinity = PackageParser.buildTaskAffinityName(applicationInfo.packageName, applicationInfo.packageName, string8, stringArray);
        if (stringArray[0] == null) {
            String string9 = package_.applicationInfo.targetSdkVersion >= 8 ? typedArray.getNonConfigurationString(11, 0) : typedArray.getNonResourceString(11);
            applicationInfo.processName = PackageParser.buildProcessName(applicationInfo.packageName, null, string9, n, this.mSeparateProcesses, stringArray);
            applicationInfo.enabled = typedArray.getBoolean(9, true);
        }
        typedArray.recycle();
        if (stringArray[0] != null) {
            this.mParseError = -108;
            return false;
        }
        int n4 = xmlPullParser.getDepth();
        while ((n2 = xmlPullParser.next()) != 1 && (n2 != 3 || xmlPullParser.getDepth() > n4)) {
            if (n2 == 3 || n2 == 4) continue;
            String string10 = xmlPullParser.getName();
            if (string10.equals("activity")) {
                Activity activity = this.parseActivity(package_, resources, xmlPullParser, attributeSet, n, stringArray, false);
                if (activity == null) {
                    this.mParseError = -108;
                    return false;
                }
                package_.activities.add(activity);
                continue;
            }
            if (string10.equals("receiver")) {
                Activity activity = this.parseActivity(package_, resources, xmlPullParser, attributeSet, n, stringArray, true);
                if (activity == null) {
                    this.mParseError = -108;
                    return false;
                }
                package_.receivers.add(activity);
                continue;
            }
            if (string10.equals("service")) {
                Service service = this.parseService(package_, resources, xmlPullParser, attributeSet, n, stringArray);
                if (service == null) {
                    this.mParseError = -108;
                    return false;
                }
                package_.services.add(service);
                continue;
            }
            if (string10.equals("provider")) {
                Provider provider = this.parseProvider(package_, resources, xmlPullParser, attributeSet, n, stringArray);
                if (provider == null) {
                    this.mParseError = -108;
                    return false;
                }
                package_.providers.add(provider);
                continue;
            }
            if (string10.equals("activity-alias")) {
                Activity activity = this.parseActivityAlias(package_, resources, xmlPullParser, attributeSet, n, stringArray);
                if (activity == null) {
                    this.mParseError = -108;
                    return false;
                }
                package_.activities.add(activity);
                continue;
            }
            if (xmlPullParser.getName().equals("meta-data")) {
                Bundle bundle;
                package_.mAppMetaData = bundle = this.parseMetaData(resources, xmlPullParser, attributeSet, package_.mAppMetaData, stringArray);
                if (bundle != null) continue;
                this.mParseError = -108;
                return false;
            }
            if (string10.equals("uses-library")) {
                TypedArray typedArray2 = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestUsesLibrary);
                String string11 = typedArray2.getNonResourceString(0);
                boolean bl = typedArray2.getBoolean(1, true);
                typedArray2.recycle();
                if (string11 != null) {
                    if (bl) {
                        if (package_.usesLibraries == null) {
                            package_.usesLibraries = new ArrayList();
                        }
                        if (!package_.usesLibraries.contains(string11)) {
                            package_.usesLibraries.add(string11.intern());
                        }
                    } else {
                        if (package_.usesOptionalLibraries == null) {
                            package_.usesOptionalLibraries = new ArrayList();
                        }
                        if (!package_.usesOptionalLibraries.contains(string11)) {
                            package_.usesOptionalLibraries.add(string11.intern());
                        }
                    }
                }
                XmlUtils.skipCurrentTag(xmlPullParser);
                continue;
            }
            if (string10.equals("uses-package")) {
                XmlUtils.skipCurrentTag(xmlPullParser);
                continue;
            }
            Log.w(TAG, "Unknown element under <application>: " + string10 + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Instrumentation parseInstrumentation(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String[] stringArray) throws XmlPullParserException, IOException {
        TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestInstrumentation);
        if (this.mParseInstrumentationArgs == null) {
            this.mParseInstrumentationArgs = new ParsePackageItemArgs(package_, stringArray, 2, 0, 1, 0);
            this.mParseInstrumentationArgs.tag = "<instrumentation>";
        }
        this.mParseInstrumentationArgs.sa = typedArray;
        Instrumentation instrumentation = new Instrumentation(this.mParseInstrumentationArgs, new InstrumentationInfo());
        if (stringArray[0] != null) {
            typedArray.recycle();
            this.mParseError = -108;
            return null;
        }
        String string2 = typedArray.getNonResourceString(3);
        InstrumentationInfo instrumentationInfo = instrumentation.info;
        String string3 = string2 != null ? string2.intern() : null;
        instrumentationInfo.targetPackage = string3;
        instrumentation.info.handleProfiling = typedArray.getBoolean(4, false);
        instrumentation.info.functionalTest = typedArray.getBoolean(5, false);
        typedArray.recycle();
        if (instrumentation.info.targetPackage == null) {
            stringArray[0] = "<instrumentation> does not specify targetPackage";
            this.mParseError = -108;
            return null;
        }
        if (!this.parseAllMetaData(resources, xmlPullParser, attributeSet, "<instrumentation>", instrumentation, stringArray)) {
            this.mParseError = -108;
            return null;
        }
        package_.instrumentation.add(instrumentation);
        return instrumentation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parseIntent(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, IntentInfo intentInfo, String[] stringArray, boolean bl) throws XmlPullParserException, IOException {
        int n2;
        TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestIntentFilter);
        intentInfo.setPriority(typedArray.getInt(2, 0));
        TypedValue typedValue = typedArray.peekValue(0);
        if (typedValue != null) {
            int n3;
            intentInfo.labelRes = n3 = typedValue.resourceId;
            if (n3 == 0) {
                intentInfo.nonLocalizedLabel = typedValue.coerceToString();
            }
        }
        intentInfo.icon = typedArray.getResourceId(1, 0);
        typedArray.recycle();
        int n4 = xmlPullParser.getDepth();
        while ((n2 = xmlPullParser.next()) != 1 && (n2 != 3 || xmlPullParser.getDepth() > n4)) {
            if (n2 == 3 || n2 == 4) continue;
            String string2 = xmlPullParser.getName();
            if (string2.equals("action")) {
                String string3 = attributeSet.getAttributeValue(ANDROID_RESOURCES, "name");
                if (string3 == null || string3 == "") {
                    stringArray[0] = "No value supplied for <android:name>";
                    return false;
                }
                XmlUtils.skipCurrentTag(xmlPullParser);
                intentInfo.addAction(string3);
                continue;
            }
            if (string2.equals("category")) {
                String string4 = attributeSet.getAttributeValue(ANDROID_RESOURCES, "name");
                if (string4 == null || string4 == "") {
                    stringArray[0] = "No value supplied for <android:name>";
                    return false;
                }
                XmlUtils.skipCurrentTag(xmlPullParser);
                intentInfo.addCategory(string4);
                continue;
            }
            if (string2.equals("data")) {
                String string5;
                String string6;
                String string7;
                String string8;
                TypedArray typedArray2 = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestData);
                String string9 = typedArray2.getNonConfigurationString(0, 0);
                if (string9 != null) {
                    try {
                        intentInfo.addDataType(string9);
                    }
                    catch (IntentFilter.MalformedMimeTypeException malformedMimeTypeException) {
                        stringArray[0] = malformedMimeTypeException.toString();
                        typedArray2.recycle();
                        return false;
                    }
                }
                if ((string8 = typedArray2.getNonConfigurationString(1, 0)) != null) {
                    intentInfo.addDataScheme(string8);
                }
                String string10 = typedArray2.getNonConfigurationString(2, 0);
                String string11 = typedArray2.getNonConfigurationString(3, 0);
                if (string10 != null) {
                    intentInfo.addDataAuthority(string10, string11);
                }
                if ((string7 = typedArray2.getNonConfigurationString(4, 0)) != null) {
                    intentInfo.addDataPath(string7, 0);
                }
                if ((string6 = typedArray2.getNonConfigurationString(5, 0)) != null) {
                    intentInfo.addDataPath(string6, 1);
                }
                if ((string5 = typedArray2.getNonConfigurationString(6, 0)) != null) {
                    intentInfo.addDataPath(string5, 2);
                }
                typedArray2.recycle();
                XmlUtils.skipCurrentTag(xmlPullParser);
                continue;
            }
            Log.w(TAG, "Unknown element under <intent-filter>: " + xmlPullParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
        intentInfo.hasDefault = intentInfo.hasCategory("android.intent.category.DEFAULT");
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Bundle parseMetaData(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Bundle bundle, String[] stringArray) throws XmlPullParserException, IOException {
        TypedArray typedArray;
        block6: {
            block8: {
                TypedValue typedValue;
                String string2;
                block10: {
                    block9: {
                        block7: {
                            String string3;
                            typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestMetaData);
                            if (bundle == null) {
                                bundle = new Bundle();
                            }
                            if ((string3 = typedArray.getNonConfigurationString(0, 0)) == null) {
                                stringArray[0] = "<meta-data> requires an android:name attribute";
                                typedArray.recycle();
                                return null;
                            }
                            string2 = string3.intern();
                            TypedValue typedValue2 = typedArray.peekValue(2);
                            if (typedValue2 == null || typedValue2.resourceId == 0) break block7;
                            bundle.putInt(string2, typedValue2.resourceId);
                            break block6;
                        }
                        typedValue = typedArray.peekValue(1);
                        if (typedValue == null) break block8;
                        if (typedValue.type != 3) break block9;
                        CharSequence charSequence = typedValue.coerceToString();
                        String string4 = charSequence != null ? ((Object)charSequence).toString().intern() : null;
                        bundle.putString(string2, string4);
                        break block6;
                    }
                    if (typedValue.type != 18) break block10;
                    boolean bl = typedValue.data != 0;
                    bundle.putBoolean(string2, bl);
                    break block6;
                }
                if (typedValue.type >= 16 && typedValue.type <= 31) {
                    bundle.putInt(string2, typedValue.data);
                    break block6;
                } else if (typedValue.type == 4) {
                    bundle.putFloat(string2, typedValue.getFloat());
                    break block6;
                } else {
                    Log.w(TAG, "<meta-data> only supports string, integer, float, color, boolean, and resource reference types: " + xmlPullParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
                }
                break block6;
            }
            stringArray[0] = "<meta-data> requires an android:value or android:resource attribute";
            bundle = null;
        }
        typedArray.recycle();
        XmlUtils.skipCurrentTag(xmlPullParser);
        return bundle;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Package parsePackage(Resources resources, XmlResourceParser xmlResourceParser, int n, String[] stringArray) throws XmlPullParserException, IOException {
        int n2;
        String string2;
        this.mParseInstrumentationArgs = null;
        this.mParseActivityArgs = null;
        this.mParseServiceArgs = null;
        this.mParseProviderArgs = null;
        String string3 = PackageParser.parsePackageName(xmlResourceParser, xmlResourceParser, n, stringArray);
        if (string3 == null) {
            this.mParseError = -106;
            return null;
        }
        Package package_ = new Package(string3);
        boolean bl = false;
        TypedArray typedArray = resources.obtainAttributes(xmlResourceParser, R.styleable.AndroidManifest);
        package_.mVersionCode = typedArray.getInteger(1, 0);
        package_.mVersionName = typedArray.getNonConfigurationString(2, 0);
        if (package_.mVersionName != null) {
            package_.mVersionName = package_.mVersionName.intern();
        }
        if ((string2 = typedArray.getNonConfigurationString(0, 0)) != null && string2.length() > 0) {
            String string4 = PackageParser.validateName(string2, true);
            if (string4 != null && !"android".equals(string3)) {
                stringArray[0] = "<manifest> specifies bad sharedUserId name \"" + string2 + "\": " + string4;
                this.mParseError = -107;
                return null;
            }
            package_.mSharedUserId = string2.intern();
            package_.mSharedUserLabel = typedArray.getResourceId(3, 0);
        }
        typedArray.recycle();
        package_.applicationInfo.installLocation = package_.installLocation = typedArray.getInteger(4, -1);
        int n3 = 1;
        int n4 = 1;
        int n5 = 1;
        int n6 = 1;
        int n7 = 1;
        int n8 = 1;
        int n9 = xmlResourceParser.getDepth();
        while ((n2 = xmlResourceParser.next()) != 1 && (n2 != 3 || xmlResourceParser.getDepth() > n9)) {
            if (n2 == 3 || n2 == 4) continue;
            String string5 = xmlResourceParser.getName();
            if (string5.equals("application")) {
                if (bl) {
                    Log.w(TAG, "<manifest> has more than one <application>");
                    XmlUtils.skipCurrentTag(xmlResourceParser);
                    continue;
                }
                bl = true;
                if (this.parseApplication(package_, resources, xmlResourceParser, xmlResourceParser, n, stringArray)) continue;
                return null;
            }
            if (string5.equals("permission-group")) {
                if (this.parsePermissionGroup(package_, resources, xmlResourceParser, xmlResourceParser, stringArray) != null) continue;
                return null;
            }
            if (string5.equals("permission")) {
                if (this.parsePermission(package_, resources, xmlResourceParser, xmlResourceParser, stringArray) != null) continue;
                return null;
            }
            if (string5.equals("permission-tree")) {
                if (this.parsePermissionTree(package_, resources, xmlResourceParser, xmlResourceParser, stringArray) != null) continue;
                return null;
            }
            if (string5.equals("uses-permission")) {
                TypedArray typedArray2 = resources.obtainAttributes(xmlResourceParser, R.styleable.AndroidManifestUsesPermission);
                String string6 = typedArray2.getNonResourceString(0);
                typedArray2.recycle();
                if (string6 != null && !package_.requestedPermissions.contains(string6)) {
                    package_.requestedPermissions.add(string6.intern());
                }
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            if (string5.equals("uses-configuration")) {
                ConfigurationInfo configurationInfo = new ConfigurationInfo();
                TypedArray typedArray3 = resources.obtainAttributes(xmlResourceParser, R.styleable.AndroidManifestUsesConfiguration);
                configurationInfo.reqTouchScreen = typedArray3.getInt(0, 0);
                configurationInfo.reqKeyboardType = typedArray3.getInt(1, 0);
                if (typedArray3.getBoolean(2, false)) {
                    configurationInfo.reqInputFeatures = 1 | configurationInfo.reqInputFeatures;
                }
                configurationInfo.reqNavigation = typedArray3.getInt(3, 0);
                if (typedArray3.getBoolean(4, false)) {
                    configurationInfo.reqInputFeatures = 2 | configurationInfo.reqInputFeatures;
                }
                typedArray3.recycle();
                package_.configPreferences.add(configurationInfo);
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            if (string5.equals("uses-feature")) {
                FeatureInfo featureInfo = new FeatureInfo();
                TypedArray typedArray4 = resources.obtainAttributes(xmlResourceParser, R.styleable.AndroidManifestUsesFeature);
                featureInfo.name = typedArray4.getNonResourceString(0);
                if (featureInfo.name == null) {
                    featureInfo.reqGlEsVersion = typedArray4.getInt(1, 0);
                }
                if (typedArray4.getBoolean(2, true)) {
                    featureInfo.flags = 1 | featureInfo.flags;
                }
                typedArray4.recycle();
                if (package_.reqFeatures == null) {
                    package_.reqFeatures = new ArrayList();
                }
                package_.reqFeatures.add(featureInfo);
                if (featureInfo.name == null) {
                    ConfigurationInfo configurationInfo = new ConfigurationInfo();
                    configurationInfo.reqGlEsVersion = featureInfo.reqGlEsVersion;
                    package_.configPreferences.add(configurationInfo);
                }
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            if (string5.equals("uses-sdk")) {
                if (SDK_VERSION > 0) {
                    TypedValue typedValue;
                    TypedArray typedArray5 = resources.obtainAttributes(xmlResourceParser, R.styleable.AndroidManifestUsesSdk);
                    TypedValue typedValue2 = typedArray5.peekValue(0);
                    String string7 = null;
                    int n10 = 0;
                    String string8 = null;
                    int n11 = 0;
                    if (typedValue2 != null) {
                        if (typedValue2.type == 3 && typedValue2.string != null) {
                            string8 = string7 = ((Object)typedValue2.string).toString();
                        } else {
                            n11 = n10 = typedValue2.data;
                            string7 = null;
                            string8 = null;
                        }
                    }
                    if ((typedValue = typedArray5.peekValue(1)) != null) {
                        if (typedValue.type == 3 && typedValue.string != null) {
                            string8 = string7 = ((Object)typedValue.string).toString();
                        } else {
                            n11 = typedValue.data;
                        }
                    }
                    typedArray5.recycle();
                    if (string7 != null) {
                        String string9 = SDK_CODENAME;
                        if (!string7.equals(string9)) {
                            stringArray[0] = SDK_CODENAME != null ? "Requires development platform " + string7 + " (current platform is " + SDK_CODENAME + ")" : "Requires development platform " + string7 + " but this is a release platform.";
                            this.mParseError = -12;
                            return null;
                        }
                    } else {
                        int n12 = SDK_VERSION;
                        if (n10 > n12) {
                            stringArray[0] = "Requires newer sdk version #" + n10 + " (current version is #" + SDK_VERSION + ")";
                            this.mParseError = -12;
                            return null;
                        }
                    }
                    if (string8 != null) {
                        String string10 = SDK_CODENAME;
                        if (!string8.equals(string10)) {
                            stringArray[0] = SDK_CODENAME != null ? "Requires development platform " + string8 + " (current platform is " + SDK_CODENAME + ")" : "Requires development platform " + string8 + " but this is a release platform.";
                            this.mParseError = -12;
                            return null;
                        }
                        package_.applicationInfo.targetSdkVersion = 10000;
                    } else {
                        package_.applicationInfo.targetSdkVersion = n11;
                    }
                }
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            if (string5.equals("supports-screens")) {
                TypedArray typedArray6 = resources.obtainAttributes(xmlResourceParser, R.styleable.AndroidManifestSupportsScreens);
                n3 = typedArray6.getInteger(1, n3);
                n4 = typedArray6.getInteger(2, n4);
                n5 = typedArray6.getInteger(3, n5);
                n6 = typedArray6.getInteger(5, n6);
                n7 = typedArray6.getInteger(4, n7);
                n8 = typedArray6.getInteger(0, n8);
                typedArray6.recycle();
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            if (string5.equals("protected-broadcast")) {
                TypedArray typedArray7 = resources.obtainAttributes(xmlResourceParser, R.styleable.AndroidManifestProtectedBroadcast);
                String string11 = typedArray7.getNonResourceString(0);
                typedArray7.recycle();
                if (string11 != null && (n & 1) != 0) {
                    if (package_.protectedBroadcasts == null) {
                        package_.protectedBroadcasts = new ArrayList();
                    }
                    if (!package_.protectedBroadcasts.contains(string11)) {
                        package_.protectedBroadcasts.add(string11.intern());
                    }
                }
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            if (string5.equals("instrumentation")) {
                if (this.parseInstrumentation(package_, resources, xmlResourceParser, xmlResourceParser, stringArray) != null) continue;
                return null;
            }
            if (string5.equals("original-package")) {
                TypedArray typedArray8 = resources.obtainAttributes(xmlResourceParser, R.styleable.AndroidManifestOriginalPackage);
                String string12 = typedArray8.getNonConfigurationString(0, 0);
                if (!package_.packageName.equals(string12)) {
                    if (package_.mOriginalPackages == null) {
                        package_.mOriginalPackages = new ArrayList();
                        package_.mRealPackage = package_.packageName;
                    }
                    package_.mOriginalPackages.add(string12);
                }
                typedArray8.recycle();
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            if (string5.equals("adopt-permissions")) {
                TypedArray typedArray9 = resources.obtainAttributes(xmlResourceParser, R.styleable.AndroidManifestOriginalPackage);
                String string13 = typedArray9.getNonConfigurationString(0, 0);
                typedArray9.recycle();
                if (string13 != null) {
                    if (package_.mAdoptPermissions == null) {
                        package_.mAdoptPermissions = new ArrayList();
                    }
                    package_.mAdoptPermissions.add(string13);
                }
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            if (string5.equals("uses-gl-texture")) {
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            if (string5.equals("compatible-screens")) {
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            if (string5.equals("eat-comment")) {
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            Log.w(TAG, "Unknown element under <manifest>: " + xmlResourceParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlResourceParser.getPositionDescription());
            XmlUtils.skipCurrentTag(xmlResourceParser);
        }
        if (!bl && package_.instrumentation.size() == 0) {
            stringArray[0] = "<manifest> does not contain an <application> or <instrumentation>";
            this.mParseError = -109;
        }
        int n13 = NEW_PERMISSIONS.length;
        StringBuilder stringBuilder = null;
        int n14 = 0;
        while (true) {
            NewPermissionInfo newPermissionInfo;
            block67: {
                block66: {
                    if (n14 >= n13) break block66;
                    newPermissionInfo = NEW_PERMISSIONS[n14];
                    if (package_.applicationInfo.targetSdkVersion < newPermissionInfo.sdkVersion) break block67;
                }
                if (stringBuilder != null) {
                    Log.i(TAG, stringBuilder.toString());
                }
                if (n3 < 0 || n3 > 0 && package_.applicationInfo.targetSdkVersion >= 4) {
                    ApplicationInfo applicationInfo = package_.applicationInfo;
                    applicationInfo.flags = 0x200 | applicationInfo.flags;
                }
                if (n4 != 0) {
                    ApplicationInfo applicationInfo = package_.applicationInfo;
                    applicationInfo.flags = 0x400 | applicationInfo.flags;
                }
                if (n5 < 0 || n5 > 0 && package_.applicationInfo.targetSdkVersion >= 4) {
                    ApplicationInfo applicationInfo = package_.applicationInfo;
                    applicationInfo.flags = 0x800 | applicationInfo.flags;
                }
                if (n6 < 0 || n6 > 0 && package_.applicationInfo.targetSdkVersion >= 9) {
                    ApplicationInfo applicationInfo = package_.applicationInfo;
                    applicationInfo.flags = 0x80000 | applicationInfo.flags;
                }
                if (n7 < 0 || n7 > 0 && package_.applicationInfo.targetSdkVersion >= 4) {
                    ApplicationInfo applicationInfo = package_.applicationInfo;
                    applicationInfo.flags = 0x1000 | applicationInfo.flags;
                }
                if (n8 < 0 || n8 > 0 && package_.applicationInfo.targetSdkVersion >= 4) {
                    ApplicationInfo applicationInfo = package_.applicationInfo;
                    applicationInfo.flags = 0x2000 | applicationInfo.flags;
                }
                return package_;
            }
            if (!package_.requestedPermissions.contains(newPermissionInfo.name)) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(128);
                    String string14 = package_.packageName;
                    stringBuilder.append(string14);
                    stringBuilder.append(": compat added ");
                } else {
                    stringBuilder.append(' ');
                }
                String string15 = newPermissionInfo.name;
                stringBuilder.append(string15);
                package_.requestedPermissions.add(newPermissionInfo.name);
            }
            ++n14;
        }
    }

    private boolean parsePackageItemInfo(Package package_, PackageItemInfo packageItemInfo, String[] stringArray, String string2, TypedArray typedArray, int n, int n2, int n3, int n4) {
        TypedValue typedValue;
        String string3 = typedArray.getNonConfigurationString(n, 0);
        if (string3 == null) {
            stringArray[0] = string2 + " does not specify android:name";
            return false;
        }
        packageItemInfo.name = PackageParser.buildClassName(package_.applicationInfo.packageName, string3, stringArray);
        if (packageItemInfo.name == null) {
            return false;
        }
        int n5 = typedArray.getResourceId(n3, 0);
        if (n5 != 0) {
            packageItemInfo.icon = n5;
            packageItemInfo.nonLocalizedLabel = null;
        }
        if ((typedValue = typedArray.peekValue(n2)) != null) {
            int n6;
            packageItemInfo.labelRes = n6 = typedValue.resourceId;
            if (n6 == 0) {
                packageItemInfo.nonLocalizedLabel = typedValue.coerceToString();
            }
        }
        packageItemInfo.packageName = package_.packageName;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static PackageLite parsePackageLite(String var0, int var1_1) {
        block19: {
            var2_2 = null;
            var3_3 = new AssetManager();
            var7_4 = var3_3.openXmlResourceParser(var3_3.addAssetPath(var0), "AndroidManifest.xml");
            var8_5 = new String[1];
            try {
                var12_7 = var16_6 = PackageParser.parsePackageLite(var7_4, var7_4, var1_1, var8_5);
                if (var7_4 != null) {
                    var7_4.close();
                }
                if (var3_3 != null) {
                    var3_3.close();
                }
lbl13:
                // 7 sources

                ** while (var12_7 == null)
            }
            catch (IOException var14_10) {
                Log.w("PackageParser", var0, var14_10);
                if (var7_4 != null) {
                    var7_4.close();
                }
                var12_7 = null;
                if (var3_3 == null) ** GOTO lbl13
                var3_3.close();
                var12_7 = null;
                ** GOTO lbl13
            }
            catch (XmlPullParserException var10_11) {
                Log.w("PackageParser", var0, var10_11);
                if (var7_4 != null) {
                    var7_4.close();
                }
                var12_7 = null;
                if (var3_3 == null) ** GOTO lbl13
                var3_3.close();
                var12_7 = null;
                ** GOTO lbl13
                {
                    catch (Throwable var9_12) {
                        if (var7_4 != null) {
                            var7_4.close();
                        }
                        if (var3_3 != null) {
                            var3_3.close();
                        }
                        throw var9_12;
                    }
                }
            }
lbl-1000:
            // 1 sources

            {
                Log.e("PackageParser", "parsePackageLite error: " + var8_5[0]);
                return null;
lbl17:
                // 1 sources

                break block19;
            }
            catch (Exception var17_8) {
                var5_9 = var17_8;
lbl20:
                // 2 sources

                while (true) {
                    if (var2_2 != null) {
                        var2_2.close();
                    }
                    Log.w("PackageParser", "Unable to read AndroidManifest.xml of " + var0, var5_9);
                    return null;
                }
            }
        }
        return var12_7;
        catch (Exception var4_13) {
            var5_9 = var4_13;
            var2_2 = var3_3;
            ** continue;
        }
    }

    private static PackageLite parsePackageLite(XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray) throws IOException, XmlPullParserException {
        int n2;
        while ((n2 = xmlPullParser.next()) != 2 && n2 != 1) {
        }
        if (n2 != 2) {
            stringArray[0] = "No start tag found";
            return null;
        }
        if ((n & 2) != 0) {
            // empty if block
        }
        if (!xmlPullParser.getName().equals("manifest")) {
            stringArray[0] = "No <manifest> tag";
            return null;
        }
        String string2 = attributeSet.getAttributeValue(null, "package");
        if (string2 == null || string2.length() == 0) {
            stringArray[0] = "<manifest> does not specify package";
            return null;
        }
        String string3 = PackageParser.validateName(string2, true);
        if (string3 != null && !"android".equals(string2)) {
            stringArray[0] = "<manifest> specifies bad package name \"" + string2 + "\": " + string3;
            return null;
        }
        int n3 = -1;
        int n4 = 0;
        while (true) {
            block11: {
                block10: {
                    if (n4 >= attributeSet.getAttributeCount()) break block10;
                    if (!attributeSet.getAttributeName(n4).equals("installLocation")) break block11;
                    n3 = attributeSet.getAttributeIntValue(n4, -1);
                }
                return new PackageLite(string2.intern(), n3);
            }
            ++n4;
        }
    }

    private static String parsePackageName(XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray) throws IOException, XmlPullParserException {
        int n2;
        while ((n2 = xmlPullParser.next()) != 2 && n2 != 1) {
        }
        if (n2 != 2) {
            stringArray[0] = "No start tag found";
            return null;
        }
        if ((n & 2) != 0) {
            // empty if block
        }
        if (!xmlPullParser.getName().equals("manifest")) {
            stringArray[0] = "No <manifest> tag";
            return null;
        }
        String string2 = attributeSet.getAttributeValue(null, "package");
        if (string2 == null || string2.length() == 0) {
            stringArray[0] = "<manifest> does not specify package";
            return null;
        }
        String string3 = PackageParser.validateName(string2, true);
        if (string3 != null && !"android".equals(string2)) {
            stringArray[0] = "<manifest> specifies bad package name \"" + string2 + "\": " + string3;
            return null;
        }
        return string2.intern();
    }

    private Permission parsePermission(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String[] stringArray) throws XmlPullParserException, IOException {
        Permission permission2 = new Permission(package_);
        TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestPermission);
        if (!this.parsePackageItemInfo(package_, permission2.info, stringArray, "<permission>", typedArray, 2, 0, 1, 0)) {
            typedArray.recycle();
            this.mParseError = -108;
            return null;
        }
        permission2.info.group = typedArray.getNonResourceString(4);
        if (permission2.info.group != null) {
            permission2.info.group = permission2.info.group.intern();
        }
        permission2.info.descriptionRes = typedArray.getResourceId(5, 0);
        permission2.info.protectionLevel = typedArray.getInt(3, 0);
        typedArray.recycle();
        if (permission2.info.protectionLevel == -1) {
            stringArray[0] = "<permission> does not specify protectionLevel";
            this.mParseError = -108;
            return null;
        }
        if (!this.parseAllMetaData(resources, xmlPullParser, attributeSet, "<permission>", permission2, stringArray)) {
            this.mParseError = -108;
            return null;
        }
        package_.permissions.add(permission2);
        return permission2;
    }

    private PermissionGroup parsePermissionGroup(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String[] stringArray) throws XmlPullParserException, IOException {
        PermissionGroup permissionGroup = new PermissionGroup(package_);
        TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestPermissionGroup);
        if (!this.parsePackageItemInfo(package_, permissionGroup.info, stringArray, "<permission-group>", typedArray, 2, 0, 1, 0)) {
            typedArray.recycle();
            this.mParseError = -108;
            return null;
        }
        permissionGroup.info.descriptionRes = typedArray.getResourceId(3, 0);
        typedArray.recycle();
        if (!this.parseAllMetaData(resources, xmlPullParser, attributeSet, "<permission-group>", permissionGroup, stringArray)) {
            this.mParseError = -108;
            return null;
        }
        package_.permissionGroups.add(permissionGroup);
        return permissionGroup;
    }

    private Permission parsePermissionTree(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String[] stringArray) throws XmlPullParserException, IOException {
        Permission permission2 = new Permission(package_);
        TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestPermissionTree);
        if (!this.parsePackageItemInfo(package_, permission2.info, stringArray, "<permission-tree>", typedArray, 2, 0, 1, 0)) {
            typedArray.recycle();
            this.mParseError = -108;
            return null;
        }
        typedArray.recycle();
        int n = permission2.info.name.indexOf(46);
        if (n > 0) {
            n = permission2.info.name.indexOf(46, n + 1);
        }
        if (n < 0) {
            stringArray[0] = "<permission-tree> name has less than three segments: " + permission2.info.name;
            this.mParseError = -108;
            return null;
        }
        permission2.info.descriptionRes = 0;
        permission2.info.protectionLevel = 0;
        permission2.tree = true;
        if (!this.parseAllMetaData(resources, xmlPullParser, attributeSet, "<permission-tree>", permission2, stringArray)) {
            this.mParseError = -108;
            return null;
        }
        package_.permissions.add(permission2);
        return permission2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Provider parseProvider(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray) throws XmlPullParserException, IOException {
        String string2;
        TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestProvider);
        if (this.mParseProviderArgs == null) {
            this.mParseProviderArgs = new ParseComponentArgs(package_, stringArray, 2, 0, 1, 0, this.mSeparateProcesses, 8, 14, 6);
            this.mParseProviderArgs.tag = "<provider>";
        }
        this.mParseProviderArgs.sa = typedArray;
        this.mParseProviderArgs.flags = n;
        Provider provider = new Provider(this.mParseProviderArgs, new ProviderInfo());
        if (stringArray[0] != null) {
            typedArray.recycle();
            return null;
        }
        provider.info.exported = typedArray.getBoolean(7, true);
        String string3 = typedArray.getNonConfigurationString(10, 0);
        provider.info.isSyncable = typedArray.getBoolean(11, false);
        String string4 = typedArray.getNonConfigurationString(3, 0);
        String string5 = typedArray.getNonConfigurationString(4, 0);
        if (string5 == null) {
            string5 = string4;
        }
        if (string5 == null) {
            provider.info.readPermission = package_.applicationInfo.permission;
        } else {
            ProviderInfo providerInfo = provider.info;
            String string6 = string5.length() > 0 ? string5.toString().intern() : null;
            providerInfo.readPermission = string6;
        }
        if ((string2 = typedArray.getNonConfigurationString(5, 0)) == null) {
            string2 = string4;
        }
        if (string2 == null) {
            provider.info.writePermission = package_.applicationInfo.permission;
        } else {
            ProviderInfo providerInfo = provider.info;
            String string7 = string2.length() > 0 ? string2.toString().intern() : null;
            providerInfo.writePermission = string7;
        }
        provider.info.grantUriPermissions = typedArray.getBoolean(13, false);
        provider.info.multiprocess = typedArray.getBoolean(9, false);
        provider.info.initOrder = typedArray.getInt(12, 0);
        typedArray.recycle();
        if ((0x8000000 & package_.applicationInfo.flags) != 0 && provider.info.processName == package_.packageName) {
            stringArray[0] = "Heavy-weight applications can not have providers in main process";
            return null;
        }
        if (string3 == null) {
            stringArray[0] = "<provider> does not incude authorities attribute";
            return null;
        }
        provider.info.authority = string3.intern();
        if (!this.parseProviderTags(resources, xmlPullParser, attributeSet, provider, stringArray)) {
            return null;
        }
        return provider;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseProviderTags(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Provider provider, String[] stringArray) throws XmlPullParserException, IOException {
        int n;
        int n2 = xmlPullParser.getDepth();
        while ((n = xmlPullParser.next()) != 1 && (n != 3 || xmlPullParser.getDepth() > n2)) {
            if (n == 3 || n == 4) continue;
            if (xmlPullParser.getName().equals("meta-data")) {
                Bundle bundle;
                provider.metaData = bundle = this.parseMetaData(resources, xmlPullParser, attributeSet, provider.metaData, stringArray);
                if (bundle != null) continue;
                return false;
            }
            if (xmlPullParser.getName().equals("grant-uri-permission")) {
                String string2;
                String string3;
                TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestGrantUriPermission);
                String string4 = typedArray.getNonConfigurationString(0, 0);
                PatternMatcher patternMatcher = null;
                if (string4 != null) {
                    patternMatcher = new PatternMatcher(string4, 0);
                }
                if ((string3 = typedArray.getNonConfigurationString(1, 0)) != null) {
                    patternMatcher = new PatternMatcher(string3, 1);
                }
                if ((string2 = typedArray.getNonConfigurationString(2, 0)) != null) {
                    patternMatcher = new PatternMatcher(string2, 2);
                }
                typedArray.recycle();
                if (patternMatcher != null) {
                    if (provider.info.uriPermissionPatterns == null) {
                        provider.info.uriPermissionPatterns = new PatternMatcher[1];
                        provider.info.uriPermissionPatterns[0] = patternMatcher;
                    } else {
                        int n3 = provider.info.uriPermissionPatterns.length;
                        PatternMatcher[] patternMatcherArray = new PatternMatcher[n3 + 1];
                        System.arraycopy(provider.info.uriPermissionPatterns, 0, patternMatcherArray, 0, n3);
                        patternMatcherArray[n3] = patternMatcher;
                        provider.info.uriPermissionPatterns = patternMatcherArray;
                    }
                    provider.info.grantUriPermissions = true;
                    XmlUtils.skipCurrentTag(xmlPullParser);
                    continue;
                }
                Log.w(TAG, "Unknown element under <path-permission>: " + xmlPullParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
                XmlUtils.skipCurrentTag(xmlPullParser);
                continue;
            }
            if (xmlPullParser.getName().equals("path-permission")) {
                String string5;
                String string6;
                String string7;
                TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestPathPermission);
                String string8 = typedArray.getNonConfigurationString(0, 0);
                String string9 = typedArray.getNonConfigurationString(1, 0);
                if (string9 == null) {
                    string9 = string8;
                }
                if ((string7 = typedArray.getNonConfigurationString(2, 0)) == null) {
                    string7 = string8;
                }
                boolean bl = false;
                if (string9 != null) {
                    string9 = string9.intern();
                    bl = true;
                }
                if (string7 != null) {
                    string7 = string7.intern();
                    bl = true;
                }
                if (!bl) {
                    Log.w(TAG, "No readPermission or writePermssion for <path-permission>: " + xmlPullParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
                    XmlUtils.skipCurrentTag(xmlPullParser);
                    continue;
                }
                String string10 = typedArray.getNonConfigurationString(3, 0);
                PathPermission pathPermission = null;
                if (string10 != null) {
                    pathPermission = new PathPermission(string10, 0, string9, string7);
                }
                if ((string6 = typedArray.getNonConfigurationString(4, 0)) != null) {
                    pathPermission = new PathPermission(string6, 1, string9, string7);
                }
                if ((string5 = typedArray.getNonConfigurationString(5, 0)) != null) {
                    pathPermission = new PathPermission(string5, 2, string9, string7);
                }
                typedArray.recycle();
                if (pathPermission != null) {
                    if (provider.info.pathPermissions == null) {
                        provider.info.pathPermissions = new PathPermission[1];
                        provider.info.pathPermissions[0] = pathPermission;
                    } else {
                        int n4 = provider.info.pathPermissions.length;
                        PathPermission[] pathPermissionArray = new PathPermission[n4 + 1];
                        System.arraycopy(provider.info.pathPermissions, 0, pathPermissionArray, 0, n4);
                        pathPermissionArray[n4] = pathPermission;
                        provider.info.pathPermissions = pathPermissionArray;
                    }
                    XmlUtils.skipCurrentTag(xmlPullParser);
                    continue;
                }
                Log.w(TAG, "No path, pathPrefix, or pathPattern for <path-permission>: " + xmlPullParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
                XmlUtils.skipCurrentTag(xmlPullParser);
                continue;
            }
            Log.w(TAG, "Unknown element under <provider>: " + xmlPullParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Service parseService(Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, int n, String[] stringArray) throws XmlPullParserException, IOException {
        int n2;
        String string2;
        TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestService);
        if (this.mParseServiceArgs == null) {
            this.mParseServiceArgs = new ParseComponentArgs(package_, stringArray, 2, 0, 1, 0, this.mSeparateProcesses, 6, 7, 4);
            this.mParseServiceArgs.tag = "<service>";
        }
        this.mParseServiceArgs.sa = typedArray;
        this.mParseServiceArgs.flags = n;
        Service service = new Service(this.mParseServiceArgs, new ServiceInfo());
        if (stringArray[0] != null) {
            typedArray.recycle();
            return null;
        }
        boolean bl = typedArray.hasValue(5);
        if (bl) {
            service.info.exported = typedArray.getBoolean(5, false);
        }
        if ((string2 = typedArray.getNonConfigurationString(3, 0)) == null) {
            service.info.permission = package_.applicationInfo.permission;
        } else {
            ServiceInfo serviceInfo = service.info;
            String string3 = string2.length() > 0 ? string2.toString().intern() : null;
            serviceInfo.permission = string3;
        }
        typedArray.recycle();
        if ((0x8000000 & package_.applicationInfo.flags) != 0 && service.info.processName == package_.packageName) {
            stringArray[0] = "Heavy-weight applications can not have services in main process";
            return null;
        }
        int n3 = xmlPullParser.getDepth();
        while ((n2 = xmlPullParser.next()) != 1 && (n2 != 3 || xmlPullParser.getDepth() > n3)) {
            if (n2 == 3 || n2 == 4) continue;
            if (xmlPullParser.getName().equals("intent-filter")) {
                ServiceIntentInfo serviceIntentInfo = new ServiceIntentInfo(service);
                if (!this.parseIntent(resources, xmlPullParser, attributeSet, n, serviceIntentInfo, stringArray, false)) {
                    return null;
                }
                service.intents.add(serviceIntentInfo);
                continue;
            }
            if (xmlPullParser.getName().equals("meta-data")) {
                Bundle bundle;
                service.metaData = bundle = this.parseMetaData(resources, xmlPullParser, attributeSet, service.metaData, stringArray);
                if (bundle != null) continue;
                return null;
            }
            Log.w(TAG, "Unknown element under <service>: " + xmlPullParser.getName() + " at " + this.mArchiveSourcePath + " " + xmlPullParser.getPositionDescription());
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
        if (!bl) {
            ServiceInfo serviceInfo = service.info;
            boolean bl2 = service.intents.size() > 0;
            serviceInfo.exported = bl2;
        }
        return service;
    }

    public static void setCompatibilityModeEnabled(boolean bl) {
        sCompatibilityModeEnabled = bl;
    }

    public static Signature stringToSignature(String string2) {
        int n = string2.length();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)string2.charAt(i);
        }
        return new Signature(byArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String validateName(String string2, boolean bl) {
        int n = string2.length();
        boolean bl2 = false;
        boolean bl3 = true;
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                bl3 = false;
                continue;
            }
            if (!bl3 && (c >= '0' && c <= '9' || c == '_')) continue;
            if (c != '.') {
                return "bad character '" + c + "'";
            }
            bl2 = true;
            bl3 = true;
        }
        if (!bl2 && bl) {
            return "must have at least one '.' separator";
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean collectCertificates(Package package_, int n) {
        block27: {
            package_.mSignatures = null;
            Object object = mSync;
            // MONITORENTER : object
            WeakReference<byte[]> weakReference = mReadBuffer;
            byte[] byArray = null;
            if (weakReference != null) {
                mReadBuffer = null;
                byArray = (byte[])weakReference.get();
            }
            if (byArray == null) {
                byArray = new byte[8192];
                weakReference = new WeakReference<byte[]>(byArray);
            }
            // MONITOREXIT : object
            JarFile jarFile = new JarFile(this.mArchiveSourcePath);
            Certificate[] certificateArray = null;
            if ((n & 1) != 0) {
                JarEntry jarEntry = jarFile.getJarEntry("AndroidManifest.xml");
                certificateArray = this.loadCertificates(jarFile, jarEntry, byArray);
                if (certificateArray == null) {
                    Log.e(TAG, "Package " + package_.packageName + " has no certificates at entry " + jarEntry.getName() + "; ignoring!");
                    jarFile.close();
                    this.mParseError = -103;
                    return false;
                }
            } else {
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    int n2;
                    JarEntry jarEntry = enumeration.nextElement();
                    if (jarEntry.isDirectory() || jarEntry.getName().startsWith("META-INF/")) continue;
                    Certificate[] certificateArray2 = this.loadCertificates(jarFile, jarEntry, byArray);
                    if (certificateArray2 == null) {
                        Log.e(TAG, "Package " + package_.packageName + " has no certificates at entry " + jarEntry.getName() + "; ignoring!");
                        jarFile.close();
                        this.mParseError = -103;
                        return false;
                    }
                    if (certificateArray == null) {
                        certificateArray = certificateArray2;
                        continue;
                    }
                    for (int i = 0; i < (n2 = certificateArray.length); ++i) {
                        boolean bl;
                        block26: {
                            int n3 = 0;
                            do {
                                int n4 = certificateArray2.length;
                                int n5 = ++n3;
                                bl = false;
                                if (n5 >= n4) break block26;
                            } while (certificateArray[i] == null || !certificateArray[i].equals(certificateArray2[n3]));
                            bl = true;
                        }
                        if (bl && certificateArray.length == certificateArray2.length) continue;
                        Log.e(TAG, "Package " + package_.packageName + " has mismatched certificates at entry " + jarEntry.getName() + "; ignoring!");
                        jarFile.close();
                        this.mParseError = -104;
                        return false;
                    }
                }
            }
            jarFile.close();
            Object object2 = mSync;
            // MONITORENTER : object2
            mReadBuffer = weakReference;
            // MONITOREXIT : object2
            if (certificateArray != null) {
                if (certificateArray.length <= 0) break block27;
                int n6 = certificateArray.length;
                package_.mSignatures = new Signature[certificateArray.length];
                int n7 = 0;
                while (n7 < n6) {
                    package_.mSignatures[n7] = new Signature(certificateArray[n7].getEncoded());
                    ++n7;
                }
                return true;
            }
        }
        try {
            Log.e(TAG, "Package " + package_.packageName + " has no certificates; ignoring!");
            this.mParseError = -103;
            return false;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            Log.w(TAG, "Exception reading " + this.mArchiveSourcePath, certificateEncodingException);
            this.mParseError = -105;
            return false;
        }
        catch (IOException iOException) {
            Log.w(TAG, "Exception reading " + this.mArchiveSourcePath, iOException);
            this.mParseError = -105;
            return false;
        }
        catch (RuntimeException runtimeException) {
            Log.w(TAG, "Exception reading " + this.mArchiveSourcePath, runtimeException);
            this.mParseError = -102;
            return false;
        }
    }

    public int getParseError() {
        return this.mParseError;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Package parsePackage(File file, String string2, DisplayMetrics displayMetrics, int n) {
        Package package_;
        AssetManager assetManager;
        XmlResourceParser xmlResourceParser;
        this.mParseError = 1;
        this.mArchiveSourcePath = file.getPath();
        if (!file.isFile()) {
            Log.w(TAG, "Skipping dir: " + this.mArchiveSourcePath);
            this.mParseError = -100;
            return null;
        }
        if (!PackageParser.isPackageFilename(file.getName()) && (n & 4) != 0) {
            if ((n & 1) == 0) {
                Log.w(TAG, "Skipping non-package file: " + this.mArchiveSourcePath);
            }
            this.mParseError = -100;
            return null;
        }
        if ((n & 2) != 0) {
            Log.d(TAG, "Scanning package: " + this.mArchiveSourcePath);
        }
        boolean bl = true;
        AssetManager assetManager2 = new AssetManager();
        try {
            int n2 = assetManager2.addAssetPath(this.mArchiveSourcePath);
            if (n2 != 0) {
                XmlResourceParser xmlResourceParser2;
                xmlResourceParser = xmlResourceParser2 = assetManager2.openXmlResourceParser(n2, "AndroidManifest.xml");
                bl = false;
            } else {
                Log.w(TAG, "Failed adding asset path:" + this.mArchiveSourcePath);
                xmlResourceParser = null;
            }
            assetManager = assetManager2;
        }
        catch (Exception exception) {
            Exception exception2;
            block19: {
                exception2 = exception;
                assetManager = assetManager2;
                break block19;
                catch (Exception exception3) {
                    exception2 = exception3;
                    assetManager = null;
                }
            }
            Log.w(TAG, "Unable to read AndroidManifest.xml of " + this.mArchiveSourcePath, exception2);
            xmlResourceParser = null;
        }
        if (bl) {
            if (assetManager != null) {
                assetManager.close();
            }
            this.mParseError = -101;
            return null;
        }
        String[] stringArray = new String[1];
        Exception exception = null;
        try {
            Package package_2;
            Resources resources = new Resources(assetManager, displayMetrics, null);
            package_ = package_2 = this.parsePackage(resources, xmlResourceParser, n, stringArray);
        }
        catch (Exception exception4) {
            exception = exception4;
            this.mParseError = -102;
            package_ = null;
        }
        if (package_ == null) {
            if (exception != null) {
                Log.w(TAG, this.mArchiveSourcePath, exception);
            } else {
                Log.w(TAG, this.mArchiveSourcePath + " (at " + xmlResourceParser.getPositionDescription() + "): " + stringArray[0]);
            }
            xmlResourceParser.close();
            assetManager.close();
            if (this.mParseError == 1) {
                this.mParseError = -108;
            }
            return null;
        }
        xmlResourceParser.close();
        assetManager.close();
        package_.mPath = string2;
        package_.mScanPath = this.mArchiveSourcePath;
        package_.mSignatures = null;
        return package_;
    }

    public void setSeparateProcesses(String[] stringArray) {
        this.mSeparateProcesses = stringArray;
    }

    public static final class Activity
    extends Component<ActivityIntentInfo> {
        public final ActivityInfo info;

        public Activity(ParseComponentArgs parseComponentArgs, ActivityInfo activityInfo) {
            super(parseComponentArgs, activityInfo);
            this.info = activityInfo;
            this.info.applicationInfo = parseComponentArgs.owner.applicationInfo;
        }

        @Override
        public void setPackageName(String string2) {
            super.setPackageName(string2);
            this.info.packageName = string2;
        }

        public String toString() {
            return "Activity{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.getComponentShortName() + "}";
        }
    }

    public static final class ActivityIntentInfo
    extends IntentInfo {
        public final Activity activity;

        public ActivityIntentInfo(Activity activity) {
            this.activity = activity;
        }

        public String toString() {
            return "ActivityIntentInfo{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.activity.info.name + "}";
        }
    }

    public static class Component<II extends IntentInfo> {
        public final String className;
        ComponentName componentName;
        String componentShortName;
        public final ArrayList<II> intents;
        public Bundle metaData;
        public final Package owner;

        public Component(Component<II> component) {
            this.owner = component.owner;
            this.intents = component.intents;
            this.className = component.className;
            this.componentName = component.componentName;
            this.componentShortName = component.componentShortName;
        }

        public Component(Package package_) {
            this.owner = package_;
            this.intents = null;
            this.className = null;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Component(ParseComponentArgs parseComponentArgs, ComponentInfo componentInfo) {
            this((ParsePackageItemArgs)parseComponentArgs, (PackageItemInfo)componentInfo);
            if (parseComponentArgs.outError[0] != null) {
                return;
            }
            if (parseComponentArgs.processRes != 0) {
                String string2 = this.owner.applicationInfo.targetSdkVersion >= 8 ? parseComponentArgs.sa.getNonConfigurationString(parseComponentArgs.processRes, 0) : parseComponentArgs.sa.getNonResourceString(parseComponentArgs.processRes);
                componentInfo.processName = PackageParser.buildProcessName(this.owner.applicationInfo.packageName, this.owner.applicationInfo.processName, string2, parseComponentArgs.flags, parseComponentArgs.sepProcesses, parseComponentArgs.outError);
            }
            if (parseComponentArgs.descriptionRes != 0) {
                componentInfo.descriptionRes = parseComponentArgs.sa.getResourceId(parseComponentArgs.descriptionRes, 0);
            }
            componentInfo.enabled = parseComponentArgs.sa.getBoolean(parseComponentArgs.enabledRes, true);
        }

        public Component(ParsePackageItemArgs parsePackageItemArgs, PackageItemInfo packageItemInfo) {
            TypedValue typedValue;
            this.owner = parsePackageItemArgs.owner;
            this.intents = new ArrayList(0);
            String string2 = parsePackageItemArgs.sa.getNonConfigurationString(parsePackageItemArgs.nameRes, 0);
            if (string2 == null) {
                this.className = null;
                parsePackageItemArgs.outError[0] = parsePackageItemArgs.tag + " does not specify android:name";
                return;
            }
            packageItemInfo.name = PackageParser.buildClassName(this.owner.applicationInfo.packageName, string2, parsePackageItemArgs.outError);
            if (packageItemInfo.name == null) {
                this.className = null;
                parsePackageItemArgs.outError[0] = parsePackageItemArgs.tag + " does not have valid android:name";
                return;
            }
            this.className = packageItemInfo.name;
            int n = parsePackageItemArgs.sa.getResourceId(parsePackageItemArgs.iconRes, 0);
            if (n != 0) {
                packageItemInfo.icon = n;
                packageItemInfo.nonLocalizedLabel = null;
            }
            if ((typedValue = parsePackageItemArgs.sa.peekValue(parsePackageItemArgs.labelRes)) != null) {
                int n2;
                packageItemInfo.labelRes = n2 = typedValue.resourceId;
                if (n2 == 0) {
                    packageItemInfo.nonLocalizedLabel = typedValue.coerceToString();
                }
            }
            packageItemInfo.packageName = this.owner.packageName;
        }

        public ComponentName getComponentName() {
            if (this.componentName != null) {
                return this.componentName;
            }
            if (this.className != null) {
                this.componentName = new ComponentName(this.owner.applicationInfo.packageName, this.className);
            }
            return this.componentName;
        }

        public String getComponentShortName() {
            if (this.componentShortName != null) {
                return this.componentShortName;
            }
            ComponentName componentName = this.getComponentName();
            if (componentName != null) {
                this.componentShortName = componentName.flattenToShortString();
            }
            return this.componentShortName;
        }

        public void setPackageName(String string2) {
            this.componentName = null;
            this.componentShortName = null;
        }
    }

    public static final class Instrumentation
    extends Component {
        public final InstrumentationInfo info;

        public Instrumentation(ParsePackageItemArgs parsePackageItemArgs, InstrumentationInfo instrumentationInfo) {
            super(parsePackageItemArgs, instrumentationInfo);
            this.info = instrumentationInfo;
        }

        @Override
        public void setPackageName(String string2) {
            super.setPackageName(string2);
            this.info.packageName = string2;
        }

        public String toString() {
            return "Instrumentation{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.getComponentShortName() + "}";
        }
    }

    public static class IntentInfo
    extends IntentFilter {
        public boolean hasDefault;
        public int icon;
        public int labelRes;
        public int logo;
        public CharSequence nonLocalizedLabel;
    }

    public static class NewPermissionInfo {
        public final int fileVersion;
        public final String name;
        public final int sdkVersion;

        public NewPermissionInfo(String string2, int n, int n2) {
            this.name = string2;
            this.sdkVersion = n;
            this.fileVersion = n2;
        }
    }

    public static final class Package {
        public final ArrayList<Activity> activities;
        public final ApplicationInfo applicationInfo = new ApplicationInfo();
        public final ArrayList<ConfigurationInfo> configPreferences;
        public int installLocation;
        public final ArrayList<Instrumentation> instrumentation;
        public ArrayList<String> mAdoptPermissions = null;
        public Bundle mAppMetaData = null;
        public boolean mDidDexOpt;
        public Object mExtras;
        public boolean mOperationPending;
        public ArrayList<String> mOriginalPackages = null;
        public String mPath;
        public int mPreferredOrder = 0;
        public String mRealPackage = null;
        public String mScanPath;
        public int mSetEnabled = 0;
        public String mSharedUserId;
        public int mSharedUserLabel;
        public Signature[] mSignatures;
        public int mVersionCode;
        public String mVersionName;
        public String packageName;
        public final ArrayList<PermissionGroup> permissionGroups;
        public final ArrayList<Permission> permissions = new ArrayList(0);
        public ArrayList<String> protectedBroadcasts;
        public final ArrayList<Provider> providers;
        public final ArrayList<Activity> receivers;
        public ArrayList<FeatureInfo> reqFeatures = null;
        public final ArrayList<String> requestedPermissions;
        public final ArrayList<Service> services;
        public ArrayList<String> usesLibraries = null;
        public String[] usesLibraryFiles = null;
        public ArrayList<String> usesOptionalLibraries = null;

        public Package(String string2) {
            this.permissionGroups = new ArrayList(0);
            this.activities = new ArrayList(0);
            this.receivers = new ArrayList(0);
            this.providers = new ArrayList(0);
            this.services = new ArrayList(0);
            this.instrumentation = new ArrayList(0);
            this.requestedPermissions = new ArrayList();
            this.configPreferences = new ArrayList();
            this.packageName = string2;
            this.applicationInfo.packageName = string2;
            this.applicationInfo.uid = -1;
        }

        public void setPackageName(String string2) {
            this.packageName = string2;
            this.applicationInfo.packageName = string2;
            for (int i = this.permissions.size() - 1; i >= 0; --i) {
                this.permissions.get(i).setPackageName(string2);
            }
            for (int i = this.permissionGroups.size() - 1; i >= 0; --i) {
                this.permissionGroups.get(i).setPackageName(string2);
            }
            for (int i = this.activities.size() - 1; i >= 0; --i) {
                this.activities.get(i).setPackageName(string2);
            }
            for (int i = this.receivers.size() - 1; i >= 0; --i) {
                this.receivers.get(i).setPackageName(string2);
            }
            for (int i = this.providers.size() - 1; i >= 0; --i) {
                this.providers.get(i).setPackageName(string2);
            }
            for (int i = this.services.size() - 1; i >= 0; --i) {
                this.services.get(i).setPackageName(string2);
            }
            for (int i = this.instrumentation.size() - 1; i >= 0; --i) {
                this.instrumentation.get(i).setPackageName(string2);
            }
        }

        public String toString() {
            return "Package{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.packageName + "}";
        }
    }

    public static class PackageLite {
        public int installLocation;
        public String mScanPath;
        public String packageName;

        public PackageLite(String string2, int n) {
            this.packageName = string2;
            this.installLocation = n;
        }
    }

    static class ParseComponentArgs
    extends ParsePackageItemArgs {
        final int descriptionRes;
        final int enabledRes;
        int flags;
        final int processRes;
        final String[] sepProcesses;

        ParseComponentArgs(Package package_, String[] stringArray, int n, int n2, int n3, int n4, String[] stringArray2, int n5, int n6, int n7) {
            super(package_, stringArray, n, n2, n3, n4);
            this.sepProcesses = stringArray2;
            this.processRes = n5;
            this.descriptionRes = n6;
            this.enabledRes = n7;
        }
    }

    static class ParsePackageItemArgs {
        final int iconRes;
        final int labelRes;
        final int logoRes;
        final int nameRes;
        final String[] outError;
        final Package owner;
        TypedArray sa;
        String tag;

        ParsePackageItemArgs(Package package_, String[] stringArray, int n, int n2, int n3, int n4) {
            this.owner = package_;
            this.outError = stringArray;
            this.nameRes = n;
            this.labelRes = n2;
            this.iconRes = n3;
            this.logoRes = n4;
        }
    }

    public static final class Permission
    extends Component<IntentInfo> {
        public PermissionGroup group;
        public final PermissionInfo info;
        public boolean tree;

        public Permission(Package package_) {
            super(package_);
            this.info = new PermissionInfo();
        }

        public Permission(Package package_, PermissionInfo permissionInfo) {
            super(package_);
            this.info = permissionInfo;
        }

        @Override
        public void setPackageName(String string2) {
            super.setPackageName(string2);
            this.info.packageName = string2;
        }

        public String toString() {
            return "Permission{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.info.name + "}";
        }
    }

    public static final class PermissionGroup
    extends Component<IntentInfo> {
        public final PermissionGroupInfo info;

        public PermissionGroup(Package package_) {
            super(package_);
            this.info = new PermissionGroupInfo();
        }

        public PermissionGroup(Package package_, PermissionGroupInfo permissionGroupInfo) {
            super(package_);
            this.info = permissionGroupInfo;
        }

        @Override
        public void setPackageName(String string2) {
            super.setPackageName(string2);
            this.info.packageName = string2;
        }

        public String toString() {
            return "PermissionGroup{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.info.name + "}";
        }
    }

    public static final class Provider
    extends Component {
        public final ProviderInfo info;
        public boolean syncable;

        public Provider(ParseComponentArgs parseComponentArgs, ProviderInfo providerInfo) {
            super(parseComponentArgs, providerInfo);
            this.info = providerInfo;
            this.info.applicationInfo = parseComponentArgs.owner.applicationInfo;
            this.syncable = false;
        }

        public Provider(Provider provider) {
            super(provider);
            this.info = provider.info;
            this.syncable = provider.syncable;
        }

        @Override
        public void setPackageName(String string2) {
            super.setPackageName(string2);
            this.info.packageName = string2;
        }

        public String toString() {
            return "Provider{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.info.name + "}";
        }
    }

    public static final class Service
    extends Component<ServiceIntentInfo> {
        public final ServiceInfo info;

        public Service(ParseComponentArgs parseComponentArgs, ServiceInfo serviceInfo) {
            super(parseComponentArgs, serviceInfo);
            this.info = serviceInfo;
            this.info.applicationInfo = parseComponentArgs.owner.applicationInfo;
        }

        @Override
        public void setPackageName(String string2) {
            super.setPackageName(string2);
            this.info.packageName = string2;
        }

        public String toString() {
            return "Service{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.getComponentShortName() + "}";
        }
    }

    public static final class ServiceIntentInfo
    extends IntentInfo {
        public final Service service;

        public ServiceIntentInfo(Service service) {
            this.service = service;
        }

        public String toString() {
            return "ServiceIntentInfo{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.service.info.name + "}";
        }
    }
}

