/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.RegisteredServicesCacheListener;
import android.content.pm.ResolveInfo;
import android.content.pm.XmlSerializerAndParser;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.Environment;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import com.android.internal.os.AtomicFile;
import com.android.internal.util.FastXmlSerializer;
import com.google.android.collect.Lists;
import com.google.android.collect.Maps;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class RegisteredServicesCache<V> {
    private static final String TAG = "PackageManager";
    private final String mAttributesName;
    public final Context mContext;
    private Handler mHandler;
    private final String mInterfaceName;
    private RegisteredServicesCacheListener<V> mListener;
    private final String mMetaDataName;
    private HashMap<V, Integer> mPersistentServices;
    private final AtomicFile mPersistentServicesFile;
    private boolean mPersistentServicesFileDidNotExist;
    private final AtomicReference<BroadcastReceiver> mReceiver;
    private final XmlSerializerAndParser<V> mSerializerAndParser;
    private Map<V, ServiceInfo<V>> mServices;
    private final Object mServicesLock = new Object();

    public RegisteredServicesCache(Context context, String string2, String string3, String string4, XmlSerializerAndParser<V> xmlSerializerAndParser) {
        this.mContext = context;
        this.mInterfaceName = string2;
        this.mMetaDataName = string3;
        this.mAttributesName = string4;
        this.mSerializerAndParser = xmlSerializerAndParser;
        this.mPersistentServicesFile = new AtomicFile(new File(new File(new File(Environment.getDataDirectory(), "system"), "registered_services"), string2 + ".xml"));
        this.generateServicesMap();
        BroadcastReceiver broadcastReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                RegisteredServicesCache.this.generateServicesMap();
            }
        };
        this.mReceiver = new AtomicReference<1>(broadcastReceiver);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PACKAGE_ADDED");
        intentFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        intentFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        intentFilter.addDataScheme("package");
        this.mContext.registerReceiver(broadcastReceiver, intentFilter);
        IntentFilter intentFilter2 = new IntentFilter();
        intentFilter2.addAction("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE");
        intentFilter2.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        this.mContext.registerReceiver(broadcastReceiver, intentFilter2);
    }

    private boolean containsType(ArrayList<ServiceInfo<V>> arrayList, V v) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (!arrayList.get((int)i).type.equals(v)) continue;
            return true;
        }
        return false;
    }

    private boolean containsTypeAndUid(ArrayList<ServiceInfo<V>> arrayList, V v, int n) {
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            ServiceInfo<V> serviceInfo = arrayList.get(i);
            if (!serviceInfo.type.equals(v) || serviceInfo.uid != n) continue;
            return true;
        }
        return false;
    }

    private boolean inSystemImage(int n) {
        for (String string2 : this.mContext.getPackageManager().getPackagesForUid(n)) {
            try {
                int n2 = this.mContext.getPackageManager().getPackageInfo((String)string2, (int)0).applicationInfo.flags;
                if ((n2 & 1) == 0) continue;
                return true;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return false;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void notifyListener(final V v, final boolean bl) {
        if (Log.isLoggable(TAG, 2)) {
            StringBuilder stringBuilder = new StringBuilder().append("notifyListener: ").append(v).append(" is ");
            String string2 = bl ? "removed" : "added";
            Log.d(TAG, stringBuilder.append(string2).toString());
        }
        // MONITORENTER : this
        final RegisteredServicesCacheListener<V> registeredServicesCacheListener = this.mListener;
        Handler handler = this.mHandler;
        // MONITOREXIT : this
        if (registeredServicesCacheListener == null) {
            return;
        }
        handler.post(new Runnable(){

            @Override
            public void run() {
                registeredServicesCacheListener.onServiceChanged(v, bl);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ServiceInfo<V> parseServiceInfo(ResolveInfo resolveInfo) throws XmlPullParserException, IOException {
        android.content.pm.ServiceInfo serviceInfo = resolveInfo.serviceInfo;
        ComponentName componentName = new ComponentName(serviceInfo.packageName, serviceInfo.name);
        PackageManager packageManager = this.mContext.getPackageManager();
        XmlResourceParser xmlResourceParser = null;
        try {
            ServiceInfo serviceInfo2;
            int n;
            block12: {
                xmlResourceParser = serviceInfo.loadXmlMetaData(packageManager, this.mMetaDataName);
                if (xmlResourceParser != null) break block12;
                throw new XmlPullParserException("No " + this.mMetaDataName + " meta-data");
            }
            AttributeSet attributeSet = Xml.asAttributeSet(xmlResourceParser);
            while ((n = xmlResourceParser.next()) != 1 && n != 2) {
            }
            String string2 = xmlResourceParser.getName();
            if (!this.mAttributesName.equals(string2)) {
                throw new XmlPullParserException("Meta-data does not start with " + this.mAttributesName + " tag");
            }
            V v = this.parseServiceAttributes(packageManager.getResourcesForApplication(serviceInfo.applicationInfo), serviceInfo.packageName, attributeSet);
            if (v == null) {
                serviceInfo2 = null;
                if (xmlResourceParser == null) return serviceInfo2;
                xmlResourceParser.close();
                return serviceInfo2;
            }
            try {
                int n2 = resolveInfo.serviceInfo.applicationInfo.uid;
                serviceInfo2 = new ServiceInfo(v, componentName, n2);
                if (xmlResourceParser == null) return serviceInfo2;
                xmlResourceParser.close();
                return serviceInfo2;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
            throw new XmlPullParserException("Unable to load resources for pacakge " + serviceInfo.packageName);
        }
        catch (Throwable throwable) {
            if (xmlResourceParser == null) throw throwable;
            xmlResourceParser.close();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readPersistentServicesLocked() {
        this.mPersistentServices = Maps.newHashMap();
        if (this.mSerializerAndParser == null) {
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            boolean bl = !this.mPersistentServicesFile.getBaseFile().exists();
            this.mPersistentServicesFileDidNotExist = bl;
            boolean bl2 = this.mPersistentServicesFileDidNotExist;
            if (bl2) {
                return;
            }
            fileInputStream = this.mPersistentServicesFile.openRead();
            XmlPullParser xmlPullParser = Xml.newPullParser();
            xmlPullParser.setInput(fileInputStream, null);
            int n = xmlPullParser.getEventType();
            while (n != 2) {
                n = xmlPullParser.next();
            }
            if ("services".equals(xmlPullParser.getName())) {
                int n2 = xmlPullParser.next();
                while (true) {
                    int n3;
                    if (n2 != 2 || xmlPullParser.getDepth() != 2 || !"service".equals(xmlPullParser.getName())) continue;
                    V v = this.mSerializerAndParser.createFromXml(xmlPullParser);
                    if (v == null) break;
                    int n4 = Integer.parseInt(xmlPullParser.getAttributeValue(null, "uid"));
                    this.mPersistentServices.put((Integer)v, n4);
                    if ((n2 = (n3 = xmlPullParser.next())) != 1) continue;
                    break;
                }
            }
            if (fileInputStream == null) return;
            try {
                fileInputStream.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
            catch (Exception exception) {
                Log.w(TAG, "Error reading persistent services, starting from scratch", exception);
                if (fileInputStream == null) return;
                try {
                    fileInputStream.close();
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                throw throwable;
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void writePersistentServicesLocked() {
        if (this.mSerializerAndParser == null) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = this.mPersistentServicesFile.startWrite();
            FastXmlSerializer fastXmlSerializer = new FastXmlSerializer();
            fastXmlSerializer.setOutput(fileOutputStream, "utf-8");
            fastXmlSerializer.startDocument(null, true);
            fastXmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            fastXmlSerializer.startTag(null, "services");
            for (Map.Entry<V, Integer> entry : this.mPersistentServices.entrySet()) {
                fastXmlSerializer.startTag(null, "service");
                fastXmlSerializer.attribute(null, "uid", Integer.toString(entry.getValue()));
                this.mSerializerAndParser.writeAsXml(entry.getKey(), fastXmlSerializer);
                fastXmlSerializer.endTag(null, "service");
            }
            fastXmlSerializer.endTag(null, "services");
            fastXmlSerializer.endDocument();
            this.mPersistentServicesFile.finishWrite(fileOutputStream);
            return;
        }
        catch (IOException iOException) {
            Log.w(TAG, "Error writing accounts", iOException);
            if (fileOutputStream == null) return;
            this.mPersistentServicesFile.failWrite(fileOutputStream);
            return;
        }
    }

    public void close() {
        BroadcastReceiver broadcastReceiver = this.mReceiver.getAndSet(null);
        if (broadcastReceiver != null) {
            this.mContext.unregisterReceiver(broadcastReceiver);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        Map<V, ServiceInfo<V>> map;
        Object object = this.mServicesLock;
        synchronized (object) {
            map = this.mServices;
        }
        printWriter.println("RegisteredServicesCache: " + map.size() + " services");
        Iterator<ServiceInfo<V>> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            ServiceInfo<V> serviceInfo = iterator.next();
            printWriter.println("  " + serviceInfo);
        }
        return;
    }

    protected void finalize() throws Throwable {
        if (this.mReceiver.get() != null) {
            Log.e(TAG, "RegisteredServicesCache finalized without being closed");
        }
        this.close();
        super.finalize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void generateServicesMap() {
        PackageManager packageManager = this.mContext.getPackageManager();
        ArrayList<ServiceInfo<V>> arrayList = new ArrayList<ServiceInfo<V>>();
        for (ResolveInfo resolveInfo : packageManager.queryIntentServices(new Intent(this.mInterfaceName), 128)) {
            try {
                ServiceInfo<V> serviceInfo = this.parseServiceInfo(resolveInfo);
                if (serviceInfo == null) {
                    Log.w(TAG, "Unable to load service info " + resolveInfo.toString());
                }
                arrayList.add(serviceInfo);
            }
            catch (XmlPullParserException xmlPullParserException) {
                Log.w(TAG, "Unable to load service info " + resolveInfo.toString(), xmlPullParserException);
            }
            catch (IOException iOException) {
                Log.w(TAG, "Unable to load service info " + resolveInfo.toString(), iOException);
            }
        }
        Object object = this.mServicesLock;
        synchronized (object) {
            if (Log.isLoggable(TAG, 2)) {
                Log.d(TAG, "generateServicesMap: " + this.mInterfaceName);
            }
            if (this.mPersistentServices == null) {
                this.readPersistentServicesLocked();
            }
            this.mServices = Maps.newHashMap();
            boolean bl = false;
            if (Log.isLoggable(TAG, 2)) {
                Log.d(TAG, "found " + arrayList.size() + " services");
            }
            for (ServiceInfo serviceInfo : arrayList) {
                Integer n = this.mPersistentServices.get(serviceInfo.type);
                if (n == null) {
                    if (Log.isLoggable(TAG, 2)) {
                        Log.d(TAG, "encountered new type: " + serviceInfo);
                    }
                    bl = true;
                    this.mServices.put((ServiceInfo)serviceInfo.type, serviceInfo);
                    this.mPersistentServices.put((Integer)serviceInfo.type, serviceInfo.uid);
                    if (this.mPersistentServicesFileDidNotExist) continue;
                    this.notifyListener(serviceInfo.type, false);
                    continue;
                }
                if (n == serviceInfo.uid) {
                    if (Log.isLoggable(TAG, 2)) {
                        Log.d(TAG, "encountered existing type with the same uid: " + serviceInfo);
                    }
                    this.mServices.put((ServiceInfo)serviceInfo.type, serviceInfo);
                    continue;
                }
                if (this.inSystemImage(serviceInfo.uid) || !this.containsTypeAndUid(arrayList, serviceInfo.type, n)) {
                    if (Log.isLoggable(TAG, 2)) {
                        if (this.inSystemImage(serviceInfo.uid)) {
                            Log.d(TAG, "encountered existing type with a new uid but from the system: " + serviceInfo);
                        } else {
                            Log.d(TAG, "encountered existing type with a new uid but existing was removed: " + serviceInfo);
                        }
                    }
                    bl = true;
                    this.mServices.put((ServiceInfo)serviceInfo.type, serviceInfo);
                    this.mPersistentServices.put((Integer)serviceInfo.type, serviceInfo.uid);
                    this.notifyListener(serviceInfo.type, false);
                    continue;
                }
                if (!Log.isLoggable(TAG, 2)) continue;
                Log.d(TAG, "encountered existing type with a new uid, ignoring: " + serviceInfo);
            }
            ArrayList<V> arrayList2 = Lists.newArrayList();
            for (V v : this.mPersistentServices.keySet()) {
                if (this.containsType(arrayList, v)) continue;
                arrayList2.add(v);
            }
            for (Object e : arrayList2) {
                this.mPersistentServices.remove(e);
                bl = true;
                this.notifyListener(e, true);
            }
            if (bl) {
                if (Log.isLoggable(TAG, 2)) {
                    Log.d(TAG, "writing updated list of persistent services");
                }
                this.writePersistentServicesLocked();
            } else if (Log.isLoggable(TAG, 2)) {
                Log.d(TAG, "persistent services did not change, so not writing anything");
            }
            this.mPersistentServicesFileDidNotExist = false;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<ServiceInfo<V>> getAllServices() {
        Object object = this.mServicesLock;
        synchronized (object) {
            return Collections.unmodifiableCollection(this.mServices.values());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RegisteredServicesCacheListener<V> getListener() {
        synchronized (this) {
            return this.mListener;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceInfo<V> getServiceInfo(V v) {
        Object object = this.mServicesLock;
        synchronized (object) {
            return this.mServices.get(v);
        }
    }

    public abstract V parseServiceAttributes(Resources var1, String var2, AttributeSet var3);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setListener(RegisteredServicesCacheListener<V> registeredServicesCacheListener, Handler handler) {
        if (handler == null) {
            handler = new Handler(this.mContext.getMainLooper());
        }
        synchronized (this) {
            this.mHandler = handler;
            this.mListener = registeredServicesCacheListener;
            return;
        }
    }

    public static class ServiceInfo<V> {
        public final ComponentName componentName;
        public final V type;
        public final int uid;

        private ServiceInfo(V v, ComponentName componentName, int n) {
            this.type = v;
            this.componentName = componentName;
            this.uid = n;
        }

        public String toString() {
            return "ServiceInfo: " + this.type + ", " + this.componentName + ", uid " + this.uid;
        }
    }
}

