/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.pm.ApplicationInfo;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Region;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.WindowManager;

public class CompatibilityInfo {
    private static final int CONFIGURED_EXPANDABLE = 4;
    private static final int CONFIGURED_LARGE_SCREENS = 16;
    private static final int CONFIGURED_XLARGE_SCREENS = 64;
    private static final boolean DBG = false;
    public static final CompatibilityInfo DEFAULT_COMPATIBILITY_INFO = new CompatibilityInfo(){

        @Override
        public void setExpandable(boolean bl) {
            throw new UnsupportedOperationException("trying to change default compatibility info");
        }
    };
    public static final int DEFAULT_PORTRAIT_HEIGHT = 480;
    public static final int DEFAULT_PORTRAIT_WIDTH = 320;
    private static final int EXPANDABLE = 2;
    private static final int LARGE_SCREENS = 8;
    private static final int SCALING_REQUIRED = 1;
    private static final String TAG = "CompatibilityInfo";
    private static final int XLARGE_SCREENS = 32;
    public final int appFlags;
    public final int applicationDensity;
    public final float applicationInvertedScale;
    public final float applicationScale;
    private int mCompatibilityFlags;

    private CompatibilityInfo() {
        this(531968, 6, DisplayMetrics.DENSITY_DEVICE, 1.0f, 1.0f);
    }

    private CompatibilityInfo(int n, int n2, int n3, float f, float f2) {
        this.appFlags = n;
        this.mCompatibilityFlags = n2;
        this.applicationDensity = n3;
        this.applicationScale = f;
        this.applicationInvertedScale = f2;
    }

    public CompatibilityInfo(ApplicationInfo applicationInfo) {
        this.appFlags = applicationInfo.flags;
        if ((0x800 & applicationInfo.flags) != 0) {
            this.mCompatibilityFlags = 0x7E | this.mCompatibilityFlags;
        }
        if ((0x80000 & applicationInfo.flags) != 0) {
            this.mCompatibilityFlags = 0x66 | this.mCompatibilityFlags;
        }
        if ((0x1000 & applicationInfo.flags) != 0) {
            this.mCompatibilityFlags = 6 | this.mCompatibilityFlags;
        }
        if ((0x2000 & applicationInfo.flags) != 0) {
            this.applicationDensity = DisplayMetrics.DENSITY_DEVICE;
            this.applicationScale = 1.0f;
            this.applicationInvertedScale = 1.0f;
            return;
        }
        this.applicationDensity = 160;
        this.applicationScale = (float)DisplayMetrics.DENSITY_DEVICE / 160.0f;
        this.applicationInvertedScale = 1.0f / this.applicationScale;
        this.mCompatibilityFlags = 1 | this.mCompatibilityFlags;
    }

    public static void updateCompatibleScreenFrame(DisplayMetrics displayMetrics, int n, Rect rect) {
        int n2 = displayMetrics.widthPixels;
        int n3 = (int)(0.5f + 480.0f * displayMetrics.density);
        int n4 = (int)(0.5f + 320.0f * displayMetrics.density);
        if (n == 2) {
            int n5 = (n2 - n3) / 2;
            rect.set(n5, 0, n5 + n3, n4);
            return;
        }
        int n6 = (n2 - n4) / 2;
        rect.set(n6, 0, n6 + n4, n3);
    }

    public CompatibilityInfo copy() {
        return new CompatibilityInfo(this.appFlags, this.mCompatibilityFlags, this.applicationDensity, this.applicationScale, this.applicationInvertedScale);
    }

    public Translator getTranslator() {
        if (this.isScalingRequired()) {
            return new Translator();
        }
        return null;
    }

    public boolean isConfiguredExpandable() {
        return (4 & this.mCompatibilityFlags) != 0;
    }

    public boolean isConfiguredLargeScreens() {
        return (0x10 & this.mCompatibilityFlags) != 0;
    }

    public boolean isConfiguredXLargeScreens() {
        return (0x40 & this.mCompatibilityFlags) != 0;
    }

    public boolean isScalingRequired() {
        return (1 & this.mCompatibilityFlags) != 0;
    }

    public void setExpandable(boolean bl) {
        if (bl) {
            this.mCompatibilityFlags = 2 | this.mCompatibilityFlags;
            return;
        }
        this.mCompatibilityFlags = 0xFFFFFFFD & this.mCompatibilityFlags;
    }

    public void setLargeScreens(boolean bl) {
        if (bl) {
            this.mCompatibilityFlags = 8 | this.mCompatibilityFlags;
            return;
        }
        this.mCompatibilityFlags = 0xFFFFFFF7 & this.mCompatibilityFlags;
    }

    public void setXLargeScreens(boolean bl) {
        if (bl) {
            this.mCompatibilityFlags = 0x20 | this.mCompatibilityFlags;
            return;
        }
        this.mCompatibilityFlags = 0xFFFFFFDF & this.mCompatibilityFlags;
    }

    public boolean supportsScreen() {
        return (0xA & this.mCompatibilityFlags) == 10;
    }

    public String toString() {
        return "CompatibilityInfo{scale=" + this.applicationScale + ", supports screen=" + this.supportsScreen() + "}";
    }

    public class Translator {
        public final float applicationInvertedScale;
        public final float applicationScale;
        private Rect mContentInsetsBuffer = null;
        private Rect mVisibleInsetsBuffer = null;

        Translator() {
            this(compatibilityInfo.applicationScale, compatibilityInfo.applicationInvertedScale);
        }

        Translator(float f, float f2) {
            this.applicationScale = f;
            this.applicationInvertedScale = f2;
        }

        public Rect getTranslatedContentInsets(Rect rect) {
            if (this.mContentInsetsBuffer == null) {
                this.mContentInsetsBuffer = new Rect();
            }
            this.mContentInsetsBuffer.set(rect);
            this.translateRectInAppWindowToScreen(this.mContentInsetsBuffer);
            return this.mContentInsetsBuffer;
        }

        public Rect getTranslatedVisbileInsets(Rect rect) {
            if (this.mVisibleInsetsBuffer == null) {
                this.mVisibleInsetsBuffer = new Rect();
            }
            this.mVisibleInsetsBuffer.set(rect);
            this.translateRectInAppWindowToScreen(this.mVisibleInsetsBuffer);
            return this.mVisibleInsetsBuffer;
        }

        public void translateCanvas(Canvas canvas) {
            if (this.applicationScale == 1.5f) {
                canvas.translate(0.0026143792f, 0.0026143792f);
            }
            canvas.scale(this.applicationScale, this.applicationScale);
        }

        public void translateEventInScreenToAppWindow(MotionEvent motionEvent) {
            motionEvent.scale(this.applicationInvertedScale);
        }

        public void translateLayoutParamsInAppWindowToScreen(WindowManager.LayoutParams layoutParams) {
            layoutParams.scale(this.applicationScale);
        }

        public void translateRectInAppWindowToScreen(Rect rect) {
            rect.scale(this.applicationScale);
        }

        public void translateRectInScreenToAppWinFrame(Rect rect) {
            rect.scale(this.applicationInvertedScale);
        }

        public void translateRectInScreenToAppWindow(Rect rect) {
            rect.scale(this.applicationInvertedScale);
        }

        public void translateRegionInWindowToScreen(Region region) {
            region.scale(this.applicationScale);
        }

        public void translateWindowLayout(WindowManager.LayoutParams layoutParams) {
            layoutParams.scale(this.applicationScale);
        }
    }
}

