/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Annotation;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.BulletSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.LineHeightSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.util.SparseArray;
import com.android.internal.util.XmlUtils;

final class StringBlock {
    private static final String TAG = "AssetManager";
    private static final boolean localLOGV;
    private final int mNative;
    private final boolean mOwnsNative;
    private SparseArray<CharSequence> mSparseStrings;
    private CharSequence[] mStrings;
    StyleIDs mStyleIDs = null;
    private final boolean mUseSparse;

    StringBlock(int n, boolean bl) {
        this.mNative = n;
        this.mUseSparse = bl;
        this.mOwnsNative = false;
    }

    public StringBlock(byte[] byArray, int n, int n2, boolean bl) {
        this.mNative = StringBlock.nativeCreate(byArray, n, n2);
        this.mUseSparse = bl;
        this.mOwnsNative = true;
    }

    public StringBlock(byte[] byArray, boolean bl) {
        this.mNative = StringBlock.nativeCreate(byArray, 0, byArray.length);
        this.mUseSparse = bl;
        this.mOwnsNative = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void addParagraphSpan(Spannable spannable, Object object, int n, int n2) {
        int n3 = spannable.length();
        if (n != 0 && n != n3 && spannable.charAt(n - 1) != '\n') {
            --n;
            while (n > 0 && spannable.charAt(n - 1) != '\n') {
                --n;
            }
        }
        if (n2 != 0 && n2 != n3 && spannable.charAt(n2 - 1) != '\n') {
            ++n2;
            while (n2 < n3 && spannable.charAt(n2 - 1) != '\n') {
                ++n2;
            }
        }
        spannable.setSpan(object, n, n2, 51);
    }

    /*
     * Enabled aggressive block sorting
     */
    private CharSequence applyStyles(String string2, int[] nArray, StyleIDs styleIDs) {
        if (nArray.length == 0) {
            return string2;
        }
        SpannableString spannableString = new SpannableString(string2);
        int n = 0;
        int n2;
        while (n < (n2 = nArray.length)) {
            int n3 = nArray[n];
            if (n3 == styleIDs.boldId) {
                spannableString.setSpan(new StyleSpan(1), nArray[n + 1], 1 + nArray[n + 2], 33);
            } else if (n3 == styleIDs.italicId) {
                spannableString.setSpan(new StyleSpan(2), nArray[n + 1], 1 + nArray[n + 2], 33);
            } else if (n3 == styleIDs.underlineId) {
                spannableString.setSpan(new UnderlineSpan(), nArray[n + 1], 1 + nArray[n + 2], 33);
            } else if (n3 == styleIDs.ttId) {
                spannableString.setSpan(new TypefaceSpan("monospace"), nArray[n + 1], 1 + nArray[n + 2], 33);
            } else if (n3 == styleIDs.bigId) {
                spannableString.setSpan(new RelativeSizeSpan(1.25f), nArray[n + 1], 1 + nArray[n + 2], 33);
            } else if (n3 == styleIDs.smallId) {
                spannableString.setSpan(new RelativeSizeSpan(0.8f), nArray[n + 1], 1 + nArray[n + 2], 33);
            } else if (n3 == styleIDs.subId) {
                spannableString.setSpan(new SubscriptSpan(), nArray[n + 1], 1 + nArray[n + 2], 33);
            } else if (n3 == styleIDs.supId) {
                spannableString.setSpan(new SuperscriptSpan(), nArray[n + 1], 1 + nArray[n + 2], 33);
            } else if (n3 == styleIDs.strikeId) {
                spannableString.setSpan(new StrikethroughSpan(), nArray[n + 1], 1 + nArray[n + 2], 33);
            } else if (n3 == styleIDs.listItemId) {
                StringBlock.addParagraphSpan(spannableString, new BulletSpan(10), nArray[n + 1], 1 + nArray[n + 2]);
            } else if (n3 == styleIDs.marqueeId) {
                spannableString.setSpan((Object)TextUtils.TruncateAt.MARQUEE, nArray[n + 1], 1 + nArray[n + 2], 18);
            } else {
                String string3 = StringBlock.nativeGetString(this.mNative, n3);
                if (string3.startsWith("font;")) {
                    String string4;
                    String string5;
                    String string6;
                    String string7 = StringBlock.subtag(string3, ";height=");
                    if (string7 != null) {
                        int n4 = Integer.parseInt(string7);
                        Height height = new Height(n4);
                        StringBlock.addParagraphSpan(spannableString, height, nArray[n + 1], 1 + nArray[n + 2]);
                    }
                    if ((string6 = StringBlock.subtag(string3, ";size=")) != null) {
                        int n5 = Integer.parseInt(string6);
                        AbsoluteSizeSpan absoluteSizeSpan = new AbsoluteSizeSpan(n5, true);
                        spannableString.setSpan(absoluteSizeSpan, nArray[n + 1], 1 + nArray[n + 2], 33);
                    }
                    if ((string5 = StringBlock.subtag(string3, ";fgcolor=")) != null) {
                        int n6 = XmlUtils.convertValueToUnsignedInt(string5, -1);
                        ForegroundColorSpan foregroundColorSpan = new ForegroundColorSpan(n6);
                        spannableString.setSpan(foregroundColorSpan, nArray[n + 1], 1 + nArray[n + 2], 33);
                    }
                    if ((string4 = StringBlock.subtag(string3, ";bgcolor=")) != null) {
                        int n7 = XmlUtils.convertValueToUnsignedInt(string4, -1);
                        BackgroundColorSpan backgroundColorSpan = new BackgroundColorSpan(n7);
                        spannableString.setSpan(backgroundColorSpan, nArray[n + 1], 1 + nArray[n + 2], 33);
                    }
                } else if (string3.startsWith("a;")) {
                    String string8 = StringBlock.subtag(string3, ";href=");
                    if (string8 != null) {
                        URLSpan uRLSpan = new URLSpan(string8);
                        spannableString.setSpan(uRLSpan, nArray[n + 1], 1 + nArray[n + 2], 33);
                    }
                } else if (string3.startsWith("annotation;")) {
                    int n8;
                    int n9 = string3.length();
                    int n10 = string3.indexOf(59);
                    while (n10 < n9 && (n8 = string3.indexOf(61, n10)) >= 0) {
                        int n11 = string3.indexOf(59, n8);
                        if (n11 < 0) {
                            n11 = n9;
                        }
                        String string9 = string3.substring(n10 + 1, n8);
                        String string10 = string3.substring(n8 + 1, n11);
                        Annotation annotation = new Annotation(string9, string10);
                        spannableString.setSpan(annotation, nArray[n + 1], 1 + nArray[n + 2], 33);
                        n10 = n11;
                    }
                }
            }
            n += 3;
        }
        return new SpannedString(spannableString);
    }

    private static final native int nativeCreate(byte[] var0, int var1, int var2);

    private static final native void nativeDestroy(int var0);

    private static final native int nativeGetSize(int var0);

    private static final native String nativeGetString(int var0, int var1);

    private static final native int[] nativeGetStyle(int var0, int var1);

    private static final native int nativeIndexOfString(int var0, String var1);

    private static String subtag(String string2, String string3) {
        int n = string2.indexOf(string3);
        if (n < 0) {
            return null;
        }
        int n2 = n + string3.length();
        int n3 = string2.indexOf(59, n2);
        if (n3 < 0) {
            return string2.substring(n2);
        }
        return string2.substring(n2, n3);
    }

    protected void finalize() throws Throwable {
        if (this.mOwnsNative) {
            StringBlock.nativeDestroy(this.mNative);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CharSequence get(int n) {
        synchronized (this) {
            String string2;
            if (this.mStrings != null) {
                CharSequence charSequence = this.mStrings[n];
                if (charSequence != null) {
                    return charSequence;
                }
            } else if (this.mSparseStrings != null) {
                CharSequence charSequence = this.mSparseStrings.get(n);
                if (charSequence != null) {
                    return charSequence;
                }
            } else {
                int n2 = StringBlock.nativeGetSize(this.mNative);
                if (this.mUseSparse && n2 > 250) {
                    this.mSparseStrings = new SparseArray();
                } else {
                    this.mStrings = new CharSequence[n2];
                }
            }
            CharSequence charSequence = string2 = StringBlock.nativeGetString(this.mNative, n);
            int[] nArray = StringBlock.nativeGetStyle(this.mNative, n);
            if (nArray != null) {
                if (this.mStyleIDs == null) {
                    this.mStyleIDs = new StyleIDs();
                    StyleIDs.access$002(this.mStyleIDs, StringBlock.nativeIndexOfString(this.mNative, "b"));
                    StyleIDs.access$102(this.mStyleIDs, StringBlock.nativeIndexOfString(this.mNative, "i"));
                    StyleIDs.access$202(this.mStyleIDs, StringBlock.nativeIndexOfString(this.mNative, "u"));
                    StyleIDs.access$302(this.mStyleIDs, StringBlock.nativeIndexOfString(this.mNative, "tt"));
                    StyleIDs.access$402(this.mStyleIDs, StringBlock.nativeIndexOfString(this.mNative, "big"));
                    StyleIDs.access$502(this.mStyleIDs, StringBlock.nativeIndexOfString(this.mNative, "small"));
                    StyleIDs.access$602(this.mStyleIDs, StringBlock.nativeIndexOfString(this.mNative, "sup"));
                    StyleIDs.access$702(this.mStyleIDs, StringBlock.nativeIndexOfString(this.mNative, "sub"));
                    StyleIDs.access$802(this.mStyleIDs, StringBlock.nativeIndexOfString(this.mNative, "strike"));
                    StyleIDs.access$902(this.mStyleIDs, StringBlock.nativeIndexOfString(this.mNative, "li"));
                    StyleIDs.access$1002(this.mStyleIDs, StringBlock.nativeIndexOfString(this.mNative, "marquee"));
                }
                charSequence = this.applyStyles(string2, nArray, this.mStyleIDs);
            }
            if (this.mStrings != null) {
                this.mStrings[n] = charSequence;
            } else {
                this.mSparseStrings.put(n, charSequence);
            }
            return charSequence;
        }
    }

    private static class Height
    implements LineHeightSpan.WithDensity {
        private static float sProportion = 0.0f;
        private int mSize;

        public Height(int n) {
            this.mSize = n;
        }

        @Override
        public void chooseHeight(CharSequence charSequence, int n, int n2, int n3, int n4, Paint.FontMetricsInt fontMetricsInt) {
            this.chooseHeight(charSequence, n, n2, n3, n4, fontMetricsInt, null);
        }

        @Override
        public void chooseHeight(CharSequence charSequence, int n, int n2, int n3, int n4, Paint.FontMetricsInt fontMetricsInt, TextPaint textPaint) {
            int n5;
            int n6;
            int n7 = this.mSize;
            if (textPaint != null) {
                n7 = (int)((float)n7 * textPaint.density);
            }
            if (fontMetricsInt.bottom - fontMetricsInt.top < n7) {
                fontMetricsInt.top = fontMetricsInt.bottom - n7;
                fontMetricsInt.ascent -= n7;
                return;
            }
            if (sProportion == 0.0f) {
                Paint paint = new Paint();
                paint.setTextSize(100.0f);
                Rect rect = new Rect();
                paint.getTextBounds("ABCDEFG", 0, 7, rect);
                sProportion = (float)rect.top / paint.ascent();
            }
            if (n7 - fontMetricsInt.descent >= (n6 = (int)Math.ceil((float)(-fontMetricsInt.top) * sProportion))) {
                fontMetricsInt.top = fontMetricsInt.bottom - n7;
                fontMetricsInt.ascent = fontMetricsInt.descent - n7;
                return;
            }
            if (n7 >= n6) {
                int n8;
                int n9;
                fontMetricsInt.ascent = n9 = -n6;
                fontMetricsInt.top = n9;
                fontMetricsInt.descent = n8 = n7 + fontMetricsInt.top;
                fontMetricsInt.bottom = n8;
                return;
            }
            fontMetricsInt.ascent = n5 = -n7;
            fontMetricsInt.top = n5;
            fontMetricsInt.descent = 0;
            fontMetricsInt.bottom = 0;
        }
    }

    static final class StyleIDs {
        private int bigId;
        private int boldId;
        private int italicId;
        private int listItemId;
        private int marqueeId;
        private int smallId;
        private int strikeId;
        private int subId;
        private int supId;
        private int ttId;
        private int underlineId;

        StyleIDs() {
        }

        static /* synthetic */ int access$002(StyleIDs styleIDs, int n) {
            styleIDs.boldId = n;
            return n;
        }

        static /* synthetic */ int access$1002(StyleIDs styleIDs, int n) {
            styleIDs.marqueeId = n;
            return n;
        }

        static /* synthetic */ int access$102(StyleIDs styleIDs, int n) {
            styleIDs.italicId = n;
            return n;
        }

        static /* synthetic */ int access$202(StyleIDs styleIDs, int n) {
            styleIDs.underlineId = n;
            return n;
        }

        static /* synthetic */ int access$302(StyleIDs styleIDs, int n) {
            styleIDs.ttId = n;
            return n;
        }

        static /* synthetic */ int access$402(StyleIDs styleIDs, int n) {
            styleIDs.bigId = n;
            return n;
        }

        static /* synthetic */ int access$502(StyleIDs styleIDs, int n) {
            styleIDs.smallId = n;
            return n;
        }

        static /* synthetic */ int access$602(StyleIDs styleIDs, int n) {
            styleIDs.supId = n;
            return n;
        }

        static /* synthetic */ int access$702(StyleIDs styleIDs, int n) {
            styleIDs.subId = n;
            return n;
        }

        static /* synthetic */ int access$802(StyleIDs styleIDs, int n) {
            styleIDs.strikeId = n;
            return n;
        }

        static /* synthetic */ int access$902(StyleIDs styleIDs, int n) {
            styleIDs.listItemId = n;
            return n;
        }
    }
}

