/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.CursorWindow;
import android.database.DatabaseUtils;
import android.database.IBulkCursor;
import android.database.IContentObserver;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.Map;

final class BulkCursorProxy
implements IBulkCursor {
    private Bundle mExtras;
    private IBinder mRemote;

    public BulkCursorProxy(IBinder iBinder) {
        this.mRemote = iBinder;
        this.mExtras = null;
    }

    @Override
    public IBinder asBinder() {
        return this.mRemote;
    }

    @Override
    public void close() throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.content.IBulkCursor");
        this.mRemote.transact(12, parcel, parcel2, 0);
        DatabaseUtils.readExceptionFromParcel(parcel2);
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int count() throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.content.IBulkCursor");
        boolean bl = this.mRemote.transact(2, parcel, parcel2, 0);
        DatabaseUtils.readExceptionFromParcel(parcel2);
        int n = !bl ? -1 : parcel2.readInt();
        parcel.recycle();
        parcel2.recycle();
        return n;
    }

    @Override
    public void deactivate() throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.content.IBulkCursor");
        this.mRemote.transact(6, parcel, parcel2, 0);
        DatabaseUtils.readExceptionFromParcel(parcel2);
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean deleteRow(int n) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.content.IBulkCursor");
        parcel.writeInt(n);
        this.mRemote.transact(5, parcel, parcel2, 0);
        DatabaseUtils.readExceptionFromParcel(parcel2);
        boolean bl = parcel2.readInt() == 1;
        parcel.recycle();
        parcel2.recycle();
        return bl;
    }

    @Override
    public String[] getColumnNames() throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.content.IBulkCursor");
        this.mRemote.transact(3, parcel, parcel2, 0);
        DatabaseUtils.readExceptionFromParcel(parcel2);
        int n = parcel2.readInt();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = parcel2.readString();
        }
        parcel.recycle();
        parcel2.recycle();
        return stringArray;
    }

    @Override
    public Bundle getExtras() throws RemoteException {
        if (this.mExtras == null) {
            Parcel parcel = Parcel.obtain();
            Parcel parcel2 = Parcel.obtain();
            parcel.writeInterfaceToken("android.content.IBulkCursor");
            this.mRemote.transact(10, parcel, parcel2, 0);
            DatabaseUtils.readExceptionFromParcel(parcel2);
            this.mExtras = parcel2.readBundle();
            parcel.recycle();
            parcel2.recycle();
        }
        return this.mExtras;
    }

    @Override
    public boolean getWantsAllOnMoveCalls() throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.content.IBulkCursor");
        this.mRemote.transact(9, parcel, parcel2, 0);
        DatabaseUtils.readExceptionFromParcel(parcel2);
        int n = parcel2.readInt();
        parcel.recycle();
        parcel2.recycle();
        return n != 0;
    }

    @Override
    public CursorWindow getWindow(int n) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.content.IBulkCursor");
        parcel.writeInt(n);
        this.mRemote.transact(1, parcel, parcel2, 0);
        DatabaseUtils.readExceptionFromParcel(parcel2);
        int n2 = parcel2.readInt();
        CursorWindow cursorWindow = null;
        if (n2 == 1) {
            cursorWindow = CursorWindow.newFromParcel(parcel2);
        }
        parcel.recycle();
        parcel2.recycle();
        return cursorWindow;
    }

    @Override
    public void onMove(int n) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.content.IBulkCursor");
        parcel.writeInt(n);
        this.mRemote.transact(8, parcel, parcel2, 0);
        DatabaseUtils.readExceptionFromParcel(parcel2);
        parcel.recycle();
        parcel2.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int requery(IContentObserver iContentObserver, CursorWindow cursorWindow) throws RemoteException {
        int n;
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.content.IBulkCursor");
        parcel.writeStrongInterface(iContentObserver);
        cursorWindow.writeToParcel(parcel, 0);
        boolean bl = this.mRemote.transact(7, parcel, parcel2, 0);
        DatabaseUtils.readExceptionFromParcel(parcel2);
        if (!bl) {
            n = -1;
        } else {
            n = parcel2.readInt();
            this.mExtras = parcel2.readBundle();
        }
        parcel.recycle();
        parcel2.recycle();
        return n;
    }

    @Override
    public Bundle respond(Bundle bundle) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.content.IBulkCursor");
        parcel.writeBundle(bundle);
        this.mRemote.transact(11, parcel, parcel2, 0);
        DatabaseUtils.readExceptionFromParcel(parcel2);
        Bundle bundle2 = parcel2.readBundle();
        parcel.recycle();
        parcel2.recycle();
        return bundle2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean updateRows(Map map) throws RemoteException {
        Parcel parcel = Parcel.obtain();
        Parcel parcel2 = Parcel.obtain();
        parcel.writeInterfaceToken("android.content.IBulkCursor");
        parcel.writeMap(map);
        this.mRemote.transact(4, parcel, parcel2, 0);
        DatabaseUtils.readExceptionFromParcel(parcel2);
        boolean bl = parcel2.readInt() == 1;
        parcel.recycle();
        parcel2.recycle();
        return bl;
    }
}

