/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.AbstractCursor;
import android.database.AbstractWindowedCursor;
import android.database.CursorWindow;
import android.database.IBulkCursor;
import android.database.IContentObserver;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;

public final class BulkCursorToCursorAdaptor
extends AbstractWindowedCursor {
    private static final String TAG = "BulkCursor";
    private IBulkCursor mBulkCursor;
    private String[] mColumns;
    private int mCount;
    private AbstractCursor.SelfContentObserver mObserverBridge;
    private boolean mWantsAllOnMoveCalls;

    public static int findRowIdColumnIndex(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals("_id")) continue;
            return i;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        super.close();
        try {
            this.mBulkCursor.close();
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Remote process exception when closing");
        }
        this.mWindow = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean commitUpdates(Map<? extends Long, ? extends Map<String, Object>> map) {
        if (!this.supportsUpdates()) {
            Log.e(TAG, "commitUpdates not supported on this cursor, did you include the _id column?");
            return false;
        }
        HashMap hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            if (map != null) {
                this.mUpdatedRows.putAll(map);
            }
            if (this.mUpdatedRows.size() <= 0) {
                return false;
            }
            try {
                boolean bl = this.mBulkCursor.updateRows(this.mUpdatedRows);
                if (bl) {
                    this.mUpdatedRows.clear();
                    this.onChange(true);
                }
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Unable to commit updates because the remote process is dead");
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deactivate() {
        super.deactivate();
        try {
            this.mBulkCursor.deactivate();
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Remote process exception when deactivating");
        }
        this.mWindow = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteRow() {
        try {
            boolean bl = this.mBulkCursor.deleteRow(this.mPos);
            if (!bl) return bl;
            this.mWindow = null;
            this.mCount = this.mBulkCursor.count();
            if (this.mPos < this.mCount) {
                int n = this.mPos;
                this.mPos = -1;
                this.moveToPosition(n);
            } else {
                this.mPos = this.mCount;
            }
            this.onChange(true);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Unable to delete row because the remote process is dead");
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String[] getColumnNames() {
        if (this.mColumns != null) return this.mColumns;
        try {
            this.mColumns = this.mBulkCursor.getColumnNames();
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Unable to fetch column names because the remote process is dead");
            return null;
        }
        return this.mColumns;
    }

    @Override
    public int getCount() {
        return this.mCount;
    }

    @Override
    public Bundle getExtras() {
        try {
            Bundle bundle = this.mBulkCursor.getExtras();
            return bundle;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public IContentObserver getObserver() {
        synchronized (this) {
            if (this.mObserverBridge == null) {
                this.mObserverBridge = new AbstractCursor.SelfContentObserver(this);
            }
            IContentObserver iContentObserver = this.mObserverBridge.getContentObserver();
            return iContentObserver;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean onMove(int n, int n2) {
        try {
            if (this.mWindow != null) {
                if (n2 < this.mWindow.getStartPosition() || n2 >= this.mWindow.getStartPosition() + this.mWindow.getNumRows()) {
                    this.mWindow = this.mBulkCursor.getWindow(n2);
                    return this.mWindow != null;
                }
                if (!this.mWantsAllOnMoveCalls) return this.mWindow != null;
                this.mBulkCursor.onMove(n2);
                return this.mWindow != null;
            }
            this.mWindow = this.mBulkCursor.getWindow(n2);
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Unable to get window because the remote process is dead");
            return false;
        }
        return this.mWindow != null;
    }

    @Override
    public boolean requery() {
        block3: {
            try {
                this.mCount = this.mBulkCursor.requery(this.getObserver(), new CursorWindow(false));
                if (this.mCount == -1) break block3;
                this.mPos = -1;
                this.mWindow = null;
                super.requery();
                return true;
            }
            catch (Exception exception) {
                Log.e(TAG, "Unable to requery because the remote process exception " + exception.getMessage());
                this.deactivate();
                return false;
            }
        }
        this.deactivate();
        return false;
    }

    @Override
    public Bundle respond(Bundle bundle) {
        try {
            Bundle bundle2 = this.mBulkCursor.respond(bundle);
            return bundle2;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "respond() threw RemoteException, returning an empty bundle.", remoteException);
            return Bundle.EMPTY;
        }
    }

    public void set(IBulkCursor iBulkCursor) {
        this.mBulkCursor = iBulkCursor;
        try {
            this.mCount = this.mBulkCursor.count();
            this.mWantsAllOnMoveCalls = this.mBulkCursor.getWantsAllOnMoveCalls();
            this.mColumns = this.mBulkCursor.getColumnNames();
            this.mRowIdColumnIndex = BulkCursorToCursorAdaptor.findRowIdColumnIndex(this.mColumns);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Setup failed because the remote process is dead");
            return;
        }
    }

    public void set(IBulkCursor iBulkCursor, int n, int n2) {
        this.mBulkCursor = iBulkCursor;
        this.mColumns = null;
        this.mCount = n;
        this.mRowIdColumnIndex = n2;
    }
}

