/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.AbstractWindowedCursor;
import android.database.BulkCursorNative;
import android.database.ContentObserver;
import android.database.CrossProcessCursor;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.IContentObserver;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.util.Map;

public final class CursorToBulkCursorAdaptor
extends BulkCursorNative
implements IBinder.DeathRecipient {
    private static final String TAG = "Cursor";
    private final CrossProcessCursor mCursor;
    private ContentObserverProxy mObserver;
    private final String mProviderName;
    private final boolean mReadOnly;
    private CursorWindow mWindow;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CursorToBulkCursorAdaptor(Cursor cursor, IContentObserver iContentObserver, String string2, boolean bl, CursorWindow cursorWindow) {
        boolean bl2;
        try {
            this.mCursor = (CrossProcessCursor)cursor;
            if (this.mCursor instanceof AbstractWindowedCursor) {
                AbstractWindowedCursor abstractWindowedCursor = (AbstractWindowedCursor)cursor;
                if (abstractWindowedCursor.hasWindow() && Log.isLoggable(TAG, 2)) {
                    Log.v(TAG, "Cross process cursor has a local window before setWindow in " + string2, new RuntimeException());
                }
                abstractWindowedCursor.setWindow(cursorWindow);
            } else {
                this.mWindow = cursorWindow;
                this.mCursor.fillWindow(0, cursorWindow);
            }
            this.mProviderName = string2;
            bl2 = !bl;
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("Only CrossProcessCursor cursors are supported across process for now", classCastException);
        }
        this.mReadOnly = bl2;
        this.createAndRegisterObserverProxy(iContentObserver);
    }

    private void createAndRegisterObserverProxy(IContentObserver iContentObserver) {
        if (this.mObserver != null) {
            throw new IllegalStateException("an observer is already registered");
        }
        this.mObserver = new ContentObserverProxy(iContentObserver, this);
        this.mCursor.registerContentObserver(this.mObserver);
    }

    private void maybeUnregisterObserverProxy() {
        if (this.mObserver != null) {
            this.mCursor.unregisterContentObserver(this.mObserver);
            this.mObserver.unlinkToDeath(this);
            this.mObserver = null;
        }
    }

    @Override
    public void binderDied() {
        this.mCursor.close();
        if (this.mWindow != null) {
            this.mWindow.close();
        }
    }

    @Override
    public void close() {
        this.maybeUnregisterObserverProxy();
        this.mCursor.close();
    }

    @Override
    public int count() {
        return this.mCursor.getCount();
    }

    @Override
    public void deactivate() {
        this.maybeUnregisterObserverProxy();
        this.mCursor.deactivate();
    }

    @Override
    public boolean deleteRow(int n) {
        if (this.mReadOnly) {
            Log.w("ContentProvider", "Permission Denial: modifying " + this.mProviderName + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return false;
        }
        if (!this.mCursor.moveToPosition(n)) {
            return false;
        }
        return this.mCursor.deleteRow();
    }

    @Override
    public String[] getColumnNames() {
        return this.mCursor.getColumnNames();
    }

    @Override
    public Bundle getExtras() {
        return this.mCursor.getExtras();
    }

    @Override
    public boolean getWantsAllOnMoveCalls() {
        return this.mCursor.getWantsAllOnMoveCalls();
    }

    @Override
    public CursorWindow getWindow(int n) {
        this.mCursor.moveToPosition(n);
        if (this.mWindow != null) {
            if (n < this.mWindow.getStartPosition() || n >= this.mWindow.getStartPosition() + this.mWindow.getNumRows()) {
                this.mCursor.fillWindow(n, this.mWindow);
            }
            return this.mWindow;
        }
        return ((AbstractWindowedCursor)this.mCursor).getWindow();
    }

    @Override
    public void onMove(int n) {
        this.mCursor.onMove(this.mCursor.getPosition(), n);
    }

    @Override
    public int requery(IContentObserver iContentObserver, CursorWindow cursorWindow) {
        if (this.mWindow == null) {
            ((AbstractWindowedCursor)this.mCursor).setWindow(cursorWindow);
        }
        try {
            boolean bl = this.mCursor.requery();
            if (!bl) {
                return -1;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalStateException(this.mProviderName + " Requery misuse db, mCursor isClosed:" + this.mCursor.isClosed(), illegalStateException);
        }
        if (this.mWindow != null) {
            this.mCursor.fillWindow(0, cursorWindow);
            this.mWindow = cursorWindow;
        }
        this.maybeUnregisterObserverProxy();
        this.createAndRegisterObserverProxy(iContentObserver);
        return this.mCursor.getCount();
    }

    @Override
    public Bundle respond(Bundle bundle) {
        return this.mCursor.respond(bundle);
    }

    @Override
    public boolean updateRows(Map<? extends Long, ? extends Map<String, Object>> map) {
        if (this.mReadOnly) {
            Log.w("ContentProvider", "Permission Denial: modifying " + this.mProviderName + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return false;
        }
        return this.mCursor.commitUpdates(map);
    }

    private static final class ContentObserverProxy
    extends ContentObserver {
        protected IContentObserver mRemote;

        public ContentObserverProxy(IContentObserver iContentObserver, IBinder.DeathRecipient deathRecipient) {
            super(null);
            this.mRemote = iContentObserver;
            try {
                iContentObserver.asBinder().linkToDeath(deathRecipient, 0);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public boolean deliverSelfNotifications() {
            return false;
        }

        @Override
        public void onChange(boolean bl) {
            try {
                this.mRemote.onChange(bl);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public boolean unlinkToDeath(IBinder.DeathRecipient deathRecipient) {
            return this.mRemote.asBinder().unlinkToDeath(deathRecipient, 0);
        }
    }
}

