/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.DatabaseObjectNotClosedException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDebug;
import android.os.StrictMode;
import android.util.Log;

class SQLiteCompiledSql {
    private static final String TAG = "SQLiteCompiledSql";
    SQLiteDatabase mDatabase;
    private boolean mInUse = false;
    private String mSqlStmt = null;
    private Throwable mStackTrace = null;
    int nHandle = 0;
    int nStatement = 0;

    SQLiteCompiledSql(SQLiteDatabase sQLiteDatabase, String string2) {
        if (!sQLiteDatabase.isOpen()) {
            throw new IllegalStateException("database " + sQLiteDatabase.getPath() + " already closed");
        }
        this.mDatabase = sQLiteDatabase;
        this.mSqlStmt = string2;
        this.mStackTrace = new DatabaseObjectNotClosedException().fillInStackTrace();
        this.nHandle = sQLiteDatabase.mNativeHandle;
        this.compile(string2, true);
    }

    private void compile(String string2, boolean bl) {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        if (bl) {
            this.mDatabase.lock();
            this.native_compile(string2);
        }
        return;
        finally {
            this.mDatabase.unlock();
        }
    }

    private final native void native_compile(String var1);

    private final native void native_finalize();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean acquire() {
        synchronized (this) {
            block4: {
                boolean bl = this.mInUse;
                if (!bl) break block4;
                return false;
            }
            this.mInUse = true;
            if (!SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) return true;
            Log.v(TAG, "Acquired DbObj (id#" + this.nStatement + ") from DB cache");
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        int n = 100;
        try {
            int n2 = this.nStatement;
            if (n2 == 0) {
                return;
            }
            if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
                Log.v(TAG, "** warning ** Finalized DbObj (id#" + this.nStatement + ")");
            }
            if (StrictMode.vmSqliteObjectLeaksEnabled()) {
                int n3 = this.mSqlStmt.length();
                StringBuilder stringBuilder = new StringBuilder().append("Releasing statement in a finalizer. Please ensure that you explicitly call close() on your cursor: ");
                String string2 = this.mSqlStmt;
                if (n3 <= n) {
                    n = n3;
                }
                StrictMode.onSqliteObjectLeaked((String)stringBuilder.append(string2.substring(0, n)).toString(), (Throwable)this.mStackTrace);
            }
            this.releaseSqlStatement();
            return;
        }
        finally {
            super.finalize();
        }
    }

    void release() {
        synchronized (this) {
            if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
                Log.v(TAG, "Released DbObj (id#" + this.nStatement + ") back to DB cache");
            }
            this.mInUse = false;
            return;
        }
    }

    void releaseSqlStatement() {
        if (this.nStatement != 0) {
            if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
                Log.v(TAG, "closed and deallocated DbObj (id#" + this.nStatement + ")");
            }
            this.mDatabase.lock();
            this.native_finalize();
            this.nStatement = 0;
        }
        return;
        finally {
            this.mDatabase.unlock();
        }
    }
}

