/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.util.Log;
import android.widget.Toast;

public final class SqliteWrapper {
    private static final String SQLITE_EXCEPTION_DETAIL_MESSAGE = "unable to open database file";
    private static final String TAG = "SqliteWrapper";

    private SqliteWrapper() {
    }

    public static void checkSQLiteException(Context context, SQLiteException sQLiteException) {
        if (SqliteWrapper.isLowMemory(sQLiteException)) {
            Toast.makeText(context, 17039628, 0).show();
            return;
        }
        throw sQLiteException;
    }

    public static int delete(Context context, ContentResolver contentResolver, Uri uri, String string2, String[] stringArray) {
        try {
            int n = contentResolver.delete(uri, string2, stringArray);
            return n;
        }
        catch (SQLiteException sQLiteException) {
            Log.e(TAG, "Catch a SQLiteException when delete: ", sQLiteException);
            SqliteWrapper.checkSQLiteException(context, sQLiteException);
            return -1;
        }
    }

    public static Uri insert(Context context, ContentResolver contentResolver, Uri uri, ContentValues contentValues) {
        try {
            Uri uri2 = contentResolver.insert(uri, contentValues);
            return uri2;
        }
        catch (SQLiteException sQLiteException) {
            Log.e(TAG, "Catch a SQLiteException when insert: ", sQLiteException);
            SqliteWrapper.checkSQLiteException(context, sQLiteException);
            return null;
        }
    }

    private static boolean isLowMemory(SQLiteException sQLiteException) {
        return sQLiteException.getMessage().equals(SQLITE_EXCEPTION_DETAIL_MESSAGE);
    }

    public static Cursor query(Context context, ContentResolver contentResolver, Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        try {
            Cursor cursor = contentResolver.query(uri, stringArray, string2, stringArray2, string3);
            return cursor;
        }
        catch (SQLiteException sQLiteException) {
            Log.e(TAG, "Catch a SQLiteException when query: ", sQLiteException);
            SqliteWrapper.checkSQLiteException(context, sQLiteException);
            return null;
        }
    }

    public static boolean requery(Context context, Cursor cursor) {
        try {
            boolean bl = cursor.requery();
            return bl;
        }
        catch (SQLiteException sQLiteException) {
            Log.e(TAG, "Catch a SQLiteException when requery: ", sQLiteException);
            SqliteWrapper.checkSQLiteException(context, sQLiteException);
            return false;
        }
    }

    public static int update(Context context, ContentResolver contentResolver, Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        try {
            int n = contentResolver.update(uri, contentValues, string2, stringArray);
            return n;
        }
        catch (SQLiteException sQLiteException) {
            Log.e(TAG, "Catch a SQLiteException when update: ", sQLiteException);
            SqliteWrapper.checkSQLiteException(context, sQLiteException);
            return -1;
        }
    }
}

