/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import android.ddm.DdmHandleAppName;
import android.os.Debug;
import android.os.Process;
import java.nio.ByteBuffer;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;

public class DdmHandleHello
extends ChunkHandler {
    public static final int CHUNK_FEAT;
    public static final int CHUNK_HELO;
    public static final int CHUNK_WAIT;
    private static DdmHandleHello mInstance;

    static {
        CHUNK_HELO = DdmHandleHello.type((String)"HELO");
        CHUNK_WAIT = DdmHandleHello.type((String)"WAIT");
        CHUNK_FEAT = DdmHandleHello.type((String)"FEAT");
        mInstance = new DdmHandleHello();
    }

    private DdmHandleHello() {
    }

    private Chunk handleFEAT(Chunk chunk) {
        String[] stringArray = Debug.getVmFeatureList();
        int n = 4 + 4 * stringArray.length;
        for (int i = stringArray.length - 1; i >= 0; --i) {
            n += 2 * stringArray[i].length();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.order(ChunkHandler.CHUNK_ORDER);
        byteBuffer.putInt(stringArray.length);
        for (int i = stringArray.length - 1; i >= 0; --i) {
            byteBuffer.putInt(stringArray[i].length());
            DdmHandleHello.putString((ByteBuffer)byteBuffer, (String)stringArray[i]);
        }
        return new Chunk(CHUNK_FEAT, byteBuffer);
    }

    private Chunk handleHELO(Chunk chunk) {
        DdmHandleHello.wrapChunk((Chunk)chunk).getInt();
        String string2 = System.getProperty("java.vm.name", "?");
        String string3 = System.getProperty("java.vm.version", "?");
        String string4 = string2 + " v" + string3;
        String string5 = DdmHandleAppName.getAppName();
        ByteBuffer byteBuffer = ByteBuffer.allocate(16 + 2 * string4.length() + 2 * string5.length());
        byteBuffer.order(ChunkHandler.CHUNK_ORDER);
        byteBuffer.putInt(1);
        byteBuffer.putInt(Process.myPid());
        byteBuffer.putInt(string4.length());
        byteBuffer.putInt(string5.length());
        DdmHandleHello.putString((ByteBuffer)byteBuffer, (String)string4);
        DdmHandleHello.putString((ByteBuffer)byteBuffer, (String)string5);
        Chunk chunk2 = new Chunk(CHUNK_HELO, byteBuffer);
        if (Debug.waitingForDebugger()) {
            DdmHandleHello.sendWAIT(0);
        }
        return chunk2;
    }

    public static void register() {
        DdmServer.registerHandler((int)CHUNK_HELO, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_FEAT, (ChunkHandler)mInstance);
    }

    public static void sendWAIT(int n) {
        byte[] byArray = new byte[]{(byte)n};
        DdmServer.sendChunk((Chunk)new Chunk(CHUNK_WAIT, byArray, 0, 1));
    }

    public void connected() {
    }

    public void disconnected() {
    }

    public Chunk handleChunk(Chunk chunk) {
        int n = chunk.type;
        if (n == CHUNK_HELO) {
            return this.handleHELO(chunk);
        }
        if (n == CHUNK_FEAT) {
            return this.handleFEAT(chunk);
        }
        throw new RuntimeException("Unknown packet " + ChunkHandler.name((int)n));
    }
}

