/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import android.os.Debug;
import android.util.Log;
import java.nio.ByteBuffer;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;

public class DdmHandleProfiling
extends ChunkHandler {
    public static final int CHUNK_MPRE;
    public static final int CHUNK_MPRQ;
    public static final int CHUNK_MPRS;
    public static final int CHUNK_MPSE;
    public static final int CHUNK_MPSS;
    private static DdmHandleProfiling mInstance;

    static {
        CHUNK_MPRS = DdmHandleProfiling.type((String)"MPRS");
        CHUNK_MPRE = DdmHandleProfiling.type((String)"MPRE");
        CHUNK_MPSS = DdmHandleProfiling.type((String)"MPSS");
        CHUNK_MPSE = DdmHandleProfiling.type((String)"MPSE");
        CHUNK_MPRQ = DdmHandleProfiling.type((String)"MPRQ");
        mInstance = new DdmHandleProfiling();
    }

    private DdmHandleProfiling() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Chunk handleMPRE(Chunk chunk) {
        byte by;
        try {
            Debug.stopMethodTracing();
            by = 0;
        }
        catch (RuntimeException runtimeException) {
            Log.w("ddm-heap", "Method profiling end failed: " + runtimeException.getMessage());
            by = 1;
        }
        byte[] byArray = new byte[]{by};
        return new Chunk(CHUNK_MPRE, byArray, 0, byArray.length);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Chunk handleMPRQ(Chunk chunk) {
        boolean bl = Debug.isMethodTracingActive();
        byte[] byArray = new byte[]{(byte)(bl ? 1 : 0)};
        return new Chunk(CHUNK_MPRQ, byArray, 0, byArray.length);
    }

    private Chunk handleMPRS(Chunk chunk) {
        ByteBuffer byteBuffer = DdmHandleProfiling.wrapChunk((Chunk)chunk);
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        String string2 = DdmHandleProfiling.getString((ByteBuffer)byteBuffer, (int)byteBuffer.getInt());
        try {
            Debug.startMethodTracing(string2, n, n2);
            return null;
        }
        catch (RuntimeException runtimeException) {
            return DdmHandleProfiling.createFailChunk((int)1, (String)runtimeException.getMessage());
        }
    }

    private Chunk handleMPSE(Chunk chunk) {
        try {
            Debug.stopMethodTracing();
            return null;
        }
        catch (RuntimeException runtimeException) {
            Log.w("ddm-heap", "Method prof stream end failed: " + runtimeException.getMessage());
            return DdmHandleProfiling.createFailChunk((int)1, (String)runtimeException.getMessage());
        }
    }

    private Chunk handleMPSS(Chunk chunk) {
        ByteBuffer byteBuffer = DdmHandleProfiling.wrapChunk((Chunk)chunk);
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        try {
            Debug.startMethodTracingDdms((int)n, (int)n2);
            return null;
        }
        catch (RuntimeException runtimeException) {
            return DdmHandleProfiling.createFailChunk((int)1, (String)runtimeException.getMessage());
        }
    }

    public static void register() {
        DdmServer.registerHandler((int)CHUNK_MPRS, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_MPRE, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_MPSS, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_MPSE, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_MPRQ, (ChunkHandler)mInstance);
    }

    public void connected() {
    }

    public void disconnected() {
    }

    public Chunk handleChunk(Chunk chunk) {
        int n = chunk.type;
        if (n == CHUNK_MPRS) {
            return this.handleMPRS(chunk);
        }
        if (n == CHUNK_MPRE) {
            return this.handleMPRE(chunk);
        }
        if (n == CHUNK_MPSS) {
            return this.handleMPSS(chunk);
        }
        if (n == CHUNK_MPSE) {
            return this.handleMPSE(chunk);
        }
        if (n == CHUNK_MPRQ) {
            return this.handleMPRQ(chunk);
        }
        throw new RuntimeException("Unknown packet " + ChunkHandler.name((int)n));
    }
}

