/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import java.nio.ByteBuffer;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;
import org.apache.harmony.dalvik.ddmc.DdmVmInternal;

public class DdmHandleThread
extends ChunkHandler {
    public static final int CHUNK_STKL;
    public static final int CHUNK_THCR;
    public static final int CHUNK_THDE;
    public static final int CHUNK_THEN;
    public static final int CHUNK_THST;
    private static DdmHandleThread mInstance;

    static {
        CHUNK_THEN = DdmHandleThread.type((String)"THEN");
        CHUNK_THCR = DdmHandleThread.type((String)"THCR");
        CHUNK_THDE = DdmHandleThread.type((String)"THDE");
        CHUNK_THST = DdmHandleThread.type((String)"THST");
        CHUNK_STKL = DdmHandleThread.type((String)"STKL");
        mInstance = new DdmHandleThread();
    }

    private DdmHandleThread() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private Chunk createStackChunk(StackTraceElement[] stackTraceElementArray, int n) {
        int n2 = 4 + (4 + (0 + 4));
        int n3 = stackTraceElementArray.length;
        for (int i = 0; i < n3; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            int n4 = 4 + (n2 + (4 + 2 * stackTraceElement.getClassName().length()) + (4 + 2 * stackTraceElement.getMethodName().length()));
            if (stackTraceElement.getFileName() != null) {
                n4 += 2 * stackTraceElement.getFileName().length();
            }
            n2 = n4 + 4;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer.putInt(0);
        byteBuffer.putInt(n);
        byteBuffer.putInt(stackTraceElementArray.length);
        int n5 = stackTraceElementArray.length;
        int n6 = 0;
        while (n6 < n5) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n6];
            byteBuffer.putInt(stackTraceElement.getClassName().length());
            DdmHandleThread.putString((ByteBuffer)byteBuffer, (String)stackTraceElement.getClassName());
            byteBuffer.putInt(stackTraceElement.getMethodName().length());
            DdmHandleThread.putString((ByteBuffer)byteBuffer, (String)stackTraceElement.getMethodName());
            if (stackTraceElement.getFileName() != null) {
                byteBuffer.putInt(stackTraceElement.getFileName().length());
                DdmHandleThread.putString((ByteBuffer)byteBuffer, (String)stackTraceElement.getFileName());
            } else {
                byteBuffer.putInt(0);
            }
            byteBuffer.putInt(stackTraceElement.getLineNumber());
            ++n6;
        }
        return new Chunk(CHUNK_STKL, byteBuffer);
    }

    private Chunk handleSTKL(Chunk chunk) {
        int n = DdmHandleThread.wrapChunk((Chunk)chunk).getInt();
        StackTraceElement[] stackTraceElementArray = DdmVmInternal.getStackTraceById((int)n);
        if (stackTraceElementArray == null) {
            return DdmHandleThread.createFailChunk((int)1, (String)"Stack trace unavailable");
        }
        return this.createStackChunk(stackTraceElementArray, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Chunk handleTHEN(Chunk chunk) {
        boolean bl = DdmHandleThread.wrapChunk((Chunk)chunk).get() != 0;
        DdmVmInternal.threadNotify((boolean)bl);
        return null;
    }

    private Chunk handleTHST(Chunk chunk) {
        DdmHandleThread.wrapChunk((Chunk)chunk);
        byte[] byArray = DdmVmInternal.getThreadStats();
        if (byArray != null) {
            return new Chunk(CHUNK_THST, byArray, 0, byArray.length);
        }
        return DdmHandleThread.createFailChunk((int)1, (String)"Can't build THST chunk");
    }

    public static void register() {
        DdmServer.registerHandler((int)CHUNK_THEN, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_THST, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_STKL, (ChunkHandler)mInstance);
    }

    public void connected() {
    }

    public void disconnected() {
    }

    public Chunk handleChunk(Chunk chunk) {
        int n = chunk.type;
        if (n == CHUNK_THEN) {
            return this.handleTHEN(chunk);
        }
        if (n == CHUNK_THST) {
            return this.handleTHST(chunk);
        }
        if (n == CHUNK_STKL) {
            return this.handleSTKL(chunk);
        }
        throw new RuntimeException("Unknown packet " + ChunkHandler.name((int)n));
    }
}

