/*
 * Decompiled with CFR 0.152.
 */
package android.drm.mobile1;

import android.drm.mobile1.DrmException;
import android.drm.mobile1.DrmRights;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DrmRawContent {
    public static final int DRM_COMBINED_DELIVERY = 2;
    public static final int DRM_FORWARD_LOCK = 1;
    private static final int DRM_MIMETYPE_CONTENT = 2;
    public static final String DRM_MIMETYPE_CONTENT_STRING = "application/vnd.oma.drm.content";
    private static final int DRM_MIMETYPE_MESSAGE = 1;
    public static final String DRM_MIMETYPE_MESSAGE_STRING = "application/vnd.oma.drm.message";
    public static final int DRM_SEPARATE_DELIVERY = 3;
    public static final int DRM_SEPARATE_DELIVERY_DM = 4;
    public static final int DRM_UNKNOWN_DATA_LEN = -1;
    private static final int JNI_DRM_EOF = -2;
    private static final int JNI_DRM_FAILURE = -1;
    private static final int JNI_DRM_SUCCESS = 0;
    private static final int JNI_DRM_UNKNOWN_DATA_LEN = -3;
    private int id = -1;
    private BufferedInputStream inData;
    private int inDataLen;
    private String mediaType;
    private int rawType;
    private String rightsIssuer;

    static {
        try {
            System.loadLibrary("drm1_jni");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("WARNING: Could not load libdrm1_jni.so");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public DrmRawContent(InputStream inputStream, int n, String string2) throws DrmException, IOException {
        int n2;
        this.inData = new BufferedInputStream(inputStream, 1024);
        this.inDataLen = n;
        if (DRM_MIMETYPE_MESSAGE_STRING.equals(string2)) {
            n2 = 1;
        } else {
            if (!DRM_MIMETYPE_CONTENT_STRING.equals(string2)) {
                throw new IllegalArgumentException("mimeType must be DRM_MIMETYPE_MESSAGE or DRM_MIMETYPE_CONTENT");
            }
            n2 = 2;
        }
        if (n <= 0) {
            throw new IllegalArgumentException("len must be > 0");
        }
        this.id = this.nativeConstructDrmContent(this.inData, this.inDataLen, n2);
        if (-1 == this.id) {
            throw new DrmException("nativeConstructDrmContent() returned JNI_DRM_FAILURE");
        }
        this.rightsIssuer = this.nativeGetRightsAddress();
        this.rawType = this.nativeGetDeliveryMethod();
        if (-1 == this.rawType) {
            throw new DrmException("nativeGetDeliveryMethod() returned JNI_DRM_FAILURE");
        }
        this.mediaType = this.nativeGetContentType();
        if (this.mediaType == null) {
            throw new DrmException("nativeGetContentType() returned null");
        }
    }

    private native int nativeConstructDrmContent(InputStream var1, int var2, int var3);

    private native int nativeGetContentLength();

    private native String nativeGetContentType();

    private native int nativeGetDeliveryMethod();

    private native String nativeGetRightsAddress();

    private native int nativeReadContent(byte[] var1, int var2, int var3, int var4);

    protected native void finalize();

    public InputStream getContentInputStream(DrmRights drmRights) {
        if (drmRights == null) {
            throw new NullPointerException();
        }
        return new DrmInputStream(drmRights);
    }

    public int getContentLength(DrmRights drmRights) throws DrmException {
        if (drmRights == null) {
            throw new NullPointerException();
        }
        int n = this.nativeGetContentLength();
        if (-1 == n) {
            throw new DrmException("nativeGetContentLength() returned JNI_DRM_FAILURE");
        }
        if (-3 == n) {
            return -1;
        }
        return n;
    }

    public String getContentType() {
        return this.mediaType;
    }

    public int getRawType() {
        return this.rawType;
    }

    public String getRightsAddress() {
        return this.rightsIssuer;
    }

    class DrmInputStream
    extends InputStream {
        private byte[] b = new byte[1];
        private boolean isClosed = false;
        private int offset = 0;

        public DrmInputStream(DrmRights drmRights) {
        }

        @Override
        public int available() throws IOException {
            int n = DrmRawContent.this.nativeGetContentLength();
            if (-1 == n) {
                throw new IOException();
            }
            if (-3 == n) {
                return 0;
            }
            int n2 = n - this.offset;
            if (n2 < 0) {
                throw new IOException();
            }
            return n2;
        }

        @Override
        public void close() {
            this.isClosed = true;
        }

        @Override
        public void mark(int n) {
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read() throws IOException {
            if (-1 == this.read(this.b, 0, 1)) {
                return -1;
            }
            return 0xFF & this.b[0];
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (this.isClosed) {
                throw new IOException();
            }
            if (n2 == 0) {
                return 0;
            }
            int n3 = DrmRawContent.this.nativeReadContent(byArray, n, n2, this.offset);
            if (-1 == n3) {
                throw new IOException();
            }
            if (-2 == n3) {
                return -1;
            }
            this.offset = n3 + this.offset;
            return n3;
        }

        @Override
        public void reset() throws IOException {
            throw new IOException();
        }

        @Override
        public long skip(long l) throws IOException {
            return 0L;
        }
    }
}

