/*
 * Decompiled with CFR 0.152.
 */
package android.drm.mobile1;

import android.drm.mobile1.DrmException;
import android.drm.mobile1.DrmRawContent;
import android.drm.mobile1.DrmRights;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class DrmRightsManager {
    private static final int DRM_MIMETYPE_MESSAGE = 1;
    private static final int DRM_MIMETYPE_RIGHTS_WBXML = 4;
    public static final String DRM_MIMETYPE_RIGHTS_WBXML_STRING = "application/vnd.oma.drm.rights+wbxml";
    private static final int DRM_MIMETYPE_RIGHTS_XML = 3;
    public static final String DRM_MIMETYPE_RIGHTS_XML_STRING = "application/vnd.oma.drm.rights+xml";
    private static final int JNI_DRM_FAILURE = -1;
    private static final int JNI_DRM_SUCCESS;
    private static DrmRightsManager singleton;

    static {
        singleton = null;
        try {
            System.loadLibrary("drm1_jni");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("WARNING: Could not load libdrm1_jni.so");
        }
    }

    protected DrmRightsManager() {
    }

    public static DrmRightsManager getInstance() {
        synchronized (DrmRightsManager.class) {
            if (singleton == null) {
                singleton = new DrmRightsManager();
            }
            DrmRightsManager drmRightsManager = singleton;
            return drmRightsManager;
        }
    }

    private native int nativeDeleteRights(DrmRights var1);

    private native int nativeGetNumOfRights();

    private native int nativeGetRightsList(DrmRights[] var1, int var2);

    private native int nativeInstallDrmRights(InputStream var1, int var2, int var3, DrmRights var4);

    private native int nativeQueryRights(DrmRawContent var1, DrmRights var2);

    public void deleteRights(DrmRights drmRights) {
        synchronized (this) {
            int n = this.nativeDeleteRights(drmRights);
            if (-1 == n) {
                // empty if block
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getRightsList() {
        synchronized (this) {
            ArrayList<DrmRights> arrayList = new ArrayList<DrmRights>();
            int n = this.nativeGetNumOfRights();
            if (-1 == n) {
                return null;
            }
            if (n <= 0) return arrayList;
            DrmRights[] drmRightsArray = new DrmRights[n];
            for (int i = 0; i < n; ++i) {
                drmRightsArray[i] = new DrmRights();
            }
            int n2 = this.nativeGetRightsList(drmRightsArray, n);
            if (-1 == n2) {
                return null;
            }
            int n3 = 0;
            while (n3 < n2) {
                arrayList.add(drmRightsArray[n3]);
                ++n3;
            }
            return arrayList;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DrmRights installRights(InputStream inputStream, int n, String string2) throws DrmException, IOException {
        synchronized (this) {
            int n2;
            boolean bl = DRM_MIMETYPE_RIGHTS_XML_STRING.equals(string2);
            if (bl) {
                n2 = 3;
            } else if (DRM_MIMETYPE_RIGHTS_WBXML_STRING.equals(string2)) {
                n2 = 4;
            } else {
                if (!"application/vnd.oma.drm.message".equals(string2)) {
                    throw new IllegalArgumentException("mimeType must be DRM_MIMETYPE_RIGHTS_XML or DRM_MIMETYPE_RIGHTS_WBXML or DRM_MIMETYPE_MESSAGE");
                }
                n2 = 1;
            }
            if (n <= 0) {
                return null;
            }
            DrmRights drmRights = new DrmRights();
            if (-1 != this.nativeInstallDrmRights(inputStream, n, n2, drmRights)) return drmRights;
            throw new DrmException("nativeInstallDrmRights() returned JNI_DRM_FAILURE");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DrmRights queryRights(DrmRawContent drmRawContent) {
        synchronized (this) {
            DrmRights drmRights = new DrmRights();
            int n = this.nativeQueryRights(drmRawContent, drmRights);
            if (-1 != n) return drmRights;
            return null;
        }
    }
}

