/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.gesture.Gesture;
import android.gesture.GestureUtils;

class Instance {
    private static final float[] ORIENTATIONS = new float[]{0.0f, 0.7853982f, 1.5707964f, 2.3561945f, (float)Math.PI, 0.0f, -0.7853982f, -1.5707964f, -2.3561945f, (float)(-Math.PI)};
    private static final int PATCH_SAMPLE_SIZE = 16;
    private static final int SEQUENCE_SAMPLE_SIZE = 16;
    final long id;
    final String label;
    final float[] vector;

    private Instance(long l, float[] fArray, String string2) {
        this.id = l;
        this.vector = fArray;
        this.label = string2;
    }

    static Instance createInstance(int n, int n2, Gesture gesture, String string2) {
        if (n == 2) {
            float[] fArray = Instance.temporalSampler(n2, gesture);
            Instance instance = new Instance(gesture.getID(), fArray, string2);
            instance.normalize();
            return instance;
        }
        float[] fArray = Instance.spatialSampler(gesture);
        return new Instance(gesture.getID(), fArray, string2);
    }

    private void normalize() {
        float[] fArray = this.vector;
        float f = 0.0f;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            f += fArray[i] * fArray[i];
        }
        float f2 = (float)Math.sqrt(f);
        for (int i = 0; i < n; ++i) {
            fArray[i] = fArray[i] / f2;
        }
    }

    private static float[] spatialSampler(Gesture gesture) {
        return GestureUtils.spatialSampling(gesture, 16, false);
    }

    private static float[] temporalSampler(int n, Gesture gesture) {
        float[] fArray = GestureUtils.temporalSampling(gesture.getStrokes().get(0), 16);
        float[] fArray2 = GestureUtils.computeCentroid((float[])fArray);
        float f = (float)Math.atan2(fArray[1] - fArray2[1], fArray[0] - fArray2[0]);
        float f2 = -f;
        if (n != 1) {
            int n2 = ORIENTATIONS.length;
            for (int i = 0; i < n2; ++i) {
                float f3 = ORIENTATIONS[i] - f;
                if (!(Math.abs(f3) < Math.abs(f2))) continue;
                f2 = f3;
            }
        }
        GestureUtils.translate((float[])fArray, (float)(-fArray2[0]), (float)(-fArray2[1]));
        GestureUtils.rotate((float[])fArray, (float)f2);
        return fArray;
    }
}

