/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.gesture.GestureUtils;
import android.gesture.Instance;
import android.gesture.Learner;
import android.gesture.Prediction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;

class InstanceLearner
extends Learner {
    private static final Comparator<Prediction> sComparator = new Comparator<Prediction>(){

        @Override
        public int compare(Prediction prediction, Prediction prediction2) {
            double d = prediction.score;
            double d2 = prediction2.score;
            if (d > d2) {
                return -1;
            }
            if (d < d2) {
                return 1;
            }
            return 0;
        }
    };

    InstanceLearner() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    ArrayList<Prediction> classify(int n, int n2, float[] fArray) {
        ArrayList<Prediction> arrayList = new ArrayList<Prediction>();
        ArrayList<Instance> arrayList2 = this.getInstances();
        int n3 = arrayList2.size();
        TreeMap<String, Double> treeMap = new TreeMap<String, Double>();
        for (int i = 0; i < n3; ++i) {
            Instance instance = arrayList2.get(i);
            if (instance.vector.length != fArray.length) continue;
            double d = n == 2 ? (double)GestureUtils.minimumCosineDistance((float[])instance.vector, (float[])fArray, (int)n2) : (double)GestureUtils.squaredEuclideanDistance((float[])instance.vector, (float[])fArray);
            double d2 = d == 0.0 ? Double.MAX_VALUE : 1.0 / d;
            Double d3 = (Double)treeMap.get(instance.label);
            if (d3 != null && !(d2 > d3)) continue;
            treeMap.put(instance.label, d2);
        }
        Iterator iterator = treeMap.keySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                Collections.sort(arrayList, sComparator);
                return arrayList;
            }
            String string2 = (String)iterator.next();
            double d = (Double)treeMap.get(string2);
            Prediction prediction = new Prediction(string2, d);
            arrayList.add(prediction);
        }
    }
}

