/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.Xfermode;

public class BoundaryPatch {
    private int mCols = 2;
    private float[] mCubicPoints = new float[24];
    private boolean mDirty;
    private short[] mIndices;
    private Paint mPaint = new Paint();
    private int mRows = 2;
    private Bitmap mTexture;
    private float[] mVerts;

    public BoundaryPatch() {
        this.mPaint.setDither(true);
        this.mPaint.setFilterBitmap(true);
        this.mDirty = true;
    }

    private void buildCache() {
        int n = 4 * (this.mRows * this.mCols);
        if (this.mVerts == null || this.mVerts.length != n) {
            this.mVerts = new float[n];
        }
        int n2 = 6 * ((this.mRows - 1) * (this.mCols - 1));
        if (this.mIndices == null || this.mIndices.length != n2) {
            this.mIndices = new short[n2];
        }
        BoundaryPatch.nativeComputeCubicPatch(this.mCubicPoints, this.mTexture.getWidth(), this.mTexture.getHeight(), this.mRows, this.mCols, this.mVerts, this.mIndices);
    }

    private static native void nativeComputeCubicPatch(float[] var0, int var1, int var2, int var3, int var4, float[] var5, short[] var6);

    public void draw(Canvas canvas) {
        if (this.mDirty) {
            this.buildCache();
            this.mDirty = false;
        }
        int n = this.mVerts.length >> 1;
        canvas.drawVertices(Canvas.VertexMode.TRIANGLES, n, this.mVerts, 0, this.mVerts, n, null, 0, this.mIndices, 0, this.mIndices.length, this.mPaint);
    }

    public int getPaintFlags() {
        return this.mPaint.getFlags();
    }

    public void setAlpha(int n) {
        this.mPaint.setAlpha(n);
    }

    public void setCubicBoundary(float[] fArray, int n, int n2, int n3) {
        if (n2 < 2 || n3 < 2) {
            throw new RuntimeException("rows and cols must be >= 2");
        }
        System.arraycopy(fArray, n, this.mCubicPoints, 0, 24);
        if (this.mRows != n2 || this.mCols != n3) {
            this.mRows = n2;
            this.mCols = n3;
        }
        this.mDirty = true;
    }

    public void setPaintFlags(int n) {
        this.mPaint.setFlags(n);
    }

    public void setTexture(Bitmap bitmap) {
        if (this.mTexture != bitmap) {
            if (this.mTexture == null || this.mTexture.getWidth() != bitmap.getWidth() || this.mTexture.getHeight() != bitmap.getHeight()) {
                this.mDirty = true;
            }
            this.mTexture = bitmap;
            this.mPaint.setShader(new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        }
    }

    public void setXfermode(Xfermode xfermode) {
        this.mPaint.setXfermode(xfermode);
    }
}

