/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.InputMethodSession;
import com.android.internal.os.HandlerCaller;
import com.android.internal.view.IInputMethodCallback;
import com.android.internal.view.IInputMethodSession;

class IInputMethodSessionWrapper
extends IInputMethodSession.Stub
implements HandlerCaller.Callback {
    private static final boolean DEBUG = false;
    private static final int DO_APP_PRIVATE_COMMAND = 100;
    private static final int DO_DISPATCH_KEY_EVENT = 70;
    private static final int DO_DISPATCH_TRACKBALL_EVENT = 80;
    private static final int DO_DISPLAY_COMPLETIONS = 65;
    private static final int DO_FINISH_INPUT = 60;
    private static final int DO_FINISH_SESSION = 110;
    private static final int DO_TOGGLE_SOFT_INPUT = 105;
    private static final int DO_UPDATE_CURSOR = 95;
    private static final int DO_UPDATE_EXTRACTED_TEXT = 67;
    private static final int DO_UPDATE_SELECTION = 90;
    private static final String TAG = "InputMethodWrapper";
    HandlerCaller mCaller;
    InputMethodSession mInputMethodSession;

    public IInputMethodSessionWrapper(Context context, InputMethodSession inputMethodSession) {
        this.mCaller = new HandlerCaller(context, this);
        this.mInputMethodSession = inputMethodSession;
    }

    @Override
    public void appPrivateCommand(String string2, Bundle bundle) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(100, string2, bundle));
    }

    @Override
    public void dispatchKeyEvent(int n, KeyEvent keyEvent, IInputMethodCallback iInputMethodCallback) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIOO(70, n, keyEvent, iInputMethodCallback));
    }

    @Override
    public void dispatchTrackballEvent(int n, MotionEvent motionEvent, IInputMethodCallback iInputMethodCallback) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIOO(80, n, motionEvent, iInputMethodCallback));
    }

    @Override
    public void displayCompletions(CompletionInfo[] completionInfoArray) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(65, completionInfoArray));
    }

    @Override
    public void executeMessage(Message message) {
        switch (message.what) {
            default: {
                Log.w(TAG, "Unhandled message code: " + message.what);
                return;
            }
            case 60: {
                this.mInputMethodSession.finishInput();
                return;
            }
            case 65: {
                this.mInputMethodSession.displayCompletions((CompletionInfo[])message.obj);
                return;
            }
            case 67: {
                this.mInputMethodSession.updateExtractedText(message.arg1, (ExtractedText)message.obj);
                return;
            }
            case 70: {
                HandlerCaller.SomeArgs someArgs = (HandlerCaller.SomeArgs)message.obj;
                this.mInputMethodSession.dispatchKeyEvent(message.arg1, (KeyEvent)someArgs.arg1, new InputMethodEventCallbackWrapper((IInputMethodCallback)someArgs.arg2));
                this.mCaller.recycleArgs(someArgs);
                return;
            }
            case 80: {
                HandlerCaller.SomeArgs someArgs = (HandlerCaller.SomeArgs)message.obj;
                this.mInputMethodSession.dispatchTrackballEvent(message.arg1, (MotionEvent)someArgs.arg1, new InputMethodEventCallbackWrapper((IInputMethodCallback)someArgs.arg2));
                this.mCaller.recycleArgs(someArgs);
                return;
            }
            case 90: {
                HandlerCaller.SomeArgs someArgs = (HandlerCaller.SomeArgs)message.obj;
                this.mInputMethodSession.updateSelection(someArgs.argi1, someArgs.argi2, someArgs.argi3, someArgs.argi4, someArgs.argi5, someArgs.argi6);
                this.mCaller.recycleArgs(someArgs);
                return;
            }
            case 95: {
                this.mInputMethodSession.updateCursor((Rect)message.obj);
                return;
            }
            case 100: {
                HandlerCaller.SomeArgs someArgs = (HandlerCaller.SomeArgs)message.obj;
                this.mInputMethodSession.appPrivateCommand((String)someArgs.arg1, (Bundle)someArgs.arg2);
                this.mCaller.recycleArgs(someArgs);
                return;
            }
            case 105: {
                this.mInputMethodSession.toggleSoftInput(message.arg1, message.arg2);
                return;
            }
            case 110: 
        }
        this.mInputMethodSession = null;
    }

    @Override
    public void finishInput() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(60));
    }

    @Override
    public void finishSession() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(110));
    }

    public InputMethodSession getInternalInputMethodSession() {
        return this.mInputMethodSession;
    }

    @Override
    public void toggleSoftInput(int n, int n2) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageII(105, n, n2));
    }

    @Override
    public void updateCursor(Rect rect) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(95, rect));
    }

    @Override
    public void updateExtractedText(int n, ExtractedText extractedText) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIO(67, n, extractedText));
    }

    @Override
    public void updateSelection(int n, int n2, int n3, int n4, int n5, int n6) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIIIIII(90, n, n2, n3, n4, n5, n6));
    }

    static class InputMethodEventCallbackWrapper
    implements InputMethodSession.EventCallback {
        final IInputMethodCallback mCb;

        InputMethodEventCallbackWrapper(IInputMethodCallback iInputMethodCallback) {
            this.mCb = iInputMethodCallback;
        }

        @Override
        public void finishedEvent(int n, boolean bl) {
            try {
                this.mCb.finishedEvent(n, bl);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }
    }
}

