/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.content.Context;
import android.inputmethodservice.AbstractInputMethodService;
import android.inputmethodservice.IInputMethodSessionWrapper;
import android.os.Binder;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.util.Log;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputBinding;
import android.view.inputmethod.InputMethod;
import android.view.inputmethod.InputMethodSession;
import com.android.internal.os.HandlerCaller;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethod;
import com.android.internal.view.IInputMethodCallback;
import com.android.internal.view.IInputMethodSession;
import com.android.internal.view.InputConnectionWrapper;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class IInputMethodWrapper
extends IInputMethod.Stub
implements HandlerCaller.Callback {
    private static final boolean DEBUG = false;
    private static final int DO_ATTACH_TOKEN = 10;
    private static final int DO_CREATE_SESSION = 40;
    private static final int DO_DUMP = 1;
    private static final int DO_HIDE_SOFT_INPUT = 70;
    private static final int DO_RESTART_INPUT = 34;
    private static final int DO_REVOKE_SESSION = 50;
    private static final int DO_SET_INPUT_CONTEXT = 20;
    private static final int DO_SET_SESSION_ENABLED = 45;
    private static final int DO_SHOW_SOFT_INPUT = 60;
    private static final int DO_START_INPUT = 32;
    private static final int DO_UNSET_INPUT_CONTEXT = 30;
    private static final String TAG = "InputMethodWrapper";
    final HandlerCaller mCaller;
    final WeakReference<InputMethod> mInputMethod;
    final WeakReference<AbstractInputMethodService> mTarget;

    public IInputMethodWrapper(AbstractInputMethodService abstractInputMethodService, InputMethod inputMethod) {
        this.mTarget = new WeakReference<AbstractInputMethodService>(abstractInputMethodService);
        this.mCaller = new HandlerCaller(abstractInputMethodService.getApplicationContext(), this);
        this.mInputMethod = new WeakReference<InputMethod>(inputMethod);
    }

    @Override
    public void attachToken(IBinder iBinder) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(10, iBinder));
    }

    @Override
    public void bindInput(InputBinding inputBinding) {
        InputBinding inputBinding2 = new InputBinding(new InputConnectionWrapper(IInputContext.Stub.asInterface(inputBinding.getConnectionToken())), inputBinding);
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(20, inputBinding2));
    }

    @Override
    public void createSession(IInputMethodCallback iInputMethodCallback) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(40, iInputMethodCallback));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        AbstractInputMethodService abstractInputMethodService = (AbstractInputMethodService)this.mTarget.get();
        if (abstractInputMethodService == null) return;
        if (abstractInputMethodService.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            printWriter.println("Permission Denial: can't dump InputMethodManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOOOO(1, fileDescriptor, printWriter, stringArray, countDownLatch));
        try {
            if (countDownLatch.await(5L, TimeUnit.SECONDS)) return;
            printWriter.println("Timeout waiting for dump");
            return;
        }
        catch (InterruptedException interruptedException) {
            printWriter.println("Interrupted waiting for dump");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeMessage(Message message) {
        InputMethod inputMethod = (InputMethod)this.mInputMethod.get();
        if (inputMethod == null && message.what != 1) {
            Log.w(TAG, "Input method reference was null, ignoring message: " + message.what);
            return;
        }
        switch (message.what) {
            default: {
                Log.w(TAG, "Unhandled message code: " + message.what);
                return;
            }
            case 1: {
                AbstractInputMethodService abstractInputMethodService = (AbstractInputMethodService)this.mTarget.get();
                if (abstractInputMethodService == null) return;
                HandlerCaller.SomeArgs someArgs = (HandlerCaller.SomeArgs)message.obj;
                try {
                    abstractInputMethodService.dump((FileDescriptor)someArgs.arg1, (PrintWriter)someArgs.arg2, (String[])someArgs.arg3);
                }
                catch (RuntimeException runtimeException) {
                    ((PrintWriter)someArgs.arg2).println("Exception: " + runtimeException);
                }
                Object object = someArgs.arg4;
                synchronized (object) {
                    ((CountDownLatch)someArgs.arg4).countDown();
                    return;
                }
            }
            case 10: {
                inputMethod.attachToken((IBinder)message.obj);
                return;
            }
            case 20: {
                inputMethod.bindInput((InputBinding)message.obj);
                return;
            }
            case 30: {
                inputMethod.unbindInput();
                return;
            }
            case 32: {
                HandlerCaller.SomeArgs someArgs = (HandlerCaller.SomeArgs)message.obj;
                IInputContext iInputContext = (IInputContext)someArgs.arg1;
                InputConnectionWrapper inputConnectionWrapper = iInputContext != null ? new InputConnectionWrapper(iInputContext) : null;
                inputMethod.startInput(inputConnectionWrapper, (EditorInfo)someArgs.arg2);
                return;
            }
            case 34: {
                HandlerCaller.SomeArgs someArgs = (HandlerCaller.SomeArgs)message.obj;
                IInputContext iInputContext = (IInputContext)someArgs.arg1;
                InputConnectionWrapper inputConnectionWrapper = iInputContext != null ? new InputConnectionWrapper(iInputContext) : null;
                inputMethod.restartInput(inputConnectionWrapper, (EditorInfo)someArgs.arg2);
                return;
            }
            case 40: {
                inputMethod.createSession(new InputMethodSessionCallbackWrapper(this.mCaller.mContext, (IInputMethodCallback)message.obj));
                return;
            }
            case 45: {
                InputMethodSession inputMethodSession = (InputMethodSession)message.obj;
                boolean bl = message.arg1 != 0;
                inputMethod.setSessionEnabled(inputMethodSession, bl);
                return;
            }
            case 50: {
                inputMethod.revokeSession((InputMethodSession)message.obj);
                return;
            }
            case 60: {
                inputMethod.showSoftInput(message.arg1, (ResultReceiver)message.obj);
                return;
            }
            case 70: 
        }
        inputMethod.hideSoftInput(message.arg1, (ResultReceiver)message.obj);
    }

    public InputMethod getInternalInputMethod() {
        return (InputMethod)this.mInputMethod.get();
    }

    @Override
    public void hideSoftInput(int n, ResultReceiver resultReceiver) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIO(70, n, resultReceiver));
    }

    @Override
    public void restartInput(IInputContext iInputContext, EditorInfo editorInfo) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(34, iInputContext, editorInfo));
    }

    @Override
    public void revokeSession(IInputMethodSession iInputMethodSession) {
        try {
            InputMethodSession inputMethodSession = ((IInputMethodSessionWrapper)iInputMethodSession).getInternalInputMethodSession();
            this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(50, inputMethodSession));
            return;
        }
        catch (ClassCastException classCastException) {
            Log.w(TAG, "Incoming session not of correct type: " + iInputMethodSession, classCastException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setSessionEnabled(IInputMethodSession iInputMethodSession, boolean bl) {
        try {
            InputMethodSession inputMethodSession = ((IInputMethodSessionWrapper)iInputMethodSession).getInternalInputMethodSession();
            HandlerCaller handlerCaller = this.mCaller;
            HandlerCaller handlerCaller2 = this.mCaller;
            int n = bl ? 1 : 0;
            handlerCaller.executeOrSendMessage(handlerCaller2.obtainMessageIO(45, n, inputMethodSession));
            return;
        }
        catch (ClassCastException classCastException) {
            Log.w(TAG, "Incoming session not of correct type: " + iInputMethodSession, classCastException);
            return;
        }
    }

    @Override
    public void showSoftInput(int n, ResultReceiver resultReceiver) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIO(60, n, resultReceiver));
    }

    @Override
    public void startInput(IInputContext iInputContext, EditorInfo editorInfo) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(32, iInputContext, editorInfo));
    }

    @Override
    public void unbindInput() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(30));
    }

    static class InputMethodSessionCallbackWrapper
    implements InputMethod.SessionCallback {
        final IInputMethodCallback mCb;
        final Context mContext;

        InputMethodSessionCallbackWrapper(Context context, IInputMethodCallback iInputMethodCallback) {
            this.mContext = context;
            this.mCb = iInputMethodCallback;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void sessionCreated(InputMethodSession var1_1) {
            if (var1_1 == null) ** GOTO lbl6
            try {
                var3_2 = new IInputMethodSessionWrapper(this.mContext, var1_1);
                this.mCb.sessionCreated(var3_2);
                return;
lbl6:
                // 1 sources

                this.mCb.sessionCreated(null);
                return;
            }
            catch (RemoteException var2_3) {
                return;
            }
        }
    }

    static class Notifier {
        boolean notified;

        Notifier() {
        }
    }
}

