/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.app.PendingIntent;
import android.location.Address;
import android.location.Criteria;
import android.location.GeocoderParams;
import android.location.IGpsStatusListener;
import android.location.ILocationListener;
import android.location.Location;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface ILocationManager
extends IInterface {
    public boolean addGpsStatusListener(IGpsStatusListener var1) throws RemoteException;

    public void addProximityAlert(double var1, double var3, float var5, long var6, PendingIntent var8) throws RemoteException;

    public void addTestProvider(String var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, int var9, int var10) throws RemoteException;

    public void clearTestProviderEnabled(String var1) throws RemoteException;

    public void clearTestProviderLocation(String var1) throws RemoteException;

    public void clearTestProviderStatus(String var1) throws RemoteException;

    public boolean geocoderIsPresent() throws RemoteException;

    public List<String> getAllProviders() throws RemoteException;

    public String getBestProvider(Criteria var1, boolean var2) throws RemoteException;

    public String getFromLocation(double var1, double var3, int var5, GeocoderParams var6, List<Address> var7) throws RemoteException;

    public String getFromLocationName(String var1, double var2, double var4, double var6, double var8, int var10, GeocoderParams var11, List<Address> var12) throws RemoteException;

    public Location getLastKnownLocation(String var1) throws RemoteException;

    public Bundle getProviderInfo(String var1) throws RemoteException;

    public List<String> getProviders(Criteria var1, boolean var2) throws RemoteException;

    public boolean isProviderEnabled(String var1) throws RemoteException;

    public void locationCallbackFinished(ILocationListener var1) throws RemoteException;

    public boolean providerMeetsCriteria(String var1, Criteria var2) throws RemoteException;

    public void removeGpsStatusListener(IGpsStatusListener var1) throws RemoteException;

    public void removeProximityAlert(PendingIntent var1) throws RemoteException;

    public void removeTestProvider(String var1) throws RemoteException;

    public void removeUpdates(ILocationListener var1) throws RemoteException;

    public void removeUpdatesPI(PendingIntent var1) throws RemoteException;

    public void reportLocation(Location var1, boolean var2) throws RemoteException;

    public void requestLocationUpdates(String var1, Criteria var2, long var3, float var5, boolean var6, ILocationListener var7) throws RemoteException;

    public void requestLocationUpdatesPI(String var1, Criteria var2, long var3, float var5, boolean var6, PendingIntent var7) throws RemoteException;

    public boolean sendExtraCommand(String var1, String var2, Bundle var3) throws RemoteException;

    public boolean sendNiResponse(int var1, int var2) throws RemoteException;

    public void setTestProviderEnabled(String var1, boolean var2) throws RemoteException;

    public void setTestProviderLocation(String var1, Location var2) throws RemoteException;

    public void setTestProviderStatus(String var1, int var2, Bundle var3, long var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILocationManager {
        private static final String DESCRIPTOR = "android.location.ILocationManager";
        static final int TRANSACTION_addGpsStatusListener = 9;
        static final int TRANSACTION_addProximityAlert = 13;
        static final int TRANSACTION_addTestProvider = 22;
        static final int TRANSACTION_clearTestProviderEnabled = 27;
        static final int TRANSACTION_clearTestProviderLocation = 25;
        static final int TRANSACTION_clearTestProviderStatus = 29;
        static final int TRANSACTION_geocoderIsPresent = 19;
        static final int TRANSACTION_getAllProviders = 1;
        static final int TRANSACTION_getBestProvider = 3;
        static final int TRANSACTION_getFromLocation = 20;
        static final int TRANSACTION_getFromLocationName = 21;
        static final int TRANSACTION_getLastKnownLocation = 17;
        static final int TRANSACTION_getProviderInfo = 15;
        static final int TRANSACTION_getProviders = 2;
        static final int TRANSACTION_isProviderEnabled = 16;
        static final int TRANSACTION_locationCallbackFinished = 11;
        static final int TRANSACTION_providerMeetsCriteria = 4;
        static final int TRANSACTION_removeGpsStatusListener = 10;
        static final int TRANSACTION_removeProximityAlert = 14;
        static final int TRANSACTION_removeTestProvider = 23;
        static final int TRANSACTION_removeUpdates = 7;
        static final int TRANSACTION_removeUpdatesPI = 8;
        static final int TRANSACTION_reportLocation = 18;
        static final int TRANSACTION_requestLocationUpdates = 5;
        static final int TRANSACTION_requestLocationUpdatesPI = 6;
        static final int TRANSACTION_sendExtraCommand = 12;
        static final int TRANSACTION_sendNiResponse = 30;
        static final int TRANSACTION_setTestProviderEnabled = 26;
        static final int TRANSACTION_setTestProviderLocation = 24;
        static final int TRANSACTION_setTestProviderStatus = 28;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ILocationManager asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof ILocationManager) {
                return (ILocationManager)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<String> list = this.getAllProviders();
                    parcel2.writeNoException();
                    parcel2.writeStringList(list);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Criteria criteria = parcel.readInt() != 0 ? Criteria.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = parcel.readInt() != 0;
                    List<String> list = this.getProviders(criteria, bl);
                    parcel2.writeNoException();
                    parcel2.writeStringList(list);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Criteria criteria = parcel.readInt() != 0 ? Criteria.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = parcel.readInt() != 0;
                    String string2 = this.getBestProvider(criteria, bl);
                    parcel2.writeNoException();
                    parcel2.writeString(string2);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string3 = parcel.readString();
                    Criteria criteria = parcel.readInt() != 0 ? Criteria.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.providerMeetsCriteria(string3, criteria);
                    parcel2.writeNoException();
                    int n3 = bl ? 1 : 0;
                    parcel2.writeInt(n3);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string4 = parcel.readString();
                    Criteria criteria = parcel.readInt() != 0 ? Criteria.CREATOR.createFromParcel(parcel) : null;
                    long l = parcel.readLong();
                    float f = parcel.readFloat();
                    boolean bl = parcel.readInt() != 0;
                    this.requestLocationUpdates(string4, criteria, l, f, bl, ILocationListener.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string5 = parcel.readString();
                    Criteria criteria = parcel.readInt() != 0 ? Criteria.CREATOR.createFromParcel(parcel) : null;
                    long l = parcel.readLong();
                    float f = parcel.readFloat();
                    boolean bl = parcel.readInt() != 0;
                    PendingIntent pendingIntent = parcel.readInt() != 0 ? PendingIntent.CREATOR.createFromParcel(parcel) : null;
                    this.requestLocationUpdatesPI(string5, criteria, l, f, bl, pendingIntent);
                    parcel2.writeNoException();
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removeUpdates(ILocationListener.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    PendingIntent pendingIntent = parcel.readInt() != 0 ? PendingIntent.CREATOR.createFromParcel(parcel) : null;
                    this.removeUpdatesPI(pendingIntent);
                    parcel2.writeNoException();
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.addGpsStatusListener(IGpsStatusListener.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    int n4 = bl ? 1 : 0;
                    parcel2.writeInt(n4);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removeGpsStatusListener(IGpsStatusListener.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.locationCallbackFinished(ILocationListener.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string6 = parcel.readString();
                    String string7 = parcel.readString();
                    Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.sendExtraCommand(string6, string7, bundle);
                    parcel2.writeNoException();
                    int n5 = bl ? 1 : 0;
                    parcel2.writeInt(n5);
                    if (bundle != null) {
                        parcel2.writeInt(1);
                        bundle.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    double d = parcel.readDouble();
                    double d2 = parcel.readDouble();
                    float f = parcel.readFloat();
                    long l = parcel.readLong();
                    PendingIntent pendingIntent = parcel.readInt() != 0 ? PendingIntent.CREATOR.createFromParcel(parcel) : null;
                    this.addProximityAlert(d, d2, f, l, pendingIntent);
                    parcel2.writeNoException();
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    PendingIntent pendingIntent = parcel.readInt() != 0 ? PendingIntent.CREATOR.createFromParcel(parcel) : null;
                    this.removeProximityAlert(pendingIntent);
                    parcel2.writeNoException();
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Bundle bundle = this.getProviderInfo(parcel.readString());
                    parcel2.writeNoException();
                    if (bundle != null) {
                        parcel2.writeInt(1);
                        bundle.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isProviderEnabled(parcel.readString());
                    parcel2.writeNoException();
                    int n6 = bl ? 1 : 0;
                    parcel2.writeInt(n6);
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Location location = this.getLastKnownLocation(parcel.readString());
                    parcel2.writeNoException();
                    if (location != null) {
                        parcel2.writeInt(1);
                        location.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Location location = parcel.readInt() != 0 ? Location.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = parcel.readInt() != 0;
                    this.reportLocation(location, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.geocoderIsPresent();
                    parcel2.writeNoException();
                    int n7 = bl ? 1 : 0;
                    parcel2.writeInt(n7);
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    double d = parcel.readDouble();
                    double d3 = parcel.readDouble();
                    int n8 = parcel.readInt();
                    GeocoderParams geocoderParams = parcel.readInt() != 0 ? GeocoderParams.CREATOR.createFromParcel(parcel) : null;
                    ArrayList<Address> arrayList = new ArrayList<Address>();
                    String string8 = this.getFromLocation(d, d3, n8, geocoderParams, arrayList);
                    parcel2.writeNoException();
                    parcel2.writeString(string8);
                    parcel2.writeTypedList(arrayList);
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string9 = parcel.readString();
                    double d = parcel.readDouble();
                    double d4 = parcel.readDouble();
                    double d5 = parcel.readDouble();
                    double d6 = parcel.readDouble();
                    int n9 = parcel.readInt();
                    GeocoderParams geocoderParams = parcel.readInt() != 0 ? GeocoderParams.CREATOR.createFromParcel(parcel) : null;
                    ArrayList<Address> arrayList = new ArrayList<Address>();
                    String string10 = this.getFromLocationName(string9, d, d4, d5, d6, n9, geocoderParams, arrayList);
                    parcel2.writeNoException();
                    parcel2.writeString(string10);
                    parcel2.writeTypedList(arrayList);
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string11 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    boolean bl2 = parcel.readInt() != 0;
                    boolean bl3 = parcel.readInt() != 0;
                    boolean bl4 = parcel.readInt() != 0;
                    boolean bl5 = parcel.readInt() != 0;
                    boolean bl6 = parcel.readInt() != 0;
                    boolean bl7 = parcel.readInt() != 0;
                    int n10 = parcel.readInt();
                    int n11 = parcel.readInt();
                    this.addTestProvider(string11, bl, bl2, bl3, bl4, bl5, bl6, bl7, n10, n11);
                    parcel2.writeNoException();
                    return true;
                }
                case 23: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removeTestProvider(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 24: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string12 = parcel.readString();
                    Location location = parcel.readInt() != 0 ? Location.CREATOR.createFromParcel(parcel) : null;
                    this.setTestProviderLocation(string12, location);
                    parcel2.writeNoException();
                    return true;
                }
                case 25: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.clearTestProviderLocation(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 26: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string13 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    this.setTestProviderEnabled(string13, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 27: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.clearTestProviderEnabled(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 28: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string14 = parcel.readString();
                    int n12 = parcel.readInt();
                    Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                    long l = parcel.readLong();
                    this.setTestProviderStatus(string14, n12, bundle, l);
                    parcel2.writeNoException();
                    return true;
                }
                case 29: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.clearTestProviderStatus(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 30: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            boolean bl = this.sendNiResponse(parcel.readInt(), parcel.readInt());
            parcel2.writeNoException();
            int n13 = bl ? 1 : 0;
            parcel2.writeInt(n13);
            return true;
        }

        private static class Proxy
        implements ILocationManager {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean addGpsStatusListener(IGpsStatusListener iGpsStatusListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iGpsStatusListener != null ? iGpsStatusListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addProximityAlert(double d, double d2, float f, long l, PendingIntent pendingIntent) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeDouble(d);
                    parcel.writeDouble(d2);
                    parcel.writeFloat(f);
                    parcel.writeLong(l);
                    if (pendingIntent != null) {
                        parcel.writeInt(1);
                        pendingIntent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addTestProvider(String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    int n3 = bl ? 1 : 0;
                    parcel.writeInt(n3);
                    int n4 = bl2 ? 1 : 0;
                    parcel.writeInt(n4);
                    int n5 = bl3 ? 1 : 0;
                    parcel.writeInt(n5);
                    int n6 = bl4 ? 1 : 0;
                    parcel.writeInt(n6);
                    int n7 = bl5 ? 1 : 0;
                    parcel.writeInt(n7);
                    int n8 = bl6 ? 1 : 0;
                    parcel.writeInt(n8);
                    int n9 = bl7 ? 1 : 0;
                    parcel.writeInt(n9);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public void clearTestProviderEnabled(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(27, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void clearTestProviderLocation(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void clearTestProviderStatus(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(29, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean geocoderIsPresent() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<String> getAllProviders() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<String> arrayList = parcel2.createStringArrayList();
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public String getBestProvider(Criteria criteria, boolean bl) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    try {
                        parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                        if (criteria != null) {
                            parcel2.writeInt(1);
                            criteria.writeToParcel(parcel2, 0);
                            break block4;
                        }
                    }
                    catch (Throwable throwable) {
                        parcel.recycle();
                        parcel2.recycle();
                        throw throwable;
                    }
                    {
                        parcel2.writeInt(0);
                    }
                }
                int n = bl ? 1 : 0;
                parcel2.writeInt(n);
                this.mRemote.transact(3, parcel2, parcel, 0);
                parcel.readException();
                String string2 = parcel.readString();
                parcel.recycle();
                parcel2.recycle();
                return string2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public String getFromLocation(double d, double d2, int n, GeocoderParams geocoderParams, List<Address> list) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeDouble(d);
                    parcel.writeDouble(d2);
                    parcel.writeInt(n);
                    if (geocoderParams != null) {
                        parcel.writeInt(1);
                        geocoderParams.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    String string2 = parcel2.readString();
                    parcel2.readTypedList(list, Address.CREATOR);
                    return string2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public String getFromLocationName(String string2, double d, double d2, double d3, double d4, int n, GeocoderParams geocoderParams, List<Address> list) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeDouble(d);
                    parcel.writeDouble(d2);
                    parcel.writeDouble(d3);
                    parcel.writeDouble(d4);
                    parcel.writeInt(n);
                    if (geocoderParams != null) {
                        parcel.writeInt(1);
                        geocoderParams.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    String string3 = parcel2.readString();
                    parcel2.readTypedList(list, Address.CREATOR);
                    return string3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Location getLastKnownLocation(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    Location location = parcel2.readInt() != 0 ? Location.CREATOR.createFromParcel(parcel2) : null;
                    return location;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Bundle getProviderInfo(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    Bundle bundle = parcel2.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel2) : null;
                    return bundle;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<String> getProviders(Criteria criteria, boolean bl) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    try {
                        parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                        if (criteria != null) {
                            parcel2.writeInt(1);
                            criteria.writeToParcel(parcel2, 0);
                            break block4;
                        }
                    }
                    catch (Throwable throwable) {
                        parcel.recycle();
                        parcel2.recycle();
                        throw throwable;
                    }
                    {
                        parcel2.writeInt(0);
                    }
                }
                int n = bl ? 1 : 0;
                parcel2.writeInt(n);
                this.mRemote.transact(2, parcel2, parcel, 0);
                parcel.readException();
                ArrayList<String> arrayList = parcel.createStringArrayList();
                parcel.recycle();
                parcel2.recycle();
                return arrayList;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isProviderEnabled(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void locationCallbackFinished(ILocationListener iLocationListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iLocationListener != null ? iLocationListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean providerMeetsCriteria(String string2, Criteria criteria) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (criteria != null) {
                        parcel.writeInt(1);
                        criteria.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void removeGpsStatusListener(IGpsStatusListener iGpsStatusListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iGpsStatusListener != null ? iGpsStatusListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void removeProximityAlert(PendingIntent pendingIntent) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (pendingIntent != null) {
                        parcel.writeInt(1);
                        pendingIntent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void removeTestProvider(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void removeUpdates(ILocationListener iLocationListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iLocationListener != null ? iLocationListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void removeUpdatesPI(PendingIntent pendingIntent) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (pendingIntent != null) {
                        parcel.writeInt(1);
                        pendingIntent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void reportLocation(Location location, boolean bl) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    try {
                        parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                        if (location != null) {
                            parcel2.writeInt(1);
                            location.writeToParcel(parcel2, 0);
                            break block4;
                        }
                    }
                    catch (Throwable throwable) {
                        parcel.recycle();
                        parcel2.recycle();
                        throw throwable;
                    }
                    {
                        parcel2.writeInt(0);
                    }
                }
                int n = bl ? 1 : 0;
                parcel2.writeInt(n);
                this.mRemote.transact(18, parcel2, parcel, 0);
                parcel.readException();
                parcel.recycle();
                parcel2.recycle();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void requestLocationUpdates(String string2, Criteria criteria, long l, float f, boolean bl, ILocationListener iLocationListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (criteria != null) {
                        parcel.writeInt(1);
                        criteria.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeLong(l);
                    parcel.writeFloat(f);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    IBinder iBinder = iLocationListener != null ? iLocationListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void requestLocationUpdatesPI(String string2, Criteria criteria, long l, float f, boolean bl, PendingIntent pendingIntent) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (criteria != null) {
                        parcel.writeInt(1);
                        criteria.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeLong(l);
                    parcel.writeFloat(f);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    if (pendingIntent != null) {
                        parcel.writeInt(1);
                        pendingIntent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean sendExtraCommand(String string2, String string3, Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    boolean bl = parcel2.readInt() != 0;
                    if (parcel2.readInt() != 0) {
                        bundle.readFromParcel(parcel2);
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean sendNiResponse(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(30, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = parcel2.readInt();
                    boolean bl = n3 != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setTestProviderEnabled(String string2, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    this.mRemote.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setTestProviderLocation(String string2, Location location) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (location != null) {
                        parcel.writeInt(1);
                        location.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setTestProviderStatus(String string2, int n, Bundle bundle, long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeLong(l);
                    this.mRemote.transact(28, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

