/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.location.Criteria;
import android.location.Location;
import android.net.NetworkInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.WorkSource;

public interface ILocationProvider
extends IInterface {
    public void addListener(int var1) throws RemoteException;

    public void disable() throws RemoteException;

    public void enable() throws RemoteException;

    public void enableLocationTracking(boolean var1) throws RemoteException;

    public int getAccuracy() throws RemoteException;

    public String getInternalState() throws RemoteException;

    public int getPowerRequirement() throws RemoteException;

    public int getStatus(Bundle var1) throws RemoteException;

    public long getStatusUpdateTime() throws RemoteException;

    public boolean hasMonetaryCost() throws RemoteException;

    public boolean meetsCriteria(Criteria var1) throws RemoteException;

    public void removeListener(int var1) throws RemoteException;

    public boolean requiresCell() throws RemoteException;

    public boolean requiresNetwork() throws RemoteException;

    public boolean requiresSatellite() throws RemoteException;

    public boolean sendExtraCommand(String var1, Bundle var2) throws RemoteException;

    public void setMinTime(long var1, WorkSource var3) throws RemoteException;

    public boolean supportsAltitude() throws RemoteException;

    public boolean supportsBearing() throws RemoteException;

    public boolean supportsSpeed() throws RemoteException;

    public void updateLocation(Location var1) throws RemoteException;

    public void updateNetworkState(int var1, NetworkInfo var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILocationProvider {
        private static final String DESCRIPTOR = "android.location.ILocationProvider";
        static final int TRANSACTION_addListener = 21;
        static final int TRANSACTION_disable = 12;
        static final int TRANSACTION_enable = 11;
        static final int TRANSACTION_enableLocationTracking = 16;
        static final int TRANSACTION_getAccuracy = 10;
        static final int TRANSACTION_getInternalState = 15;
        static final int TRANSACTION_getPowerRequirement = 8;
        static final int TRANSACTION_getStatus = 13;
        static final int TRANSACTION_getStatusUpdateTime = 14;
        static final int TRANSACTION_hasMonetaryCost = 4;
        static final int TRANSACTION_meetsCriteria = 9;
        static final int TRANSACTION_removeListener = 22;
        static final int TRANSACTION_requiresCell = 3;
        static final int TRANSACTION_requiresNetwork = 1;
        static final int TRANSACTION_requiresSatellite = 2;
        static final int TRANSACTION_sendExtraCommand = 20;
        static final int TRANSACTION_setMinTime = 17;
        static final int TRANSACTION_supportsAltitude = 5;
        static final int TRANSACTION_supportsBearing = 7;
        static final int TRANSACTION_supportsSpeed = 6;
        static final int TRANSACTION_updateLocation = 19;
        static final int TRANSACTION_updateNetworkState = 18;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ILocationProvider asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof ILocationProvider) {
                return (ILocationProvider)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.requiresNetwork();
                    parcel2.writeNoException();
                    int n3 = bl ? 1 : 0;
                    parcel2.writeInt(n3);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.requiresSatellite();
                    parcel2.writeNoException();
                    int n4 = bl ? 1 : 0;
                    parcel2.writeInt(n4);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.requiresCell();
                    parcel2.writeNoException();
                    int n5 = bl ? 1 : 0;
                    parcel2.writeInt(n5);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.hasMonetaryCost();
                    parcel2.writeNoException();
                    int n6 = bl ? 1 : 0;
                    parcel2.writeInt(n6);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.supportsAltitude();
                    parcel2.writeNoException();
                    int n7 = bl ? 1 : 0;
                    parcel2.writeInt(n7);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.supportsSpeed();
                    parcel2.writeNoException();
                    int n8 = bl ? 1 : 0;
                    parcel2.writeInt(n8);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.supportsBearing();
                    parcel2.writeNoException();
                    int n9 = bl ? 1 : 0;
                    parcel2.writeInt(n9);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n10 = this.getPowerRequirement();
                    parcel2.writeNoException();
                    parcel2.writeInt(n10);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Criteria criteria = parcel.readInt() != 0 ? Criteria.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.meetsCriteria(criteria);
                    parcel2.writeNoException();
                    int n11 = bl ? 1 : 0;
                    parcel2.writeInt(n11);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n12 = this.getAccuracy();
                    parcel2.writeNoException();
                    parcel2.writeInt(n12);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.enable();
                    parcel2.writeNoException();
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.disable();
                    parcel2.writeNoException();
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Bundle bundle = new Bundle();
                    int n13 = this.getStatus(bundle);
                    parcel2.writeNoException();
                    parcel2.writeInt(n13);
                    if (bundle != null) {
                        parcel2.writeInt(1);
                        bundle.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    long l = this.getStatusUpdateTime();
                    parcel2.writeNoException();
                    parcel2.writeLong(l);
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = this.getInternalState();
                    parcel2.writeNoException();
                    parcel2.writeString(string2);
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.enableLocationTracking(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    long l = parcel.readLong();
                    WorkSource workSource = parcel.readInt() != 0 ? WorkSource.CREATOR.createFromParcel(parcel) : null;
                    this.setMinTime(l, workSource);
                    parcel2.writeNoException();
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n14 = parcel.readInt();
                    NetworkInfo networkInfo = parcel.readInt() != 0 ? (NetworkInfo)NetworkInfo.CREATOR.createFromParcel(parcel) : null;
                    this.updateNetworkState(n14, networkInfo);
                    parcel2.writeNoException();
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Location location = parcel.readInt() != 0 ? Location.CREATOR.createFromParcel(parcel) : null;
                    this.updateLocation(location);
                    parcel2.writeNoException();
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string3 = parcel.readString();
                    Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.sendExtraCommand(string3, bundle);
                    parcel2.writeNoException();
                    int n15 = bl ? 1 : 0;
                    parcel2.writeInt(n15);
                    if (bundle != null) {
                        parcel2.writeInt(1);
                        bundle.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.addListener(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 22: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            this.removeListener(parcel.readInt());
            parcel2.writeNoException();
            return true;
        }

        private static class Proxy
        implements ILocationProvider {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public void addListener(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public void disable() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void enable() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void enableLocationTracking(boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    int n = bl ? 1 : 0;
                    parcel.writeInt(n);
                    this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int getAccuracy() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public String getInternalState() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    String string2 = parcel2.readString();
                    return string2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getPowerRequirement() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getStatus(Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    if (parcel2.readInt() != 0) {
                        bundle.readFromParcel(parcel2);
                    }
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public long getStatusUpdateTime() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    long l = parcel2.readLong();
                    return l;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean hasMonetaryCost() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean meetsCriteria(Criteria criteria) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (criteria != null) {
                        parcel.writeInt(1);
                        criteria.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void removeListener(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean requiresCell() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean requiresNetwork() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean requiresSatellite() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean sendExtraCommand(String string2, Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    boolean bl = parcel2.readInt() != 0;
                    if (parcel2.readInt() != 0) {
                        bundle.readFromParcel(parcel2);
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setMinTime(long l, WorkSource workSource) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    if (workSource != null) {
                        parcel.writeInt(1);
                        workSource.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean supportsAltitude() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean supportsBearing() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean supportsSpeed() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = n != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void updateLocation(Location location) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (location != null) {
                        parcel.writeInt(1);
                        location.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void updateNetworkState(int n, NetworkInfo networkInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (networkInfo != null) {
                        parcel.writeInt(1);
                        networkInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

