/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import java.io.IOException;
import java.io.InputStream;

public final class AmrInputStream
extends InputStream {
    private static final int SAMPLES_PER_FRAME = 160;
    private static final String TAG = "AmrInputStream";
    private byte[] mBuf = new byte[320];
    private int mBufIn = 0;
    private int mBufOut = 0;
    private int mGae;
    private InputStream mInputStream;
    private byte[] mOneByte = new byte[1];

    static {
        System.loadLibrary("media_jni");
    }

    public AmrInputStream(InputStream inputStream) {
        this.mInputStream = inputStream;
        this.mGae = AmrInputStream.GsmAmrEncoderNew();
        AmrInputStream.GsmAmrEncoderInitialize(this.mGae);
    }

    private static native void GsmAmrEncoderCleanup(int var0);

    private static native void GsmAmrEncoderDelete(int var0);

    private static native int GsmAmrEncoderEncode(int var0, byte[] var1, int var2, byte[] var3, int var4) throws IOException;

    private static native void GsmAmrEncoderInitialize(int var0);

    private static native int GsmAmrEncoderNew();

    @Override
    public void close() throws IOException {
        block23: {
            try {
                if (this.mInputStream != null) {
                    this.mInputStream.close();
                }
                this.mInputStream = null;
            }
            catch (Throwable throwable) {
                block24: {
                    this.mInputStream = null;
                    try {
                        if (this.mGae == 0) break block24;
                        AmrInputStream.GsmAmrEncoderCleanup(this.mGae);
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (this.mGae != 0) {
                                AmrInputStream.GsmAmrEncoderDelete(this.mGae);
                            }
                            throw throwable2;
                        }
                        finally {
                            this.mGae = 0;
                        }
                    }
                }
                try {
                    if (this.mGae != 0) {
                        AmrInputStream.GsmAmrEncoderDelete(this.mGae);
                    }
                    throw throwable;
                }
                finally {
                    this.mGae = 0;
                }
            }
            try {
                if (this.mGae == 0) break block23;
                AmrInputStream.GsmAmrEncoderCleanup(this.mGae);
            }
            catch (Throwable throwable) {
                try {
                    if (this.mGae != 0) {
                        AmrInputStream.GsmAmrEncoderDelete(this.mGae);
                    }
                    throw throwable;
                }
                finally {
                    this.mGae = 0;
                }
            }
        }
        try {
            if (this.mGae != 0) {
                AmrInputStream.GsmAmrEncoderDelete(this.mGae);
            }
            return;
        }
        finally {
            this.mGae = 0;
        }
    }

    protected void finalize() throws Throwable {
        if (this.mGae != 0) {
            this.close();
            throw new IllegalStateException("someone forgot to close AmrInputStream");
        }
    }

    @Override
    public int read() throws IOException {
        if (this.read(this.mOneByte, 0, 1) == 1) {
            return 0xFF & this.mOneByte[0];
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.mGae == 0) {
            throw new IllegalStateException("not open");
        }
        if (this.mBufOut >= this.mBufIn) {
            int n3;
            this.mBufOut = 0;
            this.mBufIn = 0;
            for (int i = 0; i < 320; i += n3) {
                n3 = this.mInputStream.read(this.mBuf, i, 320 - i);
                if (n3 != -1) continue;
                return -1;
            }
            this.mBufIn = AmrInputStream.GsmAmrEncoderEncode(this.mGae, this.mBuf, 0, this.mBuf, 0);
        }
        if (n2 > this.mBufIn - this.mBufOut) {
            n2 = this.mBufIn - this.mBufOut;
        }
        System.arraycopy(this.mBuf, this.mBufOut, byArray, n, n2);
        this.mBufOut = n2 + this.mBufOut;
        return n2;
    }
}

