/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityManagerNative;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.media.AudioManager;
import android.media.AudioSystem;
import android.media.IAudioFocusDispatcher;
import android.media.IAudioService;
import android.media.MediaPlayer;
import android.media.SoundPool;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.KeyEvent;
import android.view.VolumePanel;
import com.android.internal.telephony.ITelephony;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;

public class AudioService
extends IAudioService.Stub {
    private static final int BTA2DP_DOCK_TIMEOUT_MILLIS = 8000;
    private static final String IN_VOICE_COMM_FOCUS_ID = "AudioFocus_For_Phone_Ring_And_Calls";
    private static final int MSG_BTA2DP_DOCK_TIMEOUT = 8;
    private static final int MSG_MEDIA_SERVER_DIED = 5;
    private static final int MSG_MEDIA_SERVER_STARTED = 6;
    private static final int MSG_PERSIST_RINGER_MODE = 3;
    private static final int MSG_PERSIST_VIBRATE_SETTING = 4;
    private static final int MSG_PERSIST_VOLUME = 1;
    private static final int MSG_PLAY_SOUND_EFFECT = 7;
    private static final int MSG_SET_SYSTEM_VOLUME = 0;
    private static final int NUM_SOUNDPOOL_CHANNELS = 4;
    private static final int PERSIST_DELAY = 3000;
    private static final int SENDMSG_NOOP = 1;
    private static final int SENDMSG_QUEUE = 2;
    private static final int SENDMSG_REPLACE = 0;
    private static final int SHARED_MSG = -1;
    private static final String SOUND_EFFECTS_PATH = "/media/audio/ui/";
    private static final String[] SOUND_EFFECT_FILES = new String[]{"Effect_Tick.ogg", "KeypressStandard.ogg", "KeypressSpacebar.ogg", "KeypressDelete.ogg", "KeypressReturn.ogg"};
    private static final int SOUND_EFFECT_VOLUME = 1000;
    private static final String TAG = "AudioService";
    private static final Object mAudioFocusLock = new Object();
    private static final Object mRingingLock = new Object();
    private int[] MAX_STREAM_VOLUME;
    private int[][] SOUND_EFFECT_FILES_MAP;
    private int[] STREAM_VOLUME_ALIAS;
    private AudioHandler mAudioHandler;
    private AudioSystem.ErrorCallback mAudioSystemCallback;
    private AudioSystemThread mAudioSystemThread;
    private BluetoothHeadset mBluetoothHeadset;
    private boolean mBluetoothHeadsetConnected;
    private BluetoothHeadset.ServiceListener mBluetoothHeadsetServiceListener;
    private HashMap<Integer, String> mConnectedDevices;
    private ContentResolver mContentResolver;
    private Context mContext;
    private String mDockAddress;
    private Stack<FocusStackEntry> mFocusStack;
    private int mForcedUseForComm;
    private boolean mIsRinging = false;
    private final BroadcastReceiver mMediaButtonReceiver;
    private boolean mMediaServerOk;
    private int mMode;
    private int mMuteAffectedStreams;
    private int mNotificationsUseRingVolume;
    private PhoneStateListener mPhoneStateListener;
    private Stack<RemoteControlStackEntry> mRCStack;
    private final BroadcastReceiver mReceiver;
    private int mRingerMode;
    private int mRingerModeAffectedStreams;
    private int mRingerModeMutedStreams;
    private ArrayList<ScoClient> mScoClients;
    private ArrayList<SetModeDeathHandler> mSetModeDeathHandlers;
    private Object mSettingsLock = new Object();
    private SettingsObserver mSettingsObserver;
    private Object mSoundEffectsLock = new Object();
    private SoundPool mSoundPool;
    private VolumeStreamState[] mStreamStates;
    private int mVibrateSetting;
    private VolumePanel mVolumePanel;

    public AudioService(Context context) {
        this.SOUND_EFFECT_FILES_MAP = new int[][]{{0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {1, -1}, {2, -1}, {3, -1}, {4, -1}};
        this.MAX_STREAM_VOLUME = new int[]{5, 7, 7, 15, 7, 7, 15, 7, 15, 15};
        this.STREAM_VOLUME_ALIAS = new int[]{0, 1, 2, 3, 4, 5, 6, 1, 0, 3};
        this.mAudioSystemCallback = new AudioSystem.ErrorCallback(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onError(int n) {
                switch (n) {
                    case 100: {
                        if (!AudioService.this.mMediaServerOk) return;
                        AudioService.sendMsg(AudioService.this.mAudioHandler, 5, -1, 1, 0, 0, null, 1500);
                        AudioService.access$002(AudioService.this, false);
                        return;
                    }
                    default: {
                        return;
                    }
                    case 0: {
                        if (AudioService.this.mMediaServerOk) return;
                        AudioService.sendMsg(AudioService.this.mAudioHandler, 6, -1, 1, 0, 0, null, 0);
                        AudioService.access$002(AudioService.this, true);
                        return;
                    }
                }
            }
        };
        this.mReceiver = new AudioServiceBroadcastReceiver();
        this.mMediaButtonReceiver = new MediaButtonBroadcastReceiver();
        this.mConnectedDevices = new HashMap();
        this.mSetModeDeathHandlers = new ArrayList();
        this.mScoClients = new ArrayList();
        this.mBluetoothHeadsetServiceListener = new BluetoothHeadset.ServiceListener(){

            @Override
            public void onServiceConnected() {
                if (AudioService.this.mBluetoothHeadset != null) {
                    BluetoothDevice bluetoothDevice = AudioService.this.mBluetoothHeadset.getCurrentHeadset();
                    if (AudioService.this.mBluetoothHeadset.getState(bluetoothDevice) == 2) {
                        AudioService.access$1502(AudioService.this, true);
                    }
                }
            }

            @Override
            public void onServiceDisconnected() {
                if (AudioService.this.mBluetoothHeadset != null) {
                    BluetoothDevice bluetoothDevice = AudioService.this.mBluetoothHeadset.getCurrentHeadset();
                    if (AudioService.this.mBluetoothHeadset.getState(bluetoothDevice) == 0) {
                        AudioService.access$1502(AudioService.this, false);
                        AudioService.this.clearAllScoClients();
                    }
                }
            }
        };
        this.mPhoneStateListener = new PhoneStateListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onCallStateChanged(int n, String string2) {
                if (n == 1) {
                    Object object = mRingingLock;
                    synchronized (object) {
                        AudioService.access$5102(AudioService.this, true);
                    }
                    if (AudioService.this.getStreamVolume(2) <= 0) return;
                    AudioService.this.requestAudioFocus(2, 2, null, null, AudioService.IN_VOICE_COMM_FOCUS_ID);
                    return;
                }
                if (n == 2) {
                    Object object = mRingingLock;
                    synchronized (object) {
                        AudioService.access$5102(AudioService.this, false);
                    }
                    AudioService.this.requestAudioFocus(2, 2, null, null, AudioService.IN_VOICE_COMM_FOCUS_ID);
                    return;
                }
                if (n != 0) return;
                Object object = mRingingLock;
                synchronized (object) {
                    AudioService.access$5102(AudioService.this, false);
                }
                AudioService.this.abandonAudioFocus(null, AudioService.IN_VOICE_COMM_FOCUS_ID);
            }
        };
        this.mFocusStack = new Stack();
        this.mRCStack = new Stack();
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.MAX_STREAM_VOLUME[0] = SystemProperties.getInt("ro.config.vc_call_vol_steps", this.MAX_STREAM_VOLUME[0]);
        this.mVolumePanel = new VolumePanel(context, this);
        this.mSettingsObserver = new SettingsObserver();
        this.mForcedUseForComm = 0;
        this.createAudioSystemThread();
        this.readPersistedSettings();
        this.createStreamStates();
        this.mMode = -2;
        this.setMode(0, null);
        this.mMediaServerOk = true;
        this.mRingerModeMutedStreams = 0;
        this.setRingerModeInt(this.getRingerMode(), false);
        AudioSystem.setErrorCallback(this.mAudioSystemCallback);
        this.loadSoundEffects();
        this.mBluetoothHeadsetConnected = false;
        this.mBluetoothHeadset = new BluetoothHeadset(context, this.mBluetoothHeadsetServiceListener);
        IntentFilter intentFilter = new IntentFilter("android.intent.action.HEADSET_PLUG");
        intentFilter.addAction("android.bluetooth.a2dp.action.SINK_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.headset.action.STATE_CHANGED");
        intentFilter.addAction("android.intent.action.DOCK_EVENT");
        intentFilter.addAction("android.bluetooth.headset.action.AUDIO_STATE_CHANGED");
        context.registerReceiver(this.mReceiver, intentFilter);
        IntentFilter intentFilter2 = new IntentFilter("android.intent.action.MEDIA_BUTTON");
        intentFilter2.setPriority(1000);
        context.registerReceiver(this.mMediaButtonReceiver, intentFilter2);
        ((TelephonyManager)context.getSystemService("phone")).listen(this.mPhoneStateListener, 32);
    }

    static /* synthetic */ boolean access$002(AudioService audioService, boolean bl) {
        audioService.mMediaServerOk = bl;
        return bl;
    }

    static /* synthetic */ AudioHandler access$102(AudioService audioService, AudioHandler audioHandler) {
        audioService.mAudioHandler = audioHandler;
        return audioHandler;
    }

    static /* synthetic */ int access$1102(AudioService audioService, int n) {
        audioService.mMode = n;
        return n;
    }

    static /* synthetic */ boolean access$1502(AudioService audioService, boolean bl) {
        audioService.mBluetoothHeadsetConnected = bl;
        return bl;
    }

    static /* synthetic */ int access$4202(AudioService audioService, int n) {
        audioService.mRingerModeAffectedStreams = n;
        return n;
    }

    static /* synthetic */ int access$4302(AudioService audioService, int n) {
        audioService.mNotificationsUseRingVolume = n;
        return n;
    }

    static /* synthetic */ String access$4602(AudioService audioService, String string2) {
        audioService.mDockAddress = string2;
        return string2;
    }

    static /* synthetic */ boolean access$5102(AudioService audioService, boolean bl) {
        audioService.mIsRinging = bl;
        return bl;
    }

    private void broadcastRingerMode() {
        Intent intent = new Intent("android.media.RINGER_MODE_CHANGED");
        intent.putExtra("android.media.EXTRA_RINGER_MODE", this.mRingerMode);
        intent.addFlags(0x30000000);
        long l = Binder.clearCallingIdentity();
        this.mContext.sendStickyBroadcast(intent);
        Binder.restoreCallingIdentity(l);
    }

    private void broadcastVibrateSetting(int n) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent intent = new Intent("android.media.VIBRATE_SETTING_CHANGED");
            intent.putExtra("android.media.EXTRA_VIBRATE_TYPE", n);
            intent.putExtra("android.media.EXTRA_VIBRATE_SETTING", this.getVibrateSetting(n));
            this.mContext.sendBroadcast(intent);
        }
    }

    private boolean canReassignAudioFocus() {
        return this.mFocusStack.isEmpty() || !IN_VOICE_COMM_FOCUS_ID.equals(this.mFocusStack.peek().mClientId);
    }

    private void cancelA2dpDeviceTimeout() {
        this.mAudioHandler.removeMessages(8);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean checkForRingerModeChange(int n, int n2) {
        boolean bl = true;
        int n3 = this.mRingerMode;
        if (this.mRingerMode == 2) {
            if (n2 == -1 && (n + 5) / 10 == 1) {
                n3 = Settings.System.getInt(this.mContentResolver, "vibrate_in_silent", 1) == 1 ? 1 : 0;
            }
        } else if (n2 == 1) {
            n3 = 2;
        } else {
            bl = false;
        }
        if (n3 == this.mRingerMode) return bl;
        this.setRingerMode(n3);
        return false;
    }

    private void createAudioSystemThread() {
        this.mAudioSystemThread = new AudioSystemThread();
        this.mAudioSystemThread.start();
        this.waitForAudioHandlerCreation();
    }

    private void createStreamStates() {
        int n = AudioSystem.getNumStreamTypes();
        VolumeStreamState[] volumeStreamStateArray = new VolumeStreamState[n];
        this.mStreamStates = volumeStreamStateArray;
        for (int i = 0; i < n; ++i) {
            volumeStreamStateArray[i] = new VolumeStreamState(Settings.System.VOLUME_SETTINGS[this.STREAM_VOLUME_ALIAS[i]], i);
        }
        for (int i = 0; i < n; ++i) {
            if (this.STREAM_VOLUME_ALIAS[i] == i) continue;
            int n2 = this.rescaleIndex(volumeStreamStateArray[i].mIndex, this.STREAM_VOLUME_ALIAS[i], i);
            VolumeStreamState.access$602(volumeStreamStateArray[i], volumeStreamStateArray[i].getValidIndex(n2));
            this.setStreamVolumeIndex(i, n2);
            int n3 = this.rescaleIndex(volumeStreamStateArray[i].mLastAudibleIndex, this.STREAM_VOLUME_ALIAS[i], i);
            VolumeStreamState.access$802(volumeStreamStateArray[i], volumeStreamStateArray[i].getValidIndex(n3));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dumpFocusStack(PrintWriter printWriter) {
        printWriter.println("\nAudio Focus stack entries:");
        Object object = mAudioFocusLock;
        synchronized (object) {
            Iterator iterator = this.mFocusStack.iterator();
            while (iterator.hasNext()) {
                FocusStackEntry focusStackEntry = (FocusStackEntry)iterator.next();
                printWriter.println("     source:" + focusStackEntry.mSourceRef + " -- client: " + focusStackEntry.mClientId + " -- duration: " + focusStackEntry.mFocusChangeType);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dumpRCStack(PrintWriter printWriter) {
        printWriter.println("\nRemote Control stack entries:");
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            Iterator iterator = this.mRCStack.iterator();
            while (iterator.hasNext()) {
                RemoteControlStackEntry remoteControlStackEntry = (RemoteControlStackEntry)iterator.next();
                printWriter.println("     receiver:" + remoteControlStackEntry.mReceiverComponent);
            }
            return;
        }
    }

    private void ensureValidDirection(int n) {
        if (n < -1 || n > 1) {
            throw new IllegalArgumentException("Bad direction " + n);
        }
    }

    private void ensureValidStreamType(int n) {
        if (n < 0 || n >= this.mStreamStates.length) {
            throw new IllegalArgumentException("Bad stream type " + n);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getActiveStreamType(int n) {
        boolean bl;
        try {
            ITelephony iTelephony = ITelephony.Stub.asInterface(ServiceManager.checkService("phone"));
            bl = false;
            if (iTelephony != null) {
                boolean bl2;
                bl = bl2 = iTelephony.isOffhook();
            }
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Couldn't connect to phone service", remoteException);
            bl = false;
        }
        if (AudioSystem.getForceUse(0) == 3) {
            return 6;
        }
        if (bl || AudioSystem.isStreamActive(0)) {
            return 0;
        }
        if (AudioSystem.isStreamActive(3)) {
            return 3;
        }
        if (n == Integer.MIN_VALUE) {
            return 2;
        }
        return n;
    }

    private static int getMsg(int n, int n2) {
        return 0xFFFF & n | n2 << 16;
    }

    private static int getMsgBase(int n) {
        return 0xFFFF & n;
    }

    public static int getValueForVibrateSetting(int n, int n2, int n3) {
        return n & (0xFFFFFFFF ^ 3 << n2 * 2) | (n3 & 3) << n2 * 2;
    }

    private boolean hasScheduledA2dpDockTimeout() {
        return this.mAudioHandler.hasMessages(8);
    }

    private boolean isStreamMutedByRingerMode(int n) {
        return (this.mRingerModeMutedStreams & 1 << n) != 0;
    }

    private void makeA2dpDeviceAvailable(String string2) {
        AudioSystem.setDeviceConnectionState(128, 1, string2);
        AudioSystem.setParameters("A2dpSuspended=false");
        this.mConnectedDevices.put(new Integer(128), string2);
    }

    private void makeA2dpDeviceUnavailableLater(String string2) {
        AudioSystem.setParameters("A2dpSuspended=true");
        this.mConnectedDevices.remove(128);
        Message message = this.mAudioHandler.obtainMessage(8, string2);
        this.mAudioHandler.sendMessageDelayed(message, 8000L);
    }

    private void makeA2dpDeviceUnavailableNow(String string2) {
        Intent intent = new Intent("android.media.AUDIO_BECOMING_NOISY");
        this.mContext.sendBroadcast(intent);
        AudioSystem.setDeviceConnectionState(128, 0, string2);
        this.mConnectedDevices.remove(128);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void notifyTopOfAudioFocusStack() {
        if (this.mFocusStack.empty() || this.mFocusStack.peek().mFocusDispatcher == null || !this.canReassignAudioFocus()) return;
        try {
            this.mFocusStack.peek().mFocusDispatcher.dispatchAudioFocusChange(1, this.mFocusStack.peek().mClientId);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failure to signal gain of audio control focus due to " + remoteException);
            remoteException.printStackTrace();
            return;
        }
    }

    private void pushMediaButtonReceiver(ComponentName componentName) {
        if (!this.mRCStack.empty() && this.mRCStack.peek().mReceiverComponent.equals(componentName)) {
            return;
        }
        for (RemoteControlStackEntry remoteControlStackEntry : this.mRCStack) {
            if (!remoteControlStackEntry.mReceiverComponent.equals(componentName)) continue;
            this.mRCStack.remove(remoteControlStackEntry);
            break;
        }
        this.mRCStack.push(new RemoteControlStackEntry(componentName));
    }

    private void readPersistedSettings() {
        ContentResolver contentResolver = this.mContentResolver;
        this.mRingerMode = Settings.System.getInt(contentResolver, "mode_ringer", 2);
        this.mVibrateSetting = Settings.System.getInt(contentResolver, "vibrate_on", 0);
        this.mRingerModeAffectedStreams = Settings.System.getInt(contentResolver, "mode_ringer_streams_affected", 166);
        this.mMuteAffectedStreams = Settings.System.getInt(contentResolver, "mute_streams_affected", 14);
        this.mNotificationsUseRingVolume = Settings.System.getInt(contentResolver, "notifications_use_ring_volume", 1);
        if (this.mNotificationsUseRingVolume == 1) {
            this.STREAM_VOLUME_ALIAS[5] = 2;
        }
        this.broadcastRingerMode();
        this.broadcastVibrateSetting(0);
        this.broadcastVibrateSetting(1);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void removeFocusStackEntry(String string2, boolean bl) {
        if (!this.mFocusStack.empty() && this.mFocusStack.peek().mClientId.equals(string2)) {
            this.mFocusStack.pop();
            if (!bl) return;
            this.notifyTopOfAudioFocusStack();
            return;
        } else {
            for (FocusStackEntry focusStackEntry : this.mFocusStack) {
                if (!focusStackEntry.mClientId.equals(string2)) continue;
                Log.i(TAG, " AudioFocus  abandonAudioFocus(): removing entry for " + focusStackEntry.mClientId);
                this.mFocusStack.remove(focusStackEntry);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void removeFocusStackEntryForClient(IBinder iBinder) {
        boolean bl = !this.mFocusStack.isEmpty() && this.mFocusStack.peek().mSourceRef.equals(iBinder);
        for (FocusStackEntry focusStackEntry : this.mFocusStack) {
            if (!focusStackEntry.mSourceRef.equals(iBinder)) continue;
            Log.i(TAG, " AudioFocus  abandonAudioFocus(): removing entry for " + focusStackEntry.mClientId);
            this.mFocusStack.remove(focusStackEntry);
        }
        if (bl) {
            this.notifyTopOfAudioFocusStack();
        }
    }

    private void removeMediaButtonReceiver(ComponentName componentName) {
        for (RemoteControlStackEntry remoteControlStackEntry : this.mRCStack) {
            if (!remoteControlStackEntry.mReceiverComponent.equals(componentName)) continue;
            this.mRCStack.remove(remoteControlStackEntry);
            break;
        }
    }

    private int rescaleIndex(int n, int n2, int n3) {
        return (n * this.mStreamStates[n3].getMaxIndex() + this.mStreamStates[n2].getMaxIndex() / 2) / this.mStreamStates[n2].getMaxIndex();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void sendMsg(Handler handler, int n, int n2, int n3, int n4, int n5, Object object, int n6) {
        int n7 = n2 == -1 ? n : AudioService.getMsg(n, n2);
        if (n3 == 0) {
            handler.removeMessages(n7);
        } else if (n3 == 1 && handler.hasMessages(n7)) {
            return;
        }
        handler.sendMessageDelayed(handler.obtainMessage(n7, n4, n5, object), n6);
    }

    private void sendVolumeUpdate(int n, int n2, int n3) {
        int n4 = (n2 + 5) / 10;
        int n5 = (n3 + 5) / 10;
        Intent intent = new Intent("android.media.VOLUME_CHANGED_ACTION");
        intent.putExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", n);
        intent.putExtra("android.media.EXTRA_VOLUME_STREAM_VALUE", n5);
        intent.putExtra("android.media.EXTRA_PREV_VOLUME_STREAM_VALUE", n4);
        this.mContext.sendBroadcast(intent);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setRingerModeInt(int n, boolean bl) {
        this.mRingerMode = n;
        for (int i = AudioSystem.getNumStreamTypes() - 1; i >= 0; --i) {
            if (this.isStreamMutedByRingerMode(i)) {
                if (this.isStreamAffectedByRingerMode(i) && this.mRingerMode != 2) continue;
                this.mStreamStates[i].mute(null, false);
                this.mRingerModeMutedStreams &= 0xFFFFFFFF ^ 1 << i;
                continue;
            }
            if (!this.isStreamAffectedByRingerMode(i) || this.mRingerMode == 2) continue;
            this.mStreamStates[i].mute(null, true);
            this.mRingerModeMutedStreams |= 1 << i;
        }
        if (bl) {
            AudioService.sendMsg(this.mAudioHandler, 3, -1, 0, 0, 0, null, 3000);
        }
    }

    private void setStreamVolumeIndex(int n, int n2) {
        AudioSystem.setStreamVolumeIndex(n, (n2 + 5) / 10);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setStreamVolumeInt(int n, int n2, boolean bl, boolean bl2) {
        VolumeStreamState volumeStreamState = this.mStreamStates[n];
        if (volumeStreamState.muteCount() != 0) {
            if (n2 == 0) return;
            volumeStreamState.setLastAudibleIndex(n2);
            AudioService.sendMsg(this.mAudioHandler, 1, n, 0, 0, 1, volumeStreamState, 3000);
            return;
        }
        if (!volumeStreamState.setIndex(n2, bl2) && !bl) return;
        AudioService.sendMsg(this.mAudioHandler, 0, n, 1, 0, 0, volumeStreamState, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForAudioHandlerCreation() {
        synchronized (this) {
            AudioHandler audioHandler;
            while ((audioHandler = this.mAudioHandler) == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    Log.e(TAG, "Interrupted while waiting on volume handler.");
                    continue;
                }
                break;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int abandonAudioFocus(IAudioFocusDispatcher iAudioFocusDispatcher, String string2) {
        Log.i(TAG, " AudioFocus  abandonAudioFocus() from " + string2);
        try {
            Object object = mAudioFocusLock;
            synchronized (object) {
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            Log.e(TAG, "FATAL EXCEPTION AudioFocus  abandonAudioFocus() caused " + concurrentModificationException);
            concurrentModificationException.printStackTrace();
            return 1;
        }
        {
            this.removeFocusStackEntry(string2, true);
            return 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void adjustStreamVolume(int n, int n2, int n3) {
        int n4;
        this.ensureValidDirection(n2);
        this.ensureValidStreamType(n);
        VolumeStreamState volumeStreamState = this.mStreamStates[this.STREAM_VOLUME_ALIAS[n]];
        int n5 = volumeStreamState.muteCount() != 0 ? volumeStreamState.mLastAudibleIndex : volumeStreamState.mIndex;
        boolean bl = true;
        if ((n3 & 2) != 0 || n == 2) {
            bl = this.checkForRingerModeChange(n5, n2);
        }
        if (volumeStreamState.muteCount() != 0) {
            if (bl) {
                volumeStreamState.adjustLastAudibleIndex(n2);
                AudioService.sendMsg(this.mAudioHandler, 1, n, 0, 0, 1, volumeStreamState, 3000);
            }
            n4 = volumeStreamState.mLastAudibleIndex;
        } else {
            if (bl && volumeStreamState.adjustIndex(n2)) {
                AudioService.sendMsg(this.mAudioHandler, 0, this.STREAM_VOLUME_ALIAS[n], 1, 0, 0, volumeStreamState, 0);
            }
            n4 = volumeStreamState.mIndex;
        }
        this.mVolumePanel.postVolumeChanged(n, n3);
        this.sendVolumeUpdate(n, n5, n4);
    }

    @Override
    public void adjustSuggestedStreamVolume(int n, int n2, int n3) {
        int n4 = this.getActiveStreamType(n2);
        if (n4 != 2 && (n3 & 4) != 0) {
            n3 &= 0xFFFFFFFB;
        }
        this.adjustStreamVolume(n4, n, n3);
    }

    @Override
    public void adjustVolume(int n, int n2) {
        this.adjustSuggestedStreamVolume(n, Integer.MIN_VALUE, n2);
    }

    boolean checkAudioSettingsPermission(String string2) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_SETTINGS") == 0) {
            return true;
        }
        Log.w(TAG, "Audio Settings Permission Denial: " + string2 + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearAllScoClients() {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            int n = this.mScoClients.size();
            int n2 = 0;
            while (n2 < n) {
                this.mScoClients.get(n2).clearCount(false);
                ++n2;
            }
            return;
        }
    }

    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        this.dumpFocusStack(printWriter);
        this.dumpRCStack(printWriter);
    }

    @Override
    public int getMode() {
        return this.mMode;
    }

    @Override
    public int getRingerMode() {
        return this.mRingerMode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ScoClient getScoClient(IBinder iBinder) {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            int n = this.mScoClients.size();
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    ScoClient scoClient = new ScoClient(iBinder);
                    this.mScoClients.add(scoClient);
                    return scoClient;
                }
                ScoClient scoClient = this.mScoClients.get(n2);
                if (scoClient.getBinder() == iBinder) {
                    return scoClient;
                }
                ++n2;
            }
        }
    }

    @Override
    public int getStreamMaxVolume(int n) {
        this.ensureValidStreamType(n);
        return (5 + this.mStreamStates[n].getMaxIndex()) / 10;
    }

    @Override
    public int getStreamVolume(int n) {
        this.ensureValidStreamType(n);
        return (5 + this.mStreamStates[n].mIndex) / 10;
    }

    @Override
    public int getVibrateSetting(int n) {
        return 3 & this.mVibrateSetting >> n * 2;
    }

    @Override
    public boolean isBluetoothScoOn() {
        return this.mForcedUseForComm == 3;
    }

    @Override
    public boolean isSpeakerphoneOn() {
        return this.mForcedUseForComm == 1;
    }

    public boolean isStreamAffectedByMute(int n) {
        return (this.mMuteAffectedStreams & 1 << n) != 0;
    }

    public boolean isStreamAffectedByRingerMode(int n) {
        return (this.mRingerModeAffectedStreams & 1 << n) != 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadSoundEffects() {
        Object object = this.mSoundEffectsLock;
        synchronized (object) {
            if (this.mSoundPool != null) {
                return true;
            }
            this.mSoundPool = new SoundPool(4, 1, 0);
            if (this.mSoundPool == null) {
                return false;
            }
            int[] nArray = new int[SOUND_EFFECT_FILES.length];
            for (int i = 0; i < SOUND_EFFECT_FILES.length; ++i) {
                nArray[i] = -1;
            }
            int n = 0;
            while (n < 9) {
                if (this.SOUND_EFFECT_FILES_MAP[n][1] != 0) {
                    if (nArray[this.SOUND_EFFECT_FILES_MAP[n][0]] == -1) {
                        int n2;
                        String string2 = Environment.getRootDirectory() + SOUND_EFFECTS_PATH + SOUND_EFFECT_FILES[this.SOUND_EFFECT_FILES_MAP[n][0]];
                        this.SOUND_EFFECT_FILES_MAP[n][1] = n2 = this.mSoundPool.load(string2, 0);
                        nArray[this.SOUND_EFFECT_FILES_MAP[n][0]] = n2;
                        if (n2 <= 0) {
                            Log.w(TAG, "Soundpool could not load file: " + string2);
                        }
                    } else {
                        this.SOUND_EFFECT_FILES_MAP[n][1] = nArray[this.SOUND_EFFECT_FILES_MAP[n][0]];
                    }
                }
                ++n;
            }
            return true;
        }
    }

    @Override
    public void playSoundEffect(int n) {
        AudioService.sendMsg(this.mAudioHandler, 7, -1, 1, n, -1, null, 0);
    }

    @Override
    public void playSoundEffectVolume(int n, float f) {
        this.loadSoundEffects();
        AudioService.sendMsg(this.mAudioHandler, 7, -1, 1, n, (int)(1000.0f * f), null, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void registerMediaButtonEventReceiver(ComponentName componentName) {
        Log.i(TAG, "  Remote Control   registerMediaButtonEventReceiver() for " + componentName);
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            this.pushMediaButtonReceiver(componentName);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void reloadAudioSettings() {
        this.readPersistedSettings();
        int n = AudioSystem.getNumStreamTypes();
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                this.setRingerModeInt(this.getRingerMode(), false);
                return;
            }
            VolumeStreamState volumeStreamState = this.mStreamStates[n2];
            String string2 = Settings.System.VOLUME_SETTINGS[this.STREAM_VOLUME_ALIAS[n2]];
            String string3 = string2 + "_last_audible";
            int n3 = Settings.System.getInt(this.mContentResolver, string2, AudioManager.DEFAULT_STREAM_VOLUME[n2]);
            int n4 = this.STREAM_VOLUME_ALIAS[n2] != n2 ? this.rescaleIndex(n3 * 10, this.STREAM_VOLUME_ALIAS[n2], n2) : n3 * 10;
            VolumeStreamState.access$602(volumeStreamState, volumeStreamState.getValidIndex(n4));
            int n5 = (n4 + 5) / 10;
            ContentResolver contentResolver = this.mContentResolver;
            int n6 = n5 > 0 ? n5 : AudioManager.DEFAULT_STREAM_VOLUME[n2];
            int n7 = Settings.System.getInt(contentResolver, string3, n6);
            int n8 = this.STREAM_VOLUME_ALIAS[n2] != n2 ? this.rescaleIndex(n7 * 10, this.STREAM_VOLUME_ALIAS[n2], n2) : n7 * 10;
            VolumeStreamState.access$802(volumeStreamState, volumeStreamState.getValidIndex(n8));
            if (volumeStreamState.muteCount() != 0 && !this.isStreamAffectedByMute(n2)) {
                int n9 = volumeStreamState.mDeathHandlers.size();
                for (int i = 0; i < n9; ++i) {
                    VolumeStreamState.VolumeDeathHandler.access$1302((VolumeStreamState.VolumeDeathHandler)volumeStreamState.mDeathHandlers.get(i), 1);
                    ((VolumeStreamState.VolumeDeathHandler)volumeStreamState.mDeathHandlers.get(i)).mute(false);
                }
            }
            if (volumeStreamState.muteCount() == 0) {
                this.setStreamVolumeIndex(n2, volumeStreamState.mIndex);
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int requestAudioFocus(int n, int n2, IBinder iBinder, IAudioFocusDispatcher iAudioFocusDispatcher, String string2) {
        Log.i(TAG, " AudioFocus  requestAudioFocus() from " + string2);
        if (!(IN_VOICE_COMM_FOCUS_ID.equals(string2) || iBinder != null && iBinder.pingBinder())) {
            Log.i(TAG, " AudioFocus  DOA client for requestAudioFocus(), exiting");
            return 0;
        }
        Object object = mAudioFocusLock;
        synchronized (object) {
            IAudioFocusDispatcher iAudioFocusDispatcher2;
            if (!this.canReassignAudioFocus()) {
                return 0;
            }
            if (!this.mFocusStack.empty() && this.mFocusStack.peek().mClientId.equals(string2)) {
                if (this.mFocusStack.peek().mFocusChangeType == n2) {
                    return 1;
                }
                this.mFocusStack.pop();
            }
            if (!this.mFocusStack.empty() && (iAudioFocusDispatcher2 = this.mFocusStack.peek().mFocusDispatcher) != null) {
                try {
                    this.mFocusStack.peek().mFocusDispatcher.dispatchAudioFocusChange(n2 * -1, this.mFocusStack.peek().mClientId);
                }
                catch (RemoteException remoteException) {
                    Log.e(TAG, " Failure to signal loss of focus due to " + remoteException);
                    remoteException.printStackTrace();
                }
            }
            this.removeFocusStackEntry(string2, false);
            this.mFocusStack.push(new FocusStackEntry(n, n2, false, iAudioFocusDispatcher, iBinder, string2));
        }
        if (IN_VOICE_COMM_FOCUS_ID.equals(string2)) return 1;
        AudioFocusDeathHandler audioFocusDeathHandler = new AudioFocusDeathHandler(iBinder);
        try {
            iBinder.linkToDeath(audioFocusDeathHandler, 0);
            return 1;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "AudioFocus  requestAudioFocus() could not link to " + iBinder + " binder death");
            return 1;
        }
    }

    @Override
    public void setBluetoothScoOn(boolean bl) {
        if (!this.checkAudioSettingsPermission("setBluetoothScoOn()")) {
            return;
        }
        if (bl) {
            AudioSystem.setForceUse(0, 3);
            AudioSystem.setForceUse(2, 3);
            this.mForcedUseForComm = 3;
            return;
        }
        AudioSystem.setForceUse(0, 0);
        AudioSystem.setForceUse(2, 0);
        this.mForcedUseForComm = 0;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void setMode(int var1_1, IBinder var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [10 : 220->222)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setRingerMode(int n) {
        Object object = this.mSettingsLock;
        synchronized (object) {
            if (n != this.mRingerMode) {
                this.setRingerModeInt(n, true);
                this.broadcastRingerMode();
            }
            return;
        }
    }

    @Override
    public void setSpeakerphoneOn(boolean bl) {
        if (!this.checkAudioSettingsPermission("setSpeakerphoneOn()")) {
            return;
        }
        if (bl) {
            AudioSystem.setForceUse(0, 1);
            this.mForcedUseForComm = 1;
            return;
        }
        AudioSystem.setForceUse(0, 0);
        this.mForcedUseForComm = 0;
    }

    @Override
    public void setStreamMute(int n, boolean bl, IBinder iBinder) {
        if (this.isStreamAffectedByMute(n)) {
            this.mStreamStates[n].mute(iBinder, bl);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setStreamSolo(int n, boolean bl, IBinder iBinder) {
        int n2 = 0;
        while (n2 < this.mStreamStates.length) {
            if (this.isStreamAffectedByMute(n2) && n2 != n) {
                this.mStreamStates[n2].mute(iBinder, bl);
            }
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setStreamVolume(int n, int n2, int n3) {
        this.ensureValidStreamType(n);
        VolumeStreamState volumeStreamState = this.mStreamStates[this.STREAM_VOLUME_ALIAS[n]];
        int n4 = volumeStreamState.muteCount() != 0 ? volumeStreamState.mLastAudibleIndex : volumeStreamState.mIndex;
        int n5 = this.rescaleIndex(n2 * 10, n, this.STREAM_VOLUME_ALIAS[n]);
        this.setStreamVolumeInt(this.STREAM_VOLUME_ALIAS[n], n5, false, true);
        int n6 = volumeStreamState.muteCount() != 0 ? volumeStreamState.mLastAudibleIndex : volumeStreamState.mIndex;
        this.mVolumePanel.postVolumeChanged(n, n3);
        this.sendVolumeUpdate(n, n4, n6);
    }

    @Override
    public void setVibrateSetting(int n, int n2) {
        this.mVibrateSetting = AudioService.getValueForVibrateSetting(this.mVibrateSetting, n, n2);
        this.broadcastVibrateSetting(n);
        AudioService.sendMsg(this.mAudioHandler, 4, -1, 1, 0, 0, null, 0);
    }

    @Override
    public boolean shouldVibrate(int n) {
        switch (this.getVibrateSetting(n)) {
            default: {
                return false;
            }
            case 1: {
                return this.mRingerMode != 0;
            }
            case 2: {
                return this.mRingerMode == 1;
            }
            case 0: 
        }
        return false;
    }

    @Override
    public void startBluetoothSco(IBinder iBinder) {
        if (!this.checkAudioSettingsPermission("startBluetoothSco()")) {
            return;
        }
        this.getScoClient(iBinder).incCount();
    }

    @Override
    public void stopBluetoothSco(IBinder iBinder) {
        if (!this.checkAudioSettingsPermission("stopBluetoothSco()")) {
            return;
        }
        this.getScoClient(iBinder).decCount();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void unloadSoundEffects() {
        Object object = this.mSoundEffectsLock;
        synchronized (object) {
            if (this.mSoundPool == null) {
                return;
            }
            int[] nArray = new int[SOUND_EFFECT_FILES.length];
            for (int i = 0; i < SOUND_EFFECT_FILES.length; ++i) {
                nArray[i] = 0;
            }
            int n = 0;
            while (true) {
                if (n >= 9) {
                    this.mSoundPool = null;
                    return;
                }
                if (this.SOUND_EFFECT_FILES_MAP[n][1] > 0 && nArray[this.SOUND_EFFECT_FILES_MAP[n][0]] == 0) {
                    this.mSoundPool.unload(this.SOUND_EFFECT_FILES_MAP[n][1]);
                    this.SOUND_EFFECT_FILES_MAP[n][1] = -1;
                    nArray[this.SOUND_EFFECT_FILES_MAP[n][0]] = -1;
                }
                ++n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void unregisterAudioFocusClient(String string2) {
        Object object = mAudioFocusLock;
        synchronized (object) {
            this.removeFocusStackEntry(string2, false);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void unregisterMediaButtonEventReceiver(ComponentName componentName) {
        Log.i(TAG, "  Remote Control   unregisterMediaButtonEventReceiver() for " + componentName);
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            this.removeMediaButtonReceiver(componentName);
            return;
        }
    }

    private class AudioFocusDeathHandler
    implements IBinder.DeathRecipient {
        private IBinder mCb;

        AudioFocusDeathHandler(IBinder iBinder) {
            this.mCb = iBinder;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void binderDied() {
            Object object = mAudioFocusLock;
            synchronized (object) {
                Log.w(AudioService.TAG, "  AudioFocus   audio focus client died");
                AudioService.this.removeFocusStackEntryForClient(this.mCb);
                return;
            }
        }

        public IBinder getBinder() {
            return this.mCb;
        }
    }

    private class AudioHandler
    extends Handler {
        private AudioHandler() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void cleanupPlayer(MediaPlayer mediaPlayer) {
            if (mediaPlayer == null) return;
            try {
                mediaPlayer.stop();
                mediaPlayer.release();
                return;
            }
            catch (IllegalStateException illegalStateException) {
                Log.w(AudioService.TAG, "MediaPlayer IllegalStateException: " + illegalStateException);
                return;
            }
        }

        private void persistRingerMode() {
            Settings.System.putInt(AudioService.this.mContentResolver, "mode_ringer", AudioService.this.mRingerMode);
        }

        private void persistVibrateSetting() {
            Settings.System.putInt(AudioService.this.mContentResolver, "vibrate_on", AudioService.this.mVibrateSetting);
        }

        private void persistVolume(VolumeStreamState volumeStreamState, boolean bl, boolean bl2) {
            if (bl) {
                Settings.System.putInt(AudioService.this.mContentResolver, volumeStreamState.mVolumeIndexSettingName, (5 + volumeStreamState.mIndex) / 10);
            }
            if (bl2) {
                Settings.System.putInt(AudioService.this.mContentResolver, volumeStreamState.mLastAudibleVolumeIndexSettingName, (5 + volumeStreamState.mLastAudibleIndex) / 10);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void playSoundEffect(int n, int n2) {
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                if (AudioService.this.mSoundPool == null) {
                    return;
                }
                float f = n2 < 0 ? (float)Math.pow(10.0, ((float)(50.0 / (double)AudioService.this.MAX_STREAM_VOLUME[3]) * (float)((5 + AudioService.this.mStreamStates[3].mIndex) / 10 - AudioService.this.MAX_STREAM_VOLUME[3]) - 3.0f) / 20.0f) : (float)n2 / 1000.0f;
                if (AudioService.this.SOUND_EFFECT_FILES_MAP[n][1] > 0) {
                    AudioService.this.mSoundPool.play(AudioService.this.SOUND_EFFECT_FILES_MAP[n][1], f, f, 0, 0, 1.0f);
                } else {
                    MediaPlayer mediaPlayer = new MediaPlayer();
                    if (mediaPlayer != null) {
                        try {
                            mediaPlayer.setDataSource(Environment.getRootDirectory() + AudioService.SOUND_EFFECTS_PATH + SOUND_EFFECT_FILES[AudioService.this.SOUND_EFFECT_FILES_MAP[n][0]]);
                            mediaPlayer.setAudioStreamType(1);
                            mediaPlayer.prepare();
                            mediaPlayer.setVolume(f, f);
                            mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                                @Override
                                public void onCompletion(MediaPlayer mediaPlayer) {
                                    AudioHandler.this.cleanupPlayer(mediaPlayer);
                                }
                            });
                            mediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                                @Override
                                public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
                                    AudioHandler.this.cleanupPlayer(mediaPlayer);
                                    return true;
                                }
                            });
                            mediaPlayer.start();
                        }
                        catch (IOException iOException) {
                            Log.w(AudioService.TAG, "MediaPlayer IOException: " + iOException);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            Log.w(AudioService.TAG, "MediaPlayer IllegalArgumentException: " + illegalArgumentException);
                        }
                        catch (IllegalStateException illegalStateException) {
                            Log.w(AudioService.TAG, "MediaPlayer IllegalStateException: " + illegalStateException);
                        }
                    }
                }
                return;
            }
        }

        private void setSystemVolume(VolumeStreamState volumeStreamState) {
            AudioService.this.setStreamVolumeIndex(volumeStreamState.mStreamType, volumeStreamState.mIndex);
            for (int i = AudioSystem.getNumStreamTypes() - 1; i >= 0; --i) {
                if (i == volumeStreamState.mStreamType || AudioService.this.STREAM_VOLUME_ALIAS[i] != volumeStreamState.mStreamType) continue;
                AudioService.this.setStreamVolumeIndex(i, AudioService.this.mStreamStates[i].mIndex);
            }
            AudioService.sendMsg(AudioService.this.mAudioHandler, 1, volumeStreamState.mStreamType, 0, 1, 1, volumeStreamState, 3000);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleMessage(Message message) {
            switch (AudioService.getMsgBase(message.what)) {
                case 0: {
                    this.setSystemVolume((VolumeStreamState)message.obj);
                    return;
                }
                case 1: {
                    VolumeStreamState volumeStreamState = (VolumeStreamState)message.obj;
                    boolean bl = message.arg1 != 0;
                    boolean bl2 = message.arg2 != 0;
                    this.persistVolume(volumeStreamState, bl, bl2);
                    return;
                }
                case 3: {
                    this.persistRingerMode();
                    return;
                }
                case 4: {
                    this.persistVibrateSetting();
                    return;
                }
                case 5: {
                    if (!AudioService.this.mMediaServerOk) {
                        Log.e(AudioService.TAG, "Media server died.");
                        AudioSystem.isStreamActive(3);
                        AudioService.sendMsg(AudioService.this.mAudioHandler, 5, -1, 1, 0, 0, null, 500);
                        return;
                    }
                }
                default: {
                    return;
                }
                case 6: {
                    Log.e(AudioService.TAG, "Media server started.");
                    AudioSystem.setParameters("restarting=true");
                    for (Map.Entry entry : AudioService.this.mConnectedDevices.entrySet()) {
                        AudioSystem.setDeviceConnectionState((Integer)entry.getKey(), 1, (String)entry.getValue());
                    }
                    AudioSystem.setPhoneState(AudioService.this.mMode);
                    AudioSystem.setForceUse(0, AudioService.this.mForcedUseForComm);
                    AudioSystem.setForceUse(2, AudioService.this.mForcedUseForComm);
                    int n = AudioSystem.getNumStreamTypes() - 1;
                    while (true) {
                        if (n < 0) {
                            AudioService.this.setRingerModeInt(AudioService.this.getRingerMode(), false);
                            AudioSystem.setParameters("restarting=false");
                            return;
                        }
                        VolumeStreamState volumeStreamState = AudioService.this.mStreamStates[n];
                        int n2 = (5 + volumeStreamState.mIndexMax) / 10;
                        AudioSystem.initStreamVolume(n, 0, n2);
                        int n3 = volumeStreamState.muteCount() == 0 ? volumeStreamState.mIndex : 0;
                        AudioService.this.setStreamVolumeIndex(n, n3);
                        --n;
                    }
                }
                case 7: {
                    this.playSoundEffect(message.arg1, message.arg2);
                    return;
                }
                case 8: 
            }
            AudioService.this.makeA2dpDeviceUnavailableNow((String)message.obj);
        }
    }

    private class AudioServiceBroadcastReceiver
    extends BroadcastReceiver {
        private AudioServiceBroadcastReceiver() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String string2 = intent.getAction();
            if (string2.equals("android.intent.action.DOCK_EVENT")) {
                int n;
                switch (intent.getIntExtra("android.intent.extra.DOCK_STATE", 0)) {
                    default: {
                        n = 0;
                        break;
                    }
                    case 1: {
                        n = 7;
                        break;
                    }
                    case 2: {
                        n = 6;
                    }
                }
                AudioSystem.setForceUse(3, n);
                return;
            }
            if (string2.equals("android.bluetooth.a2dp.action.SINK_STATE_CHANGED")) {
                int n = intent.getIntExtra("android.bluetooth.a2dp.extra.SINK_STATE", 0);
                BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                String string3 = bluetoothDevice.getAddress();
                boolean bl = AudioService.this.mConnectedDevices.containsKey(128) && ((String)AudioService.this.mConnectedDevices.get(128)).equals(string3);
                if (bl && n != 2 && n != 4) {
                    if (bluetoothDevice.isBluetoothDock()) {
                        if (n != 0) return;
                        AudioService.this.makeA2dpDeviceUnavailableLater(string3);
                        return;
                    }
                    AudioService.this.makeA2dpDeviceUnavailableNow(string3);
                    return;
                }
                if (bl) return;
                if (n != 2) {
                    if (n != 4) return;
                }
                if (bluetoothDevice.isBluetoothDock()) {
                    AudioService.this.cancelA2dpDeviceTimeout();
                    AudioService.access$4602(AudioService.this, string3);
                } else if (AudioService.this.hasScheduledA2dpDockTimeout()) {
                    AudioService.this.cancelA2dpDeviceTimeout();
                    AudioService.this.makeA2dpDeviceUnavailableNow(AudioService.this.mDockAddress);
                }
                AudioService.this.makeA2dpDeviceAvailable(string3);
                return;
            }
            if (string2.equals("android.bluetooth.headset.action.STATE_CHANGED")) {
                boolean bl;
                int n = intent.getIntExtra("android.bluetooth.headset.extra.STATE", -1);
                int n2 = 16;
                BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                String string4 = null;
                if (bluetoothDevice != null) {
                    string4 = bluetoothDevice.getAddress();
                    BluetoothClass bluetoothClass = bluetoothDevice.getBluetoothClass();
                    if (bluetoothClass != null) {
                        switch (bluetoothClass.getDeviceClass()) {
                            case 1028: 
                            case 1032: {
                                n2 = 32;
                                break;
                            }
                            case 1056: {
                                n2 = 64;
                            }
                        }
                    }
                }
                if ((bl = AudioService.this.mConnectedDevices.containsKey(n2) && ((String)AudioService.this.mConnectedDevices.get(n2)).equals(string4)) && n != 2) {
                    AudioSystem.setDeviceConnectionState(n2, 0, string4);
                    AudioService.this.mConnectedDevices.remove(n2);
                    AudioService.access$1502(AudioService.this, false);
                    AudioService.this.clearAllScoClients();
                    return;
                }
                if (bl) return;
                if (n != 2) return;
                AudioSystem.setDeviceConnectionState(n2, 1, string4);
                AudioService.this.mConnectedDevices.put(new Integer(n2), string4);
                AudioService.access$1502(AudioService.this, true);
                return;
            }
            if (string2.equals("android.intent.action.HEADSET_PLUG")) {
                int n = intent.getIntExtra("state", 0);
                if (intent.getIntExtra("microphone", 0) != 0) {
                    boolean bl = AudioService.this.mConnectedDevices.containsKey(4);
                    if (n == 0 && bl) {
                        AudioSystem.setDeviceConnectionState(4, 0, "");
                        AudioService.this.mConnectedDevices.remove(4);
                        return;
                    }
                    if (n != 1) return;
                    if (bl) return;
                    AudioSystem.setDeviceConnectionState(4, 1, "");
                    AudioService.this.mConnectedDevices.put(new Integer(4), "");
                    return;
                }
                boolean bl = AudioService.this.mConnectedDevices.containsKey(8);
                if (n == 0 && bl) {
                    AudioSystem.setDeviceConnectionState(8, 0, "");
                    AudioService.this.mConnectedDevices.remove(8);
                    return;
                }
                if (n != 1) return;
                if (bl) return;
                AudioSystem.setDeviceConnectionState(8, 1, "");
                AudioService.this.mConnectedDevices.put(new Integer(8), "");
                return;
            }
            if (!string2.equals("android.bluetooth.headset.action.AUDIO_STATE_CHANGED")) return;
            int n = intent.getIntExtra("android.bluetooth.headset.extra.AUDIO_STATE", -1);
            ArrayList arrayList = AudioService.this.mScoClients;
            // MONITORENTER : arrayList
            if (!AudioService.this.mScoClients.isEmpty()) {
                int n3;
                switch (n) {
                    case 1: {
                        n3 = 1;
                        break;
                    }
                    case 0: {
                        n3 = 0;
                        break;
                    }
                    default: {
                        n3 = -1;
                    }
                }
                if (n3 != -1) {
                    Intent intent2 = new Intent("android.media.SCO_AUDIO_STATE_CHANGED");
                    intent2.putExtra("android.media.extra.SCO_AUDIO_STATE", n3);
                    AudioService.this.mContext.sendStickyBroadcast(intent2);
                }
            }
            // MONITOREXIT : arrayList
        }
    }

    private class AudioSystemThread
    extends Thread {
        AudioSystemThread() {
            super(AudioService.TAG);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Looper.prepare();
            AudioService audioService = AudioService.this;
            synchronized (audioService) {
                AudioService.access$102(AudioService.this, new AudioHandler());
                AudioService.this.notify();
            }
            Looper.loop();
        }
    }

    private static class FocusStackEntry {
        public String mClientId;
        public int mFocusChangeType;
        public IAudioFocusDispatcher mFocusDispatcher = null;
        public boolean mIsTransportControlReceiver = false;
        public IBinder mSourceRef = null;
        public int mStreamType = -1;

        public FocusStackEntry() {
        }

        public FocusStackEntry(int n, int n2, boolean bl, IAudioFocusDispatcher iAudioFocusDispatcher, IBinder iBinder, String string2) {
            this.mStreamType = n;
            this.mIsTransportControlReceiver = bl;
            this.mFocusDispatcher = iAudioFocusDispatcher;
            this.mSourceRef = iBinder;
            this.mClientId = string2;
            this.mFocusChangeType = n2;
        }
    }

    private class MediaButtonBroadcastReceiver
    extends BroadcastReceiver {
        private MediaButtonBroadcastReceiver() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if (!"android.intent.action.MEDIA_BUTTON".equals(intent.getAction()) || (KeyEvent)intent.getParcelableExtra("android.intent.extra.KEY_EVENT") == null) {
                return;
            }
            Object object = mRingingLock;
            synchronized (object) {
                if (AudioService.this.mIsRinging || AudioService.this.getMode() == 2 || AudioService.this.getMode() == 3 || AudioService.this.getMode() == 1) {
                    return;
                }
            }
            Stack stack = AudioService.this.mRCStack;
            synchronized (stack) {
                if (!AudioService.this.mRCStack.empty()) {
                    Intent intent2 = new Intent("android.intent.action.MEDIA_BUTTON");
                    intent2.putExtras(intent.getExtras());
                    intent2.setComponent(((RemoteControlStackEntry)((AudioService)AudioService.this).mRCStack.peek()).mReceiverComponent);
                    this.abortBroadcast();
                    context.sendBroadcast(intent2, null);
                }
                return;
            }
        }
    }

    private static class RemoteControlStackEntry {
        public ComponentName mReceiverComponent;

        public RemoteControlStackEntry() {
        }

        public RemoteControlStackEntry(ComponentName componentName) {
            this.mReceiverComponent = componentName;
        }
    }

    private class ScoClient
    implements IBinder.DeathRecipient {
        private IBinder mCb;
        private int mStartcount;

        ScoClient(IBinder iBinder) {
            this.mCb = iBinder;
            this.mStartcount = 0;
        }

        private void requestScoState(int n) {
            block3: {
                block2: {
                    if (this.totalCount() != 0 || !AudioService.this.mBluetoothHeadsetConnected || AudioService.this.mMode != 0) break block2;
                    if (n != 1) break block3;
                    AudioService.this.mBluetoothHeadset.startVoiceRecognition();
                }
                return;
            }
            AudioService.this.mBluetoothHeadset.stopVoiceRecognition();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void binderDied() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                Log.w(AudioService.TAG, "SCO client died");
                if (AudioService.this.mScoClients.indexOf(this) < 0) {
                    Log.w(AudioService.TAG, "unregistered SCO client died");
                } else {
                    this.clearCount(true);
                    AudioService.this.mScoClients.remove(this);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void clearCount(boolean bl) {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                int n = this.mStartcount;
                if (n != 0) {
                    try {
                        this.mCb.unlinkToDeath(this, 0);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        Log.w(AudioService.TAG, "clearCount() mStartcount: " + this.mStartcount + " != 0 but not registered to binder");
                    }
                }
                this.mStartcount = 0;
                if (bl) {
                    this.requestScoState(0);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void decCount() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                if (this.mStartcount == 0) {
                    Log.w(AudioService.TAG, "ScoClient.decCount() already 0");
                } else {
                    --this.mStartcount;
                    int n = this.mStartcount;
                    if (n == 0) {
                        try {
                            this.mCb.unlinkToDeath(this, 0);
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            Log.w(AudioService.TAG, "decCount() going to 0 but not registered to binder");
                        }
                    }
                    this.requestScoState(0);
                }
                return;
            }
        }

        public IBinder getBinder() {
            return this.mCb;
        }

        public int getCount() {
            return this.mStartcount;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void incCount() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                this.requestScoState(1);
                int n = this.mStartcount;
                if (n == 0) {
                    try {
                        this.mCb.linkToDeath(this, 0);
                    }
                    catch (RemoteException remoteException) {
                        Log.w(AudioService.TAG, "ScoClient  incCount() could not link to " + this.mCb + " binder death");
                    }
                }
                this.mStartcount = 1 + this.mStartcount;
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int totalCount() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                int n = 0;
                int n2 = AudioService.this.mScoClients.size();
                int n3 = 0;
                while (n3 < n2) {
                    n += ((ScoClient)AudioService.this.mScoClients.get(n3)).getCount();
                    ++n3;
                }
                return n;
            }
        }
    }

    private class SetModeDeathHandler
    implements IBinder.DeathRecipient {
        private IBinder mCb;
        private int mMode = 0;

        SetModeDeathHandler(IBinder iBinder) {
            this.mCb = iBinder;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void binderDied() {
            ArrayList arrayList = AudioService.this.mSetModeDeathHandlers;
            synchronized (arrayList) {
                Log.w(AudioService.TAG, "setMode() client died");
                int n = AudioService.this.mSetModeDeathHandlers.indexOf(this);
                if (n < 0) {
                    Log.w(AudioService.TAG, "unregistered setMode() client died");
                } else {
                    AudioService.this.mSetModeDeathHandlers.remove(this);
                    if (n == 0) {
                        int n2 = ((SetModeDeathHandler)AudioService.this.mSetModeDeathHandlers.get(0)).getMode();
                        if (AudioService.this.mMode != n2 && AudioSystem.setPhoneState(n2) == 0) {
                            AudioService.access$1102(AudioService.this, n2);
                        }
                    }
                }
                return;
            }
        }

        public IBinder getBinder() {
            return this.mCb;
        }

        public int getMode() {
            return this.mMode;
        }

        public void setMode(int n) {
            this.mMode = n;
        }
    }

    private class SettingsObserver
    extends ContentObserver {
        SettingsObserver() {
            super(new Handler());
            AudioService.this.mContentResolver.registerContentObserver(Settings.System.getUriFor("mode_ringer_streams_affected"), false, this);
            AudioService.this.mContentResolver.registerContentObserver(Settings.System.getUriFor("notifications_use_ring_volume"), false, this);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onChange(boolean bl) {
            super.onChange(bl);
            Object object = AudioService.this.mSettingsLock;
            synchronized (object) {
                int n;
                int n2 = Settings.System.getInt(AudioService.this.mContentResolver, "mode_ringer_streams_affected", 0);
                if (n2 != AudioService.this.mRingerModeAffectedStreams) {
                    AudioService.access$4202(AudioService.this, n2);
                    AudioService.this.setRingerModeInt(AudioService.this.getRingerMode(), false);
                }
                if ((n = Settings.System.getInt(AudioService.this.mContentResolver, "notifications_use_ring_volume", 1)) != AudioService.this.mNotificationsUseRingVolume) {
                    AudioService.access$4302(AudioService.this, n);
                    if (AudioService.this.mNotificationsUseRingVolume == 1) {
                        ((AudioService)AudioService.this).STREAM_VOLUME_ALIAS[5] = 2;
                        AudioService.this.mStreamStates[5].setVolumeIndexSettingName(Settings.System.VOLUME_SETTINGS[2]);
                    } else {
                        ((AudioService)AudioService.this).STREAM_VOLUME_ALIAS[5] = 5;
                        AudioService.this.mStreamStates[5].setVolumeIndexSettingName(Settings.System.VOLUME_SETTINGS[5]);
                        AudioService.sendMsg(AudioService.this.mAudioHandler, 1, 5, 0, 1, 1, AudioService.this.mStreamStates[5], 0);
                    }
                }
                return;
            }
        }
    }

    public class VolumeStreamState {
        private ArrayList<VolumeDeathHandler> mDeathHandlers;
        private int mIndex;
        private int mIndexMax;
        private int mLastAudibleIndex;
        private String mLastAudibleVolumeIndexSettingName;
        private final int mStreamType;
        private String mVolumeIndexSettingName;

        /*
         * Enabled aggressive block sorting
         */
        private VolumeStreamState(String string2, int n) {
            this.setVolumeIndexSettingName(string2);
            this.mStreamType = n;
            ContentResolver contentResolver = AudioService.this.mContentResolver;
            this.mIndexMax = AudioService.this.MAX_STREAM_VOLUME[n];
            this.mIndex = Settings.System.getInt(contentResolver, this.mVolumeIndexSettingName, AudioManager.DEFAULT_STREAM_VOLUME[n]);
            String string3 = this.mLastAudibleVolumeIndexSettingName;
            int n2 = this.mIndex > 0 ? this.mIndex : AudioManager.DEFAULT_STREAM_VOLUME[n];
            this.mLastAudibleIndex = Settings.System.getInt(contentResolver, string3, n2);
            AudioSystem.initStreamVolume(n, 0, this.mIndexMax);
            this.mIndexMax = 10 * this.mIndexMax;
            this.mIndex = this.getValidIndex(10 * this.mIndex);
            this.mLastAudibleIndex = this.getValidIndex(10 * this.mLastAudibleIndex);
            AudioService.this.setStreamVolumeIndex(n, this.mIndex);
            this.mDeathHandlers = new ArrayList();
        }

        static /* synthetic */ int access$602(VolumeStreamState volumeStreamState, int n) {
            volumeStreamState.mIndex = n;
            return n;
        }

        static /* synthetic */ int access$802(VolumeStreamState volumeStreamState, int n) {
            volumeStreamState.mLastAudibleIndex = n;
            return n;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private VolumeDeathHandler getDeathHandler(IBinder iBinder, boolean bl) {
            ArrayList<VolumeDeathHandler> arrayList = this.mDeathHandlers;
            synchronized (arrayList) {
                int n = this.mDeathHandlers.size();
                int n2 = 0;
                while (true) {
                    if (n2 < n) {
                        VolumeDeathHandler volumeDeathHandler = this.mDeathHandlers.get(n2);
                        if (iBinder == volumeDeathHandler.mICallback) {
                            return volumeDeathHandler;
                        }
                    } else {
                        if (bl) {
                            return new VolumeDeathHandler(iBinder);
                        }
                        Log.w(AudioService.TAG, "stream was not muted by this client");
                        return null;
                    }
                    ++n2;
                }
            }
        }

        private int getValidIndex(int n) {
            if (n < 0) {
                return 0;
            }
            if (n > this.mIndexMax) {
                return this.mIndexMax;
            }
            return n;
        }

        private int muteCount() {
            int n = 0;
            int n2 = this.mDeathHandlers.size();
            for (int i = 0; i < n2; ++i) {
                n += this.mDeathHandlers.get(i).mMuteCount;
            }
            return n;
        }

        public boolean adjustIndex(int n) {
            return this.setIndex(this.mIndex + n * 10, true);
        }

        public void adjustLastAudibleIndex(int n) {
            this.setLastAudibleIndex(this.mLastAudibleIndex + n * 10);
        }

        public int getMaxIndex() {
            return this.mIndexMax;
        }

        public void mute(IBinder iBinder, boolean bl) {
            VolumeDeathHandler volumeDeathHandler = this.getDeathHandler(iBinder, bl);
            if (volumeDeathHandler == null) {
                Log.e(AudioService.TAG, "Could not get client death handler for stream: " + this.mStreamType);
                return;
            }
            volumeDeathHandler.mute(bl);
        }

        public boolean setIndex(int n, boolean bl) {
            int n2 = this.mIndex;
            this.mIndex = this.getValidIndex(n);
            if (n2 != this.mIndex) {
                if (bl) {
                    this.mLastAudibleIndex = this.mIndex;
                }
                for (int i = AudioSystem.getNumStreamTypes() - 1; i >= 0; --i) {
                    if (i == this.mStreamType || AudioService.this.STREAM_VOLUME_ALIAS[i] != this.mStreamType) continue;
                    AudioService.this.mStreamStates[i].setIndex(AudioService.this.rescaleIndex(this.mIndex, this.mStreamType, i), bl);
                }
                return true;
            }
            return false;
        }

        public void setLastAudibleIndex(int n) {
            this.mLastAudibleIndex = this.getValidIndex(n);
        }

        public void setVolumeIndexSettingName(String string2) {
            this.mVolumeIndexSettingName = string2;
            this.mLastAudibleVolumeIndexSettingName = string2 + "_last_audible";
        }

        private class VolumeDeathHandler
        implements IBinder.DeathRecipient {
            private IBinder mICallback;
            private int mMuteCount;

            VolumeDeathHandler(IBinder iBinder) {
                this.mICallback = iBinder;
            }

            static /* synthetic */ int access$1302(VolumeDeathHandler volumeDeathHandler, int n) {
                volumeDeathHandler.mMuteCount = n;
                return n;
            }

            @Override
            public void binderDied() {
                Log.w(AudioService.TAG, "Volume service client died for stream: " + VolumeStreamState.this.mStreamType);
                if (this.mMuteCount != 0) {
                    this.mMuteCount = 1;
                    this.mute(false);
                }
            }

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void mute(boolean var1_1) {
                var2_2 = VolumeStreamState.access$1200(VolumeStreamState.this);
                synchronized (var2_2) {
                    if (var1_1) {
                        var8_3 = this.mMuteCount;
                        if (var8_3 == 0) {
                            try {
                                if (this.mICallback != null) {
                                    this.mICallback.linkToDeath(this, 0);
                                }
                                VolumeStreamState.access$1200(VolumeStreamState.this).add(this);
                                if (VolumeStreamState.access$900(VolumeStreamState.this) != 0) ** GOTO lbl22
                                VolumeStreamState.this.setIndex(0, false);
                                AudioService.access$200(AudioService.access$100(AudioService.this), 0, VolumeStreamState.access$2300(VolumeStreamState.this), 1, 0, 0, VolumeStreamState.this, 0);
                            }
                            catch (RemoteException var10_4) {
                                this.binderDied();
                                VolumeStreamState.access$1200(VolumeStreamState.this).notify();
                                return;
                            }
                        } else {
                            Log.w("AudioService", "stream: " + VolumeStreamState.access$2300(VolumeStreamState.this) + " was already muted by this client");
                        }
lbl22:
                        // 3 sources

                        this.mMuteCount = 1 + this.mMuteCount;
                    } else if (this.mMuteCount == 0) {
                        Log.e("AudioService", "unexpected unmute for stream: " + VolumeStreamState.access$2300(VolumeStreamState.this));
                    } else {
                        --this.mMuteCount;
                        if (this.mMuteCount == 0) {
                            VolumeStreamState.access$1200(VolumeStreamState.this).remove(this);
                            if (this.mICallback != null) {
                                this.mICallback.unlinkToDeath(this, 0);
                            }
                            if (!(VolumeStreamState.access$900(VolumeStreamState.this) != 0 || AudioService.this.isStreamAffectedByRingerMode(VolumeStreamState.access$2300(VolumeStreamState.this)) && AudioService.access$2400(AudioService.this) != 2)) {
                                VolumeStreamState.this.setIndex(VolumeStreamState.access$800(VolumeStreamState.this), false);
                                AudioService.access$200(AudioService.access$100(AudioService.this), 0, VolumeStreamState.access$2300(VolumeStreamState.this), 1, 0, 0, VolumeStreamState.this, 0);
                            }
                        }
                    }
                    VolumeStreamState.access$1200(VolumeStreamState.this).notify();
                    return;
                }
            }
        }
    }
}

