/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.database.Cursor;
import android.database.SQLException;
import android.graphics.BitmapFactory;
import android.media.ExifInterface;
import android.media.MediaFile;
import android.media.MediaScannerClient;
import android.net.Uri;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.provider.MediaStore;
import android.provider.Settings;
import android.sax.ElementListener;
import android.sax.RootElement;
import android.text.TextUtils;
import android.util.Log;
import android.util.Xml;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MediaScanner {
    private static final String ALARMS_DIR = "/alarms/";
    private static final String[] AUDIO_PROJECTION;
    private static final int DATE_MODIFIED_AUDIO_COLUMN_INDEX = 2;
    private static final int DATE_MODIFIED_IMAGES_COLUMN_INDEX = 2;
    private static final int DATE_MODIFIED_PLAYLISTS_COLUMN_INDEX = 2;
    private static final int DATE_MODIFIED_VIDEO_COLUMN_INDEX = 2;
    private static final String DEFAULT_RINGTONE_PROPERTY_PREFIX = "ro.config.";
    private static final String[] GENRE_LOOKUP_PROJECTION;
    private static final String[] ID3_GENRES;
    private static final int ID_AUDIO_COLUMN_INDEX = 0;
    private static final int ID_IMAGES_COLUMN_INDEX = 0;
    private static final int ID_PLAYLISTS_COLUMN_INDEX = 0;
    private static final int ID_VIDEO_COLUMN_INDEX = 0;
    private static final String[] IMAGES_PROJECTION;
    private static final String MUSIC_DIR = "/music/";
    private static final String NOTIFICATIONS_DIR = "/notifications/";
    private static final int PATH_AUDIO_COLUMN_INDEX = 1;
    private static final int PATH_IMAGES_COLUMN_INDEX = 1;
    private static final int PATH_PLAYLISTS_COLUMN_INDEX = 1;
    private static final int PATH_VIDEO_COLUMN_INDEX = 1;
    private static final String[] PLAYLISTS_PROJECTION;
    private static final String[] PLAYLIST_MEMBERS_PROJECTION;
    private static final String PODCAST_DIR = "/podcasts/";
    private static final String RINGTONES_DIR = "/ringtones/";
    private static final String TAG = "MediaScanner";
    private static final String[] VIDEO_PROJECTION;
    private Uri mAudioUri;
    private BitmapFactory.Options mBitmapOptions = new BitmapFactory.Options();
    private boolean mCaseInsensitivePaths;
    private MyMediaScannerClient mClient = new MyMediaScannerClient();
    private Context mContext;
    private String mDefaultAlarmAlertFilename;
    private boolean mDefaultAlarmSet;
    private String mDefaultNotificationFilename;
    private boolean mDefaultNotificationSet;
    private String mDefaultRingtoneFilename;
    private boolean mDefaultRingtoneSet;
    private HashMap<String, FileCacheEntry> mFileCache;
    private HashMap<String, Uri> mGenreCache;
    private Uri mGenresUri;
    private Uri mImagesUri;
    private IContentProvider mMediaProvider;
    private int mNativeContext;
    private int mOriginalCount;
    private ArrayList<FileCacheEntry> mPlayLists;
    private Uri mPlaylistsUri;
    private boolean mProcessGenres;
    private boolean mProcessPlaylists;
    private Uri mThumbsUri;
    private Uri mVideoUri;

    static {
        System.loadLibrary("media_jni");
        MediaScanner.native_init();
        AUDIO_PROJECTION = new String[]{"_id", "_data", "date_modified"};
        VIDEO_PROJECTION = new String[]{"_id", "_data", "date_modified"};
        IMAGES_PROJECTION = new String[]{"_id", "_data", "date_modified"};
        PLAYLISTS_PROJECTION = new String[]{"_id", "_data", "date_modified"};
        PLAYLIST_MEMBERS_PROJECTION = new String[]{"playlist_id"};
        GENRE_LOOKUP_PROJECTION = new String[]{"_id", "name"};
        ID3_GENRES = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Bass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "A capella", "Euro-House", "Dance Hall"};
    }

    public MediaScanner(Context context) {
        this.native_setup();
        this.mContext = context;
        this.mBitmapOptions.inSampleSize = 1;
        this.mBitmapOptions.inJustDecodeBounds = true;
        this.setDefaultRingtoneFileNames();
    }

    static /* synthetic */ boolean access$1100(MediaScanner mediaScanner) {
        return mediaScanner.mProcessGenres;
    }

    static /* synthetic */ HashMap access$1200(MediaScanner mediaScanner) {
        return mediaScanner.mGenreCache;
    }

    static /* synthetic */ Uri access$1300(MediaScanner mediaScanner) {
        return mediaScanner.mGenresUri;
    }

    static /* synthetic */ String[] access$1400() {
        return GENRE_LOOKUP_PROJECTION;
    }

    static /* synthetic */ boolean access$1500(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultNotificationSet;
    }

    static /* synthetic */ boolean access$1502(MediaScanner mediaScanner, boolean bl) {
        mediaScanner.mDefaultNotificationSet = bl;
        return bl;
    }

    static /* synthetic */ String access$1600(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultNotificationFilename;
    }

    static /* synthetic */ boolean access$1700(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultRingtoneSet;
    }

    static /* synthetic */ boolean access$1702(MediaScanner mediaScanner, boolean bl) {
        mediaScanner.mDefaultRingtoneSet = bl;
        return bl;
    }

    static /* synthetic */ String access$1800(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultRingtoneFilename;
    }

    static /* synthetic */ boolean access$1900(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultAlarmSet;
    }

    static /* synthetic */ boolean access$1902(MediaScanner mediaScanner, boolean bl) {
        mediaScanner.mDefaultAlarmSet = bl;
        return bl;
    }

    static /* synthetic */ String access$2000(MediaScanner mediaScanner) {
        return mediaScanner.mDefaultAlarmAlertFilename;
    }

    static /* synthetic */ Uri access$700(MediaScanner mediaScanner) {
        return mediaScanner.mVideoUri;
    }

    static /* synthetic */ Uri access$800(MediaScanner mediaScanner) {
        return mediaScanner.mImagesUri;
    }

    static /* synthetic */ Uri access$900(MediaScanner mediaScanner) {
        return mediaScanner.mAudioUri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addPlayListEntry(String string2, String string3, Uri uri, ContentValues contentValues, int n) {
        char c;
        boolean bl;
        int n2;
        int n3;
        for (n3 = string2.length(); n3 > 0 && Character.isWhitespace(string2.charAt(n2 = n3 - 1)); --n3) {
        }
        if (n3 < 3) {
            return false;
        }
        if (n3 < string2.length()) {
            string2 = string2.substring(0, n3);
        }
        if (!(bl = (c = string2.charAt(0)) == '/' || Character.isLetter(c) && string2.charAt(1) == ':' && string2.charAt(2) == '\\')) {
            string2 = string3 + string2;
        }
        FileCacheEntry fileCacheEntry = null;
        int n4 = 0;
        Iterator<FileCacheEntry> iterator = this.mFileCache.values().iterator();
        while (true) {
            String string4;
            FileCacheEntry fileCacheEntry2;
            block11: {
                block10: {
                    if (!iterator.hasNext()) break block10;
                    fileCacheEntry2 = iterator.next();
                    string4 = fileCacheEntry2.mPath;
                    if (!string4.equalsIgnoreCase(string2)) break block11;
                    fileCacheEntry = fileCacheEntry2;
                }
                if (fileCacheEntry != null && this.mAudioUri.equals(fileCacheEntry.mTableUri)) break;
                return false;
            }
            int n5 = this.matchPaths(string4, string2);
            if (n5 <= n4) continue;
            fileCacheEntry = fileCacheEntry2;
            n4 = n5;
        }
        try {
            contentValues.clear();
            contentValues.put("play_order", n);
            contentValues.put("audio_id", fileCacheEntry.mRowId);
            this.mMediaProvider.insert(uri, contentValues);
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in MediaScanner.addPlayListEntry()", remoteException);
            return false;
        }
    }

    private boolean inScanDirectory(String string2, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.startsWith(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private void initialize(String string2) {
        this.mMediaProvider = this.mContext.getContentResolver().acquireProvider("media");
        this.mAudioUri = MediaStore.Audio.Media.getContentUri(string2);
        this.mVideoUri = MediaStore.Video.Media.getContentUri(string2);
        this.mImagesUri = MediaStore.Images.Media.getContentUri(string2);
        this.mThumbsUri = MediaStore.Images.Thumbnails.getContentUri(string2);
        if (!string2.equals("internal")) {
            this.mProcessPlaylists = true;
            this.mProcessGenres = true;
            this.mGenreCache = new HashMap();
            this.mGenresUri = MediaStore.Audio.Genres.getContentUri(string2);
            this.mPlaylistsUri = MediaStore.Audio.Playlists.getContentUri(string2);
            if (Process.supportsProcesses()) {
                this.mCaseInsensitivePaths = true;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int matchPaths(String string2, String string3) {
        int n = 0;
        int n2 = string2.length();
        int n3 = string3.length();
        while (n2 > 0 && n3 > 0) {
            int n4;
            int n5;
            int n6;
            int n7 = string2.lastIndexOf(47, n2 - 1);
            int n8 = string3.lastIndexOf(47, n3 - 1);
            int n9 = string2.lastIndexOf(92, n2 - 1);
            int n10 = string3.lastIndexOf(92, n3 - 1);
            int n11 = n8 > n10 ? n8 : n10;
            int n12 = n11 < 0 ? 0 : n11 + 1;
            if (n3 - n12 != (n6 = n2 - (n5 = (n4 = n7 > n9 ? n7 : n9) < 0 ? 0 : n4 + 1)) || !string2.regionMatches(true, n5, string3, n12, n6)) break;
            ++n;
            n2 = n5 - 1;
            n3 = n12 - 1;
        }
        return n;
    }

    private final native void native_finalize();

    private static final native void native_init();

    private final native void native_setup();

    /*
     * Enabled aggressive block sorting
     */
    private void postscan(String[] stringArray) throws RemoteException {
        Iterator<FileCacheEntry> iterator = this.mFileCache.values().iterator();
        while (iterator.hasNext()) {
            FileCacheEntry fileCacheEntry = iterator.next();
            String string2 = fileCacheEntry.mPath;
            boolean bl = fileCacheEntry.mSeenInFileSystem;
            boolean bl2 = false;
            if (!bl) {
                if (this.inScanDirectory(string2, stringArray)) {
                    bl2 = true;
                } else {
                    boolean bl3 = new File(string2).exists();
                    bl2 = false;
                    if (!bl3) {
                        bl2 = true;
                    }
                }
            }
            if (!bl2) continue;
            MediaFile.MediaFileType mediaFileType = MediaFile.getFileType(string2);
            int n = mediaFileType == null ? 0 : mediaFileType.fileType;
            if (MediaFile.isPlayListFileType(n)) {
                ContentValues contentValues = new ContentValues();
                contentValues.put("_data", "");
                contentValues.put("date_modified", 0);
                this.mMediaProvider.update(ContentUris.withAppendedId(this.mPlaylistsUri, fileCacheEntry.mRowId), contentValues, null, null);
                continue;
            }
            this.mMediaProvider.delete(ContentUris.withAppendedId(fileCacheEntry.mTableUri, fileCacheEntry.mRowId), null, null);
            iterator.remove();
        }
        if (this.mProcessPlaylists) {
            this.processPlayLists();
        }
        if (this.mOriginalCount == 0 && this.mImagesUri.equals(MediaStore.Images.Media.getContentUri("external"))) {
            this.pruneDeadThumbnailFiles();
        }
        this.mGenreCache = null;
        this.mPlayLists = null;
        this.mFileCache = null;
        this.mMediaProvider = null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void prescan(String var1_1) throws RemoteException {
        block27: {
            var2_2 = null;
            if (this.mFileCache == null) {
                this.mFileCache = new HashMap<K, V>();
            } else {
                this.mFileCache.clear();
            }
            if (this.mPlayLists == null) {
                this.mPlayLists = new ArrayList<E>();
            } else {
                this.mPlayLists.clear();
            }
            var3_3 = null;
            var4_4 = null;
            if (var1_1 == null) ** GOTO lbl16
            var3_3 = "_data=?";
            var4_4 = new String[]{var1_1};
lbl16:
            // 2 sources

            if ((var2_2 = (var6_5 = this.mMediaProvider.query(this.mAudioUri, MediaScanner.AUDIO_PROJECTION, var3_3, var4_4, null))) == null) ** GOTO lbl38
            try {
                while (var2_2.moveToNext()) {
                    var38_6 = var2_2.getLong(0);
                    var40_7 = var2_2.getString(1);
                    var41_8 = var2_2.getLong(2);
                    if (!var40_7.startsWith("/")) continue;
                    var43_9 = var40_7;
                    if (this.mCaseInsensitivePaths) {
                        var43_9 = var40_7.toLowerCase();
                    }
                    this.mFileCache.put(var43_9, new FileCacheEntry(this.mAudioUri, var38_6, var40_7, var41_8));
                }
                ** GOTO lbl36
            }
            catch (Throwable var37_10) {
                var2_2.close();
                var2_2 = null;
                throw var37_10;
lbl36:
                // 2 sources

                var2_2.close();
                var2_2 = null;
lbl38:
                // 2 sources

                if ((var2_2 = (var8_13 = this.mMediaProvider.query(this.mVideoUri, MediaScanner.VIDEO_PROJECTION, var7_12 = var1_1 != null ? "_data=?" : null, var4_4, null))) == null) ** GOTO lbl59
                try {
                    while (var2_2.moveToNext()) {
                        var30_17 = var2_2.getLong(0);
                        var32_14 = var2_2.getString(1);
                        var33_15 = var2_2.getLong(2);
                        if (!var32_14.startsWith("/")) continue;
                        var35_16 = var32_14;
                        if (this.mCaseInsensitivePaths) {
                            var35_16 = var32_14.toLowerCase();
                        }
                        this.mFileCache.put(var35_16, new FileCacheEntry(this.mVideoUri, var30_17, var32_14, var33_15));
                    }
                    ** GOTO lbl57
                }
                catch (Throwable var29_18) {
                    var2_2.close();
                    var2_2 = null;
                    throw var29_18;
lbl57:
                    // 1 sources

                    var2_2.close();
                    var2_2 = null;
lbl59:
                    // 2 sources

                    var9_19 = var1_1 != null ? "_data=?" : null;
                    this.mOriginalCount = 0;
                    var10_20 = this.mMediaProvider.query(this.mImagesUri, MediaScanner.IMAGES_PROJECTION, var9_19, var4_4, null);
                    var2_2 = var10_20;
                    if (var2_2 == null) ** GOTO lbl85
                    try {
                        this.mOriginalCount = var2_2.getCount();
                        while (var2_2.moveToNext()) {
                            var22_21 = var2_2.getLong(0);
                            var24_22 = var2_2.getString(1);
                            var25_23 = var2_2.getLong(2);
                            if (!var24_22.startsWith("/")) continue;
                            var27_24 = var24_22;
                            if (this.mCaseInsensitivePaths) {
                                var27_24 = var24_22.toLowerCase();
                            }
                            this.mFileCache.put(var27_24, new FileCacheEntry(this.mImagesUri, var22_21, var24_22, var25_23));
                        }
                        ** GOTO lbl83
                    }
                    catch (Throwable var21_25) {
                        var2_2.close();
                        var2_2 = null;
                        throw var21_25;
lbl83:
                        // 1 sources

                        var2_2.close();
                        var2_2 = null;
lbl85:
                        // 2 sources

                        if (!this.mProcessPlaylists || (var2_2 = (var12_27 = this.mMediaProvider.query(this.mPlaylistsUri, MediaScanner.PLAYLISTS_PROJECTION, var11_26 = var1_1 != null ? "_data=?" : null, var4_4, null))) == null) break block27;
                        try {
                            while (var2_2.moveToNext()) {
                                var14_28 = var2_2.getString(1);
                                if (var14_28 == null || var14_28.length() <= 0) continue;
                                var15_29 = var2_2.getLong(0);
                                var17_30 = var2_2.getLong(2);
                                var19_31 = var14_28;
                                if (this.mCaseInsensitivePaths) {
                                    var19_31 = var14_28.toLowerCase();
                                }
                                this.mFileCache.put(var19_31, new FileCacheEntry(this.mPlaylistsUri, var15_29, var14_28, var17_30));
                            }
                        }
                        catch (Throwable var13_32) {
                            try {
                                var2_2.close();
                                var2_2 = null;
                                throw var13_32;
                            }
                            catch (Throwable var5_11) {
                                if (var2_2 == null) throw var5_11;
                                var2_2.close();
                                throw var5_11;
                            }
                        }
                    }
                }
            }
            var2_2.close();
            return;
        }
        if (var2_2 == null) return;
        var2_2.close();
    }

    private native void processDirectory(String var1, String var2, MediaScannerClient var3);

    private native void processFile(String var1, String var2, MediaScannerClient var3);

    /*
     * Unable to fully structure code
     */
    private void processM3uPlayList(String var1_1, String var2_2, Uri var3_3, ContentValues var4_4) {
        block22: {
            var5_5 = null;
            var6_6 = new File(var1_1);
            var15_7 = var6_6.exists();
            var5_5 = null;
            if (!var15_7) break block22;
            var16_8 = new BufferedReader(new InputStreamReader(new FileInputStream(var6_6)), 8192);
            var18_9 = var16_8.readLine();
            var19_10 = 0;
            while (var18_9 != null) {
                block23: {
                    if (var18_9.length() <= 0 || var18_9.charAt(0) == '#') break block23;
                    var4_4.clear();
                    if (!this.addPlayListEntry(var18_9, var2_2, var3_3, var4_4, var19_10)) break block23;
                    ++var19_10;
                }
                var18_9 = var20_11 = var16_8.readLine();
            }
            var5_5 = var16_8;
        }
        if (var5_5 == null) ** GOTO lbl27
        try {
            var5_5.close();
lbl27:
            // 3 sources

            return;
        }
        catch (IOException var21_12) {
            Log.e("MediaScanner", "IOException in MediaScanner.processM3uPlayList()", var21_12);
            return;
        }
        catch (IOException var10_13) {
            var11_14 = var10_13;
lbl35:
            // 2 sources

            while (true) {
                try {
                    Log.e("MediaScanner", "IOException in MediaScanner.processM3uPlayList()", var11_14);
                    if (var5_5 == null) ** continue;
                }
                catch (Throwable var7_16) lbl-1000:
                // 2 sources

                {
                    while (true) {
                        if (var5_5 != null) {
                            var5_5.close();
                        }
lbl45:
                        // 4 sources

                        throw var7_17;
                        catch (IOException var8_19) {
                            Log.e("MediaScanner", "IOException in MediaScanner.processM3uPlayList()", var8_19);
                            ** continue;
                        }
                        break;
                    }
                }
                try {
                    var5_5.close();
                    return;
                }
                catch (IOException var13_15) {
                    Log.e("MediaScanner", "IOException in MediaScanner.processM3uPlayList()", var13_15);
                    return;
                }
                break;
            }
        }
        catch (Throwable var7_18) {
            var5_5 = var16_8;
            ** continue;
        }
        catch (IOException var17_20) {
            var11_14 = var17_20;
            var5_5 = var16_8;
            ** continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processPlayLists() throws RemoteException {
        block3: for (FileCacheEntry var2_2 : this.mPlayLists) {
            block13: {
                block10: {
                    block9: {
                        block11: {
                            block12: {
                                var3_3 = var2_2.mPath;
                                if (!var2_2.mLastModifiedChanged) continue;
                                var4_4 = new ContentValues();
                                var5_5 = var3_3.lastIndexOf(47);
                                if (var5_5 < 0) {
                                    throw new IllegalArgumentException("bad path " + var3_3);
                                }
                                var6_6 = var2_2.mRowId;
                                if (var6_6 != 0L) break block11;
                                var19_13 = var3_3.lastIndexOf(46);
                                if (var19_13 >= 0) break block12;
                                var20_14 = var3_3.substring(var5_5 + 1);
lbl13:
                                // 2 sources

                                while (true) {
                                    var4_4.put("name", var20_14);
                                    var4_4.put("_data", var3_3);
                                    var4_4.put("date_modified", var2_2.mLastModified);
                                    var8_7 = this.mMediaProvider.insert(this.mPlaylistsUri, var4_4);
                                    ContentUris.parseId(var8_7);
                                    var10_8 = Uri.withAppendedPath(var8_7, "members");
lbl21:
                                    // 2 sources

                                    while (true) {
                                        var12_9 = var3_3.substring(0, var5_5 + 1);
                                        var13_10 = MediaFile.getFileType(var3_3);
                                        if (var13_10 != null) break block9;
                                        var14_11 = 0;
lbl26:
                                        // 2 sources

                                        while (var14_11 == 41) {
                                            this.processM3uPlayList(var3_3, var12_9, var10_8, var4_4);
lbl28:
                                            // 4 sources

                                            while (true) {
                                                var15_12 = this.mMediaProvider.query(var10_8, MediaScanner.PLAYLIST_MEMBERS_PROJECTION, null, null, null);
                                                if (var15_12 == null) ** GOTO lbl33
                                                if (var15_12.getCount() != 0) continue block3;
lbl33:
                                                // 2 sources

                                                Log.d("MediaScanner", "playlist is empty - deleting");
                                                this.mMediaProvider.delete(var8_7, null, null);
                                                continue block3;
                                                break;
                                            }
                                        }
                                        break block10;
                                        break;
                                    }
                                    break;
                                }
                            }
                            var20_14 = var3_3.substring(var5_5 + 1, var19_13);
                            ** continue;
                        }
                        var8_7 = ContentUris.withAppendedId(this.mPlaylistsUri, var6_6);
                        var4_4.put("date_modified", var2_2.mLastModified);
                        this.mMediaProvider.update(var8_7, var4_4, null, null);
                        var10_8 = Uri.withAppendedPath(var8_7, "members");
                        this.mMediaProvider.delete(var10_8, null, null);
                        ** continue;
                    }
                    var14_11 = var13_10.fileType;
                    ** GOTO lbl26
                }
                if (var14_11 != 42) break block13;
                this.processPlsPlayList(var3_3, var12_9, var10_8, var4_4);
                ** GOTO lbl28
            }
            if (var14_11 != 43) ** GOTO lbl28
            this.processWplPlayList(var3_3, var12_9, var10_8);
            ** continue;
            finally {
                if (var15_12 == null) continue;
                var15_12.close();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processPlsPlayList(String var1_1, String var2_2, Uri var3_3, ContentValues var4_4) {
        block23: {
            var5_5 = null;
            var6_6 = new File(var1_1);
            var15_7 = var6_6.exists();
            var5_5 = null;
            if (!var15_7) break block23;
            var16_8 = new BufferedReader(new InputStreamReader(new FileInputStream(var6_6)), 8192);
            var18_9 = var16_8.readLine();
            var19_10 = 0;
            while (var18_9 != null) {
                block24: {
                    if (!var18_9.startsWith("File") || (var21_12 = var18_9.indexOf(61)) <= 0) break block24;
                    var4_4.clear();
                    if (!this.addPlayListEntry(var18_9.substring(var21_12 + 1), var2_2, var3_3, var4_4, var19_10)) break block24;
                    ++var19_10;
                }
                var18_9 = var20_11 = var16_8.readLine();
            }
            var5_5 = var16_8;
        }
        if (var5_5 == null) ** GOTO lbl28
        try {
            var5_5.close();
lbl28:
            // 3 sources

            return;
        }
        catch (IOException var22_13) {
            Log.e("MediaScanner", "IOException in MediaScanner.processPlsPlayList()", var22_13);
            return;
        }
        catch (IOException var10_14) {
            var11_15 = var10_14;
lbl36:
            // 2 sources

            while (true) {
                try {
                    Log.e("MediaScanner", "IOException in MediaScanner.processPlsPlayList()", var11_15);
                    if (var5_5 == null) ** continue;
                }
                catch (Throwable var7_17) lbl-1000:
                // 2 sources

                {
                    while (true) {
                        if (var5_5 != null) {
                            var5_5.close();
                        }
lbl46:
                        // 4 sources

                        throw var7_18;
                        catch (IOException var8_20) {
                            Log.e("MediaScanner", "IOException in MediaScanner.processPlsPlayList()", var8_20);
                            ** continue;
                        }
                        break;
                    }
                }
                try {
                    var5_5.close();
                    return;
                }
                catch (IOException var13_16) {
                    Log.e("MediaScanner", "IOException in MediaScanner.processPlsPlayList()", var13_16);
                    return;
                }
                break;
            }
        }
        catch (Throwable var7_19) {
            var5_5 = var16_8;
            ** continue;
        }
        catch (IOException var17_21) {
            var11_15 = var17_21;
            var5_5 = var16_8;
            ** continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processWplPlayList(String var1_1, String var2_2, Uri var3_3) {
        block25: {
            var4_4 = null;
            var5_5 = new File(var1_1);
            var17_6 = var5_5.exists();
            var4_4 = null;
            if (!var17_6) break block25;
            var18_7 = new FileInputStream(var5_5);
            Xml.parse(var18_7, Xml.findEncodingByName("UTF-8"), new WplHandler(var2_2, var3_3).getContentHandler());
            var4_4 = var18_7;
        }
        if (var4_4 == null) ** GOTO lbl16
        try {
            var4_4.close();
lbl16:
            // 4 sources

            return;
        }
        catch (IOException var21_8) {
            Log.e("MediaScanner", "IOException in MediaScanner.processWplPlayList()", var21_8);
            return;
        }
        catch (SAXException var13_9) {
            var14_10 = var13_9;
lbl24:
            // 2 sources

            while (true) {
                var14_10.printStackTrace();
                if (var4_4 == null) ** GOTO lbl16
                try {
                    var4_4.close();
                    return;
                }
                catch (IOException var15_11) {
                    Log.e("MediaScanner", "IOException in MediaScanner.processWplPlayList()", var15_11);
                    return;
                }
                break;
            }
        }
        catch (IOException var9_12) {
            var10_13 = var9_12;
lbl37:
            // 2 sources

            while (true) {
                var10_13.printStackTrace();
                if (var4_4 == null) ** continue;
                {
                    catch (Throwable var6_15) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            if (var4_4 != null) {
                                var4_4.close();
                            }
lbl46:
                            // 4 sources

                            throw var6_16;
                            catch (IOException var7_18) {
                                Log.e("MediaScanner", "IOException in MediaScanner.processWplPlayList()", var7_18);
                                ** continue;
                            }
                            break;
                        }
                    }
                }
                try {
                    var4_4.close();
                    return;
                }
                catch (IOException var11_14) {
                    Log.e("MediaScanner", "IOException in MediaScanner.processWplPlayList()", var11_14);
                    return;
                }
                break;
            }
        }
        catch (Throwable var6_17) {
            var4_4 = var18_7;
            ** continue;
        }
        catch (IOException var20_19) {
            var10_13 = var20_19;
            var4_4 = var18_7;
            ** continue;
        }
        catch (SAXException var19_20) {
            var14_10 = var19_20;
            var4_4 = var18_7;
            ** continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pruneDeadThumbnailFiles() {
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = new File("/sdcard/DCIM/.thumbnails").list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add("/sdcard/DCIM/.thumbnails" + "/" + stringArray[i]);
        }
        try {
            Cursor cursor = this.mMediaProvider.query(this.mThumbsUri, new String[]{"_data"}, null, null, null);
            Log.v(TAG, "pruneDeadThumbnailFiles... " + cursor);
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    hashSet.remove(cursor.getString(0));
                } while (cursor.moveToNext());
            }
            for (String string2 : hashSet) {
                try {
                    new File(string2).delete();
                }
                catch (SecurityException securityException) {}
            }
            Log.v(TAG, "/pruneDeadThumbnailFiles... " + cursor);
            if (cursor != null) {
                cursor.close();
            }
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    private void setDefaultRingtoneFileNames() {
        this.mDefaultRingtoneFilename = SystemProperties.get("ro.config.ringtone");
        this.mDefaultNotificationFilename = SystemProperties.get("ro.config.notification_sound");
        this.mDefaultAlarmAlertFilename = SystemProperties.get("ro.config.alarm_alert");
    }

    public native byte[] extractAlbumArt(FileDescriptor var1);

    protected void finalize() {
        this.mContext.getContentResolver().releaseProvider(this.mMediaProvider);
        this.native_finalize();
    }

    public void scanDirectories(String[] stringArray, String string2) {
        long l = System.currentTimeMillis();
        this.initialize(string2);
        this.prescan(null);
        long l2 = System.currentTimeMillis();
        int n = 0;
        while (true) {
            if (n >= stringArray.length) break;
            this.processDirectory(stringArray[n], MediaFile.sFileExtensions, this.mClient);
            ++n;
            continue;
            break;
        }
        try {
            long l3 = System.currentTimeMillis();
            this.postscan(stringArray);
            long l4 = System.currentTimeMillis();
            Log.d(TAG, " prescan time: " + (l2 - l) + "ms\n");
            Log.d(TAG, "    scan time: " + (l3 - l2) + "ms\n");
            Log.d(TAG, "postscan time: " + (l4 - l3) + "ms\n");
            Log.d(TAG, "   total time: " + (l4 - l) + "ms\n");
            return;
        }
        catch (SQLException sQLException) {
            Log.e(TAG, "SQLException in MediaScanner.scan()", sQLException);
            return;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Log.e(TAG, "UnsupportedOperationException in MediaScanner.scan()", unsupportedOperationException);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in MediaScanner.scan()", remoteException);
            return;
        }
    }

    public Uri scanSingleFile(String string2, String string3, String string4) {
        try {
            this.initialize(string3);
            this.prescan(string2);
            File file = new File(string2);
            Uri uri = this.mClient.doScanFile(string2, string4, file.lastModified(), file.length(), true);
            return uri;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "RemoteException in MediaScanner.scanFile()", remoteException);
            return null;
        }
    }

    public native void setLocale(String var1);

    private static class FileCacheEntry {
        long mLastModified;
        boolean mLastModifiedChanged;
        String mPath;
        long mRowId;
        boolean mSeenInFileSystem;
        Uri mTableUri;

        FileCacheEntry(Uri uri, long l, String string2, long l2) {
            this.mTableUri = uri;
            this.mRowId = l;
            this.mPath = string2;
            this.mLastModified = l2;
            this.mSeenInFileSystem = false;
            this.mLastModifiedChanged = false;
        }

        public String toString() {
            return this.mPath;
        }
    }

    private class MyMediaScannerClient
    implements MediaScannerClient {
        private String mAlbum;
        private String mAlbumArtist;
        private String mArtist;
        private int mCompilation;
        private String mComposer;
        private int mDuration;
        private long mFileSize;
        private int mFileType;
        private String mGenre;
        private long mLastModified;
        private String mMimeType;
        private String mPath;
        private String mTitle;
        private int mTrack;
        private String mWriter;
        private int mYear;

        private MyMediaScannerClient() {
        }

        private boolean doesPathHaveFilename(String string2, String string3) {
            int n;
            int n2 = 1 + string2.lastIndexOf(File.separatorChar);
            return string2.regionMatches(n2, string3, 0, n = string3.length()) && n2 + n == string2.length();
        }

        /*
         * Unable to fully structure code
         */
        private Uri endFile(FileCacheEntry var1_1, boolean var2_2, boolean var3_3, boolean var4_4, boolean var5_5, boolean var6_6) throws RemoteException {
            block43: {
                block39: {
                    block38: {
                        block40: {
                            block37: {
                                block36: {
                                    block42: {
                                        block41: {
                                            var7_7 = MediaFile.isAudioFileType(this.mFileType);
                                            var8_8 = MediaFile.isVideoFileType(this.mFileType);
                                            var9_9 = MediaFile.isImageFileType(this.mFileType);
                                            if (!var8_8) break block41;
                                            var10_10 = MediaScanner.access$700(MediaScanner.this);
lbl6:
                                            // 3 sources

                                            while (true) {
                                                var1_1.mTableUri = var10_10;
                                                if (this.mArtist == null || this.mArtist.length() == 0) {
                                                    this.mArtist = this.mAlbumArtist;
                                                }
                                                if ((var12_12 = (var11_11 = this.toValues()).getAsString("title")) == null || TextUtils.isEmpty(var12_12.trim())) {
                                                    var13_13 = var11_11.getAsString("_data");
                                                    var14_14 = var13_13.lastIndexOf(47);
                                                    if (var14_14 >= 0 && (var43_15 = var14_14 + 1) < var13_13.length()) {
                                                        var13_13 = var13_13.substring(var43_15);
                                                    }
                                                    if ((var15_16 = var13_13.lastIndexOf(46)) > 0) {
                                                        var13_13 = var13_13.substring(0, var15_16);
                                                    }
                                                    var11_11.put("title", var13_13);
                                                }
                                                if (!"<unknown>".equals(var11_11.getAsString("album")) || (var40_18 = (var39_17 = var11_11.getAsString("_data")).lastIndexOf(47)) < 0) ** GOTO lbl25
                                                var41_19 = 0;
lbl20:
                                                // 2 sources

                                                while (true) {
                                                    var42_20 = var39_17.indexOf(47, var41_19 + 1);
                                                    if (var42_20 >= 0 && var42_20 < var40_18) break block36;
                                                    if (var41_19 != 0) {
                                                        var11_11.put("album", var39_17.substring(var41_19 + 1, var40_18));
                                                    }
lbl25:
                                                    // 4 sources

                                                    var16_21 = var1_1.mRowId;
                                                    if (!var7_7 || var16_21 != 0L) break block37;
                                                    var11_11.put("is_ringtone", var2_2);
                                                    var11_11.put("is_notification", var3_3);
                                                    var11_11.put("is_alarm", var4_4);
                                                    var11_11.put("is_music", var5_5);
                                                    var11_11.put("is_podcast", var6_6);
lbl32:
                                                    // 5 sources

                                                    while (var16_21 == 0L) {
                                                        var25_22 = MediaScanner.access$1000(MediaScanner.this).insert(var10_10, var11_11);
                                                        if (var25_22 != null) {
                                                            var1_1.mRowId = var16_21 = ContentUris.parseId(var25_22);
                                                        }
lbl36:
                                                        // 4 sources

                                                        while (true) {
                                                            if (!MediaScanner.access$1100(MediaScanner.this) || this.mGenre == null) ** GOTO lbl61
                                                            var30_23 = this.mGenre;
                                                            var31_24 = (Uri)MediaScanner.access$1200(MediaScanner.this).get(var30_23);
                                                            if (var31_24 != null) ** GOTO lbl56
                                                            var33_25 = null;
                                                            var33_25 = MediaScanner.access$1000(MediaScanner.this).query(MediaScanner.access$1300(MediaScanner.this), MediaScanner.access$1400(), "name=?", new String[]{var30_23}, null);
                                                            if (var33_25 == null) ** GOTO lbl47
                                                            if (var33_25.getCount() != 0) break block38;
lbl47:
                                                            // 2 sources

                                                            var11_11.clear();
                                                            var11_11.put("name", var30_23);
                                                            var31_24 = MediaScanner.access$1000(MediaScanner.this).insert(MediaScanner.access$1300(MediaScanner.this), var11_11);
lbl50:
                                                            // 2 sources

                                                            while (true) {
                                                                if (var31_24 != null) {
                                                                    var31_24 = Uri.withAppendedPath(var31_24, "members");
                                                                    MediaScanner.access$1200(MediaScanner.this).put(var30_23, var31_24);
                                                                }
lbl56:
                                                                // 4 sources

                                                                if (var31_24 != null) {
                                                                    var11_11.clear();
                                                                    var11_11.put("audio_id", var16_21);
                                                                    MediaScanner.access$1000(MediaScanner.this).insert(var31_24, var11_11);
                                                                }
lbl61:
                                                                // 4 sources

                                                                if (var3_3 && !MediaScanner.access$1500(MediaScanner.this)) {
                                                                    if (TextUtils.isEmpty(MediaScanner.access$1600(MediaScanner.this)) || this.doesPathHaveFilename(var1_1.mPath, MediaScanner.access$1600(MediaScanner.this))) {
                                                                        this.setSettingIfNotSet("notification_sound", var10_10, var16_21);
                                                                        MediaScanner.access$1502(MediaScanner.this, true);
                                                                    }
lbl66:
                                                                    // 6 sources

                                                                    return var25_22;
                                                                }
                                                                break block39;
                                                                break;
                                                            }
                                                            break;
                                                        }
                                                    }
                                                    break block40;
                                                    break;
                                                }
                                                break;
                                            }
                                        }
                                        if (!var9_9) break block42;
                                        var10_10 = MediaScanner.access$800(MediaScanner.this);
                                        ** GOTO lbl6
                                    }
                                    if (var7_7) {
                                        var10_10 = MediaScanner.access$900(MediaScanner.this);
                                        ** continue;
                                    }
                                    return null;
                                }
                                var41_19 = var42_20;
                                ** while (true)
                            }
                            if (this.mFileType != 31) ** GOTO lbl32
                            var19_27 = var18_26 = new ExifInterface(var1_1.mPath);
lbl86:
                            // 2 sources

                            ** while (var19_27 != null)
lbl-1000:
                            // 1 sources

                            {
                                var20_28 = new float[2];
                                if (var19_27.getLatLong(var20_28)) {
                                    var11_11.put("latitude", Float.valueOf(var20_28[0]));
                                    var11_11.put("longitude", Float.valueOf(var20_28[1]));
                                }
                                if ((var21_29 = var19_27.getGpsDateTime()) != -1L) {
                                    var11_11.put("datetaken", var21_29);
                                }
                                if ((var23_30 = var19_27.getAttributeInt("Orientation", -1)) == -1) ** GOTO lbl32
                                switch (var23_30) {
                                    default: {
                                        var24_31 = 0;
lbl97:
                                        // 4 sources

                                        while (true) {
                                            var11_11.put("orientation", var24_31);
                                            ** GOTO lbl32
                                            break;
                                        }
                                    }
                                    case 6: {
                                        var24_31 = 90;
                                        ** GOTO lbl97
                                    }
                                    case 3: {
                                        var24_31 = 180;
                                        ** GOTO lbl97
                                    }
                                    case 8: 
                                }
                                var24_31 = 270;
                                ** continue;
lbl109:
                                // 1 sources

                                ** GOTO lbl32
                            }
                        }
                        var25_22 = ContentUris.withAppendedId(var10_10, var16_21);
                        MediaScanner.access$1000(MediaScanner.this).update(var25_22, var11_11, null, null);
                        ** while (true)
                    }
                    try {
                        var33_25.moveToNext();
                        var31_24 = var37_32 = ContentUris.withAppendedId(MediaScanner.access$1300(MediaScanner.this), var33_25.getLong(0));
                        ** continue;
                    }
                    catch (Throwable var34_33) {
                        throw var34_33;
                    }
                    finally {
                        if (var33_25 != null) {
                            var33_25.close();
                        }
                    }
                }
                if (!var2_2 || MediaScanner.access$1700(MediaScanner.this)) break block43;
                if (TextUtils.isEmpty(MediaScanner.access$1800(MediaScanner.this)) || this.doesPathHaveFilename(var1_1.mPath, MediaScanner.access$1800(MediaScanner.this))) {
                    this.setSettingIfNotSet("ringtone", var10_10, var16_21);
                    MediaScanner.access$1702(MediaScanner.this, true);
                }
                ** GOTO lbl66
            }
            if (!var4_4 || MediaScanner.access$1900(MediaScanner.this) || !TextUtils.isEmpty(MediaScanner.access$2000(MediaScanner.this)) && !this.doesPathHaveFilename(var1_1.mPath, MediaScanner.access$2000(MediaScanner.this))) ** GOTO lbl66
            this.setSettingIfNotSet("alarm_alert", var10_10, var16_21);
            MediaScanner.access$1902(MediaScanner.this, true);
            ** while (true)
            catch (IOException var38_34) {
                var19_27 = null;
                ** GOTO lbl86
            }
        }

        private int parseSubstring(String string2, int n, int n2) {
            int n3 = string2.length();
            if (n == n3) {
                return n2;
            }
            int n4 = n + 1;
            char c = string2.charAt(n);
            if (c < '0' || c > '9') {
                return n2;
            }
            int n5 = c - 48;
            while (n4 < n3) {
                int n6 = n4 + 1;
                char c2 = string2.charAt(n4);
                if (c2 < '0' || c2 > '9') {
                    return n5;
                }
                n5 = n5 * 10 + (c2 - 48);
                n4 = n6;
            }
            return n5;
        }

        private void setSettingIfNotSet(String string2, Uri uri, long l) {
            if (TextUtils.isEmpty(Settings.System.getString(MediaScanner.this.mContext.getContentResolver(), string2))) {
                Settings.System.putString(MediaScanner.this.mContext.getContentResolver(), string2, ContentUris.withAppendedId(uri, l).toString());
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private ContentValues toValues() {
            String string2;
            ContentValues contentValues = new ContentValues();
            contentValues.put("_data", this.mPath);
            contentValues.put("title", this.mTitle);
            contentValues.put("date_modified", this.mLastModified);
            contentValues.put("_size", this.mFileSize);
            contentValues.put("mime_type", this.mMimeType);
            if (MediaFile.isVideoFileType(this.mFileType)) {
                String string3 = this.mArtist != null && this.mArtist.length() > 0 ? this.mArtist : "<unknown>";
                contentValues.put("artist", string3);
                String string4 = this.mAlbum != null && this.mAlbum.length() > 0 ? this.mAlbum : "<unknown>";
                contentValues.put("album", string4);
                contentValues.put("duration", this.mDuration);
                return contentValues;
            } else {
                if (MediaFile.isImageFileType(this.mFileType) || !MediaFile.isAudioFileType(this.mFileType)) return contentValues;
                string2 = this.mArtist != null && this.mArtist.length() > 0 ? this.mArtist : "<unknown>";
            }
            contentValues.put("artist", string2);
            String string5 = this.mAlbumArtist != null && this.mAlbumArtist.length() > 0 ? this.mAlbumArtist : null;
            contentValues.put("album_artist", string5);
            String string6 = this.mAlbum != null && this.mAlbum.length() > 0 ? this.mAlbum : "<unknown>";
            contentValues.put("album", string6);
            contentValues.put("composer", this.mComposer);
            if (this.mYear != 0) {
                contentValues.put("year", this.mYear);
            }
            contentValues.put("track", this.mTrack);
            contentValues.put("duration", this.mDuration);
            contentValues.put("compilation", this.mCompilation);
            return contentValues;
        }

        @Override
        public void addNoMediaFolder(String string2) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("_data", "");
            String[] stringArray = new String[]{string2 + '%'};
            try {
                MediaScanner.this.mMediaProvider.update(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues, "_data LIKE ?", stringArray);
                MediaScanner.this.mMediaProvider.update(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, contentValues, "_data LIKE ?", stringArray);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException();
            }
        }

        public FileCacheEntry beginFile(String string2, String string3, long l, long l2) {
            FileCacheEntry fileCacheEntry;
            MediaFile.MediaFileType mediaFileType;
            int n = string2.lastIndexOf(47);
            if (n >= 0 && n + 2 < string2.length()) {
                if (string2.regionMatches(n + 1, "._", 0, 2)) {
                    return null;
                }
                if (string2.regionMatches(true, string2.length() - 4, ".jpg", 0, 4)) {
                    if (string2.regionMatches(true, n + 1, "AlbumArt_{", 0, 10) || string2.regionMatches(true, n + 1, "AlbumArt.", 0, 9)) {
                        return null;
                    }
                    int n2 = string2.length() - n - 1;
                    if (n2 == 17 && string2.regionMatches(true, n + 1, "AlbumArtSmall", 0, 13) || n2 == 10 && string2.regionMatches(true, n + 1, "Folder", 0, 6)) {
                        return null;
                    }
                }
            }
            this.mMimeType = null;
            if (string3 != null) {
                this.mFileType = MediaFile.getFileTypeForMimeType(string3);
                if (this.mFileType != 0) {
                    this.mMimeType = string3;
                }
            }
            this.mFileSize = l2;
            if (this.mMimeType == null && (mediaFileType = MediaFile.getFileType(string2)) != null) {
                this.mFileType = mediaFileType.fileType;
                this.mMimeType = mediaFileType.mimeType;
            }
            String string4 = string2;
            if (MediaScanner.this.mCaseInsensitivePaths) {
                string4 = string2.toLowerCase();
            }
            if ((fileCacheEntry = (FileCacheEntry)MediaScanner.this.mFileCache.get(string4)) == null) {
                fileCacheEntry = new FileCacheEntry(null, 0L, string2, 0L);
                MediaScanner.this.mFileCache.put(string4, fileCacheEntry);
            }
            fileCacheEntry.mSeenInFileSystem = true;
            long l3 = l - fileCacheEntry.mLastModified;
            if (l3 > 1L || l3 < -1L) {
                fileCacheEntry.mLastModified = l;
                fileCacheEntry.mLastModifiedChanged = true;
            }
            if (MediaScanner.this.mProcessPlaylists && MediaFile.isPlayListFileType(this.mFileType)) {
                MediaScanner.this.mPlayLists.add(fileCacheEntry);
                return null;
            }
            this.mArtist = null;
            this.mAlbumArtist = null;
            this.mAlbum = null;
            this.mTitle = null;
            this.mComposer = null;
            this.mGenre = null;
            this.mTrack = 0;
            this.mYear = 0;
            this.mDuration = 0;
            this.mPath = string2;
            this.mLastModified = l;
            this.mWriter = null;
            this.mCompilation = 0;
            return fileCacheEntry;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Uri doScanFile(String string2, String string3, long l, long l2, boolean bl) {
            Uri uri;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            boolean bl6;
            FileCacheEntry fileCacheEntry;
            block4: {
                block3: {
                    try {
                        String string4;
                        fileCacheEntry = this.beginFile(string2, string3, l, l2);
                        Uri uri2 = null;
                        if (fileCacheEntry == null) return uri2;
                        if (!fileCacheEntry.mLastModifiedChanged) {
                            uri2 = null;
                            if (!bl) return uri2;
                        }
                        bl6 = (string4 = string2.toLowerCase()).indexOf(MediaScanner.RINGTONES_DIR) > 0;
                        bl5 = string4.indexOf(MediaScanner.NOTIFICATIONS_DIR) > 0;
                        bl4 = string4.indexOf(MediaScanner.ALARMS_DIR) > 0;
                        bl3 = string4.indexOf(MediaScanner.PODCAST_DIR) > 0;
                        if (string4.indexOf(MediaScanner.MUSIC_DIR) > 0 || !bl6 && !bl5 && !bl4 && !bl3) break block3;
                        bl2 = false;
                        break block4;
                    }
                    catch (RemoteException remoteException) {
                        Log.e(MediaScanner.TAG, "RemoteException in MediaScanner.scanFile()", remoteException);
                        return null;
                    }
                }
                bl2 = true;
            }
            if (MediaFile.isImageFileType(this.mFileType)) return uri;
            MediaScanner.this.processFile(string2, string3, this);
            uri = this.endFile(fileCacheEntry, bl6, bl5, bl4, bl2, bl3);
            return uri;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleStringTag(String string2, String string3) {
            if (string2.equalsIgnoreCase("title") || string2.startsWith("title;")) {
                this.mTitle = string3;
                return;
            } else {
                if (string2.equalsIgnoreCase("artist") || string2.startsWith("artist;")) {
                    this.mArtist = string3.trim();
                    return;
                }
                if (string2.equalsIgnoreCase("albumartist") || string2.startsWith("albumartist;")) {
                    this.mAlbumArtist = string3.trim();
                    return;
                }
                if (string2.equalsIgnoreCase("album") || string2.startsWith("album;")) {
                    this.mAlbum = string3.trim();
                    return;
                }
                if (string2.equalsIgnoreCase("composer") || string2.startsWith("composer;")) {
                    this.mComposer = string3.trim();
                    return;
                }
                if (string2.equalsIgnoreCase("genre") || string2.startsWith("genre;")) {
                    if (string3.length() > 0) {
                        int n = -1;
                        char c = string3.charAt(0);
                        if (c == '(') {
                            n = this.parseSubstring(string3, 1, -1);
                        } else if (c >= '0' && c <= '9') {
                            n = this.parseSubstring(string3, 0, -1);
                        }
                        if (n >= 0 && n < ID3_GENRES.length) {
                            string3 = ID3_GENRES[n];
                        } else if (n == 255) {
                            string3 = null;
                        }
                    }
                    this.mGenre = string3;
                    return;
                }
                if (string2.equalsIgnoreCase("year") || string2.startsWith("year;")) {
                    this.mYear = this.parseSubstring(string3, 0, 0);
                    return;
                }
                if (string2.equalsIgnoreCase("tracknumber") || string2.startsWith("tracknumber;")) {
                    this.mTrack = this.parseSubstring(string3, 0, 0) + 1000 * (this.mTrack / 1000);
                    return;
                }
                if (string2.equalsIgnoreCase("discnumber") || string2.equals("set") || string2.startsWith("set;")) {
                    this.mTrack = 1000 * this.parseSubstring(string3, 0, 0) + this.mTrack % 1000;
                    return;
                }
                if (string2.equalsIgnoreCase("duration")) {
                    this.mDuration = this.parseSubstring(string3, 0, 0);
                    return;
                }
                if (string2.equalsIgnoreCase("writer") || string2.startsWith("writer;")) {
                    this.mWriter = string3.trim();
                    return;
                }
                if (!string2.equalsIgnoreCase("compilation")) return;
                this.mCompilation = this.parseSubstring(string3, 0, 0);
                return;
            }
        }

        @Override
        public void scanFile(String string2, long l, long l2) {
            this.doScanFile(string2, null, l, l2, false);
        }

        @Override
        public void scanFile(String string2, String string3, long l, long l2) {
            this.doScanFile(string2, string3, l, l2, false);
        }

        @Override
        public void setMimeType(String string2) {
            if ("audio/mp4".equals(this.mMimeType) && string2.startsWith("video")) {
                return;
            }
            this.mMimeType = string2;
            this.mFileType = MediaFile.getFileTypeForMimeType(string2);
        }
    }

    class WplHandler
    implements ElementListener {
        final ContentHandler handler;
        int index = 0;
        String playListDirectory;
        Uri uri;
        ContentValues values = new ContentValues();

        public WplHandler(String string2, Uri uri) {
            this.playListDirectory = string2;
            this.uri = uri;
            RootElement rootElement = new RootElement("smil");
            rootElement.getChild("body").getChild("seq").getChild("media").setElementListener(this);
            this.handler = rootElement.getContentHandler();
        }

        @Override
        public void end() {
        }

        ContentHandler getContentHandler() {
            return this.handler;
        }

        @Override
        public void start(Attributes attributes) {
            String string2 = attributes.getValue("", "src");
            if (string2 != null) {
                this.values.clear();
                if (MediaScanner.this.addPlayListEntry(string2, this.playListDirectory, this.uri, this.values, this.index)) {
                    this.index = 1 + this.index;
                }
            }
        }
    }
}

