/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.os.Parcel;
import android.util.Log;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.TimeZone;

public class Metadata {
    public static final int ALBUM = 4;
    public static final int ALBUM_ART = 14;
    public static final int ANY = 0;
    public static final int ARTIST = 5;
    public static final int AUDIO_BIT_RATE = 18;
    public static final int AUDIO_CODEC = 23;
    public static final int AUDIO_SAMPLE_RATE = 20;
    public static final int AUTHOR = 6;
    public static final int BIT_RATE = 17;
    public static final int BOOLEAN_VAL = 3;
    public static final int BYTE_ARRAY_VAL = 8;
    public static final int CAPTION = 16;
    public static final int CD_TRACK_MAX = 12;
    public static final int CD_TRACK_NUM = 11;
    public static final int COMMENT = 2;
    public static final int COMPOSER = 7;
    public static final int COPYRIGHT = 3;
    public static final int DATE = 9;
    public static final int DATE_VAL = 7;
    public static final int DOUBLE_VAL = 5;
    public static final int DRM_CRIPPLED = 28;
    public static final int DURATION = 10;
    private static final int FIRST_CUSTOM = 8192;
    public static final int GENRE = 8;
    public static final int INTEGER_VAL = 2;
    private static final int LAST_SYSTEM = 32;
    private static final int LAST_TYPE = 8;
    public static final int LONG_VAL = 4;
    public static final Set<Integer> MATCH_ALL;
    public static final Set<Integer> MATCH_NONE;
    public static final int MIME_TYPE = 22;
    public static final int NUM_TRACKS = 27;
    public static final int PAUSE_AVAILABLE = 29;
    public static final int RATING = 13;
    public static final int SEEK_AVAILABLE = 32;
    public static final int SEEK_BACKWARD_AVAILABLE = 30;
    public static final int SEEK_FORWARD_AVAILABLE = 31;
    public static final int STRING_VAL = 1;
    private static final String TAG = "media.Metadata";
    public static final int TIMED_TEXT_VAL = 6;
    public static final int TITLE = 1;
    public static final int VIDEO_BIT_RATE = 19;
    public static final int VIDEO_CODEC = 24;
    public static final int VIDEO_FRAME = 15;
    public static final int VIDEO_FRAME_RATE = 21;
    public static final int VIDEO_HEIGHT = 25;
    public static final int VIDEO_WIDTH = 26;
    private static final int kInt32Size = 4;
    private static final int kMetaHeaderSize = 8;
    private static final int kMetaMarker = 1296389185;
    private static final int kRecordHeaderSize = 12;
    private final HashMap<Integer, Integer> mKeyToPosMap = new HashMap();
    private Parcel mParcel;

    static {
        MATCH_NONE = Collections.EMPTY_SET;
        MATCH_ALL = Collections.singleton(0);
    }

    private boolean checkMetadataId(int n) {
        if (n <= 0 || 32 < n && n < 8192) {
            Log.e(TAG, "Invalid metadata ID " + n);
            return false;
        }
        return true;
    }

    private void checkType(int n, int n2) {
        int n3 = this.mKeyToPosMap.get(n);
        this.mParcel.setDataPosition(n3);
        int n4 = this.mParcel.readInt();
        if (n4 != n2) {
            throw new IllegalStateException("Wrong type " + n2 + " but got " + n4);
        }
    }

    public static int firstCustomId() {
        return 8192;
    }

    public static int lastSytemId() {
        return 32;
    }

    public static int lastType() {
        return 8;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean scanAllRecords(Parcel parcel, int n) {
        int n2 = 0;
        this.mKeyToPosMap.clear();
        while (true) {
            int n3;
            int n4;
            block9: {
                boolean bl;
                block5: {
                    int n5;
                    block8: {
                        block7: {
                            block6: {
                                bl = false;
                                if (n <= 12) break block5;
                                n4 = parcel.dataPosition();
                                n3 = parcel.readInt();
                                if (n3 > 12) break block6;
                                Log.e(TAG, "Record is too short");
                                bl = true;
                                break block5;
                            }
                            n5 = parcel.readInt();
                            if (this.checkMetadataId(n5)) break block7;
                            bl = true;
                            break block5;
                        }
                        if (!this.mKeyToPosMap.containsKey(n5)) break block8;
                        Log.e(TAG, "Duplicate metadata ID found");
                        bl = true;
                        break block5;
                    }
                    this.mKeyToPosMap.put(n5, parcel.dataPosition());
                    int n6 = parcel.readInt();
                    if (n6 > 0 && n6 <= 8) break block9;
                    Log.e(TAG, "Invalid metadata type " + n6);
                    bl = true;
                }
                if (n == 0 && !bl) {
                    return true;
                }
                Log.e(TAG, "Ran out of data or error on record " + n2);
                this.mKeyToPosMap.clear();
                return false;
            }
            parcel.setDataPosition(n4 + n3);
            n -= n3;
            ++n2;
        }
    }

    public boolean getBoolean(int n) {
        this.checkType(n, 3);
        return this.mParcel.readInt() == 1;
    }

    public byte[] getByteArray(int n) {
        this.checkType(n, 8);
        return this.mParcel.createByteArray();
    }

    public Date getDate(int n) {
        this.checkType(n, 7);
        long l = this.mParcel.readLong();
        String string2 = this.mParcel.readString();
        if (string2.length() == 0) {
            return new Date(l);
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(string2));
        calendar.setTimeInMillis(l);
        return calendar.getTime();
    }

    public double getDouble(int n) {
        this.checkType(n, 5);
        return this.mParcel.readDouble();
    }

    public int getInt(int n) {
        this.checkType(n, 2);
        return this.mParcel.readInt();
    }

    public long getLong(int n) {
        this.checkType(n, 4);
        return this.mParcel.readLong();
    }

    public String getString(int n) {
        this.checkType(n, 1);
        return this.mParcel.readString();
    }

    public TimedText getTimedText(int n) {
        this.checkType(n, 6);
        return new TimedText(new Date(this.mParcel.readLong()), this.mParcel.readInt(), this.mParcel.readString());
    }

    public boolean has(int n) {
        if (!this.checkMetadataId(n)) {
            throw new IllegalArgumentException("Invalid key: " + n);
        }
        return this.mKeyToPosMap.containsKey(n);
    }

    public Set<Integer> keySet() {
        return this.mKeyToPosMap.keySet();
    }

    public boolean parse(Parcel parcel) {
        if (parcel.dataAvail() < 8) {
            Log.e(TAG, "Not enough data " + parcel.dataAvail());
            return false;
        }
        int n = parcel.dataPosition();
        int n2 = parcel.readInt();
        if (4 + parcel.dataAvail() < n2 || n2 < 8) {
            Log.e(TAG, "Bad size " + n2 + " avail " + parcel.dataAvail() + " position " + n);
            parcel.setDataPosition(n);
            return false;
        }
        int n3 = parcel.readInt();
        if (n3 != 1296389185) {
            Log.e(TAG, "Marker missing " + Integer.toHexString(n3));
            parcel.setDataPosition(n);
            return false;
        }
        if (!this.scanAllRecords(parcel, n2 - 8)) {
            parcel.setDataPosition(n);
            return false;
        }
        this.mParcel = parcel;
        return true;
    }

    public class TimedText {
        private int mDuration;
        private String mText;
        private Date mTime;

        public TimedText(Date date, int n, String string2) {
            this.mTime = date;
            this.mDuration = n;
            this.mText = string2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(80);
            stringBuilder.append(this.mTime).append("-").append(this.mDuration).append(":").append(this.mText);
            return stringBuilder.toString();
        }
    }
}

