/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import java.io.IOException;
import java.io.InputStream;

public final class ResampleInputStream
extends InputStream {
    private static final String TAG = "ResampleInputStream";
    private static final int mFirLength = 29;
    private byte[] mBuf;
    private int mBufCount;
    private InputStream mInputStream;
    private final byte[] mOneByte = new byte[1];
    private final int mRateIn;
    private final int mRateOut;

    static {
        System.loadLibrary("media_jni");
    }

    public ResampleInputStream(InputStream inputStream, int n, int n2) {
        if (n != n2 * 2) {
            throw new IllegalArgumentException("only support 2:1 at the moment");
        }
        this.mInputStream = inputStream;
        this.mRateIn = 2;
        this.mRateOut = 1;
    }

    private static native void fir21(byte[] var0, int var1, byte[] var2, int var3, int var4);

    @Override
    public void close() throws IOException {
        try {
            if (this.mInputStream != null) {
                this.mInputStream.close();
            }
            return;
        }
        finally {
            this.mInputStream = null;
        }
    }

    protected void finalize() throws Throwable {
        if (this.mInputStream != null) {
            this.close();
            throw new IllegalStateException("someone forgot to close ResampleInputStream");
        }
    }

    @Override
    public int read() throws IOException {
        if (this.read(this.mOneByte, 0, 1) == 1) {
            return 0xFF & this.mOneByte[0];
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.mInputStream == null) {
            throw new IllegalStateException("not open");
        }
        int n3 = 2 * (29 + n2 / 2 * this.mRateIn / this.mRateOut);
        if (this.mBuf == null) {
            this.mBuf = new byte[n3];
        } else if (n3 > this.mBuf.length) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(this.mBuf, 0, byArray2, 0, this.mBufCount);
            this.mBuf = byArray2;
        }
        while (true) {
            int n4;
            if ((n4 = 2 * ((this.mBufCount / 2 - 29) * this.mRateOut / this.mRateIn)) > 0) {
                int n5 = n4 < n2 ? n4 : 2 * (n2 / 2);
                ResampleInputStream.fir21(this.mBuf, 0, byArray, n, n5 / 2);
                int n6 = n5 * this.mRateIn / this.mRateOut;
                this.mBufCount -= n6;
                if (this.mBufCount > 0) {
                    System.arraycopy(this.mBuf, n6, this.mBuf, 0, this.mBufCount);
                }
                return n5;
            }
            int n7 = this.mInputStream.read(this.mBuf, this.mBufCount, this.mBuf.length - this.mBufCount);
            if (n7 == -1) {
                return -1;
            }
            this.mBufCount = n7 + this.mBufCount;
        }
    }
}

