/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.SystemClock;
import android.provider.Downloads;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public final class Downloads {
    public static final String ACTION_DOWNLOAD_COMPLETED = "android.intent.action.DOWNLOAD_COMPLETED";
    public static final String COLUMN_NOTIFICATION_EXTRAS = "notificationextras";
    private static final int DOWNLOADS_COLUMN_CURRENT_BYTES = 5;
    private static final int DOWNLOADS_COLUMN_FILENAME = 3;
    private static final int DOWNLOADS_COLUMN_ID = 0;
    private static final int DOWNLOADS_COLUMN_LAST_MODIFICATION = 4;
    private static final int DOWNLOADS_COLUMN_STATUS = 2;
    private static final int DOWNLOADS_COLUMN_URI = 1;
    private static final String[] DOWNLOADS_PROJECTION = new String[]{"_id", "entity", "status", "_data", "lastmod", "current_bytes"};
    public static final int DOWNLOAD_DESTINATION_CACHE = 2;
    public static final int DOWNLOAD_DESTINATION_CACHE_PURGEABLE = 3;
    public static final int DOWNLOAD_DESTINATION_EXTERNAL = 1;
    public static final long DOWNLOAD_ID_INVALID = -1L;
    public static final int STATUS_DEVICE_NOT_FOUND_ERROR = 499;
    private static final int STATUS_DOWNLOADED_UPDATE = 4;
    private static final int STATUS_DOWNLOADING_UPDATE = 3;
    public static final int STATUS_INSUFFICIENT_SPACE_ERROR = 498;
    private static final int STATUS_INVALID = 0;
    public static final int STATUS_NOT_ACCEPTABLE = 406;
    public static final int STATUS_PENDING = 190;
    public static final int STATUS_RUNNING = 192;
    public static final int STATUS_SUCCESS = 200;
    public static final int STATUS_UNHANDLED_REDIRECT = 493;
    public static final int STATUS_UNKNOWN_ERROR = 491;

    private Downloads() {
    }

    private static final int getStatusOfDownload(Cursor cursor, long l) {
        int n = cursor.getInt(2);
        SystemClock.elapsedRealtime();
        if (!Downloads.Impl.isStatusCompleted(n)) {
            long l2 = cursor.getLong(4);
            long l3 = System.currentTimeMillis();
            if (l3 < l2 || l3 - l2 > l) {
                return 0;
            }
            return 3;
        }
        if (Downloads.Impl.isStatusError(n)) {
            return 0;
        }
        if (cursor.getString(3) == null) {
            return 0;
        }
        return 4;
    }

    public static boolean isStatusError(int n) {
        return n >= 400 && n < 600;
    }

    public static boolean isStatusSuccess(int n) {
        return n >= 200 && n < 300;
    }

    public static final class ById
    extends DownloadBase {
        private ById() {
        }

        public static void deleteDownload(Context context, long l) {
            context.getContentResolver().delete(ById.getDownloadUri(l), null, null);
        }

        private static Uri getDownloadUri(long l) {
            return Uri.parse(Downloads.Impl.CONTENT_URI + "/" + l);
        }

        public static String getMimeTypeForId(Context context, long l) {
            String string2;
            Cursor cursor;
            block5: {
                String string3;
                ContentResolver contentResolver = context.getContentResolver();
                cursor = null;
                try {
                    cursor = contentResolver.query(ById.getDownloadUri(l), new String[]{"mimetype"}, null, null, null);
                    boolean bl = cursor.moveToNext();
                    string2 = null;
                    if (!bl) break block5;
                }
                catch (Throwable throwable) {
                    if (cursor != null) {
                        cursor.close();
                    }
                    throw throwable;
                }
                string2 = string3 = cursor.getString(0);
            }
            if (cursor != null) {
                cursor.close();
            }
            return string2;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static final StatusInfo getStatus(Context context, long l) {
            int n;
            StatusInfo statusInfo;
            Cursor cursor;
            block10: {
                block11: {
                    StatusInfo statusInfo2;
                    Uri uri = ById.getDownloadUri(l);
                    cursor = context.getContentResolver().query(uri, DOWNLOADS_PROJECTION, null, null, null);
                    boolean bl = cursor.moveToNext();
                    if (!bl) {
                        if (cursor != null) {
                            cursor.close();
                        }
                        return null;
                    }
                    statusInfo = statusInfo2 = new StatusInfo();
                    n = Downloads.getStatusOfDownload(cursor, 0L);
                    if (n == 3 || n == 4) break block10;
                    cursor.getLong(4);
                    statusInfo.statusCode = cursor.getInt(2);
                    statusInfo.bytesSoFar = cursor.getLong(5);
                    if (cursor == null) break block11;
                    cursor.close();
                }
                return statusInfo;
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block12: {
                        throwable2 = throwable;
                        break block12;
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                        }
                    }
                    if (cursor != null) {
                        cursor.close();
                    }
                    throw throwable2;
                }
            }
            boolean bl = n == 4;
            statusInfo.completed = bl;
            statusInfo.filename = cursor.getString(3);
            statusInfo.id = cursor.getLong(0);
            statusInfo.statusCode = cursor.getInt(2);
            statusInfo.bytesSoFar = cursor.getLong(5);
            if (cursor != null) {
                cursor.close();
            }
            return statusInfo;
        }

        public static ParcelFileDescriptor openDownload(Context context, long l, String string2) throws FileNotFoundException {
            return context.getContentResolver().openFileDescriptor(ById.getDownloadUri(l), string2);
        }

        public static InputStream openDownloadStream(Context context, long l) throws FileNotFoundException, IOException {
            return context.getContentResolver().openInputStream(ById.getDownloadUri(l));
        }
    }

    public static final class ByUri
    extends DownloadBase {
        private static final String[] PROJECTION = new String[]{"_id", "current_bytes", "total_bytes"};
        private static final String QUERY_WHERE_APP_DATA_CLAUSE = "entity=?";
        private static final String QUERY_WHERE_CLAUSE = "notificationpackage=? AND notificationclass=?";

        private ByUri() {
        }

        private static final Cursor getCurrentOtaDownloads(Context context, String string2) {
            return context.getContentResolver().query(Downloads.Impl.CONTENT_URI, DOWNLOADS_PROJECTION, QUERY_WHERE_APP_DATA_CLAUSE, new String[]{string2}, null);
        }

        public static final int getProgressColumnCurrentBytes() {
            return 1;
        }

        public static final int getProgressColumnId() {
            return 0;
        }

        public static final int getProgressColumnTotalBytes() {
            return 2;
        }

        public static final Cursor getProgressCursor(Context context, long l) {
            Uri uri = Uri.withAppendedPath(Downloads.Impl.CONTENT_URI, String.valueOf(l));
            return context.getContentResolver().query(uri, PROJECTION, null, null, null);
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static final StatusInfo getStatus(Context context, String string2, long l) {
            int n;
            StatusInfo statusInfo;
            Cursor cursor;
            block11: {
                StatusInfo statusInfo2 = null;
                long l2 = 0L;
                cursor = ByUri.getCurrentOtaDownloads(context, string2);
                boolean bl = false;
                while (cursor != null) {
                    StatusInfo statusInfo3;
                    if (!cursor.moveToNext()) break;
                    statusInfo = statusInfo2 == null ? (statusInfo3 = new StatusInfo()) : statusInfo2;
                    n = Downloads.getStatusOfDownload(cursor, l);
                    if (n != 3 && n != 4) {
                        long l3 = cursor.getLong(4);
                        if (bl && l3 < l2) {
                            statusInfo2 = statusInfo;
                            continue;
                        }
                        bl = true;
                        l2 = l3;
                        statusInfo.statusCode = cursor.getInt(2);
                        statusInfo.bytesSoFar = cursor.getLong(5);
                        statusInfo2 = statusInfo;
                        continue;
                    }
                    break block11;
                }
                if (cursor != null) {
                    cursor.close();
                }
                return statusInfo2;
                catch (Throwable throwable) {
                    Throwable throwable2;
                    block12: {
                        throwable2 = throwable;
                        break block12;
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                        }
                    }
                    if (cursor != null) {
                        cursor.close();
                    }
                    throw throwable2;
                }
            }
            boolean bl = n == 4;
            statusInfo.completed = bl;
            statusInfo.filename = cursor.getString(3);
            statusInfo.id = cursor.getLong(0);
            statusInfo.statusCode = cursor.getInt(2);
            statusInfo.bytesSoFar = cursor.getLong(5);
            if (cursor != null) {
                cursor.close();
            }
            return statusInfo;
        }

        public static final void removeAllDownloadsByPackage(Context context, String string2, String string3) {
            context.getContentResolver().delete(Downloads.Impl.CONTENT_URI, QUERY_WHERE_CLAUSE, new String[]{string2, string3});
        }
    }

    public static class DownloadBase {
        DownloadBase() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public static long startDownloadByUri(Context context, String string2, String string3, boolean bl, int n, boolean bl2, boolean bl3, String string4, String string5, String string6, String string7) {
            ContentResolver contentResolver = context.getContentResolver();
            ContentValues contentValues = new ContentValues();
            contentValues.put("uri", string2);
            contentValues.put("cookiedata", string3);
            int n2 = bl ? 0 : 2;
            contentValues.put("visibility", n2);
            if (string4 != null) {
                contentValues.put("title", string4);
            }
            contentValues.put("entity", string2);
            int n3 = 0;
            switch (n) {
                case 1: {
                    n3 = 0;
                    break;
                }
                case 2: {
                    if (bl2) {
                        n3 = 1;
                        break;
                    }
                    n3 = 3;
                    break;
                }
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            contentValues.put("destination", n3);
            contentValues.put("no_integrity", bl3);
            if (string5 != null && string6 != null) {
                contentValues.put("notificationpackage", string5);
                contentValues.put("notificationclass", string6);
                if (string7 != null) {
                    contentValues.put(Downloads.COLUMN_NOTIFICATION_EXTRAS, string7);
                }
            }
            Uri uri = contentResolver.insert(Downloads.Impl.CONTENT_URI, contentValues);
            long l = -1L;
            if (uri == null) return l;
            return Long.parseLong(uri.getLastPathSegment());
        }
    }

    public static final class StatusInfo {
        public long bytesSoFar = -1L;
        public boolean completed = false;
        public String filename = null;
        public long id = -1L;
        public int statusCode = -1;

        public boolean isComplete() {
            return Downloads.Impl.isStatusCompleted(this.statusCode);
        }

        public boolean isSuccessful() {
            return Downloads.Impl.isStatusCompleted(this.statusCode);
        }
    }
}

