/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.NetworkStateTracker;
import android.net.NetworkUtils;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.Phone;

public class MobileDataStateTracker
extends NetworkStateTracker {
    private static final boolean DBG = false;
    private static final String TAG = "MobileDataStateTracker";
    private String mApnName;
    private String mApnType;
    private String mApnTypeToWatchFor;
    private boolean mEnabled;
    private boolean mIsDefaultOrHipri = false;
    private Phone.DataState mMobileDataState;
    private ITelephony mPhoneService;
    private BroadcastReceiver mStateReceiver;

    /*
     * Enabled aggressive block sorting
     */
    public MobileDataStateTracker(Context context, Handler handler, int n, String string2) {
        super(context, handler, n, TelephonyManager.getDefault().getNetworkType(), string2, TelephonyManager.getDefault().getNetworkTypeName());
        this.mApnType = MobileDataStateTracker.networkTypeToApnType(n);
        this.mApnTypeToWatchFor = TextUtils.equals(this.mApnType, "hipri") ? "default" : this.mApnType;
        if (n == 0 || n == 5) {
            this.mIsDefaultOrHipri = true;
        }
        this.mPhoneService = null;
        this.mEnabled = n == 0;
        this.mDnsPropNames = new String[]{"net.rmnet0.dns1", "net.rmnet0.dns2", "net.eth0.dns1", "net.eth0.dns2", "net.eth0.dns3", "net.eth0.dns4", "net.gprs.dns1", "net.gprs.dns2", "net.ppp0.dns1", "net.ppp0.dns2"};
    }

    static /* synthetic */ Phone.DataState access$100(MobileDataStateTracker mobileDataStateTracker, Intent intent) {
        return mobileDataStateTracker.getMobileDataState(intent);
    }

    static /* synthetic */ String access$202(MobileDataStateTracker mobileDataStateTracker, String string2) {
        mobileDataStateTracker.mApnName = string2;
        return string2;
    }

    static /* synthetic */ boolean access$300(MobileDataStateTracker mobileDataStateTracker, String string2) {
        return mobileDataStateTracker.isApnTypeIncluded(string2);
    }

    static /* synthetic */ boolean access$400(MobileDataStateTracker mobileDataStateTracker) {
        return mobileDataStateTracker.mEnabled;
    }

    static /* synthetic */ boolean access$402(MobileDataStateTracker mobileDataStateTracker, boolean bl) {
        mobileDataStateTracker.mEnabled = bl;
        return bl;
    }

    static /* synthetic */ Phone.DataState access$500(MobileDataStateTracker mobileDataStateTracker) {
        return mobileDataStateTracker.mMobileDataState;
    }

    static /* synthetic */ Phone.DataState access$502(MobileDataStateTracker mobileDataStateTracker, Phone.DataState dataState) {
        mobileDataStateTracker.mMobileDataState = dataState;
        return dataState;
    }

    static /* synthetic */ boolean access$600(MobileDataStateTracker mobileDataStateTracker) {
        return mobileDataStateTracker.mIsDefaultOrHipri;
    }

    static /* synthetic */ String access$700(MobileDataStateTracker mobileDataStateTracker) {
        return mobileDataStateTracker.mApnType;
    }

    private Phone.DataState getMobileDataState(Intent intent) {
        String string2 = intent.getStringExtra("state");
        if (string2 != null && this.isApnTypeIncluded(intent.getStringExtra("apnType"))) {
            return Enum.valueOf(Phone.DataState.class, string2);
        }
        return Phone.DataState.DISCONNECTED;
    }

    private void getPhoneService(boolean bl) {
        if (this.mPhoneService == null || bl) {
            this.mPhoneService = ITelephony.Stub.asInterface(ServiceManager.getService("phone"));
        }
    }

    private boolean isApnTypeIncluded(String string2) {
        if (string2 == null) {
            return false;
        }
        String[] stringArray = string2.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!TextUtils.equals(stringArray[i], this.mApnTypeToWatchFor) && !TextUtils.equals(stringArray[i], "*")) continue;
            return true;
        }
        return false;
    }

    public static String networkTypeToApnType(int n) {
        switch (n) {
            default: {
                Log.e(TAG, "Error mapping networkType " + n + " to apnType.");
                return null;
            }
            case 0: {
                return "default";
            }
            case 2: {
                return "mms";
            }
            case 3: {
                return "supl";
            }
            case 4: {
                return "dun";
            }
            case 5: 
        }
        return "hipri";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int setEnableApn(String string2, boolean bl) {
        this.getPhoneService(false);
        int n = 0;
        while (true) {
            block8: {
                block7: {
                    if (n >= 2) break block7;
                    if (this.mPhoneService != null) break block8;
                    Log.w(TAG, "Ignoring feature request because could not acquire PhoneService");
                }
                StringBuilder stringBuilder = new StringBuilder().append("Could not ");
                String string3 = bl ? "enable" : "disable";
                Log.w(TAG, stringBuilder.append(string3).append(" APN type \"").append(string2).append("\"").toString());
                return 3;
            }
            if (!bl) return this.mPhoneService.disableApnType(string2);
            try {
                return this.mPhoneService.enableApnType(string2);
            }
            catch (RemoteException remoteException) {
                if (n == 0) {
                    this.getPhoneService(true);
                }
                ++n;
                continue;
            }
            break;
        }
    }

    public int getNetworkSubtype() {
        return TelephonyManager.getDefault().getNetworkType();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String getTcpBufferSizesPropName() {
        String string2 = "unknown";
        switch (new TelephonyManager(this.mContext).getNetworkType()) {
            case 1: {
                string2 = "gprs";
                return "net.tcp.buffersize." + string2;
            }
            case 2: {
                string2 = "edge";
                return "net.tcp.buffersize." + string2;
            }
            case 3: {
                string2 = "umts";
                return "net.tcp.buffersize." + string2;
            }
            case 8: {
                string2 = "hsdpa";
                return "net.tcp.buffersize." + string2;
            }
            case 9: {
                string2 = "hsupa";
                return "net.tcp.buffersize." + string2;
            }
            case 10: {
                string2 = "hspa";
                return "net.tcp.buffersize." + string2;
            }
            case 4: {
                string2 = "cdma";
                return "net.tcp.buffersize." + string2;
            }
            case 7: {
                string2 = "1xrtt";
                return "net.tcp.buffersize." + string2;
            }
            case 5: {
                string2 = "evdo";
                return "net.tcp.buffersize." + string2;
            }
            case 6: {
                string2 = "evdo";
                return "net.tcp.buffersize." + string2;
            }
            case 12: {
                string2 = "evdo";
                return "net.tcp.buffersize." + string2;
            }
        }
        return "net.tcp.buffersize." + string2;
    }

    @Override
    public boolean isAvailable() {
        this.getPhoneService(false);
        int n = 0;
        while (n < 2 && this.mPhoneService != null) {
            try {
                boolean bl = this.mPhoneService.isDataConnectivityPossible();
                return bl;
            }
            catch (RemoteException remoteException) {
                if (n == 0) {
                    this.getPhoneService(true);
                }
                ++n;
                continue;
            }
            break;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean reconnect() {
        this.setTeardownRequested(false);
        switch (this.setEnableApn(this.mApnType, true)) {
            default: {
                Log.e(TAG, "Error in reconnect - unexpected response.");
                this.mEnabled = false;
                return this.mEnabled;
            }
            case 0: {
                this.mEnabled = true;
                this.mMobileDataState = Phone.DataState.CONNECTING;
                this.setDetailedState(NetworkInfo.DetailedState.CONNECTING, "apnChanged", null);
                Intent intent = new Intent("android.intent.action.ANY_DATA_STATE");
                intent.putExtra("state", Phone.DataState.CONNECTED.toString());
                intent.putExtra("reason", "apnChanged");
                intent.putExtra("apnType", this.mApnTypeToWatchFor);
                intent.putExtra("apn", this.mApnName);
                intent.putExtra("iface", this.mInterfaceName);
                intent.putExtra("networkUnvailable", false);
                if (this.mStateReceiver == null) return this.mEnabled;
                this.mStateReceiver.onReceive(this.mContext, intent);
                return this.mEnabled;
            }
            case 1: {
                this.mEnabled = true;
                return this.mEnabled;
            }
            case 3: {
                if (this.mPhoneService != null || this.mApnType != "default") break;
                this.mEnabled = true;
                return false;
            }
            case 2: 
        }
        if (this.mApnType == "default") return this.mEnabled;
        this.mEnabled = false;
        return this.mEnabled;
    }

    @Override
    public boolean requestRouteToHost(int n) {
        if (this.mInterfaceName != null && n != -1) {
            return NetworkUtils.addHostRoute(this.mInterfaceName, n) == 0;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setRadio(boolean bl) {
        this.getPhoneService(false);
        int n = 0;
        while (true) {
            block8: {
                block7: {
                    if (n >= 2) break block7;
                    if (this.mPhoneService != null) break block8;
                    Log.w(TAG, "Ignoring mobile radio request because could not acquire PhoneService");
                }
                StringBuilder stringBuilder = new StringBuilder().append("Could not set radio power to ");
                String string2 = bl ? "on" : "off";
                Log.w(TAG, stringBuilder.append(string2).toString());
                return false;
            }
            try {
                return this.mPhoneService.setRadio(bl);
            }
            catch (RemoteException remoteException) {
                if (n == 0) {
                    this.getPhoneService(true);
                }
                ++n;
                continue;
            }
            break;
        }
    }

    @Override
    public void startMonitoring() {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.ANY_DATA_STATE");
        intentFilter.addAction("android.intent.action.DATA_CONNECTION_FAILED");
        intentFilter.addAction("android.intent.action.SERVICE_STATE");
        this.mStateReceiver = new MobileDataStateReceiver();
        Intent intent = this.mContext.registerReceiver(this.mStateReceiver, intentFilter);
        if (intent != null) {
            this.mMobileDataState = this.getMobileDataState(intent);
            return;
        }
        this.mMobileDataState = Phone.DataState.DISCONNECTED;
    }

    @Override
    public int startUsingNetworkFeature(String string2, int n, int n2) {
        return -1;
    }

    @Override
    public int stopUsingNetworkFeature(String string2, int n, int n2) {
        return -1;
    }

    @Override
    public boolean teardown() {
        this.setTeardownRequested(true);
        return this.setEnableApn(this.mApnType, false) != 3;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Mobile data state: ");
        stringBuffer.append((Object)this.mMobileDataState);
        return stringBuffer.toString();
    }

    private class MobileDataStateReceiver
    extends BroadcastReceiver {
        ConnectivityManager mConnectivityManager;

        private MobileDataStateReceiver() {
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onReceive(Context var1_1, Intent var2_2) {
            synchronized (this) {
                block19: {
                    block20: {
                        var4_3 = TelephonyManager.getDefault();
                        MobileDataStateTracker.this.setRoamingStatus(var4_3.isNetworkRoaming());
                        MobileDataStateTracker.this.setSubtype(var4_3.getNetworkType(), var4_3.getNetworkTypeName());
                        if (!var2_2.getAction().equals("android.intent.action.ANY_DATA_STATE")) ** GOTO lbl50
                        var8_4 = MobileDataStateTracker.access$100(MobileDataStateTracker.this, var2_2);
                        var9_5 = var2_2.getStringExtra("reason");
                        var10_6 = var2_2.getStringExtra("apn");
                        var11_7 = var2_2.getStringExtra("apnType");
                        MobileDataStateTracker.access$202(MobileDataStateTracker.this, var10_6);
                        var13_8 = var2_2.getBooleanExtra("networkUnvailable", false);
                        var14_9 = MobileDataStateTracker.this.mNetworkInfo;
                        var15_10 = var13_8 == false;
                        var14_9.setIsAvailable(var15_10);
                        if (!MobileDataStateTracker.access$300(MobileDataStateTracker.this, var11_7)) {
                            return;
                        }
                        if (!MobileDataStateTracker.access$400(MobileDataStateTracker.this)) {
                            if (var8_4 == Phone.DataState.CONNECTED) {
                                MobileDataStateTracker.this.mInterfaceName = var2_2.getStringExtra("iface");
                            }
                            return;
                        }
                        if (MobileDataStateTracker.access$500(MobileDataStateTracker.this) == var8_4) break block19;
                        MobileDataStateTracker.access$502(MobileDataStateTracker.this, var8_4);
                        switch (1.$SwitchMap$com$android$internal$telephony$Phone$DataState[var8_4.ordinal()]) {
                            case 1: {
                                if (MobileDataStateTracker.this.isTeardownRequested()) {
                                    MobileDataStateTracker.access$402(MobileDataStateTracker.this, false);
                                    MobileDataStateTracker.this.setTeardownRequested(false);
                                }
                                MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, var9_5, var10_6);
                                var18_11 = true;
                                if (MobileDataStateTracker.access$600(MobileDataStateTracker.this)) {
                                    var20_12 = "default".equals(MobileDataStateTracker.access$700(MobileDataStateTracker.this)) != false ? 5 : 0;
                                }
                                break block20;
                            }
                            case 2: {
                                MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.CONNECTING, var9_5, var10_6);
                                ** break;
                            }
                            case 3: {
                                MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.SUSPENDED, var9_5, var10_6);
                                ** break;
                            }
                            case 4: {
                                MobileDataStateTracker.this.mInterfaceName = var2_2.getStringExtra("iface");
                                if (MobileDataStateTracker.this.mInterfaceName == null) {
                                    Log.d("MobileDataStateTracker", "CONNECTED event did not supply interface name.");
                                }
                                MobileDataStateTracker.this.mDefaultGatewayAddr = var2_2.getIntExtra("gateway", 0);
                                MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.CONNECTED, var9_5, var10_6);
                                ** break;
                            }
lbl50:
                            // 1 sources

                            if (var2_2.getAction().equals("android.intent.action.DATA_CONNECTION_FAILED")) {
                                MobileDataStateTracker.access$402(MobileDataStateTracker.this, false);
                                var6_14 = var2_2.getStringExtra("reason");
                                var7_15 = var2_2.getStringExtra("apn");
                                MobileDataStateTracker.this.setDetailedState(NetworkInfo.DetailedState.FAILED, var6_14, var7_15);
                            }
                            break block19;
                        }
                        if (this.mConnectivityManager == null) {
                            this.mConnectivityManager = (ConnectivityManager)var1_1.getSystemService("connectivity");
                        }
                        if (this.mConnectivityManager != null && (var21_13 = this.mConnectivityManager.getNetworkInfo(var20_12)) != null && var21_13.isConnected()) {
                            var18_11 = false;
                        }
                    }
                    if (var18_11 && MobileDataStateTracker.this.mInterfaceName != null) {
                        NetworkUtils.resetConnections(MobileDataStateTracker.this.mInterfaceName);
                        ** break;
                    }
                }
                return;
            }
        }
    }
}

