/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.NetworkInfo;
import android.net.NetworkUtils;
import android.os.Handler;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Log;
import java.io.FileWriter;
import java.io.IOException;

public abstract class NetworkStateTracker
extends Handler {
    private static boolean DBG = false;
    public static final int EVENT_CONFIGURATION_CHANGED = 4;
    public static final int EVENT_NETWORK_SUBTYPE_CHANGED = 6;
    public static final int EVENT_NOTIFICATION_CHANGED = 3;
    public static final int EVENT_ROAMING_CHANGED = 5;
    public static final int EVENT_SCAN_RESULTS_AVAILABLE = 2;
    public static final int EVENT_STATE_CHANGED = 1;
    private static final int MAX_NETWORK_STATE_TRACKER_EVENT = 100;
    private static final int MIN_NETWORK_STATE_TRACKER_EVENT = 1;
    private static final String TAG = "NetworkStateTracker";
    protected Context mContext;
    protected int mDefaultGatewayAddr;
    protected String[] mDnsPropNames;
    protected String mInterfaceName;
    protected NetworkInfo mNetworkInfo;
    private boolean mPrivateDnsRouteSet;
    protected Handler mTarget;
    private boolean mTeardownRequested;

    static {
        DBG = false;
    }

    public NetworkStateTracker(Context context, Handler handler, int n, int n2, String string2, String string3) {
        this.mContext = context;
        this.mTarget = handler;
        this.mTeardownRequested = false;
        this.mNetworkInfo = new NetworkInfo(n, n2, string2, string3);
    }

    protected static String[] getNameServerList(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = SystemProperties.get(stringArray[i]);
            if (TextUtils.isEmpty(string2) || TextUtils.equals(string2, "0.0.0.0")) continue;
            int n2 = n + 1;
            stringArray2[n] = string2;
            n = n2;
        }
        return stringArray2;
    }

    private void setBufferSize(String string2) {
        try {
            String[] stringArray = string2.split(",");
            if (stringArray.length == 6) {
                this.stringToFile("/sys/kernel/ipv4/tcp_rmem_min", stringArray[0]);
                this.stringToFile("/sys/kernel/ipv4/tcp_rmem_def", stringArray[1]);
                this.stringToFile("/sys/kernel/ipv4/tcp_rmem_max", stringArray[2]);
                this.stringToFile("/sys/kernel/ipv4/tcp_wmem_min", stringArray[3]);
                this.stringToFile("/sys/kernel/ipv4/tcp_wmem_def", stringArray[4]);
                this.stringToFile("/sys/kernel/ipv4/tcp_wmem_max", stringArray[5]);
                return;
            }
            Log.w(TAG, "Invalid buffersize string: " + string2);
            return;
        }
        catch (IOException iOException) {
            Log.w(TAG, "Can't set tcp buffer sizes:" + iOException);
            return;
        }
    }

    private void stringToFile(String string2, String string3) throws IOException {
        FileWriter fileWriter = new FileWriter(string2);
        try {
            fileWriter.write(string3);
            return;
        }
        finally {
            fileWriter.close();
        }
    }

    public void addDefaultRoute() {
        if (this.mInterfaceName != null && this.mDefaultGatewayAddr != 0) {
            if (DBG) {
                Log.d(TAG, "addDefaultRoute for " + this.mNetworkInfo.getTypeName() + " (" + this.mInterfaceName + "), GatewayAddr=" + this.mDefaultGatewayAddr);
            }
            NetworkUtils.setDefaultRoute(this.mInterfaceName, this.mDefaultGatewayAddr);
        }
    }

    public void addPrivateDnsRoutes() {
        if (DBG) {
            Log.d(TAG, "addPrivateDnsRoutes for " + this + "(" + this.mInterfaceName + ") - mPrivateDnsRouteSet = " + this.mPrivateDnsRouteSet);
        }
        if (this.mInterfaceName != null && !this.mPrivateDnsRouteSet) {
            for (String string2 : this.getNameServers()) {
                int n = NetworkUtils.lookupHost(string2);
                if (n == -1 || n == 0) continue;
                if (DBG) {
                    Log.d(TAG, "  adding " + string2 + " (" + n + ")");
                }
                NetworkUtils.addHostRoute(this.mInterfaceName, n);
            }
            this.mPrivateDnsRouteSet = true;
        }
    }

    public String[] getNameServers() {
        return NetworkStateTracker.getNameServerList(this.mDnsPropNames);
    }

    public NetworkInfo getNetworkInfo() {
        return this.mNetworkInfo;
    }

    public abstract String getTcpBufferSizesPropName();

    public void interpretScanResultsAvailable() {
    }

    public abstract boolean isAvailable();

    public boolean isTeardownRequested() {
        return this.mTeardownRequested;
    }

    public abstract boolean reconnect();

    public void releaseWakeLock() {
    }

    public void removeDefaultRoute() {
        if (this.mInterfaceName != null) {
            if (DBG) {
                Log.d(TAG, "removeDefaultRoute for " + this.mNetworkInfo.getTypeName() + " (" + this.mInterfaceName + ")");
            }
            NetworkUtils.removeDefaultRoute(this.mInterfaceName);
        }
    }

    public void removePrivateDnsRoutes() {
        if (this.mInterfaceName != null && this.mPrivateDnsRouteSet) {
            if (DBG) {
                Log.d(TAG, "removePrivateDnsRoutes for " + this.mNetworkInfo.getTypeName() + " (" + this.mInterfaceName + ")");
            }
            NetworkUtils.removeHostRoutes(this.mInterfaceName);
            this.mPrivateDnsRouteSet = false;
        }
    }

    public boolean requestRouteToHost(int n) {
        return false;
    }

    protected void sendScanResultsAvailable() {
        this.mTarget.obtainMessage(2, this.mNetworkInfo).sendToTarget();
    }

    public void setDetailedState(NetworkInfo.DetailedState detailedState) {
        this.setDetailedState(detailedState, null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDetailedState(NetworkInfo.DetailedState detailedState, String string2, String string3) {
        if (DBG) {
            Log.d(TAG, "setDetailed state, old =" + (Object)((Object)this.mNetworkInfo.getDetailedState()) + " and new state=" + (Object)((Object)detailedState));
        }
        if (detailedState != this.mNetworkInfo.getDetailedState()) {
            boolean bl = this.mNetworkInfo.getState() == NetworkInfo.State.CONNECTING;
            String string4 = this.mNetworkInfo.getReason();
            if (bl && detailedState == NetworkInfo.DetailedState.CONNECTED && string2 == null && string4 != null) {
                string2 = string4;
            }
            this.mNetworkInfo.setDetailedState(detailedState, string2, string3);
            this.mTarget.obtainMessage(1, this.mNetworkInfo).sendToTarget();
        }
    }

    protected void setDetailedStateInternal(NetworkInfo.DetailedState detailedState) {
        this.mNetworkInfo.setDetailedState(detailedState, null, null);
    }

    public abstract boolean setRadio(boolean var1);

    protected void setRoamingStatus(boolean bl) {
        if (bl != this.mNetworkInfo.isRoaming()) {
            this.mNetworkInfo.setRoaming(bl);
            this.mTarget.obtainMessage(5, this.mNetworkInfo).sendToTarget();
        }
    }

    protected void setSubtype(int n, String string2) {
        int n2 = this.mNetworkInfo.getSubtype();
        if (n != n2) {
            this.mNetworkInfo.setSubtype(n, string2);
            if (this.mNetworkInfo.isConnected()) {
                this.mTarget.obtainMessage(6, n2, 0, this.mNetworkInfo).sendToTarget();
            }
        }
    }

    public void setTeardownRequested(boolean bl) {
        this.mTeardownRequested = bl;
    }

    public abstract void startMonitoring();

    public abstract int startUsingNetworkFeature(String var1, int var2, int var3);

    public abstract int stopUsingNetworkFeature(String var1, int var2, int var3);

    public abstract boolean teardown();

    public void updateNetworkSettings() {
        String string2 = this.getTcpBufferSizesPropName();
        String string3 = SystemProperties.get(string2);
        if (string3.length() == 0) {
            Log.w(TAG, string2 + " not found in system properties. Using defaults");
            string2 = "net.tcp.buffersize.default";
            string3 = SystemProperties.get(string2);
        }
        if (string3.length() != 0) {
            if (DBG) {
                Log.v(TAG, "Setting TCP values: [" + string3 + "] which comes from [" + string2 + "]");
            }
            this.setBufferSize(string3);
        }
    }
}

