/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.HttpsConnection;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import com.android.internal.net.DomainNameValidator;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.harmony.xnet.provider.jsse.SSLParametersImpl;

class CertificateChainValidator {
    private static final CertificateChainValidator sInstance = new CertificateChainValidator();

    private CertificateChainValidator() {
    }

    private void closeSocketThrowException(SSLSocket sSLSocket, String string2) throws IOException {
        if (sSLSocket != null) {
            SSLSession sSLSession = sSLSocket.getSession();
            if (sSLSession != null) {
                sSLSession.invalidate();
            }
            sSLSocket.close();
        }
        throw new SSLHandshakeException(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void closeSocketThrowException(SSLSocket sSLSocket, String string2, String string3) throws IOException {
        String string4 = string2 != null ? string2 : string3;
        this.closeSocketThrowException(sSLSocket, string4);
    }

    public static CertificateChainValidator getInstance() {
        return sInstance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SslError doHandshakeAndValidateServerCertificates(HttpsConnection httpsConnection, SSLSocket sSLSocket, String string2) throws IOException {
        X509Certificate x509Certificate;
        Certificate[] certificateArray;
        X509Certificate[] x509CertificateArray = null;
        try {
            sSLSocket.setUseClientMode(true);
            sSLSocket.startHandshake();
        }
        catch (IOException iOException) {
            this.closeSocketThrowException(sSLSocket, iOException.getMessage(), "failed to perform SSL handshake");
        }
        if ((certificateArray = sSLSocket.getSession().getPeerCertificates()) == null || certificateArray.length <= 0) {
            this.closeSocketThrowException(sSLSocket, "failed to retrieve peer certificates");
        } else {
            int n;
            x509CertificateArray = new X509Certificate[certificateArray.length];
            for (int i = 0; i < (n = certificateArray.length); ++i) {
                x509CertificateArray[i] = (X509Certificate)certificateArray[i];
            }
            if (httpsConnection != null && x509CertificateArray[0] != null) {
                httpsConnection.setCertificate(new SslCertificate(x509CertificateArray[0]));
            }
        }
        if ((x509Certificate = x509CertificateArray[0]) == null) {
            this.closeSocketThrowException(sSLSocket, "certificate for this site is null");
        } else if (!DomainNameValidator.match(x509Certificate, string2)) {
            String cfr_ignored_0 = "certificate not for this host: " + string2;
            sSLSocket.getSession().invalidate();
            return new SslError(2, x509Certificate);
        }
        int n = x509CertificateArray.length;
        if (x509CertificateArray.length > 1) {
            int n2;
            int n3;
            for (n3 = 0; n3 < (n2 = x509CertificateArray.length); ++n3) {
                boolean bl;
                block17: {
                    int n4 = n3 + 1;
                    do {
                        int n5 = x509CertificateArray.length;
                        int n6 = ++n4;
                        bl = false;
                        if (n6 >= n5) break block17;
                    } while (!((Object)x509CertificateArray[n3].getIssuerDN()).equals(x509CertificateArray[n4].getSubjectDN()));
                    bl = true;
                    int n7 = n3 + 1;
                    if (n4 != n7) {
                        X509Certificate x509Certificate2 = x509CertificateArray[n4];
                        x509CertificateArray[n4] = x509CertificateArray[n3 + 1];
                        x509CertificateArray[n3 + 1] = x509Certificate2;
                    }
                }
                if (!bl) break;
            }
            n = n3 + 1;
            X509Certificate x509Certificate3 = x509CertificateArray[n - 1];
            Date date = new Date();
            if (((Object)x509Certificate3.getSubjectDN()).equals(x509Certificate3.getIssuerDN()) && date.after(x509Certificate3.getNotAfter())) {
                --n;
            }
        }
        X509Certificate[] x509CertificateArray2 = new X509Certificate[n];
        for (int i = 0; i < n; ++i) {
            x509CertificateArray2[i] = x509CertificateArray[i];
        }
        try {
            SSLParametersImpl.getDefaultTrustManager().checkServerTrusted(x509CertificateArray2, "RSA");
            return null;
        }
        catch (CertificateException certificateException) {
            sSLSocket.getSession().invalidate();
            return new SslError(3, x509Certificate);
        }
    }
}

