/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.os.SystemClock;
import android.security.Sha1MessageDigest;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;

class CertificateValidatorCache {
    private static final long CACHE_ENTRY_LIFETIME = 600000L;
    public static long mCost;
    public static long mSave;
    private static CertificateFactory sCertificateFactory;
    private int mBigScrew = new Random().nextInt();
    private HashMap<Integer, CacheEntry> mCacheMap = new HashMap();

    static {
        mSave = 0L;
        mCost = 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static byte[] secureHash(Certificate[] certificateArray) {
        byte[] byArray;
        long l;
        block13: {
            l = SystemClock.uptimeMillis();
            byArray = null;
            if (certificateArray != null) {
                int n = certificateArray.length;
                byArray = null;
                if (n != 0) {
                    CertificateFactory certificateFactory = sCertificateFactory;
                    if (certificateFactory == null) {
                        try {
                            sCertificateFactory = CertificateFactory.getInstance("X.509");
                        }
                        catch (GeneralSecurityException generalSecurityException) {}
                    }
                    // MONITOREXIT : android.net.http.CertificateValidatorCache.class
                    try {
                        CertPath certPath = sCertificateFactory.generateCertPath(Arrays.asList(certificateArray));
                        byArray = null;
                        if (certPath == null) break block13;
                        byte[] byArray2 = certPath.getEncoded();
                        byArray = null;
                        if (byArray2 != null) {
                            byte[] byArray3;
                            byArray = byArray3 = new Sha1MessageDigest().digest(byArray2);
                        }
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        byArray = null;
                    }
                }
            }
        }
        long l2 = SystemClock.uptimeMillis();
        mCost += l2 - l;
        return byArray;
    }

    public boolean has(String string2, byte[] byArray) {
        CacheEntry cacheEntry;
        block5: {
            boolean bl;
            block4: {
                bl = false;
                if (string2 == null) break block4;
                int n = string2.length();
                bl = false;
                if (n == 0) break block4;
                bl = false;
                if (byArray == null) break block4;
                int n2 = byArray.length;
                bl = false;
                if (n2 == 0) break block4;
                cacheEntry = this.mCacheMap.get(new Integer(this.mBigScrew ^ string2.hashCode()));
                bl = false;
                if (cacheEntry == null) break block4;
                if (cacheEntry.expired()) break block5;
                bl = cacheEntry.has(string2, byArray);
                if (bl) {
                    mSave += cacheEntry.mSave;
                }
            }
            return bl;
        }
        this.mCacheMap.remove(cacheEntry);
        return false;
    }

    public boolean put(String string2, byte[] byArray, long l) {
        if (string2 != null && string2.length() != 0 && byArray != null && byArray.length != 0) {
            this.mCacheMap.put(new Integer(this.mBigScrew ^ string2.hashCode()), new CacheEntry(string2, byArray, l));
            return true;
        }
        return false;
    }

    private class CacheEntry {
        private String mDomain;
        private byte[] mHash;
        public long mSave;
        private long mTime;

        public CacheEntry(String string2, byte[] byArray, long l) {
            this.mDomain = string2;
            this.mHash = byArray;
            this.mSave = l;
            this.mTime = SystemClock.uptimeMillis();
        }

        public boolean expired() {
            return 600000L < SystemClock.uptimeMillis() - this.mTime;
        }

        public boolean has(String string2, byte[] byArray) {
            int n;
            if (string2 != null && string2.length() > 0 && !this.mDomain.equals(string2)) {
                return false;
            }
            if (byArray != null && (n = byArray.length) > 0 && n == this.mHash.length) {
                for (int i = 0; i < n; ++i) {
                    if (byArray[i] == this.mHash[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

