/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

public class HttpAuthHeader {
    private static final String ALGORITHM_TOKEN = "algorithm";
    public static final int BASIC = 1;
    public static final String BASIC_TOKEN = "Basic";
    public static final int DIGEST = 2;
    public static final String DIGEST_TOKEN = "Digest";
    private static final String NONCE_TOKEN = "nonce";
    private static final String OPAQUE_TOKEN = "opaque";
    private static final String QOP_TOKEN = "qop";
    private static final String REALM_TOKEN = "realm";
    private static final String STALE_TOKEN = "stale";
    public static final int UNKNOWN;
    private String mAlgorithm;
    private boolean mIsProxy;
    private String mNonce;
    private String mOpaque;
    private String mPassword;
    private String mQop;
    private String mRealm;
    private int mScheme;
    private boolean mStale;
    private String mUsername;

    public HttpAuthHeader(String string2) {
        if (string2 != null) {
            this.parseHeader(string2);
        }
    }

    private void parseHeader(String string2) {
        String string3;
        if (string2 != null && (string3 = this.parseScheme(string2)) != null && this.mScheme != 0) {
            this.parseParameters(string3);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseParameter(String string2) {
        int n;
        if (string2 == null || (n = string2.indexOf(61)) < 0) return;
        String string3 = string2.substring(0, n).trim();
        String string4 = HttpAuthHeader.trimDoubleQuotesIfAny(string2.substring(n + 1).trim());
        if (string3.equalsIgnoreCase(REALM_TOKEN)) {
            this.mRealm = string4;
            return;
        } else {
            if (this.mScheme != 2) return;
            this.parseParameter(string3, string4);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseParameter(String string2, String string3) {
        if (string2 == null || string3 == null) return;
        if (string2.equalsIgnoreCase(NONCE_TOKEN)) {
            this.mNonce = string3;
            return;
        } else {
            if (string2.equalsIgnoreCase(STALE_TOKEN)) {
                this.parseStale(string3);
                return;
            }
            if (string2.equalsIgnoreCase(OPAQUE_TOKEN)) {
                this.mOpaque = string3;
                return;
            }
            if (string2.equalsIgnoreCase(QOP_TOKEN)) {
                this.mQop = string3.toLowerCase();
                return;
            }
            if (!string2.equalsIgnoreCase(ALGORITHM_TOKEN)) return;
            this.mAlgorithm = string3.toLowerCase();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseParameters(String string2) {
        if (string2 != null) {
            int n;
            do {
                if ((n = string2.indexOf(44)) < 0) {
                    this.parseParameter(string2);
                    continue;
                }
                this.parseParameter(string2.substring(0, n));
                string2 = string2.substring(n + 1);
            } while (n >= 0);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String parseScheme(String string2) {
        if (string2 == null) return null;
        int n = string2.indexOf(32);
        if (n < 0) return null;
        String string3 = string2.substring(0, n).trim();
        if (string3.equalsIgnoreCase(DIGEST_TOKEN)) {
            this.mScheme = 2;
            this.mAlgorithm = "md5";
            return string2.substring(n + 1);
        }
        if (!string3.equalsIgnoreCase(BASIC_TOKEN)) return string2.substring(n + 1);
        this.mScheme = 1;
        return string2.substring(n + 1);
    }

    private void parseStale(String string2) {
        if (string2 != null && string2.equalsIgnoreCase("true")) {
            this.mStale = true;
        }
    }

    private static String trimDoubleQuotesIfAny(String string2) {
        int n;
        if (string2 != null && (n = string2.length()) > 2 && string2.charAt(0) == '\"' && string2.charAt(n - 1) == '\"') {
            return string2.substring(1, n - 1);
        }
        return string2;
    }

    public String getAlgorithm() {
        return this.mAlgorithm;
    }

    public String getNonce() {
        return this.mNonce;
    }

    public String getOpaque() {
        return this.mOpaque;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public String getQop() {
        return this.mQop;
    }

    public String getRealm() {
        return this.mRealm;
    }

    public int getScheme() {
        return this.mScheme;
    }

    public boolean getStale() {
        return this.mStale;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public boolean isBasic() {
        return this.mScheme == 1;
    }

    public boolean isDigest() {
        return this.mScheme == 2;
    }

    public boolean isProxy() {
        return this.mIsProxy;
    }

    public boolean isSupportedScheme() {
        if (this.mRealm != null) {
            if (this.mScheme == 1) {
                return true;
            }
            if (this.mScheme == 2) {
                return this.mAlgorithm.equals("md5") && (this.mQop == null || this.mQop.equals("auth"));
            }
        }
        return false;
    }

    public void setPassword(String string2) {
        this.mPassword = string2;
    }

    public void setProxy() {
        this.mIsProxy = true;
    }

    public void setUsername(String string2) {
        this.mUsername = string2;
    }
}

