/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.content.Context;
import android.net.http.AndroidHttpClientConnection;
import android.net.http.CertificateChainValidator;
import android.net.http.Connection;
import android.net.http.Headers;
import android.net.http.Request;
import android.net.http.RequestFeeder;
import android.net.http.SSLConnectionClosedByUserException;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.harmony.xnet.provider.jsse.FileClientSessionCache;
import org.apache.harmony.xnet.provider.jsse.OpenSSLContextImpl;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.ParseException;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;

public class HttpsConnection
extends Connection {
    private static SSLSocketFactory mSslSocketFactory = null;
    private boolean mAborted = false;
    private HttpHost mProxyHost;
    private Object mSuspendLock = new Object();
    private boolean mSuspended = false;

    static {
        HttpsConnection.initializeEngine(null);
    }

    HttpsConnection(Context context, HttpHost httpHost, HttpHost httpHost2, RequestFeeder requestFeeder) {
        super(context, httpHost, requestFeeder);
        this.mProxyHost = httpHost2;
    }

    private static SSLSocketFactory getSocketFactory() {
        synchronized (HttpsConnection.class) {
            SSLSocketFactory sSLSocketFactory = mSslSocketFactory;
            return sSLSocketFactory;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void initializeEngine(File var0) {
        var1_1 = null;
        if (var0 == null) ** GOTO lbl7
        try {
            Log.d("HttpsConnection", "Caching SSL sessions in " + var0 + ".");
            var1_1 = FileClientSessionCache.usingDirectory((File)var0);
lbl7:
            // 2 sources

            var2_2 = new OpenSSLContextImpl();
            var5_3 = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string2) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string2) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            var2_2.engineInit(null, var5_3, null);
            var2_2.engineGetClientSessionContext().setPersistentCache(var1_1);
            synchronized (HttpsConnection.class) {
            }
        }
        catch (KeyManagementException var4_4) {
            throw new RuntimeException(var4_4);
        }
        catch (IOException var3_5) {
            throw new RuntimeException(var3_5);
        }
        {
            HttpsConnection.mSslSocketFactory = var2_2.engineGetSocketFactory();
            return;
        }
    }

    @Override
    void closeConnection() {
        if (this.mSuspended) {
            this.restartConnection(false);
        }
        try {
            if (this.mHttpClientConnection != null && this.mHttpClientConnection.isOpen()) {
                this.mHttpClientConnection.close();
            }
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    @Override
    String getScheme() {
        return "https";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    AndroidHttpClientConnection openConnection(Request var1_1) throws IOException {
        block38: {
            block40: {
                block37: {
                    var2_2 = null;
                    if (this.mProxyHost == null) break block40;
                    var19_3 = null;
                    var20_4 = new Socket(this.mProxyHost.getHostName(), this.mProxyHost.getPort());
                    var20_4.setSoTimeout(60000);
                    var25_5 = new AndroidHttpClientConnection();
                    var26_6 = new BasicHttpParams();
                    HttpConnectionParams.setSocketBufferSize(var26_6, 8192);
                    var25_5.bind(var20_4, var26_6);
                    var28_7 = new Headers();
                    var29_8 = new BasicHttpRequest("CONNECT", this.mHost.toHostString());
                    for (Header var42_12 : var1_1.mHttpRequest.getAllHeaders()) {
                        var43_13 = var42_12.getName().toLowerCase();
                        if (!var43_13.startsWith("proxy") && !var43_13.equals("keep-alive")) continue;
                        var29_8.addHeader(var42_12);
                    }
                    catch (IOException var50_14) {
                        var22_15 = var50_14;
lbl24:
                        // 3 sources

                        while (true) {
                            if (var19_3 != null) {
                                var19_3.close();
                            }
                            if ((var23_16 = var22_15.getMessage()) == null) {
                                var23_16 = "failed to establish a connection to the proxy";
                            }
                            var24_17 = new IOException(var23_16);
                            throw var24_17;
                        }
                    }
                    catch (IOException var27_47) {
                        var22_15 = var27_47;
                        var19_3 = var25_5;
                        ** GOTO lbl24
                    }
                    catch (IOException var21_46) {
                        var22_15 = var21_46;
                        var19_3 = null;
                        ** continue;
                    }
                    catch (ParseException var36_24) {
                        var37_25 = var36_24.getMessage();
                        if (var37_25 == null) {
                            var37_25 = "failed to send a CONNECT request";
                        }
                        var38_26 = new IOException(var37_25);
                        throw var38_26;
                    }
                    catch (HttpException var33_27) {
                        var34_28 = var33_27.getMessage();
                        if (var34_28 == null) {
                            var34_28 = "failed to send a CONNECT request";
                        }
                        var35_29 = new IOException(var34_28);
                        throw var35_29;
                    }
                    catch (IOException var30_30) {
                        var31_31 = var30_30.getMessage();
                        if (var31_31 == null) {
                            var31_31 = "failed to send a CONNECT request";
                        }
                        var32_32 = new IOException(var31_31);
                        throw var32_32;
                    }
                    {
                        var25_5.sendRequestHeader(var29_8);
                        var25_5.flush();
                        while ((var45_19 = (var44_18 = var25_5.parseResponseHeader(var28_7)).getStatusCode()) < 200) {
                        }
                        if (var45_19 != 200) break block37;
                    }
                    {
                        var2_2 = (SSLSocket)HttpsConnection.getSocketFactory().createSocket(var20_4, this.mHost.getHostName(), this.mHost.getPort(), true);
                        break block38;
                    }
                }
                var46_36 = var44_18.getProtocolVersion();
                var1_1.mEventHandler.status(var46_36.getMajor(), var46_36.getMinor(), var45_19, var44_18.getReasonPhrase());
                var1_1.mEventHandler.headers(var28_7);
                var1_1.mEventHandler.endData();
                var25_5.close();
                return null;
            }
            try {
                var2_2 = (SSLSocket)HttpsConnection.getSocketFactory().createSocket();
                var2_2.setSoTimeout(60000);
                var6_37 = new InetSocketAddress(this.mHost.getHostName(), this.mHost.getPort());
                var2_2.connect(var6_37);
            }
            catch (IOException var3_38) {
                if (var2_2 != null) {
                    var2_2.close();
                }
                if ((var4_39 = var3_38.getMessage()) == null) {
                    var4_39 = "failed to create an SSL socket";
                }
                var5_40 = new IOException(var4_39);
                throw var5_40;
            }
        }
        if ((var9_22 = (var7_20 = CertificateChainValidator.getInstance()).doHandshakeAndValidateServerCertificates(this, var2_2, var8_21 = this.mHost.getHostName())) == null) ** GOTO lbl107
        var13_23 = this.mSuspendLock;
        synchronized (var13_23) {
            this.mSuspended = true;
            ** if (var1_1.getEventHandler().handleSslErrorRequest((SslError)var9_22)) goto lbl92
        }
lbl-1000:
        // 1 sources

        {
            throw new IOException("failed to handle " + var9_22);
        }
lbl92:
        // 1 sources

        var15_41 = this.mSuspendLock;
        synchronized (var15_41) {
            block39: {
                var17_42 = this.mSuspended;
                if (var17_42) {
                    this.mSuspendLock.wait(600000L);
                    if (!this.mSuspended) break block39;
                    this.mSuspended = false;
                    this.mAborted = true;
                }
            }
lbl102:
            // 2 sources

            while (true) {
                if (this.mAborted) {
                    var2_2.close();
                    throw new SSLConnectionClosedByUserException("connection closed by the user");
                }
                // MONITOREXIT @DISABLED, blocks:[26, 13] lbl106 : MonitorExitStatement: MONITOREXIT : var15_41
lbl107:
                // 2 sources

                var10_43 = new AndroidHttpClientConnection();
                var11_44 = new BasicHttpParams();
                var11_44.setIntParameter("http.socket.buffer-size", 8192);
                var10_43.bind(var2_2, var11_44);
                return var10_43;
            }
            catch (InterruptedException var18_45) {
                ** continue;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void restartConnection(boolean bl) {
        Object object = this.mSuspendLock;
        synchronized (object) {
            if (this.mSuspended) {
                this.mSuspended = false;
                boolean bl2 = !bl;
                this.mAborted = bl2;
                this.mSuspendLock.notify();
            }
            return;
        }
    }

    void setCertificate(SslCertificate sslCertificate) {
        this.mCertificate = sslCertificate;
    }
}

