/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.net.WebAddress;
import android.net.http.Connection;
import android.net.http.ConnectionThread;
import android.net.http.EventHandler;
import android.net.http.HttpLog;
import android.net.http.IdleCache;
import android.net.http.LoggingEventHandler;
import android.net.http.Request;
import android.net.http.RequestFeeder;
import android.net.http.RequestHandle;
import android.util.Log;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.http.HttpHost;

public class RequestQueue
implements RequestFeeder {
    private static final int CONNECTION_COUNT = 4;
    private final ActivePool mActivePool;
    private final ConnectivityManager mConnectivityManager;
    private final Context mContext;
    private final LinkedHashMap<HttpHost, LinkedList<Request>> mPending;
    private BroadcastReceiver mProxyChangeReceiver;
    private HttpHost mProxyHost = null;

    public RequestQueue(Context context) {
        this(context, 4);
    }

    public RequestQueue(Context context, int n) {
        this.mContext = context;
        this.mPending = new LinkedHashMap(32);
        this.mActivePool = new ActivePool(n);
        this.mActivePool.startup();
        this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
    }

    private HttpHost determineHost(HttpHost httpHost) {
        if (this.mProxyHost == null || "https".equals(httpHost.getSchemeName())) {
            return httpHost;
        }
        return this.mProxyHost;
    }

    private Request removeFirst(LinkedHashMap<HttpHost, LinkedList<Request>> linkedHashMap) {
        Iterator iterator = linkedHashMap.entrySet().iterator();
        boolean bl = iterator.hasNext();
        Request request = null;
        if (bl) {
            Map.Entry entry = iterator.next();
            LinkedList linkedList = (LinkedList)entry.getValue();
            request = (Request)linkedList.removeFirst();
            if (linkedList.isEmpty()) {
                linkedHashMap.remove(entry.getKey());
            }
        }
        return request;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setProxyConfig() {
        synchronized (this) {
            NetworkInfo networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
            if (networkInfo != null && networkInfo.getType() == 1) {
                this.mProxyHost = null;
            } else {
                String string2 = Proxy.getHost(this.mContext);
                if (string2 == null) {
                    this.mProxyHost = null;
                } else {
                    this.mActivePool.disablePersistence();
                    this.mProxyHost = new HttpHost(string2, Proxy.getPort(this.mContext), "http");
                }
            }
            return;
        }
    }

    public void disablePlatformNotifications() {
        synchronized (this) {
            if (this.mProxyChangeReceiver != null) {
                this.mContext.unregisterReceiver(this.mProxyChangeReceiver);
                this.mProxyChangeReceiver = null;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dump() {
        synchronized (this) {
            HttpLog.v("dump()");
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.mPending.isEmpty()) {
                Iterator iterator = this.mPending.entrySet().iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string2 = ((HttpHost)entry.getKey()).getHostName();
                    StringBuilder stringBuilder2 = new StringBuilder().append("p");
                    int n2 = n + 1;
                    StringBuilder stringBuilder3 = new StringBuilder(stringBuilder2.append(n).append(" ").append(string2).append(" ").toString());
                    ((LinkedList)entry.getValue()).listIterator(0);
                    while (iterator.hasNext()) {
                        Request request = (Request)((Object)iterator.next());
                        stringBuilder3.append(request + " ");
                    }
                    stringBuilder.append(stringBuilder3);
                    stringBuilder.append("\n");
                    n = n2;
                }
            }
            HttpLog.v(stringBuilder.toString());
            return;
        }
    }

    public void enablePlatformNotifications() {
        synchronized (this) {
            if (this.mProxyChangeReceiver == null) {
                this.mProxyChangeReceiver = new BroadcastReceiver(){

                    @Override
                    public void onReceive(Context context, Intent intent) {
                        RequestQueue.this.setProxyConfig();
                    }
                };
                this.mContext.registerReceiver(this.mProxyChangeReceiver, new IntentFilter("android.intent.action.PROXY_CHANGE"));
            }
            this.setProxyConfig();
            return;
        }
    }

    public HttpHost getProxyHost() {
        return this.mProxyHost;
    }

    @Override
    public Request getRequest() {
        synchronized (this) {
            Request request;
            block4: {
                Request request2;
                boolean bl = this.mPending.isEmpty();
                request = null;
                if (bl) break block4;
                request = request2 = this.removeFirst(this.mPending);
            }
            return request;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Request getRequest(HttpHost httpHost) {
        synchronized (this) {
            boolean bl = this.mPending.containsKey(httpHost);
            Request request = null;
            if (bl) {
                LinkedList<Request> linkedList = this.mPending.get(httpHost);
                request = linkedList.removeFirst();
                if (linkedList.isEmpty()) {
                    this.mPending.remove(httpHost);
                }
            }
            return request;
        }
    }

    @Override
    public boolean haveRequest(HttpHost httpHost) {
        synchronized (this) {
            boolean bl = this.mPending.containsKey(httpHost);
            return bl;
        }
    }

    public RequestHandle queueRequest(String string2, WebAddress webAddress, String string3, Map<String, String> map, EventHandler eventHandler, InputStream inputStream, int n) {
        if (eventHandler == null) {
            eventHandler = new LoggingEventHandler();
        }
        Request request = new Request(string3, new HttpHost(webAddress.mHost, webAddress.mPort, webAddress.mScheme), this.mProxyHost, webAddress.mPath, inputStream, n, eventHandler, map);
        this.queueRequest(request, false);
        ActivePool.access$408(this.mActivePool);
        this.mActivePool.startConnectionThread();
        return new RequestHandle(this, string2, webAddress, string3, map, inputStream, n, request);
    }

    public RequestHandle queueRequest(String string2, String string3, Map<String, String> map, EventHandler eventHandler, InputStream inputStream, int n) {
        return this.queueRequest(string2, new WebAddress(string2), string3, map, eventHandler, inputStream, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void queueRequest(Request request, boolean bl) {
        synchronized (this) {
            LinkedList<Object> linkedList;
            HttpHost httpHost = request.mProxyHost == null ? request.mHost : request.mProxyHost;
            if (this.mPending.containsKey(httpHost)) {
                linkedList = this.mPending.get(httpHost);
            } else {
                linkedList = new LinkedList();
                this.mPending.put(httpHost, linkedList);
            }
            if (bl) {
                linkedList.addFirst(request);
            } else {
                linkedList.add(request);
            }
            return;
        }
    }

    public RequestHandle queueSynchronousRequest(String string2, WebAddress webAddress, String string3, Map<String, String> map, EventHandler eventHandler, InputStream inputStream, int n) {
        HttpHost httpHost = new HttpHost(webAddress.mHost, webAddress.mPort, webAddress.mScheme);
        Request request = new Request(string3, httpHost, this.mProxyHost, webAddress.mPath, inputStream, n, eventHandler, map);
        HttpHost httpHost2 = this.determineHost(httpHost);
        return new RequestHandle(this, string2, webAddress, string3, map, inputStream, n, request, Connection.getConnection(this.mContext, httpHost2, this.mProxyHost, new SyncFeeder()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean requestsPending() {
        synchronized (this) {
            boolean bl = this.mPending.isEmpty();
            if (bl) return false;
            return true;
        }
    }

    @Override
    public void requeueRequest(Request request) {
        this.queueRequest(request, true);
    }

    public void shutdown() {
        this.mActivePool.shutdown();
    }

    public void startTiming() {
        this.mActivePool.startTiming();
    }

    public void stopTiming() {
        this.mActivePool.stopTiming();
    }

    class ActivePool
    implements ConnectionManager {
        private int mConnectionCount;
        IdleCache mIdleCache = new IdleCache();
        ConnectionThread[] mThreads;
        private int mTotalConnection;
        private int mTotalRequest;

        ActivePool(int n) {
            this.mConnectionCount = n;
            this.mThreads = new ConnectionThread[this.mConnectionCount];
            for (int i = 0; i < this.mConnectionCount; ++i) {
                this.mThreads[i] = new ConnectionThread(RequestQueue.this.mContext, i, this, RequestQueue.this);
            }
        }

        static /* synthetic */ int access$408(ActivePool activePool) {
            int n = activePool.mTotalRequest;
            activePool.mTotalRequest = n + 1;
            return n;
        }

        void disablePersistence() {
            for (int i = 0; i < this.mConnectionCount; ++i) {
                Connection connection = this.mThreads[i].mConnection;
                if (connection == null) continue;
                connection.setCanPersist(false);
            }
            this.mIdleCache.clear();
        }

        @Override
        public Connection getConnection(Context context, HttpHost httpHost) {
            HttpHost httpHost2 = RequestQueue.this.determineHost(httpHost);
            Connection connection = this.mIdleCache.getConnection(httpHost2);
            if (connection == null) {
                this.mTotalConnection = 1 + this.mTotalConnection;
                connection = Connection.getConnection(RequestQueue.this.mContext, httpHost2, RequestQueue.this.mProxyHost, RequestQueue.this);
            }
            return connection;
        }

        @Override
        public HttpHost getProxyHost() {
            return RequestQueue.this.mProxyHost;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        ConnectionThread getThread(HttpHost httpHost) {
            RequestQueue requestQueue = RequestQueue.this;
            synchronized (requestQueue) {
                int n = 0;
                while (n < this.mThreads.length) {
                    ConnectionThread connectionThread = this.mThreads[n];
                    Connection connection = connectionThread.mConnection;
                    if (connection != null && connection.mHost.equals(httpHost)) {
                        return connectionThread;
                    }
                    ++n;
                }
                return null;
            }
        }

        void logState() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.mConnectionCount; ++i) {
                stringBuilder.append(this.mThreads[i] + "\n");
            }
            HttpLog.v(stringBuilder.toString());
        }

        @Override
        public boolean recycleConnection(Connection connection) {
            return this.mIdleCache.cacheConnection(connection.getHost(), connection);
        }

        void shutdown() {
            for (int i = 0; i < this.mConnectionCount; ++i) {
                this.mThreads[i].requestStop();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void startConnectionThread() {
            RequestQueue requestQueue = RequestQueue.this;
            synchronized (requestQueue) {
                RequestQueue.this.notify();
                return;
            }
        }

        public void startTiming() {
            for (int i = 0; i < this.mConnectionCount; ++i) {
                ConnectionThread connectionThread = this.mThreads[i];
                connectionThread.mCurrentThreadTime = -1L;
                connectionThread.mTotalThreadTime = 0L;
            }
            this.mTotalRequest = 0;
            this.mTotalConnection = 0;
        }

        void startup() {
            for (int i = 0; i < this.mConnectionCount; ++i) {
                this.mThreads[i].start();
            }
        }

        public void stopTiming() {
            int n = 0;
            for (int i = 0; i < this.mConnectionCount; ++i) {
                ConnectionThread connectionThread = this.mThreads[i];
                if (connectionThread.mCurrentThreadTime != -1L) {
                    n = (int)((long)n + connectionThread.mTotalThreadTime);
                }
                connectionThread.mCurrentThreadTime = 0L;
            }
            Log.d("Http", "Http thread used " + n + " ms " + " for " + this.mTotalRequest + " requests and " + this.mTotalConnection + " new connections");
        }
    }

    static interface ConnectionManager {
        public Connection getConnection(Context var1, HttpHost var2);

        public HttpHost getProxyHost();

        public boolean recycleConnection(Connection var1);
    }

    private static class SyncFeeder
    implements RequestFeeder {
        private Request mRequest;

        SyncFeeder() {
        }

        @Override
        public Request getRequest() {
            Request request = this.mRequest;
            this.mRequest = null;
            return request;
        }

        @Override
        public Request getRequest(HttpHost httpHost) {
            return this.getRequest();
        }

        @Override
        public boolean haveRequest(HttpHost httpHost) {
            return this.mRequest != null;
        }

        @Override
        public void requeueRequest(Request request) {
            this.mRequest = request;
        }
    }
}

