/*
 * Decompiled with CFR 0.152.
 */
package android.net.rtp;

import android.net.rtp.AudioCodec;
import android.net.rtp.AudioGroup;
import android.net.rtp.RtpStream;
import java.net.InetAddress;
import java.net.SocketException;

public class AudioStream
extends RtpStream {
    private AudioCodec mCodec;
    private int mDtmfType = -1;
    private AudioGroup mGroup;

    public AudioStream(InetAddress inetAddress) throws SocketException {
        super(inetAddress);
    }

    public AudioCodec getCodec() {
        return this.mCodec;
    }

    public int getDtmfType() {
        return this.mDtmfType;
    }

    public AudioGroup getGroup() {
        return this.mGroup;
    }

    @Override
    public final boolean isBusy() {
        return this.mGroup != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void join(AudioGroup audioGroup) {
        block5: {
            block4: {
                if (this.mGroup == audioGroup) break block4;
                if (this.mGroup != null) {
                    this.mGroup.remove(this);
                    this.mGroup = null;
                }
                if (audioGroup != null) break block5;
            }
            return;
        }
        audioGroup.add(this, this.mCodec, this.mDtmfType);
        this.mGroup = audioGroup;
    }

    public void setCodec(AudioCodec audioCodec) {
        if (this.isBusy()) {
            throw new IllegalStateException("Busy");
        }
        if (audioCodec.type == this.mDtmfType) {
            throw new IllegalArgumentException("The type is used by DTMF");
        }
        this.mCodec = audioCodec;
    }

    public void setDtmfType(int n) {
        if (this.isBusy()) {
            throw new IllegalStateException("Busy");
        }
        if (n != -1) {
            if (n < 96 || n > 127) {
                throw new IllegalArgumentException("Invalid type");
            }
            if (n == this.mCodec.type) {
                throw new IllegalArgumentException("The type is used by codec");
            }
        }
        this.mDtmfType = n;
    }
}

