/*
 * Decompiled with CFR 0.152.
 */
package android.net.sip;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class SimpleSessionDescription {
    private final Fields mFields = new Fields("voscbtka");
    private final ArrayList<Media> mMedia = new ArrayList();

    /*
     * Enabled aggressive block sorting
     */
    public SimpleSessionDescription(long l, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = string2.indexOf(58) < 0 ? "IN IP4 " : "IN IP6 ";
        String string4 = stringBuilder.append(string3).append(string2).toString();
        this.mFields.parse("v=0");
        Fields fields = this.mFields;
        Object[] objectArray = new Object[]{l, System.currentTimeMillis(), string4};
        fields.parse(String.format("o=- %d %d %s", objectArray));
        this.mFields.parse("s=-");
        this.mFields.parse("t=0 0");
        this.mFields.parse("c=" + string4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SimpleSessionDescription(String string2) {
        String[] stringArray = string2.trim().replaceAll(" +", " ").split("[\r\n]+");
        Fields fields = this.mFields;
        int n = stringArray.length;
        int n2 = 0;
        while (true) {
            block10: {
                Media media;
                block9: {
                    block8: {
                        String string3;
                        block7: {
                            int n3;
                            int n4;
                            String string4;
                            String[] stringArray2;
                            if (n2 >= n) break block8;
                            string3 = stringArray[n2];
                            try {
                                if (string3.charAt(1) != '=') {
                                    throw new IllegalArgumentException();
                                }
                                if (string3.charAt(0) != 'm') break block7;
                                stringArray2 = string3.substring(2).split(" ", 4);
                                String[] stringArray3 = stringArray2[1].split("/", 2);
                                string4 = stringArray2[0];
                                n4 = Integer.parseInt(stringArray3[0]);
                                n3 = stringArray3.length < 2 ? 1 : Integer.parseInt(stringArray3[1]);
                            }
                            catch (Exception exception) {
                                throw new IllegalArgumentException("Invalid SDP: " + string3);
                            }
                            String string5 = stringArray2[2];
                            media = this.newMedia(string4, n4, n3, string5);
                            String[] stringArray4 = stringArray2[3].split(" ");
                            int n5 = stringArray4.length;
                            for (int i = 0; i < n5; ++i) {
                                media.setFormat(stringArray4[i], null);
                            }
                            break block9;
                        }
                        fields.parse(string3);
                        break block10;
                    }
                    return;
                }
                fields = media;
            }
            ++n2;
        }
    }

    public String encode() {
        StringBuilder stringBuilder = new StringBuilder();
        this.mFields.write(stringBuilder);
        Iterator<Media> iterator = this.mMedia.iterator();
        while (iterator.hasNext()) {
            iterator.next().write(stringBuilder);
        }
        return stringBuilder.toString();
    }

    public String getAddress() {
        return this.mFields.getAddress();
    }

    public String getAttribute(String string2) {
        return this.mFields.getAttribute(string2);
    }

    public String[] getAttributeNames() {
        return this.mFields.getAttributeNames();
    }

    public int getBandwidth(String string2) {
        return this.mFields.getBandwidth(string2);
    }

    public String[] getBandwidthTypes() {
        return this.mFields.getBandwidthTypes();
    }

    public String getEncryptionKey() {
        return this.mFields.getEncryptionKey();
    }

    public String getEncryptionMethod() {
        return this.mFields.getEncryptionMethod();
    }

    public Media[] getMedia() {
        return this.mMedia.toArray(new Media[this.mMedia.size()]);
    }

    public Media newMedia(String string2, int n, int n2, String string3) {
        Media media = new Media(string2, n, n2, string3);
        this.mMedia.add(media);
        return media;
    }

    public void setAddress(String string2) {
        this.mFields.setAddress(string2);
    }

    public void setAttribute(String string2, String string3) {
        this.mFields.setAttribute(string2, string3);
    }

    public void setBandwidth(String string2, int n) {
        this.mFields.setBandwidth(string2, n);
    }

    public void setEncryption(String string2, String string3) {
        this.mFields.setEncryption(string2, string3);
    }

    private static class Fields {
        private final ArrayList<String> mLines = new ArrayList();
        private final String mOrder;

        Fields(String string2) {
            this.mOrder = string2;
        }

        private String[] cut(String string2, char c) {
            String[] stringArray = new String[this.mLines.size()];
            int n = 0;
            for (String string3 : this.mLines) {
                if (!string3.startsWith(string2)) continue;
                int n2 = string3.indexOf(c);
                if (n2 == -1) {
                    n2 = string3.length();
                }
                stringArray[n] = string3.substring(string2.length(), n2);
                ++n;
            }
            return Arrays.copyOf(stringArray, n);
        }

        private int find(String string2, char c) {
            int n = string2.length();
            for (int i = this.mLines.size() - 1; i >= 0; --i) {
                String string3 = this.mLines.get(i);
                if (!string3.startsWith(string2) || string3.length() != n && string3.charAt(n) != c) continue;
                return i;
            }
            return -1;
        }

        private String get(String string2, char c) {
            int n = this.find(string2, c);
            if (n == -1) {
                return null;
            }
            String string3 = this.mLines.get(n);
            int n2 = string2.length();
            if (string3.length() == n2) {
                return "";
            }
            return string3.substring(n2 + 1);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void parse(String string2) {
            int n;
            char c = string2.charAt(0);
            if (this.mOrder.indexOf(c) == -1) {
                return;
            }
            char c2 = '=';
            if (string2.startsWith("a=rtpmap:") || string2.startsWith("a=fmtp:")) {
                c2 = ' ';
            } else if (c == 'b' || c == 'a') {
                c2 = ':';
            }
            if ((n = string2.indexOf(c2)) == -1) {
                this.set(string2, c2, "");
                return;
            }
            this.set(string2.substring(0, n), c2, string2.substring(n + 1));
        }

        /*
         * Enabled aggressive block sorting
         */
        private void set(String string2, char c, String string3) {
            int n = this.find(string2, c);
            if (string3 != null) {
                if (string3.length() != 0) {
                    string2 = string2 + c + string3;
                }
                if (n != -1) {
                    this.mLines.set(n, string2);
                    return;
                }
                this.mLines.add(string2);
                return;
            } else {
                if (n == -1) return;
                this.mLines.remove(n);
                return;
            }
        }

        private void write(StringBuilder stringBuilder) {
            for (int i = 0; i < this.mOrder.length(); ++i) {
                char c = this.mOrder.charAt(i);
                for (String string2 : this.mLines) {
                    if (string2.charAt(0) != c) continue;
                    stringBuilder.append(string2).append("\r\n");
                }
            }
        }

        public String getAddress() {
            String string2 = this.get("c", '=');
            if (string2 == null) {
                return null;
            }
            String[] stringArray = string2.split(" ");
            if (stringArray.length != 3) {
                return null;
            }
            int n = stringArray[2].indexOf(47);
            if (n < 0) {
                return stringArray[2];
            }
            return stringArray[2].substring(0, n);
        }

        public String getAttribute(String string2) {
            return this.get("a=" + string2, ':');
        }

        public String[] getAttributeNames() {
            return this.cut("a=", ':');
        }

        public int getBandwidth(String string2) {
            String string3 = this.get("b=" + string2, ':');
            if (string3 != null) {
                try {
                    int n = Integer.parseInt(string3);
                    return n;
                }
                catch (NumberFormatException numberFormatException) {
                    this.setBandwidth(string2, -1);
                }
            }
            return -1;
        }

        public String[] getBandwidthTypes() {
            return this.cut("b=", ':');
        }

        public String getEncryptionKey() {
            String string2 = this.get("k", '=');
            if (string2 == null) {
                return null;
            }
            int n = string2.indexOf(58);
            if (n == -1) {
                return null;
            }
            return string2.substring(0, n + 1);
        }

        public String getEncryptionMethod() {
            String string2 = this.get("k", '=');
            if (string2 == null) {
                return null;
            }
            int n = string2.indexOf(58);
            if (n == -1) {
                return string2;
            }
            return string2.substring(0, n);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setAddress(String string2) {
            if (string2 != null) {
                StringBuilder stringBuilder = new StringBuilder();
                String string3 = string2.indexOf(58) < 0 ? "IN IP4 " : "IN IP6 ";
                string2 = stringBuilder.append(string3).append(string2).toString();
            }
            this.set("c", '=', string2);
        }

        public void setAttribute(String string2, String string3) {
            this.set("a=" + string2, ':', string3);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setBandwidth(String string2, int n) {
            String string3 = "b=" + string2;
            String string4 = n < 0 ? null : String.valueOf(n);
            this.set(string3, ':', string4);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setEncryption(String string2, String string3) {
            String string4 = string2 == null || string3 == null ? string2 : string2 + ':' + string3;
            this.set("k", '=', string4);
        }
    }

    public static class Media
    extends Fields {
        private ArrayList<String> mFormats = new ArrayList();
        private final int mPort;
        private final int mPortCount;
        private final String mProtocol;
        private final String mType;

        private Media(String string2, int n, int n2, String string3) {
            super("icbka");
            this.mType = string2;
            this.mPort = n;
            this.mPortCount = n2;
            this.mProtocol = string3;
        }

        private void write(StringBuilder stringBuilder) {
            stringBuilder.append("m=").append(this.mType).append(' ').append(this.mPort);
            if (this.mPortCount != 1) {
                stringBuilder.append('/').append(this.mPortCount);
            }
            stringBuilder.append(' ').append(this.mProtocol);
            for (String string2 : this.mFormats) {
                stringBuilder.append(' ').append(string2);
            }
            stringBuilder.append("\r\n");
            ((Fields)this).write(stringBuilder);
        }

        public String getFmtp(int n) {
            return ((Fields)this).get("a=fmtp:" + n, ' ');
        }

        public String getFmtp(String string2) {
            return ((Fields)this).get("a=fmtp:" + string2, ' ');
        }

        public String[] getFormats() {
            return this.mFormats.toArray(new String[this.mFormats.size()]);
        }

        public int getPort() {
            return this.mPort;
        }

        public int getPortCount() {
            return this.mPortCount;
        }

        public String getProtocol() {
            return this.mProtocol;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int[] getRtpPayloadTypes() {
            int[] nArray = new int[this.mFormats.size()];
            int n = 0;
            for (String string2 : this.mFormats) {
                try {
                    nArray[n] = Integer.parseInt(string2);
                    ++n;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return Arrays.copyOf(nArray, n);
        }

        public String getRtpmap(int n) {
            return ((Fields)this).get("a=rtpmap:" + n, ' ');
        }

        public String getType() {
            return this.mType;
        }

        public void removeFormat(String string2) {
            this.mFormats.remove(string2);
            ((Fields)this).set("a=rtpmap:" + string2, ' ', null);
            ((Fields)this).set("a=fmtp:" + string2, ' ', null);
        }

        public void removeRtpPayload(int n) {
            this.removeFormat(String.valueOf(n));
        }

        public void setFormat(String string2, String string3) {
            this.mFormats.remove(string2);
            this.mFormats.add(string2);
            ((Fields)this).set("a=rtpmap:" + string2, ' ', null);
            ((Fields)this).set("a=fmtp:" + string2, ' ', string3);
        }

        public void setRtpPayload(int n, String string2, String string3) {
            String string4 = String.valueOf(n);
            this.mFormats.remove(string4);
            this.mFormats.add(string4);
            ((Fields)this).set("a=rtpmap:" + string4, ' ', string2);
            ((Fields)this).set("a=fmtp:" + string4, ' ', string3);
        }
    }
}

