/*
 * Decompiled with CFR 0.152.
 */
package android.net.vpn;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.net.vpn.VpnProfile;
import android.net.vpn.VpnState;
import android.net.vpn.VpnType;
import android.os.Environment;
import android.util.Log;
import java.io.Serializable;

public class VpnManager {
    private static final String ACTION_VPN_CONNECTIVITY = "vpn.connectivity";
    private static final String ACTION_VPN_SERVICE;
    private static final String ACTION_VPN_SETTINGS;
    public static final String BROADCAST_CONNECTION_STATE = "connection_state";
    public static final String BROADCAST_ERROR_CODE = "err";
    public static final String BROADCAST_PROFILE_NAME = "profile_name";
    private static final String PACKAGE_PREFIX;
    public static final String PROFILES_PATH = "/misc/vpn/profiles";
    public static final String TAG;
    public static final int VPN_ERROR_AUTH = 51;
    public static final int VPN_ERROR_CHALLENGE = 5;
    public static final int VPN_ERROR_CONNECTION_FAILED = 101;
    public static final int VPN_ERROR_CONNECTION_LOST = 103;
    public static final int VPN_ERROR_LARGEST = 200;
    public static final int VPN_ERROR_NO_ERROR = 0;
    public static final int VPN_ERROR_PPP_NEGOTIATION_FAILED = 42;
    public static final int VPN_ERROR_REMOTE_HUNG_UP = 7;
    public static final int VPN_ERROR_REMOTE_PPP_HUNG_UP = 48;
    public static final int VPN_ERROR_UNKNOWN_SERVER = 102;
    private Context mContext;

    static {
        PACKAGE_PREFIX = VpnManager.class.getPackage().getName() + ".";
        ACTION_VPN_SERVICE = PACKAGE_PREFIX + "SERVICE";
        ACTION_VPN_SETTINGS = PACKAGE_PREFIX + "SETTINGS";
        TAG = VpnManager.class.getSimpleName();
    }

    public VpnManager(Context context) {
        this.mContext = context;
    }

    public static String getProfilePath() {
        return Environment.getSecureDataDirectory().getPath() + PROFILES_PATH;
    }

    public static VpnType[] getSupportedVpnTypes() {
        return VpnType.values();
    }

    public boolean bindVpnService(ServiceConnection serviceConnection) {
        if (!this.mContext.bindService(new Intent(ACTION_VPN_SERVICE), serviceConnection, 0)) {
            Log.w(TAG, "failed to connect to VPN service");
            return false;
        }
        Log.d(TAG, "succeeded to connect to VPN service");
        return true;
    }

    public void broadcastConnectivity(String string2, VpnState vpnState) {
        this.broadcastConnectivity(string2, vpnState, 0);
    }

    public void broadcastConnectivity(String string2, VpnState vpnState, int n) {
        Intent intent = new Intent(ACTION_VPN_CONNECTIVITY);
        intent.putExtra(BROADCAST_PROFILE_NAME, string2);
        intent.putExtra(BROADCAST_CONNECTION_STATE, (Serializable)((Object)vpnState));
        if (n != 0) {
            intent.putExtra(BROADCAST_ERROR_CODE, n);
        }
        this.mContext.sendBroadcast(intent);
    }

    public Intent createSettingsActivityIntent() {
        Intent intent = new Intent(ACTION_VPN_SETTINGS);
        intent.setFlags(0x10000000);
        return intent;
    }

    public VpnProfile createVpnProfile(VpnType vpnType) {
        return this.createVpnProfile(vpnType, false);
    }

    public VpnProfile createVpnProfile(VpnType vpnType, boolean bl) {
        try {
            VpnProfile vpnProfile = vpnType.getProfileClass().newInstance();
            vpnProfile.setCustomized(bl);
            return vpnProfile;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public void registerConnectivityReceiver(BroadcastReceiver broadcastReceiver) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(ACTION_VPN_CONNECTIVITY);
        this.mContext.registerReceiver(broadcastReceiver, intentFilter);
    }

    public void startSettingsActivity() {
        Intent intent = new Intent(ACTION_VPN_SETTINGS);
        intent.setFlags(0x10000000);
        this.mContext.startActivity(intent);
    }

    public void startVpnService() {
        this.mContext.startService(new Intent(ACTION_VPN_SERVICE));
    }

    public void stopVpnService() {
        this.mContext.stopService(new Intent(ACTION_VPN_SERVICE));
    }

    public void unregisterConnectivityReceiver(BroadcastReceiver broadcastReceiver) {
        this.mContext.unregisterReceiver(broadcastReceiver);
    }
}

