/*
 * Decompiled with CFR 0.152.
 */
package android.net.vpn;

import android.net.vpn.VpnManager;
import android.net.vpn.VpnState;
import android.net.vpn.VpnType;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;

public abstract class VpnProfile
implements Parcelable,
Serializable {
    public static final Parcelable.Creator<VpnProfile> CREATOR = new Parcelable.Creator<VpnProfile>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public VpnProfile createFromParcel(Parcel parcel) {
            boolean bl;
            VpnType vpnType = Enum.valueOf(VpnType.class, parcel.readString());
            VpnProfile vpnProfile = new VpnManager(null).createVpnProfile(vpnType, bl = parcel.readInt() > 0);
            if (vpnProfile == null) {
                return null;
            }
            vpnProfile.readFromParcel(parcel);
            return vpnProfile;
        }

        public VpnProfile[] newArray(int n) {
            return new VpnProfile[n];
        }
    };
    private static final long serialVersionUID = 1L;
    private String mDomainSuffices;
    private String mId;
    private boolean mIsCustomized;
    private String mName;
    private String mRouteList;
    private String mSavedUsername;
    private String mServerName;
    private transient VpnState mState = VpnState.IDLE;

    @Override
    public int describeContents() {
        return 0;
    }

    public String getDomainSuffices() {
        return this.mDomainSuffices;
    }

    public String getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public String getRouteList() {
        return this.mRouteList;
    }

    public String getSavedUsername() {
        return this.mSavedUsername;
    }

    public String getServerName() {
        return this.mServerName;
    }

    public VpnState getState() {
        if (this.mState == null) {
            return VpnState.IDLE;
        }
        return this.mState;
    }

    public abstract VpnType getType();

    public boolean isCustomized() {
        return this.mIsCustomized;
    }

    public boolean isIdle() {
        return this.mState == VpnState.IDLE;
    }

    protected void readFromParcel(Parcel parcel) {
        this.mName = parcel.readString();
        this.mId = parcel.readString();
        this.mServerName = parcel.readString();
        this.mDomainSuffices = parcel.readString();
        this.mRouteList = parcel.readString();
        this.mSavedUsername = parcel.readString();
    }

    void setCustomized(boolean bl) {
        this.mIsCustomized = bl;
    }

    public void setDomainSuffices(String string2) {
        this.mDomainSuffices = string2;
    }

    public void setId(String string2) {
        this.mId = string2;
    }

    public void setName(String string2) {
        this.mName = string2;
    }

    public void setRouteList(String string2) {
        this.mRouteList = string2;
    }

    public void setSavedUsername(String string2) {
        this.mSavedUsername = string2;
    }

    public void setServerName(String string2) {
        this.mServerName = string2;
    }

    public void setState(VpnState vpnState) {
        this.mState = vpnState;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.getType().toString());
        int n2 = this.mIsCustomized ? 1 : 0;
        parcel.writeInt(n2);
        parcel.writeString(this.mName);
        parcel.writeString(this.mId);
        parcel.writeString(this.mServerName);
        parcel.writeString(this.mDomainSuffices);
        parcel.writeString(this.mRouteList);
        parcel.writeString(this.mSavedUsername);
    }
}

