/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.NetworkInfo;
import android.net.NetworkStateTracker;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiNative;
import android.net.wifi.WifiStateTracker;
import android.util.Log;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WifiMonitor {
    private static final int CONNECTED = 1;
    private static final int DISCONNECTED = 2;
    private static final int DRIVER_STATE = 7;
    private static final int LINK_SPEED = 5;
    private static final int MAX_RECV_ERRORS = 10;
    private static final int SCAN_RESULTS = 4;
    private static final int STATE_CHANGE = 3;
    private static final String TAG = "WifiMonitor";
    private static final int TERMINATING = 6;
    private static final int UNKNOWN = 8;
    private static final String connectedEvent = "CONNECTED";
    private static final String disconnectedEvent = "DISCONNECTED";
    private static final String driverStateEvent = "DRIVER-STATE";
    private static final String eventPrefix = "CTRL-EVENT-";
    private static final int eventPrefixLen = 0;
    private static final String linkSpeedEvent = "LINK-SPEED";
    private static Pattern mConnectedEventPattern;
    private static final String monitorSocketClosed = "connection closed";
    private static final String passwordKeyMayBeIncorrectEvent = "pre-shared key may be incorrect";
    private static final String scanResultsEvent = "SCAN-RESULTS";
    private static final String stateChangeEvent = "STATE-CHANGE";
    private static final String terminatingEvent = "TERMINATING";
    private static final String wpaEventPrefix = "WPA:";
    private static final String wpaRecvError = "recv error";
    private int mRecvErrors = 0;
    private final WifiStateTracker mWifiStateTracker;

    static {
        eventPrefixLen = eventPrefix.length();
        mConnectedEventPattern = Pattern.compile("((?:[0-9a-f]{2}:){5}[0-9a-f]{2}) .* \\[id=([0-9]+) ");
    }

    public WifiMonitor(WifiStateTracker wifiStateTracker) {
        this.mWifiStateTracker = wifiStateTracker;
    }

    static /* synthetic */ int access$202(WifiMonitor wifiMonitor, int n) {
        wifiMonitor.mRecvErrors = n;
        return n;
    }

    static /* synthetic */ int access$204(WifiMonitor wifiMonitor) {
        int n;
        wifiMonitor.mRecvErrors = n = 1 + wifiMonitor.mRecvErrors;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleNetworkStateChange(NetworkInfo.DetailedState detailedState, String string2) {
        int n = -1;
        NetworkInfo.DetailedState detailedState2 = NetworkInfo.DetailedState.CONNECTED;
        String string3 = null;
        if (detailedState == detailedState2) {
            Matcher matcher = mConnectedEventPattern.matcher(string2);
            if (!matcher.find()) {
                Log.d(TAG, "Could not find BSSID in CONNECTED event string");
            } else {
                string3 = matcher.group(1);
                try {
                    int n2;
                    n = n2 = Integer.parseInt(matcher.group(2));
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
            }
        }
        this.mWifiStateTracker.notifyStateChange(detailedState, string3, n);
    }

    private static void nap(int n) {
        long l = n * 1000;
        try {
            Thread.sleep(l);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public NetworkStateTracker getNetworkStateTracker() {
        return this.mWifiStateTracker;
    }

    public void startMonitoring() {
        new MonitorThread().start();
    }

    class MonitorThread
    extends Thread {
        public MonitorThread() {
            super(WifiMonitor.TAG);
        }

        private boolean connectToSupplicant() {
            int n = 0;
            while (true) {
                if (WifiMonitor.this.mWifiStateTracker.connectToSupplicant()) {
                    return true;
                }
                int n2 = n + 1;
                if (n >= 3) break;
                WifiMonitor.nap(5);
                n = n2;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void handleDriverEvent(String string2) {
            block6: {
                block5: {
                    if (string2 == null) break block5;
                    if (string2.equals("STOPPED")) {
                        WifiMonitor.this.mWifiStateTracker.notifyDriverStopped();
                        return;
                    }
                    if (string2.equals("STARTED")) {
                        WifiMonitor.this.mWifiStateTracker.notifyDriverStarted();
                        return;
                    }
                    if (string2.equals("HANGED")) break block6;
                }
                return;
            }
            WifiMonitor.this.mWifiStateTracker.notifyDriverHung();
        }

        private void handlePasswordKeyMayBeIncorrect() {
            WifiMonitor.this.mWifiStateTracker.notifyPasswordKeyMayBeIncorrect();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void handleSupplicantStateChange(String string2) {
            String[] stringArray = string2.split(" ");
            String string3 = null;
            int n = -1;
            int n2 = -1;
            for (String string4 : stringArray) {
                int n3;
                String[] stringArray2 = string4.split("=");
                if (stringArray2.length != 2) continue;
                if (stringArray2[0].equals("BSSID")) {
                    string3 = stringArray2[1];
                    continue;
                }
                try {
                    n3 = Integer.parseInt(stringArray2[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    Log.w(WifiMonitor.TAG, "STATE-CHANGE non-integer parameter: " + string4);
                    continue;
                }
                if (stringArray2[0].equals("id")) {
                    n = n3;
                    continue;
                }
                if (!stringArray2[0].equals("state")) continue;
                n2 = n3;
            }
            if (n2 == -1) {
                return;
            }
            SupplicantState supplicantState = SupplicantState.INVALID;
            SupplicantState[] supplicantStateArray = SupplicantState.values();
            int n4 = supplicantStateArray.length;
            int n5 = 0;
            while (true) {
                block13: {
                    block12: {
                        if (n5 >= n4) break block12;
                        SupplicantState supplicantState2 = supplicantStateArray[n5];
                        if (supplicantState2.ordinal() != n2) break block13;
                        supplicantState = supplicantState2;
                    }
                    if (supplicantState == SupplicantState.INVALID) {
                        Log.w(WifiMonitor.TAG, "Invalid supplicant state: " + n2);
                    }
                    WifiMonitor.this.mWifiStateTracker.notifyStateChange(n, string3, supplicantState);
                    return;
                }
                ++n5;
            }
        }

        void handleEvent(int n, String string2) {
            switch (n) {
                default: {
                    return;
                }
                case 2: {
                    WifiMonitor.this.handleNetworkStateChange(NetworkInfo.DetailedState.DISCONNECTED, string2);
                    return;
                }
                case 1: {
                    WifiMonitor.this.handleNetworkStateChange(NetworkInfo.DetailedState.CONNECTED, string2);
                    return;
                }
                case 4: 
            }
            WifiMonitor.this.mWifiStateTracker.notifyScanResultsAvailable();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void run() {
            if (!this.connectToSupplicant()) {
                WifiMonitor.this.mWifiStateTracker.notifySupplicantLost();
                return;
            }
            WifiMonitor.this.mWifiStateTracker.notifySupplicantConnection();
            while (true) {
                String string2;
                if ((string2 = WifiNative.waitForEvent()).indexOf(WifiMonitor.scanResultsEvent) == -1) {
                    Log.v(WifiMonitor.TAG, "Event [" + string2 + "]");
                }
                if (!string2.startsWith(WifiMonitor.eventPrefix)) {
                    if (!string2.startsWith(WifiMonitor.wpaEventPrefix) || string2.indexOf(WifiMonitor.passwordKeyMayBeIncorrectEvent) <= 0) continue;
                    this.handlePasswordKeyMayBeIncorrect();
                    continue;
                }
                String string3 = string2.substring(eventPrefixLen);
                int n = string3.indexOf(32);
                if (n != -1) {
                    string3 = string3.substring(0, n);
                }
                if (string3.length() == 0) {
                    Log.i(WifiMonitor.TAG, "Received wpa_supplicant event with empty event name");
                    continue;
                }
                int n2 = string3.equals(WifiMonitor.connectedEvent) ? 1 : (string3.equals(WifiMonitor.disconnectedEvent) ? 2 : (string3.equals(WifiMonitor.stateChangeEvent) ? 3 : (string3.equals(WifiMonitor.scanResultsEvent) ? 4 : (string3.equals(WifiMonitor.linkSpeedEvent) ? 5 : (string3.equals(WifiMonitor.terminatingEvent) ? 6 : (string3.equals(WifiMonitor.driverStateEvent) ? 7 : 8))))));
                String string4 = string2;
                if (n2 == 7 || n2 == 5) {
                    string4 = string4.split(" ")[1];
                } else if (n2 == 3) {
                    int n3 = string2.indexOf(" ");
                    if (n3 != -1) {
                        string4 = string2.substring(n3 + 1);
                    }
                } else {
                    int n4 = string2.indexOf(" - ");
                    if (n4 != -1) {
                        string4 = string2.substring(n4 + 3);
                    }
                }
                if (n2 == 3) {
                    this.handleSupplicantStateChange(string4);
                } else if (n2 == 7) {
                    this.handleDriverEvent(string4);
                } else {
                    if (n2 == 6) {
                        if (string4.startsWith(WifiMonitor.monitorSocketClosed)) {
                            Log.d(WifiMonitor.TAG, "Monitor socket is closed, exiting thread");
                            return;
                        }
                        if (string4.startsWith(WifiMonitor.wpaRecvError)) {
                            if (WifiMonitor.access$204(WifiMonitor.this) <= 10) continue;
                            Log.d(WifiMonitor.TAG, "too many recv errors, closing connection");
                        }
                        WifiMonitor.this.mWifiStateTracker.notifySupplicantLost();
                        return;
                    }
                    this.handleEvent(n2, string4);
                }
                WifiMonitor.access$202(WifiMonitor.this, 0);
            }
        }
    }
}

